/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.repo.JasperDesignReportResource;

public class JasperDesignCache {
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_ENTRY = "repo.invalid.entry";
    private static final String PARAMETER_JASPER_DESIGN_CACHE = "net.sf.jasperreports.parameter.jasperdesign.cache";
    private JasperReportsContext jasperReportsContext;
    private Map<String, JasperDesignReportResource> cachedResourcesMap = new HashMap<String, JasperDesignReportResource>();

    public static JasperDesignCache getInstance(JasperReportsContext jasperReportsContext, ReportContext reportContext) {
        JasperDesignCache cache = null;
        if (reportContext != null && (cache = (JasperDesignCache)reportContext.getParameterValue(PARAMETER_JASPER_DESIGN_CACHE)) == null) {
            cache = new JasperDesignCache(jasperReportsContext);
            reportContext.setParameterValue(PARAMETER_JASPER_DESIGN_CACHE, cache);
        }
        return cache;
    }

    public static JasperDesignCache getExistingInstance(ReportContext reportContext) {
        JasperDesignCache cache = null;
        if (reportContext != null) {
            cache = (JasperDesignCache)reportContext.getParameterValue(PARAMETER_JASPER_DESIGN_CACHE);
        }
        return cache;
    }

    private JasperDesignCache(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public JasperReport getJasperReport(String uri) {
        JasperDesignReportResource resource = this.getResource(uri);
        if (resource != null) {
            return resource.getReport();
        }
        return null;
    }

    public JasperDesign getJasperDesign(String uri) {
        JasperDesignReportResource resource = this.getResource(uri);
        if (resource != null) {
            return resource.getJasperDesign();
        }
        return null;
    }

    public void set(String uri, JasperReport jasperReport) {
        JasperDesignReportResource resource = new JasperDesignReportResource();
        resource.setReport(jasperReport);
        this.cachedResourcesMap.put(uri, resource);
    }

    public void set(String uri, JasperDesign jasperDesign) {
        JasperDesignReportResource resource = new JasperDesignReportResource();
        resource.setJasperDesign(jasperDesign);
        this.cachedResourcesMap.put(uri, resource);
    }

    public void resetJasperReport(String uri) {
        JasperDesignReportResource resource = this.cachedResourcesMap.get(uri);
        if (resource != null) {
            resource.setReport(null);
        }
    }

    public JasperDesignReportResource remove(String uri) {
        return this.cachedResourcesMap.remove(uri);
    }

    public void set(String uri, JasperDesignReportResource resource) {
        this.cachedResourcesMap.put(uri, resource);
    }

    public void clear() {
        this.cachedResourcesMap.clear();
    }

    private JasperDesignReportResource getResource(String uri) {
        JasperDesignReportResource resource = this.cachedResourcesMap.get(uri);
        if (resource != null) {
            JasperDesign jasperDesign = resource.getJasperDesign();
            JasperReport jasperReport = resource.getReport();
            if (jasperDesign == null) {
                if (jasperReport == null) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INVALID_ENTRY, new Object[]{"JasperDesignCache"});
                }
                ByteArrayInputStream bais = null;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    new JRXmlWriter(this.jasperReportsContext).write((JRReport)jasperReport, baos, "UTF-8");
                    bais = new ByteArrayInputStream(baos.toByteArray());
                    jasperDesign = JRXmlLoader.load(bais);
                    resource.setJasperDesign(jasperDesign);
                }
                catch (JRException e) {
                    throw new JRRuntimeException(e);
                }
                finally {
                    try {
                        baos.close();
                        if (bais != null) {
                            bais.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            if (jasperReport == null) {
                try {
                    jasperReport = JasperCompileManager.getInstance(this.jasperReportsContext).compile(jasperDesign);
                    resource.setReport(jasperReport);
                }
                catch (JRException e) {
                    throw new JRRuntimeException(e);
                }
            }
        }
        return resource;
    }

    public Map<String, JasperDesignReportResource> getCachedResources() {
        return this.cachedResourcesMap;
    }
}

