/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class DurationNumberFormat
extends NumberFormat {
    private static final long serialVersionUID = 10200L;

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format((long)number, toAppendTo, pos);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        long seconds = number;
        long hours = seconds / 3600L;
        long minutes = (seconds -= hours * 3600L) / 60L;
        seconds -= minutes * 60L;
        toAppendTo.append(hours);
        toAppendTo.append(":");
        toAppendTo.append(minutes);
        toAppendTo.append(":");
        toAppendTo.append(seconds);
        return toAppendTo;
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        if (source != null && source.trim().length() > 0) {
            String[] tokens = source.split(":");
            if (tokens.length > 3) {
                throw new NumberFormatException();
            }
            long seconds = 3600L * Long.parseLong(tokens[0]);
            if (tokens.length > 1) {
                seconds += 60L * Long.parseLong(tokens[1]);
            }
            if (tokens.length > 2) {
                seconds += Long.parseLong(tokens[2]);
            }
            parsePosition.setIndex(source.length());
            return seconds;
        }
        return null;
    }
}

