/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRIntegerIncrementerFactory;

final class JRIntegerSumIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRIntegerSumIncrementer mainInstance = new JRIntegerSumIncrementer();

    private JRIntegerSumIncrementer() {
    }

    public static JRIntegerSumIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        Number newValue = (Number)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            value = JRIntegerIncrementerFactory.ZERO;
        }
        return value.intValue() + newValue.intValue();
    }

    @Override
    public Object initialValue() {
        return JRIntegerIncrementerFactory.ZERO;
    }
}

