/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfICCBased;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.color.ICC_Profile;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.AbstractPdfTextRenderer;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementPdfHandler;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JRPdfExporterContext;
import net.sf.jasperreports.engine.export.JRPdfExporterTagHelper;
import net.sf.jasperreports.engine.export.PdfGlyphRenderer;
import net.sf.jasperreports.engine.export.PdfTextRenderer;
import net.sf.jasperreports.engine.export.PdfXmpCreator;
import net.sf.jasperreports.engine.export.SimplePdfTextRenderer;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.util.BreakIteratorSplitCharacter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRPdfaIccProfileNotFoundException;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.NullOutputStream;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.OutputStreamExporterOutput;
import net.sf.jasperreports.export.PdfExporterConfiguration;
import net.sf.jasperreports.export.PdfReportConfiguration;
import net.sf.jasperreports.export.parameters.ParametersOutputStreamExporterOutput;
import net.sf.jasperreports.export.type.PdfPermissionsEnum;
import net.sf.jasperreports.export.type.PdfPrintScalingEnum;
import net.sf.jasperreports.export.type.PdfVersionEnum;
import net.sf.jasperreports.export.type.PdfaConformanceEnum;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRPdfExporter
extends JRAbstractExporter<PdfReportConfiguration, PdfExporterConfiguration, OutputStreamExporterOutput, JRPdfExporterContext> {
    private static final Log log = LogFactory.getLog(JRPdfExporter.class);
    public static final String PDF_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.pdf.";
    public static final String EXCEPTION_MESSAGE_KEY_DOCUMENT_ERROR = "export.pdf.document.error";
    public static final String EXCEPTION_MESSAGE_KEY_FONT_LOADING_ERROR = "export.pdf.font.loading.error";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_GENERATION_ERROR = "export.pdf.report.generation.error";
    public static final String PROPERTY_IGNORE_HYPERLINK = "net.sf.jasperreports.export.pdf.ignore.hyperlink";
    public static final String PDF_FONT_FILES_PREFIX = "net.sf.jasperreports.export.pdf.font.";
    public static final String PDF_FONT_DIRS_PREFIX = "net.sf.jasperreports.export.pdf.fontdir.";
    public static final String PDF_EXPORTER_KEY = "net.sf.jasperreports.pdf";
    private static final String EMPTY_BOOKMARK_TITLE = "";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static boolean fontsRegistered;
    protected Document document;
    protected PdfContentByte pdfContentByte;
    protected PdfWriter pdfWriter;
    protected Document imageTesterDocument;
    protected PdfContentByte imageTesterPdfContentByte;
    protected JRPdfExporterTagHelper tagHelper = new JRPdfExporterTagHelper(this);
    protected int reportIndex;
    protected PrintPageFormat pageFormat;
    protected int crtDocumentPageNumber;
    protected int permissions;
    protected Map<Renderable, Image> loadedImagesMap;
    protected Image pxImage;
    private BookmarkStack bookmarkStack;
    private SplitCharacter splitCharacter;
    private int crtOddPageOffsetX;
    private int crtOddPageOffsetY;
    private int crtEvenPageOffsetX;
    private int crtEvenPageOffsetY;
    private boolean awtIgnoreMissingFont;
    private FontUtil fontUtil;
    private Set<Character.UnicodeBlock> glyphRendererBlocks;
    private boolean glyphRendererAddActualText;
    private PdfVersionEnum minimalVersion;
    private Map<FontKey, Boolean> glyphRendererFonts;

    public JRPdfExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRPdfExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
        this.glyphRendererFonts = new HashMap<FontKey, Boolean>();
    }

    @Override
    protected Class<PdfExporterConfiguration> getConfigurationInterface() {
        return PdfExporterConfiguration.class;
    }

    @Override
    protected Class<PdfReportConfiguration> getItemConfigurationInterface() {
        return PdfReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersOutputStreamExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    protected Image getPxImage() {
        if (this.pxImage == null) {
            try {
                this.pxImage = Image.getInstance((byte[])JRLoader.loadBytesFromResource("net/sf/jasperreports/engine/images/pixel.GIF"));
            }
            catch (Exception e) {
                throw new JRRuntimeException(e);
            }
        }
        return this.pxImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportReport() throws JRException {
        JRPdfExporter.registerFonts();
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        OutputStream outputStream = ((OutputStreamExporterOutput)this.getExporterOutput()).getOutputStream();
        try {
            this.exportReportToStream(outputStream);
        }
        finally {
            ((OutputStreamExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
        PdfExporterConfiguration configuration = (PdfExporterConfiguration)this.getCurrentConfiguration();
        Boolean isTagged = configuration.isTagged();
        if (isTagged != null) {
            this.tagHelper.setTagged(isTagged);
        }
        this.tagHelper.setLanguage(configuration.getTagLanguage());
        this.permissions = JRPdfExporter.getIntegerPermissions(configuration.getAllowedPermissions()) & ~JRPdfExporter.getIntegerPermissions(configuration.getDeniedPermissions());
        this.crtDocumentPageNumber = 0;
        this.awtIgnoreMissingFont = this.getPropertiesUtil().getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font");
        this.fontUtil = FontUtil.getInstance(this.jasperReportsContext);
        this.glyphRendererAddActualText = this.propertiesUtil.getBooleanProperty("net.sf.jasperreports.export.pdf.glyph.renderer.add.actual.text", false);
        if (this.glyphRendererAddActualText && !this.tagHelper.isTagged && PdfGlyphRenderer.supported()) {
            this.minimalVersion = PdfVersionEnum.VERSION_1_5;
        }
    }

    @Override
    protected void initReport() {
        super.initReport();
        PdfReportConfiguration configuration = (PdfReportConfiguration)this.getCurrentItemConfiguration();
        if (configuration.isForceLineBreakPolicy().booleanValue()) {
            this.splitCharacter = new BreakIteratorSplitCharacter();
        }
        this.crtOddPageOffsetX = configuration.getOddPageOffsetX();
        this.crtOddPageOffsetY = configuration.getOddPageOffsetY();
        this.crtEvenPageOffsetX = configuration.getEvenPageOffsetX();
        this.crtEvenPageOffsetY = configuration.getEvenPageOffsetY();
        this.initGlyphRenderer();
    }

    protected void initGlyphRenderer() {
        this.glyphRendererBlocks = new HashSet<Character.UnicodeBlock>();
        List<JRPropertiesUtil.PropertySuffix> props = this.propertiesUtil.getAllProperties(this.getCurrentJasperPrint(), "net.sf.jasperreports.export.pdf.glyph.renderer.blocks.");
        for (JRPropertiesUtil.PropertySuffix prop : props) {
            String blocks = prop.getValue();
            for (String blockToken : blocks.split(",")) {
                Character.UnicodeBlock block = this.resolveUnicodeBlock(blockToken);
                if (block == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("glyph renderer block " + block));
                }
                this.glyphRendererBlocks.add(block);
            }
        }
    }

    protected Character.UnicodeBlock resolveUnicodeBlock(String name) {
        if (name.trim().isEmpty()) {
            return null;
        }
        try {
            return Character.UnicodeBlock.forName(name.trim());
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Could not resolve \"" + name + "\" to a Unicode block"));
            return null;
        }
    }

    protected void exportReportToStream(OutputStream os) throws JRException {
        PdfExporterConfiguration configuration = (PdfExporterConfiguration)this.getCurrentConfiguration();
        this.pageFormat = this.jasperPrint.getPageFormat(0);
        this.document = new Document(new Rectangle((float)this.pageFormat.getPageWidth().intValue(), (float)this.pageFormat.getPageHeight().intValue()));
        this.imageTesterDocument = new Document(new Rectangle(10.0f, 10.0f));
        boolean closeDocuments = true;
        try {
            String pdfJavaScript;
            String creator;
            String keywords;
            String subject;
            String author;
            String title;
            PdfPrintScalingEnum printScaling;
            this.pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)os);
            this.pdfWriter.setCloseStream(false);
            this.tagHelper.setPdfWriter(this.pdfWriter);
            PdfVersionEnum pdfVersion = configuration.getPdfVersion();
            if (pdfVersion != null) {
                this.pdfWriter.setPdfVersion(pdfVersion.getName().charAt(0));
            }
            if (this.minimalVersion != null) {
                this.pdfWriter.setAtLeastPdfVersion(this.minimalVersion.getName().charAt(0));
            }
            if (configuration.isCompressed().booleanValue()) {
                this.pdfWriter.setFullCompression();
            }
            if (configuration.isEncrypted().booleanValue()) {
                int perms = configuration.isOverrideHints() == null || configuration.isOverrideHints().booleanValue() ? (configuration.getPermissions() != null ? configuration.getPermissions() : this.permissions) : (this.permissions != 0 ? this.permissions : (configuration.getPermissions() != null ? configuration.getPermissions() : 0));
                this.pdfWriter.setEncryption(configuration.is128BitKey().booleanValue(), configuration.getUserPassword(), configuration.getOwnerPassword(), perms);
            }
            if (PdfPrintScalingEnum.DEFAULT == (printScaling = configuration.getPrintScaling())) {
                this.pdfWriter.addViewerPreference(PdfName.PRINTSCALING, (PdfObject)PdfName.APPDEFAULT);
            } else if (PdfPrintScalingEnum.NONE == printScaling) {
                this.pdfWriter.addViewerPreference(PdfName.PRINTSCALING, (PdfObject)PdfName.NONE);
            }
            boolean justifiedLetterSpacing = this.propertiesUtil.getBooleanProperty(this.jasperPrint, "net.sf.jasperreports.export.pdf.justified.letter.spacing", false);
            if (!justifiedLetterSpacing) {
                this.pdfWriter.setSpaceCharRatio(1.0E7f);
            }
            if ((title = configuration.getMetadataTitle()) != null) {
                this.document.addTitle(title);
                if (configuration.isDisplayMetadataTitle().booleanValue()) {
                    this.pdfWriter.addViewerPreference(PdfName.DISPLAYDOCTITLE, (PdfObject)new PdfBoolean(true));
                }
            }
            if ((author = configuration.getMetadataAuthor()) != null) {
                this.document.addAuthor(author);
            }
            if ((subject = configuration.getMetadataSubject()) != null) {
                this.document.addSubject(subject);
            }
            if ((keywords = configuration.getMetadataKeywords()) != null) {
                this.document.addKeywords(keywords);
            }
            if ((creator = configuration.getMetadataCreator()) != null) {
                this.document.addCreator(creator);
            } else {
                this.document.addCreator("JasperReports Library version " + Package.getPackage("net.sf.jasperreports.engine").getImplementationVersion());
            }
            this.pdfWriter.setTabs(PdfName.S);
            String language = configuration.getTagLanguage();
            if (language != null) {
                this.pdfWriter.getExtraCatalog().put(PdfName.LANG, (PdfObject)new PdfString(language));
            }
            PdfaConformanceEnum pdfaConformance = configuration.getPdfaConformance();
            boolean gotPdfa = false;
            if (PdfaConformanceEnum.PDFA_1A == pdfaConformance) {
                this.pdfWriter.setPDFXConformance(3);
                gotPdfa = true;
            } else if (PdfaConformanceEnum.PDFA_1B == pdfaConformance) {
                this.pdfWriter.setPDFXConformance(4);
                gotPdfa = true;
            }
            if (gotPdfa) {
                if (PdfXmpCreator.supported()) {
                    byte[] metadata = PdfXmpCreator.createXmpMetadata(this.pdfWriter);
                    this.pdfWriter.setXmpMetadata(metadata);
                } else {
                    if ((title != null || subject != null || keywords != null) && log.isWarnEnabled()) {
                        log.warn((Object)"XMP metadata might be non conforming, include the Adobe XMP library to correct");
                    }
                    this.pdfWriter.createXmpMetadata();
                }
            } else {
                this.pdfWriter.setRgbTransparencyBlending(true);
            }
            this.document.open();
            if (gotPdfa) {
                String iccProfilePath = configuration.getIccProfilePath();
                if (iccProfilePath != null) {
                    PdfDictionary pdfDictionary = new PdfDictionary(PdfName.OUTPUTINTENT);
                    pdfDictionary.put(PdfName.OUTPUTCONDITIONIDENTIFIER, (PdfObject)new PdfString("sRGB IEC61966-2.1"));
                    pdfDictionary.put(PdfName.INFO, (PdfObject)new PdfString("sRGB IEC61966-2.1"));
                    pdfDictionary.put(PdfName.S, (PdfObject)PdfName.GTS_PDFA1);
                    InputStream iccIs = RepositoryUtil.getInstance(this.jasperReportsContext).getInputStreamFromLocation(iccProfilePath);
                    PdfICCBased pdfICCBased = new PdfICCBased(ICC_Profile.getInstance(iccIs));
                    pdfICCBased.remove(PdfName.ALTERNATE);
                    pdfDictionary.put(PdfName.DESTOUTPUTPROFILE, (PdfObject)this.pdfWriter.addToBody((PdfObject)pdfICCBased).getIndirectReference());
                    this.pdfWriter.getExtraCatalog().put(PdfName.OUTPUTINTENTS, (PdfObject)new PdfArray((PdfObject)pdfDictionary));
                } else {
                    throw new JRPdfaIccProfileNotFoundException();
                }
            }
            if ((pdfJavaScript = configuration.getPdfJavaScript()) != null) {
                this.pdfWriter.addJavaScript(pdfJavaScript);
            }
            this.pdfContentByte = this.pdfWriter.getDirectContent();
            this.tagHelper.init(this.pdfContentByte);
            PdfWriter imageTesterPdfWriter = PdfWriter.getInstance((Document)this.imageTesterDocument, (OutputStream)new NullOutputStream());
            this.imageTesterDocument.open();
            this.imageTesterDocument.newPage();
            this.imageTesterPdfContentByte = imageTesterPdfWriter.getDirectContent();
            this.imageTesterPdfContentByte.setLiteral("\n");
            List<ExporterInputItem> items = this.exporterInput.getItems();
            this.initBookmarks(items);
            boolean isCreatingBatchModeBookmarks = configuration.isCreatingBatchModeBookmarks();
            this.reportIndex = 0;
            while (this.reportIndex < items.size()) {
                ExporterInputItem item = items.get(this.reportIndex);
                this.setCurrentExporterInputItem(item);
                this.loadedImagesMap = new HashMap<Renderable, Image>();
                this.pageFormat = this.jasperPrint.getPageFormat(0);
                this.setPageSize(null);
                List<JRPrintPage> pages = this.jasperPrint.getPages();
                if (pages != null && pages.size() > 0) {
                    if (items.size() > 1) {
                        this.document.newPage();
                        if (isCreatingBatchModeBookmarks) {
                            this.addBookmark(0, this.jasperPrint.getName(), 0, 0);
                        }
                    }
                    PdfReportConfiguration lcItemConfiguration = (PdfReportConfiguration)this.getCurrentItemConfiguration();
                    boolean sizePageToContent = lcItemConfiguration.isSizePageToContent();
                    PrintPageFormat oldPageFormat = null;
                    JRAbstractExporter.PageRange pageRange = this.getPageRange();
                    int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                    int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                    for (int pageIndex = startPageIndex; pageIndex <= endPageIndex; ++pageIndex) {
                        if (Thread.interrupted()) {
                            throw new ExportInterruptedException();
                        }
                        JRPrintPage page = pages.get(pageIndex);
                        this.pageFormat = this.jasperPrint.getPageFormat(pageIndex);
                        if (sizePageToContent || oldPageFormat != this.pageFormat) {
                            this.setPageSize(sizePageToContent ? page : null);
                        }
                        this.document.newPage();
                        this.pdfContentByte = this.pdfWriter.getDirectContent();
                        this.pdfContentByte.setLineCap(2);
                        this.writePageAnchor(pageIndex);
                        ++this.crtDocumentPageNumber;
                        this.exportPage(page);
                        oldPageFormat = this.pageFormat;
                    }
                } else {
                    this.document.newPage();
                    this.pdfContentByte = this.pdfWriter.getDirectContent();
                    this.pdfContentByte.setLiteral("\n");
                }
                ++this.reportIndex;
            }
            closeDocuments = false;
            this.document.close();
            this.imageTesterDocument.close();
        }
        catch (DocumentException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DOCUMENT_ERROR, new Object[]{this.jasperPrint.getName()}, e);
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_REPORT_GENERATION_ERROR, new Object[]{this.jasperPrint.getName()}, e);
        }
        finally {
            if (closeDocuments) {
                try {
                    this.document.close();
                }
                catch (Exception exception) {}
                try {
                    this.imageTesterDocument.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void writePageAnchor(int pageIndex) throws DocumentException {
        HashMap<AttributedCharacterIterator.Attribute, Object> attributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        FontUtil.getInstance(this.jasperReportsContext).getAttributesWithoutAwtFont(attributes, new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider()));
        com.lowagie.text.Font pdfFont = this.getFont(attributes, this.getLocale(), false);
        Chunk chunk = new Chunk(" ", pdfFont);
        chunk.setLocalDestination(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (pageIndex + 1));
        this.tagHelper.startPageAnchor();
        ColumnText colText = new ColumnText(this.pdfContentByte);
        colText.setSimpleColumn(new Phrase(chunk), 0.0f, (float)this.pageFormat.getPageHeight().intValue(), 1.0f, 1.0f, 0.0f, 0);
        colText.go();
        this.tagHelper.endPageAnchor();
    }

    protected void setPageSize(JRPrintPage page) throws JRException, DocumentException, IOException {
        Rectangle pageSize;
        int pageWidth = 0;
        int pageHeight = 0;
        if (page != null) {
            List<JRPrintElement> elements = page.getElements();
            for (JRPrintElement element : elements) {
                int elementRight = element.getX() + element.getWidth();
                int elementBottom = element.getY() + element.getHeight();
                pageWidth = pageWidth < elementRight ? elementRight : pageWidth;
                pageHeight = pageHeight < elementBottom ? elementBottom : pageHeight;
            }
            pageWidth += this.pageFormat.getRightMargin().intValue();
            pageHeight += this.pageFormat.getBottomMargin().intValue();
        }
        pageWidth = pageWidth < this.pageFormat.getPageWidth() ? this.pageFormat.getPageWidth() : pageWidth;
        pageHeight = pageHeight < this.pageFormat.getPageHeight() ? this.pageFormat.getPageHeight() : pageHeight;
        switch (this.pageFormat.getOrientation()) {
            case LANDSCAPE: {
                pageSize = new Rectangle((float)pageHeight, (float)pageWidth).rotate();
                break;
            }
            default: {
                pageSize = new Rectangle((float)pageWidth, (float)pageHeight);
            }
        }
        this.document.setPageSize(pageSize);
    }

    protected void exportPage(JRPrintPage page) throws JRException, DocumentException, IOException {
        this.tagHelper.startPage();
        List<JRPrintElement> elements = page.getElements();
        this.exportElements(elements);
        this.tagHelper.endPage();
        JRExportProgressMonitor progressMonitor = ((PdfReportConfiguration)this.getCurrentItemConfiguration()).getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection<JRPrintElement> elements) throws DocumentException, IOException, JRException {
        if (elements != null && elements.size() > 0) {
            for (JRPrintElement element : elements) {
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                this.tagHelper.startElement(element);
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                } else if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                } else if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                } else if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                } else if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                } else if (element instanceof JRPrintFrame) {
                    this.exportFrame((JRPrintFrame)element);
                } else if (element instanceof JRGenericPrintElement) {
                    this.exportGenericElement((JRGenericPrintElement)element);
                }
                this.tagHelper.endElement(element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) {
        int lcOffsetX = this.getOffsetX();
        int lcOffsetY = this.getOffsetY();
        float lineWidth = line.getLinePen().getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            JRPdfExporter.preparePen(this.pdfContentByte, line.getLinePen(), 0);
            if (line.getWidth() == 1) {
                if (line.getHeight() != 1) {
                    if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                        this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX) + 0.5f - lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY));
                        this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX) + 0.5f - lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()));
                        this.pdfContentByte.stroke();
                        this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX) + 0.5f + lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY));
                        this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX) + 0.5f + lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()));
                    } else {
                        this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX) + 0.5f, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY));
                        this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX) + 0.5f, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()));
                    }
                }
            } else if (line.getHeight() == 1) {
                if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                    this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f + lineWidth / 3.0f);
                    this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX + line.getWidth()), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f + lineWidth / 3.0f);
                    this.pdfContentByte.stroke();
                    this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f - lineWidth / 3.0f);
                    this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX + line.getWidth()), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f - lineWidth / 3.0f);
                } else {
                    this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f);
                    this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX + line.getWidth()), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f);
                }
            } else if (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN) {
                if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                    double xtrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getWidth(), 2.0) / Math.pow(line.getHeight(), 2.0)));
                    double ytrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getHeight(), 2.0) / Math.pow(line.getWidth(), 2.0)));
                    this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) + (float)ytrans);
                    this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX + line.getWidth()) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) + (float)ytrans);
                    this.pdfContentByte.stroke();
                    this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - (float)ytrans);
                    this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX + line.getWidth()) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) - (float)ytrans);
                } else {
                    this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY));
                    this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX + line.getWidth()), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()));
                }
            } else if (line.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                double xtrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getWidth(), 2.0) / Math.pow(line.getHeight(), 2.0)));
                double ytrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getHeight(), 2.0) / Math.pow(line.getWidth(), 2.0)));
                this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) - (float)ytrans);
                this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX + line.getWidth()) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - (float)ytrans);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) + (float)ytrans);
                this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX + line.getWidth()) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) + (float)ytrans);
            } else {
                this.pdfContentByte.moveTo((float)(line.getX() + lcOffsetX), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()));
                this.pdfContentByte.lineTo((float)(line.getX() + lcOffsetX + line.getWidth()), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY));
            }
            this.pdfContentByte.stroke();
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.setLineCap(2);
        }
    }

    protected void exportRectangle(JRPrintRectangle rectangle) {
        this.pdfContentByte.setRGBColorFill(rectangle.getBackcolor().getRed(), rectangle.getBackcolor().getGreen(), rectangle.getBackcolor().getBlue());
        JRPdfExporter.preparePen(this.pdfContentByte, rectangle.getLinePen(), 2);
        float lineWidth = rectangle.getLinePen().getLineWidth().floatValue();
        int lcOffsetX = this.getOffsetX();
        int lcOffsetY = this.getOffsetY();
        if (rectangle.getModeValue() == ModeEnum.OPAQUE) {
            this.pdfContentByte.roundRectangle((float)(rectangle.getX() + lcOffsetX), (float)(this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight()), (float)rectangle.getWidth(), (float)rectangle.getHeight(), (float)rectangle.getRadius());
            this.pdfContentByte.fill();
        }
        if (lineWidth > 0.0f) {
            if (rectangle.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                this.pdfContentByte.roundRectangle((float)(rectangle.getX() + lcOffsetX) - lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight()) - lineWidth / 3.0f, (float)rectangle.getWidth() + 2.0f * lineWidth / 3.0f, (float)rectangle.getHeight() + 2.0f * lineWidth / 3.0f, (float)rectangle.getRadius());
                this.pdfContentByte.stroke();
                this.pdfContentByte.roundRectangle((float)(rectangle.getX() + lcOffsetX) + lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight()) + lineWidth / 3.0f, (float)rectangle.getWidth() - 2.0f * lineWidth / 3.0f, (float)rectangle.getHeight() - 2.0f * lineWidth / 3.0f, (float)rectangle.getRadius());
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.roundRectangle((float)(rectangle.getX() + lcOffsetX), (float)(this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight()), (float)rectangle.getWidth(), (float)rectangle.getHeight(), (float)rectangle.getRadius());
                this.pdfContentByte.stroke();
            }
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    protected void exportEllipse(JRPrintEllipse ellipse) {
        this.pdfContentByte.setRGBColorFill(ellipse.getBackcolor().getRed(), ellipse.getBackcolor().getGreen(), ellipse.getBackcolor().getBlue());
        JRPdfExporter.preparePen(this.pdfContentByte, ellipse.getLinePen(), 2);
        float lineWidth = ellipse.getLinePen().getLineWidth().floatValue();
        int lcOffsetX = this.getOffsetX();
        int lcOffsetY = this.getOffsetY();
        if (ellipse.getModeValue() == ModeEnum.OPAQUE) {
            this.pdfContentByte.ellipse((float)(ellipse.getX() + lcOffsetX), (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight()), (float)(ellipse.getX() + lcOffsetX + ellipse.getWidth()), (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY));
            this.pdfContentByte.fill();
        }
        if (lineWidth > 0.0f) {
            if (ellipse.getLinePen().getLineStyleValue() == LineStyleEnum.DOUBLE) {
                this.pdfContentByte.ellipse((float)(ellipse.getX() + lcOffsetX) - lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight()) - lineWidth / 3.0f, (float)(ellipse.getX() + lcOffsetX + ellipse.getWidth()) + lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY) + lineWidth / 3.0f);
                this.pdfContentByte.stroke();
                this.pdfContentByte.ellipse((float)(ellipse.getX() + lcOffsetX) + lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight()) + lineWidth / 3.0f, (float)(ellipse.getX() + lcOffsetX + ellipse.getWidth()) - lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY) - lineWidth / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.ellipse((float)(ellipse.getX() + lcOffsetX), (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight()), (float)(ellipse.getX() + lcOffsetX + ellipse.getWidth()), (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY));
                this.pdfContentByte.stroke();
            }
        }
        this.pdfContentByte.setLineDash(0.0f);
    }

    public void exportImage(JRPrintImage printImage) throws DocumentException, IOException, JRException {
        if (printImage.getModeValue() == ModeEnum.OPAQUE) {
            this.pdfContentByte.setRGBColorFill(printImage.getBackcolor().getRed(), printImage.getBackcolor().getGreen(), printImage.getBackcolor().getBlue());
            this.pdfContentByte.rectangle((float)(printImage.getX() + this.getOffsetX()), (float)(this.pageFormat.getPageHeight() - printImage.getY() - this.getOffsetY()), (float)printImage.getWidth(), (float)(-printImage.getHeight()));
            this.pdfContentByte.fill();
        }
        int topPadding = printImage.getLineBox().getTopPadding();
        int leftPadding = printImage.getLineBox().getLeftPadding();
        int bottomPadding = printImage.getLineBox().getBottomPadding();
        int rightPadding = printImage.getLineBox().getRightPadding();
        int availableImageWidth = printImage.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        Renderable renderer = printImage.getRenderable();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                renderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForImageData(renderer, printImage.getOnErrorTypeValue());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            int xoffset = 0;
            int yoffset = 0;
            Chunk chunk = null;
            float scaledWidth = availableImageWidth;
            float scaledHeight = availableImageHeight;
            if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                Image image = null;
                float xalignFactor = this.getXAlignFactor(printImage);
                float yalignFactor = this.getYAlignFactor(printImage);
                switch (printImage.getScaleImageValue()) {
                    case CLIP: {
                        renderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForDimension(renderer, printImage.getOnErrorTypeValue());
                        if (renderer == null) break;
                        int normalWidth = availableImageWidth;
                        int normalHeight = availableImageHeight;
                        Dimension2D dimension = renderer.getDimension(this.jasperReportsContext);
                        if (dimension != null) {
                            normalWidth = (int)dimension.getWidth();
                            normalHeight = (int)dimension.getHeight();
                        }
                        xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                        yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                        int minWidth = Math.min(normalWidth, availableImageWidth);
                        int minHeight = Math.min(normalHeight, availableImageHeight);
                        BufferedImage bi = new BufferedImage(minWidth, minHeight, 2);
                        Graphics2D g = bi.createGraphics();
                        if (printImage.getModeValue() == ModeEnum.OPAQUE) {
                            g.setColor(printImage.getBackcolor());
                            g.fillRect(0, 0, minWidth, minHeight);
                        }
                        renderer.render(this.jasperReportsContext, g, new java.awt.Rectangle(xoffset > 0 ? 0 : xoffset, yoffset > 0 ? 0 : yoffset, normalWidth, normalHeight));
                        g.dispose();
                        xoffset = xoffset < 0 ? 0 : xoffset;
                        yoffset = yoffset < 0 ? 0 : yoffset;
                        image = Image.getInstance((java.awt.Image)bi, null);
                        break;
                    }
                    case FILL_FRAME: {
                        if (printImage.isUsingCache() && this.loadedImagesMap.containsKey(renderer)) {
                            image = this.loadedImagesMap.get(renderer);
                        } else {
                            try {
                                image = Image.getInstance((byte[])renderer.getImageData(this.jasperReportsContext));
                                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                            }
                            catch (Exception e) {
                                JRImageRenderer tmpRenderer = JRImageRenderer.getOnErrorRendererForImage(this.jasperReportsContext, JRImageRenderer.getInstance(renderer.getImageData(this.jasperReportsContext)), printImage.getOnErrorTypeValue());
                                if (tmpRenderer == null) break;
                                java.awt.Image awtImage = tmpRenderer.getImage(this.jasperReportsContext);
                                image = Image.getInstance((java.awt.Image)awtImage, null);
                            }
                            if (printImage.isUsingCache()) {
                                this.loadedImagesMap.put(renderer, image);
                            }
                        }
                        image.scaleAbsolute((float)availableImageWidth, (float)availableImageHeight);
                        break;
                    }
                    default: {
                        if (printImage.isUsingCache() && this.loadedImagesMap.containsKey(renderer)) {
                            image = this.loadedImagesMap.get(renderer);
                        } else {
                            try {
                                image = Image.getInstance((byte[])renderer.getImageData(this.jasperReportsContext));
                                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                            }
                            catch (Exception e) {
                                JRImageRenderer tmpRenderer = JRImageRenderer.getOnErrorRendererForImage(this.jasperReportsContext, JRImageRenderer.getInstance(renderer.getImageData(this.jasperReportsContext)), printImage.getOnErrorTypeValue());
                                if (tmpRenderer == null) break;
                                java.awt.Image awtImage = tmpRenderer.getImage(this.jasperReportsContext);
                                image = Image.getInstance((java.awt.Image)awtImage, null);
                            }
                            if (printImage.isUsingCache()) {
                                this.loadedImagesMap.put(renderer, image);
                            }
                        }
                        image.scaleToFit((float)availableImageWidth, (float)availableImageHeight);
                        xoffset = (int)(xalignFactor * ((float)availableImageWidth - image.getPlainWidth()));
                        yoffset = (int)(yalignFactor * ((float)availableImageHeight - image.getPlainHeight()));
                        xoffset = xoffset < 0 ? 0 : xoffset;
                        int n = yoffset = yoffset < 0 ? 0 : yoffset;
                    }
                }
                if (image != null) {
                    chunk = new Chunk(image, 0.0f, 0.0f);
                    scaledWidth = image.getScaledWidth();
                    scaledHeight = image.getScaledHeight();
                }
            } else {
                Graphics2D g;
                double normalWidth = availableImageWidth;
                double normalHeight = availableImageHeight;
                double displayWidth = availableImageWidth;
                double displayHeight = availableImageHeight;
                double ratioX = 1.0;
                double ratioY = 1.0;
                Rectangle2D.Double clip = null;
                Dimension2D dimension = renderer.getDimension(this.jasperReportsContext);
                if (dimension != null) {
                    normalWidth = dimension.getWidth();
                    normalHeight = dimension.getHeight();
                    displayWidth = normalWidth;
                    displayHeight = normalHeight;
                    float xalignFactor = this.getXAlignFactor(printImage);
                    float yalignFactor = this.getYAlignFactor(printImage);
                    switch (printImage.getScaleImageValue()) {
                        case CLIP: {
                            xoffset = (int)((double)xalignFactor * ((double)availableImageWidth - normalWidth));
                            yoffset = (int)((double)yalignFactor * ((double)availableImageHeight - normalHeight));
                            clip = new Rectangle2D.Double(-xoffset, -yoffset, availableImageWidth, availableImageHeight);
                            break;
                        }
                        case FILL_FRAME: {
                            ratioX = (double)availableImageWidth / normalWidth;
                            ratioY = (double)availableImageHeight / normalHeight;
                            normalWidth *= ratioX;
                            normalHeight *= ratioY;
                            xoffset = 0;
                            yoffset = 0;
                            break;
                        }
                        default: {
                            ratioX = (double)availableImageWidth / normalWidth;
                            ratioY = (double)availableImageHeight / normalHeight;
                            ratioY = ratioX = ratioX < ratioY ? ratioX : ratioY;
                            xoffset = (int)((double)xalignFactor * ((double)availableImageWidth - (normalWidth *= ratioX)));
                            yoffset = (int)((double)yalignFactor * ((double)availableImageHeight - (normalHeight *= ratioY)));
                        }
                    }
                }
                PdfTemplate template = this.pdfContentByte.createTemplate((float)displayWidth, (float)displayHeight);
                Graphics2D graphics2D = g = ((PdfReportConfiguration)this.getCurrentItemConfiguration()).isForceSvgShapes() != false ? template.createGraphicsShapes((float)displayWidth, (float)displayHeight) : template.createGraphics((float)availableImageWidth, (float)availableImageHeight, (FontMapper)new LocalFontMapper());
                if (clip != null) {
                    g.setClip(clip);
                }
                if (printImage.getModeValue() == ModeEnum.OPAQUE) {
                    g.setColor(printImage.getBackcolor());
                    g.fillRect(0, 0, (int)displayWidth, (int)displayHeight);
                }
                Rectangle2D.Double rectangle = new Rectangle2D.Double(0.0, 0.0, displayWidth, displayHeight);
                renderer.render(this.jasperReportsContext, g, rectangle);
                g.dispose();
                this.pdfContentByte.saveState();
                this.pdfContentByte.addTemplate(template, (float)ratioX, 0.0f, 0.0f, (float)ratioY, (float)(printImage.getX() + this.getOffsetX() + xoffset), (float)(this.pageFormat.getPageHeight() - printImage.getY() - this.getOffsetY() - (int)normalHeight - yoffset));
                this.pdfContentByte.restoreState();
                Image image = this.getPxImage();
                image.scaleAbsolute((float)availableImageWidth, (float)availableImageHeight);
                chunk = new Chunk(image, 0.0f, 0.0f);
                this.pdfWriter.releaseTemplate(template);
            }
            if (chunk != null) {
                this.setAnchor(chunk, printImage, printImage);
                this.setHyperlinkInfo(chunk, printImage);
                this.tagHelper.startImage(printImage);
                ColumnText colText = new ColumnText(this.pdfContentByte);
                int upperY = this.pageFormat.getPageHeight() - printImage.getY() - topPadding - this.getOffsetY() - yoffset;
                int lowerX = printImage.getX() + leftPadding + this.getOffsetX() + xoffset;
                colText.setSimpleColumn(new Phrase(chunk), (float)lowerX, (float)upperY - scaledHeight, (float)lowerX + scaledWidth, (float)upperY, scaledHeight, 0);
                colText.go();
                this.tagHelper.endImage();
            }
        }
        if (printImage.getLineBox().getTopPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getLeftPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getBottomPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (printImage.getLinePen().getLineWidth().floatValue() > 0.0f) {
                this.exportPen(printImage.getLinePen(), printImage);
            }
        } else {
            this.exportBox(printImage.getLineBox(), printImage);
        }
    }

    private float getXAlignFactor(JRPrintImage printImage) {
        float xalignFactor = 0.0f;
        switch (printImage.getHorizontalImageAlign()) {
            case RIGHT: {
                xalignFactor = 1.0f;
                break;
            }
            case CENTER: {
                xalignFactor = 0.5f;
                break;
            }
            default: {
                xalignFactor = 0.0f;
            }
        }
        return xalignFactor;
    }

    private float getYAlignFactor(JRPrintImage printImage) {
        float yalignFactor = 0.0f;
        switch (printImage.getVerticalImageAlign()) {
            case BOTTOM: {
                yalignFactor = 1.0f;
                break;
            }
            case MIDDLE: {
                yalignFactor = 0.5f;
                break;
            }
            default: {
                yalignFactor = 0.0f;
            }
        }
        return yalignFactor;
    }

    protected void setHyperlinkInfo(Chunk chunk, JRPrintHyperlink link) {
        if (link != null) {
            Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(PROPERTY_IGNORE_HYPERLINK, link);
            if (ignoreHyperlink == null) {
                ignoreHyperlink = ((PdfReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreHyperlink();
            }
            if (!ignoreHyperlink.booleanValue()) {
                block0 : switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() == null) break;
                        switch (link.getHyperlinkTargetValue()) {
                            case BLANK: {
                                chunk.setAction(PdfAction.javaScript((String)("if (app.viewerVersion < 7){this.getURL(\"" + link.getHyperlinkReference() + "\");}" + "else {app.launchURL(\"" + link.getHyperlinkReference() + "\", true);};"), (PdfWriter)this.pdfWriter));
                                break block0;
                            }
                        }
                        chunk.setAnchor(link.getHyperlinkReference());
                        break;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() == null) break;
                        chunk.setLocalGoto(link.getHyperlinkAnchor());
                        break;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() == null) break;
                        chunk.setLocalGoto(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + link.getHyperlinkPage().toString());
                        break;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() == null || link.getHyperlinkAnchor() == null) break;
                        chunk.setRemoteGoto(link.getHyperlinkReference(), link.getHyperlinkAnchor());
                        break;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() == null || link.getHyperlinkPage() == null) break;
                        chunk.setRemoteGoto(link.getHyperlinkReference(), link.getHyperlinkPage().intValue());
                        break;
                    }
                    case CUSTOM: {
                        String hyperlink;
                        JRHyperlinkProducerFactory hyperlinkProducerFactory = ((PdfReportConfiguration)this.getCurrentItemConfiguration()).getHyperlinkProducerFactory();
                        if (hyperlinkProducerFactory == null || (hyperlink = hyperlinkProducerFactory.produceHyperlink(link)) == null) break;
                        switch (link.getHyperlinkTargetValue()) {
                            case BLANK: {
                                chunk.setAction(PdfAction.javaScript((String)("if (app.viewerVersion < 7){this.getURL(\"" + hyperlink + "\");}" + "else {app.launchURL(\"" + hyperlink + "\", true);};"), (PdfWriter)this.pdfWriter));
                                break block0;
                            }
                        }
                        chunk.setAnchor(hyperlink);
                    }
                }
            }
        }
    }

    @Override
    protected Locale getTextLocale(JRPrintText text) {
        return super.getTextLocale(text);
    }

    protected Phrase getPhrase(AttributedString as, String text, JRPrintText textElement) {
        Phrase phrase = new Phrase();
        int runLimit = 0;
        AttributedCharacterIterator iterator = as.getIterator();
        Locale locale = this.getTextLocale(textElement);
        boolean firstChunk = true;
        while (runLimit < text.length() && (runLimit = iterator.getRunLimit()) <= text.length()) {
            JRPrintHyperlink hyperlink;
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            Chunk chunk = this.getChunk(attributes, text.substring(iterator.getIndex(), runLimit), locale);
            if (firstChunk) {
                this.setAnchor(chunk, textElement, textElement);
            }
            if ((hyperlink = textElement).getHyperlinkTypeValue() == HyperlinkTypeEnum.NONE) {
                hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK);
            }
            this.setHyperlinkInfo(chunk, hyperlink);
            phrase.add((Object)chunk);
            iterator.setIndex(runLimit);
            firstChunk = false;
        }
        return phrase;
    }

    protected Chunk getChunk(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale) {
        Object script;
        Color backcolor;
        com.lowagie.text.Font font = this.getFont(attributes, locale, false);
        Chunk chunk = new Chunk(text, font);
        if (this.hasUnderline(attributes)) {
            chunk.setUnderline(null, 0.0f, 0.055555556f, 0.0f, -0.083333336f, 0);
        }
        if (this.hasStrikethrough(attributes)) {
            chunk.setUnderline(null, 0.0f, 0.055555556f, 0.0f, 0.33333334f, 0);
        }
        if ((backcolor = (Color)attributes.get(TextAttribute.BACKGROUND)) != null) {
            chunk.setBackground(backcolor);
        }
        if ((script = attributes.get(TextAttribute.SUPERSCRIPT)) != null) {
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(script)) {
                chunk.setTextRise(font.getCalculatedLeading(1.0f) / 2.0f);
            } else if (TextAttribute.SUPERSCRIPT_SUB.equals(script)) {
                chunk.setTextRise(-font.getCalculatedLeading(1.0f) / 2.0f);
            }
        }
        if (this.splitCharacter != null) {
            chunk.setSplitCharacter(this.splitCharacter);
        }
        return chunk;
    }

    protected boolean hasUnderline(Map<AttributedCharacterIterator.Attribute, Object> textAttributes) {
        Integer underline = (Integer)textAttributes.get(TextAttribute.UNDERLINE);
        return TextAttribute.UNDERLINE_ON.equals(underline);
    }

    protected boolean hasStrikethrough(Map<AttributedCharacterIterator.Attribute, Object> textAttributes) {
        Boolean strike = (Boolean)textAttributes.get(TextAttribute.STRIKETHROUGH);
        return TextAttribute.STRIKETHROUGH_ON.equals(strike);
    }

    protected com.lowagie.text.Font getFont(Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale, boolean setFontLines) {
        JRBaseFont jrFont = new JRBaseFont(attributes);
        Exception initialException = null;
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        float fontSizeScale = 1.0f;
        Integer scriptStyle = (Integer)attributes.get(TextAttribute.SUPERSCRIPT);
        if (scriptStyle != null && (TextAttribute.SUPERSCRIPT_SUB.equals(scriptStyle) || TextAttribute.SUPERSCRIPT_SUPER.equals(scriptStyle))) {
            fontSizeScale = 0.6666667f;
        }
        com.lowagie.text.Font font = null;
        String pdfFontName = null;
        String pdfEncoding = null;
        boolean isPdfEmbedded = false;
        boolean isPdfSimulatedBold = false;
        boolean isPdfSimulatedItalic = false;
        FontInfo fontInfo = FontUtil.getInstance(this.jasperReportsContext).getFontInfo(jrFont.getFontName(), locale);
        if (fontInfo == null) {
            pdfFontName = jrFont.getPdfFontName();
            pdfEncoding = jrFont.getPdfEncoding();
            isPdfEmbedded = jrFont.isPdfEmbedded();
        } else {
            FontFamily family = fontInfo.getFontFamily();
            int pdfFontStyle = 0;
            FontFace fontFace = fontInfo.getFontFace();
            if (fontFace != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = fontInfo.getStyle();
            }
            if (pdfFontName == null && jrFont.isBold() && jrFont.isItalic() && (fontFace = family.getBoldItalicFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 3;
            }
            if (pdfFontName == null && jrFont.isBold() && (fontFace = family.getBoldFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 1;
            }
            if (pdfFontName == null && jrFont.isItalic() && (fontFace = family.getItalicFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 2;
            }
            if (pdfFontName == null && (fontFace = family.getNormalFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 0;
            }
            if (pdfFontName == null) {
                pdfFontName = jrFont.getPdfFontName();
            }
            pdfEncoding = family.getPdfEncoding() == null ? jrFont.getPdfEncoding() : family.getPdfEncoding();
            isPdfEmbedded = family.isPdfEmbedded() == null ? jrFont.isPdfEmbedded() : family.isPdfEmbedded().booleanValue();
            isPdfSimulatedBold = jrFont.isBold() && (pdfFontStyle & 1) == 0;
            isPdfSimulatedItalic = jrFont.isItalic() && (pdfFontStyle & 2) == 0;
        }
        int pdfFontStyle = (isPdfSimulatedBold ? 1 : 0) | (isPdfSimulatedItalic ? 2 : 0);
        if (setFontLines) {
            pdfFontStyle |= (jrFont.isUnderline() ? 4 : 0) | (jrFont.isStrikeThrough() ? 8 : 0);
        }
        try {
            font = FontFactory.getFont((String)pdfFontName, (String)pdfEncoding, (boolean)isPdfEmbedded, (float)(jrFont.getFontsize() * fontSizeScale), (int)pdfFontStyle, (Color)forecolor);
            if (font != null && font.getBaseFont() == null && font.getFamily() == -1) {
                font = null;
            }
        }
        catch (Exception e) {
            initialException = e;
        }
        if (font == null) {
            byte[] bytes = null;
            try {
                bytes = RepositoryUtil.getInstance(this.jasperReportsContext).getBytesFromLocation(pdfFontName);
            }
            catch (JRException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_FONT_LOADING_ERROR, new Object[]{pdfFontName, pdfEncoding, isPdfEmbedded}, initialException);
            }
            BaseFont baseFont = null;
            try {
                baseFont = BaseFont.createFont((String)pdfFontName, (String)pdfEncoding, (boolean)isPdfEmbedded, (boolean)true, (byte[])bytes, null);
            }
            catch (DocumentException e) {
                throw new JRRuntimeException(e);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            font = new com.lowagie.text.Font(baseFont, jrFont.getFontsize() * fontSizeScale, pdfFontStyle, forecolor);
        }
        return font;
    }

    public void exportText(JRPrintText text) throws DocumentException {
        JRStyledText styledText = JRStyledTextUtil.getInstance(this.jasperReportsContext).getStyledText(text, this.noBackcolorSelector);
        if (styledText == null) {
            return;
        }
        AbstractPdfTextRenderer textRenderer = this.getTextRenderer(text, styledText);
        textRenderer.initialize(this, this.pdfContentByte, text, styledText, this.getOffsetX(), this.getOffsetY());
        double angle = 0.0;
        switch (text.getRotationValue()) {
            case LEFT: {
                angle = 1.5707963267948966;
                break;
            }
            case RIGHT: {
                angle = -1.5707963267948966;
                break;
            }
            case UPSIDE_DOWN: {
                angle = Math.PI;
                break;
            }
        }
        AffineTransform atrans = new AffineTransform();
        atrans.rotate(angle, textRenderer.getX(), this.pageFormat.getPageHeight() - textRenderer.getY());
        this.pdfContentByte.transform(atrans);
        if (text.getModeValue() == ModeEnum.OPAQUE) {
            Color backcolor = text.getBackcolor();
            this.pdfContentByte.setRGBColorFill(backcolor.getRed(), backcolor.getGreen(), backcolor.getBlue());
            this.pdfContentByte.rectangle((float)textRenderer.getX(), (float)(this.pageFormat.getPageHeight() - textRenderer.getY()), (float)textRenderer.getWidth(), (float)(-textRenderer.getHeight()));
            this.pdfContentByte.fill();
        }
        if (styledText.length() > 0) {
            if (this.glyphRendererAddActualText && textRenderer instanceof PdfGlyphRenderer) {
                this.tagHelper.startText(styledText.getText(), text.getLinkType() != null);
            } else {
                this.tagHelper.startText(text.getLinkType() != null);
            }
            textRenderer.render();
            this.tagHelper.endText();
        }
        atrans = new AffineTransform();
        atrans.rotate(-angle, textRenderer.getX(), this.pageFormat.getPageHeight() - textRenderer.getY());
        this.pdfContentByte.transform(atrans);
        this.exportBox(text.getLineBox(), text);
    }

    protected AbstractPdfTextRenderer getTextRenderer(JRPrintText text, JRStyledText styledText) {
        AbstractPdfTextRenderer textRenderer = this.toUseGlyphRenderer(text) && PdfGlyphRenderer.supported() && this.canUseGlyphRendering(text, styledText) ? new PdfGlyphRenderer(this.jasperReportsContext, this.awtIgnoreMissingFont, this.glyphRendererAddActualText && !this.tagHelper.isTagged) : (text.getLeadingOffset() == 0.0f ? new PdfTextRenderer(this.jasperReportsContext, this.awtIgnoreMissingFont) : new SimplePdfTextRenderer(this.jasperReportsContext, this.awtIgnoreMissingFont));
        return textRenderer;
    }

    protected boolean canUseGlyphRendering(JRPrintText text, JRStyledText styledText) {
        Locale locale = this.getTextLocale(text);
        for (JRStyledText.Run run : styledText.getRuns()) {
            FontKey fontKey = this.extractFontKey(run, locale);
            Boolean canUse = this.glyphRendererFonts.get(fontKey);
            if (canUse == null) {
                canUse = this.canUseGlyphRendering(fontKey);
                this.glyphRendererFonts.put(fontKey, canUse);
            }
            if (canUse.booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected FontKey extractFontKey(JRStyledText.Run run, Locale locale) {
        String family = (String)run.attributes.get(TextAttribute.FAMILY);
        Number posture = (Number)run.attributes.get(TextAttribute.POSTURE);
        boolean italic = TextAttribute.POSTURE_OBLIQUE.equals(posture);
        Number weight = (Number)run.attributes.get(TextAttribute.WEIGHT);
        boolean bold = TextAttribute.WEIGHT_BOLD.equals(weight);
        return new FontKey(family, italic, bold, locale);
    }

    protected boolean canUseGlyphRendering(FontKey fontKey) {
        com.lowagie.text.Font pdfFont;
        BaseFont baseFont;
        HashMap<AttributedCharacterIterator.Attribute, Object> fontAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        fontAttributes.put(TextAttribute.FAMILY, fontKey.family);
        fontAttributes.put(TextAttribute.SIZE, Float.valueOf(10.0f));
        int style = 0;
        if (fontKey.italic) {
            style |= 2;
            fontAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (fontKey.bold) {
            style |= 1;
            fontAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if ((baseFont = (pdfFont = this.getFont(fontAttributes, fontKey.locale, false)).getBaseFont()).getFontType() != 3 || baseFont.isFontSpecific()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("pdf font for " + fontKey + " has type " + baseFont.getFontType() + ", symbol " + baseFont.isFontSpecific() + ", cannot use glyph rendering"));
            }
            return false;
        }
        Font awtFont = this.fontUtil.getAwtFontFromBundles(fontKey.family, style, 10.0f, fontKey.locale, this.awtIgnoreMissingFont);
        if (awtFont == null) {
            awtFont = new Font(fontAttributes);
        }
        String awtFontName = awtFont.getFontName();
        if (log.isDebugEnabled()) {
            log.debug((Object)(fontKey + " resolved to awt font " + awtFontName));
        }
        String[][] pdfFontNames = baseFont.getFullFontName();
        boolean nameMatch = false;
        for (String[] nameArray : pdfFontNames) {
            if (nameArray.length < 4) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(fontKey + " resolved to pdf font " + nameArray[3]));
            }
            if (!awtFontName.equals(nameArray[3])) continue;
            nameMatch = true;
            break;
        }
        return nameMatch;
    }

    protected boolean toUseGlyphRenderer(JRPrintText text) {
        String value = this.styledTextUtil.getTruncatedText(text);
        if (value == null) {
            return false;
        }
        if (this.glyphRendererBlocks.isEmpty()) {
            return false;
        }
        int charCount = value.length();
        char[] chars = new char[charCount];
        value.getChars(0, charCount, chars, 0);
        for (char c : chars) {
            Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
            if (!this.glyphRendererBlocks.contains(block)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("found character in block " + block + ", using the glyph renderer"));
            }
            return true;
        }
        return false;
    }

    protected void exportBox(JRLineBox box, JRPrintElement element) {
        this.exportTopPen(box.getTopPen(), box.getLeftPen(), box.getRightPen(), element);
        this.exportLeftPen(box.getTopPen(), box.getLeftPen(), box.getBottomPen(), element);
        this.exportBottomPen(box.getLeftPen(), box.getBottomPen(), box.getRightPen(), element);
        this.exportRightPen(box.getTopPen(), box.getBottomPen(), box.getRightPen(), element);
        this.pdfContentByte.setLineDash(0.0f);
        this.pdfContentByte.setLineCap(2);
    }

    protected void exportPen(JRPen pen, JRPrintElement element) {
        this.exportTopPen(pen, pen, pen, element);
        this.exportLeftPen(pen, pen, pen, element);
        this.exportBottomPen(pen, pen, pen, element);
        this.exportRightPen(pen, pen, pen, element);
        this.pdfContentByte.setLineDash(0.0f);
        this.pdfContentByte.setLineCap(2);
    }

    protected void exportTopPen(JRPen topPen, JRPen leftPen, JRPen rightPen, JRPrintElement element) {
        if (topPen.getLineWidth().floatValue() > 0.0f) {
            float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f;
            float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            JRPdfExporter.preparePen(this.pdfContentByte, topPen, 0);
            if (topPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float topOffset = topPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) - leftOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset / 3.0f);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) - leftOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY));
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY));
                this.pdfContentByte.stroke();
            }
        }
    }

    protected void exportLeftPen(JRPen topPen, JRPen leftPen, JRPen bottomPen, JRPrintElement element) {
        if (leftPen.getLineWidth().floatValue() > 0.0f) {
            float topOffset = topPen.getLineWidth().floatValue() / 2.0f;
            float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            JRPdfExporter.preparePen(this.pdfContentByte, leftPen, 0);
            if (leftPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float leftOffset = leftPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) - leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX) - leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX), (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX), (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
            }
        }
    }

    protected void exportBottomPen(JRPen leftPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element) {
        if (bottomPen.getLineWidth().floatValue() > 0.0f) {
            float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f;
            float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            JRPdfExporter.preparePen(this.pdfContentByte, bottomPen, 0);
            if (bottomPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float bottomOffset = bottomPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) - leftOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX) - leftOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()));
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()));
                this.pdfContentByte.stroke();
            }
        }
    }

    protected void exportRightPen(JRPen topPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element) {
        if (rightPen.getLineWidth().floatValue() > 0.0f) {
            float topOffset = topPen.getLineWidth().floatValue() / 2.0f;
            float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            JRPdfExporter.preparePen(this.pdfContentByte, rightPen, 0);
            if (rightPen.getLineStyleValue() == LineStyleEnum.DOUBLE) {
                float rightOffset = rightPen.getLineWidth().floatValue();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f);
                this.pdfContentByte.stroke();
            } else {
                this.pdfContentByte.moveTo((float)(element.getX() + lcOffsetX + element.getWidth()), (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset);
                this.pdfContentByte.lineTo((float)(element.getX() + lcOffsetX + element.getWidth()), (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
                this.pdfContentByte.stroke();
            }
        }
    }

    private static void preparePen(PdfContentByte pdfContentByte, JRPen pen, int lineCap) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth <= 0.0f) {
            return;
        }
        pdfContentByte.setLineWidth(lineWidth);
        pdfContentByte.setLineCap(lineCap);
        Color color = pen.getLineColor();
        pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
        switch (pen.getLineStyleValue()) {
            case DOUBLE: {
                pdfContentByte.setLineWidth(lineWidth / 3.0f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            case DOTTED: {
                switch (lineCap) {
                    case 0: {
                        pdfContentByte.setLineDash(lineWidth, lineWidth, 0.0f);
                        break;
                    }
                    case 2: {
                        pdfContentByte.setLineDash(0.0f, 2.0f * lineWidth, 0.0f);
                    }
                }
                break;
            }
            case DASHED: {
                switch (lineCap) {
                    case 0: {
                        pdfContentByte.setLineDash(5.0f * lineWidth, 3.0f * lineWidth, 0.0f);
                        break;
                    }
                    case 2: {
                        pdfContentByte.setLineDash(4.0f * lineWidth, 4.0f * lineWidth, 0.0f);
                    }
                }
                break;
            }
            default: {
                pdfContentByte.setLineDash(0.0f);
            }
        }
    }

    protected static synchronized void registerFonts() {
        if (!fontsRegistered) {
            List<JRPropertiesUtil.PropertySuffix> fontDirs;
            List<JRPropertiesUtil.PropertySuffix> fontFiles = JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance()).getProperties(PDF_FONT_FILES_PREFIX);
            if (!fontFiles.isEmpty()) {
                for (JRPropertiesUtil.PropertySuffix font : fontFiles) {
                    String file = font.getValue();
                    if (file.toLowerCase().endsWith(".ttc")) {
                        FontFactory.register((String)file);
                        continue;
                    }
                    String alias = font.getSuffix();
                    FontFactory.register((String)file, (String)alias);
                }
            }
            if (!(fontDirs = JRPropertiesUtil.getInstance(DefaultJasperReportsContext.getInstance()).getProperties(PDF_FONT_DIRS_PREFIX)).isEmpty()) {
                for (JRPropertiesUtil.PropertySuffix dir : fontDirs) {
                    FontFactory.registerDirectory((String)dir.getValue());
                }
            }
            fontsRegistered = true;
        }
    }

    protected void initBookmarks(List<ExporterInputItem> items) {
        this.bookmarkStack = new BookmarkStack();
        int rootLevel = items.size() > 1 && ((PdfExporterConfiguration)this.getCurrentConfiguration()).isCreatingBatchModeBookmarks() != false ? -1 : 0;
        Bookmark bookmark = new Bookmark(this.pdfContentByte.getRootOutline(), rootLevel);
        this.bookmarkStack.push(bookmark);
    }

    protected void addBookmark(int level, String title, int x, int y) {
        Bookmark parent = this.bookmarkStack.peek();
        while (parent.level >= level) {
            this.bookmarkStack.pop();
            parent = this.bookmarkStack.peek();
        }
        if (!((PdfReportConfiguration)this.getCurrentItemConfiguration()).isCollapseMissingBookmarkLevels().booleanValue()) {
            for (int i = parent.level + 1; i < level; ++i) {
                Bookmark emptyBookmark = new Bookmark(parent, parent.pdfOutline.getPdfDestination(), EMPTY_BOOKMARK_TITLE);
                this.bookmarkStack.push(emptyBookmark);
                parent = emptyBookmark;
            }
        }
        int height = OrientationEnum.PORTRAIT.equals(this.pageFormat.getOrientation()) ? this.pageFormat.getPageHeight() - y : y;
        Bookmark bookmark = new Bookmark(parent, x, height, title);
        this.bookmarkStack.push(bookmark);
    }

    protected void setAnchor(Chunk chunk, JRPrintAnchor anchor, JRPrintElement element) {
        String anchorName = anchor.getAnchorName();
        if (anchorName != null) {
            chunk.setLocalDestination(anchorName);
            if (anchor.getBookmarkLevel() != 0) {
                int x = OrientationEnum.PORTRAIT.equals(this.pageFormat.getOrientation()) ? this.getOffsetX() + element.getX() : this.getOffsetY() + element.getY();
                int y = OrientationEnum.PORTRAIT.equals(this.pageFormat.getOrientation()) ? this.getOffsetY() + element.getY() : this.getOffsetX() + element.getX();
                this.addBookmark(anchor.getBookmarkLevel(), anchor.getAnchorName(), x, y);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFrame(JRPrintFrame frame) throws DocumentException, IOException, JRException {
        if (frame.getModeValue() == ModeEnum.OPAQUE) {
            int x = frame.getX() + this.getOffsetX();
            int y = frame.getY() + this.getOffsetY();
            Color backcolor = frame.getBackcolor();
            this.pdfContentByte.setRGBColorFill(backcolor.getRed(), backcolor.getGreen(), backcolor.getBlue());
            this.pdfContentByte.rectangle((float)x, (float)(this.pageFormat.getPageHeight() - y), (float)frame.getWidth(), (float)(-frame.getHeight()));
            this.pdfContentByte.fill();
        }
        this.setFrameElementsOffset(frame, false);
        try {
            this.exportElements(frame.getElements());
        }
        finally {
            this.restoreElementOffsets();
        }
        this.exportBox(frame.getLineBox(), frame);
    }

    protected PrintPageFormat getCurrentPageFormat() {
        return this.pageFormat;
    }

    @Override
    protected int getOffsetX() {
        return super.getOffsetX() + (this.insideFrame() ? 0 : (this.crtDocumentPageNumber % 2 == 0 ? this.crtEvenPageOffsetX : this.crtOddPageOffsetX));
    }

    @Override
    protected int getOffsetY() {
        return super.getOffsetY() + (this.insideFrame() ? 0 : (this.crtDocumentPageNumber % 2 == 0 ? this.crtEvenPageOffsetY : this.crtOddPageOffsetY));
    }

    protected void exportGenericElement(JRGenericPrintElement element) {
        GenericElementPdfHandler handler = (GenericElementPdfHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), PDF_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement((JRPdfExporterContext)this.exporterContext, element);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No PDF generic element handler for " + element.getGenericType()));
        }
    }

    @Override
    public String getExporterKey() {
        return PDF_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return PDF_EXPORTER_PROPERTIES_PREFIX;
    }

    public static int getIntegerPermissions(String permissions) {
        int permission = 0;
        if (permissions != null && permissions.length() > 0) {
            String[] perms;
            for (String perm : perms = permissions.split("\\|")) {
                if (PdfPermissionsEnum.ALL.equals(PdfPermissionsEnum.getByName(perm))) {
                    permission = PdfExporterConfiguration.ALL_PERMISSIONS;
                    break;
                }
                if (perm == null || perm.length() <= 0) continue;
                permission |= PdfPermissionsEnum.getByName(perm).getPdfPermission().intValue();
            }
        }
        return permission;
    }

    protected static class FontKey {
        String family;
        boolean italic;
        boolean bold;
        Locale locale;

        public FontKey(String family, boolean italic, boolean bold, Locale locale) {
            this.family = family;
            this.italic = italic;
            this.bold = bold;
            this.locale = locale;
        }

        public int hashCode() {
            int hash = 43;
            hash = hash * 29 + this.family.hashCode();
            hash = hash * 29 + (this.italic ? 1231 : 1237);
            hash = hash * 29 + (this.bold ? 1231 : 1237);
            hash = hash * 29 + (this.locale == null ? 0 : this.locale.hashCode());
            return hash;
        }

        public boolean equals(Object obj) {
            FontKey key = (FontKey)obj;
            return this.family.equals(key.family) && this.italic == key.italic && this.bold == key.bold && (this.locale == null ? key.locale == null : key.locale != null && this.locale.equals(key.locale));
        }

        public String toString() {
            return "{family: " + this.family + ", italic: " + this.italic + ", bold: " + this.bold + "}";
        }
    }

    class LocalFontMapper
    implements FontMapper {
        public BaseFont awtToPdf(Font font) {
            HashMap<AttributedCharacterIterator.Attribute, Object> atts = new HashMap<AttributedCharacterIterator.Attribute, Object>();
            atts.putAll(font.getAttributes());
            return JRPdfExporter.this.getFont(atts, null, false).getBaseFont();
        }

        public Font pdfToAwt(BaseFont font, int size) {
            return null;
        }
    }

    protected static class BookmarkStack {
        LinkedList<Bookmark> stack = new LinkedList();

        BookmarkStack() {
        }

        void push(Bookmark bookmark) {
            this.stack.add(bookmark);
        }

        Bookmark pop() {
            return this.stack.removeLast();
        }

        Bookmark peek() {
            return this.stack.getLast();
        }
    }

    protected static class Bookmark {
        final PdfOutline pdfOutline;
        final int level;

        Bookmark(Bookmark parent, int x, int top, String title) {
            this(parent, new PdfDestination(0, (float)x, (float)top, 0.0f), title);
        }

        Bookmark(Bookmark parent, PdfDestination destination, String title) {
            this.pdfOutline = new PdfOutline(parent.pdfOutline, destination, title, false);
            this.level = parent.level + 1;
        }

        Bookmark(PdfOutline pdfOutline, int level) {
            this.pdfOutline = pdfOutline;
            this.level = level;
        }
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRPdfExporterContext {
        protected ExporterContext() {
        }

        @Override
        public PdfWriter getPdfWriter() {
            return JRPdfExporter.this.pdfWriter;
        }
    }
}

