/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.LevelCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.calc.impl.DimensionCurrentMemberCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

class ParallelPeriodFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("ParallelPeriod", "ParallelPeriod([<Level>[, <Numeric Expression>[, <Member>]]])", "Returns a member from a prior period in the same relative position as a specified member.", new String[]{"fm", "fml", "fmln", "fmlnm"}, ParallelPeriodFunDef.class);

    public ParallelPeriodFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 0) {
            Dimension defaultTimeDimension = validator.getQuery().getCube().getTimeDimension();
            if (defaultTimeDimension == null) {
                throw MondrianResource.instance().NoTimeDimensionInCube.ex(this.getName());
            }
            Hierarchy hierarchy = defaultTimeDimension.getHierarchy();
            return MemberType.forHierarchy(hierarchy);
        }
        return super.getResultType(validator, args);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        MemberCalc memberCalc;
        Exp[] args = call.getArgs();
        final ConstantCalc lagValueCalc = args.length >= 2 ? compiler.compileInteger(args[1]) : ConstantCalc.constantInteger(1);
        final LevelCalc ancestorLevelCalc = args.length >= 1 ? compiler.compileLevel(args[0]) : null;
        switch (args.length) {
            case 3: {
                memberCalc = compiler.compileMember(args[2]);
                break;
            }
            case 1: {
                Dimension dimension = args[0].getType().getDimension();
                if (dimension != null) {
                    memberCalc = new DimensionCurrentMemberCalc(dimension);
                    break;
                }
                memberCalc = null;
                break;
            }
            default: {
                Dimension timeDimension = compiler.getEvaluator().getCube().getTimeDimension();
                if (timeDimension == null) {
                    throw MondrianResource.instance().NoTimeDimensionInCube.ex(this.getName());
                }
                memberCalc = new DimensionCurrentMemberCalc(timeDimension);
            }
        }
        return new AbstractMemberCalc(call, new Calc[]{memberCalc, lagValueCalc, ancestorLevelCalc}){

            public Member evaluateMember(Evaluator evaluator) {
                Member member;
                Level ancestorLevel;
                int lagValue = lagValueCalc.evaluateInteger(evaluator);
                if (ancestorLevelCalc != null) {
                    ancestorLevel = ancestorLevelCalc.evaluateLevel(evaluator);
                    member = memberCalc == null ? evaluator.getContext(ancestorLevel.getDimension()) : memberCalc.evaluateMember(evaluator);
                } else {
                    member = memberCalc.evaluateMember(evaluator);
                    Member parent = member.getParentMember();
                    if (parent == null) {
                        return member.getHierarchy().getNullMember();
                    }
                    ancestorLevel = parent.getLevel();
                }
                return ParallelPeriodFunDef.this.parallelPeriod(member, ancestorLevel, evaluator, lagValue);
            }
        };
    }

    Member parallelPeriod(Member member, Level ancestorLevel, Evaluator evaluator, int lagValue) {
        if (member.getHierarchy() != ancestorLevel.getHierarchy()) {
            MondrianResource.instance().FunctionMbrAndLevelHierarchyMismatch.ex("ParallelPeriod", ancestorLevel.getHierarchy().getUniqueName(), member.getHierarchy().getUniqueName());
        }
        if (lagValue == Integer.MIN_VALUE) {
            ++lagValue;
        }
        int distance = member.getLevel().getDepth() - ancestorLevel.getDepth();
        Member ancestor = FunUtil.ancestor(evaluator, member, distance, ancestorLevel);
        Member inLaw = evaluator.getSchemaReader().getLeadMember(ancestor, -lagValue);
        return FunUtil.cousin(evaluator.getSchemaReader(), member, inLaw);
    }
}

