/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.XMPMetaFactory;
import com.adobe.xmp.options.PropertyOptions;
import com.adobe.xmp.options.SerializeOptions;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRRuntimeException;

class XmpWriter {
    private static final String FORMAT_PDF = "application/pdf";
    private static final String PDF_PRODUCER = "Producer";
    private static final String PDF_KEYWORDS = "Keywords";
    private static final String PDFA_PART = "part";
    private static final String PDFA_CONFORMANCE = "conformance";
    private static final String PDFA_PART_1 = "1";
    private static final String PDFA_CONFORMANCE_A = "A";
    private static final String PDFA_CONFORMANCE_B = "B";
    private static final String XMP_CREATE_DATE = "CreateDate";
    private static final String XMP_MODIFY_DATE = "ModifyDate";
    private static final String XMP_CREATOR_TOOL = "CreatorTool";
    private final PdfWriter pdfWriter;
    private final PdfDictionary info;

    XmpWriter(PdfWriter pdfWriter) {
        this.pdfWriter = pdfWriter;
        this.info = pdfWriter.getInfo();
    }

    byte[] createXmpMetadata() {
        try {
            String creator;
            String keywords;
            String subject;
            String author;
            XMPMeta xmp = XMPMetaFactory.create();
            xmp.setObjectName("");
            xmp.setProperty("http://purl.org/dc/elements/1.1/", "dc:format", (Object)FORMAT_PDF);
            xmp.setProperty("http://ns.adobe.com/pdf/1.3/", PDF_PRODUCER, (Object)Document.getVersion());
            if (this.pdfWriter.getPDFXConformance() == 3) {
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_PART, (Object)PDFA_PART_1);
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_CONFORMANCE, (Object)PDFA_CONFORMANCE_A);
            } else if (this.pdfWriter.getPDFXConformance() == 4) {
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_PART, (Object)PDFA_PART_1);
                xmp.setProperty("http://www.aiim.org/pdfa/ns/id/", PDFA_CONFORMANCE, (Object)PDFA_CONFORMANCE_B);
            }
            xmp.setProperty("http://ns.adobe.com/xap/1.0/", XMP_CREATE_DATE, (Object)((PdfDate)this.info.get(PdfName.CREATIONDATE)).getW3CDate());
            xmp.setProperty("http://ns.adobe.com/xap/1.0/", XMP_MODIFY_DATE, (Object)((PdfDate)this.info.get(PdfName.MODDATE)).getW3CDate());
            String title = this.extractInfo(PdfName.TITLE);
            if (title != null) {
                xmp.setLocalizedText("http://purl.org/dc/elements/1.1/", "dc:title", "x-default", "x-default", title);
            }
            if ((author = this.extractInfo(PdfName.AUTHOR)) != null) {
                PropertyOptions arrayOrdered = new PropertyOptions().setArrayOrdered(true);
                xmp.appendArrayItem("http://purl.org/dc/elements/1.1/", "dc:creator", arrayOrdered, author, null);
            }
            if ((subject = this.extractInfo(PdfName.SUBJECT)) != null) {
                PropertyOptions array = new PropertyOptions().setArray(true);
                xmp.appendArrayItem("http://purl.org/dc/elements/1.1/", "dc:subject", array, subject, null);
                xmp.setLocalizedText("http://purl.org/dc/elements/1.1/", "dc:description", "x-default", "x-default", subject);
            }
            if ((keywords = this.extractInfo(PdfName.KEYWORDS)) != null) {
                xmp.setProperty("http://ns.adobe.com/pdf/1.3/", PDF_KEYWORDS, (Object)keywords);
            }
            if ((creator = this.extractInfo(PdfName.CREATOR)) != null) {
                xmp.setProperty("http://ns.adobe.com/xap/1.0/", XMP_CREATOR_TOOL, (Object)creator);
            }
            SerializeOptions options = new SerializeOptions();
            options.setUseCanonicalFormat(true);
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            XMPMetaFactory.serialize((XMPMeta)xmp, (OutputStream)out, (SerializeOptions)options);
            return out.toByteArray();
        }
        catch (XMPException e) {
            throw new JRRuntimeException(e);
        }
    }

    private String extractInfo(PdfName key) {
        PdfString value = (PdfString)this.info.get(key);
        return value == null ? null : value.toUnicodeString();
    }
}

