/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.io.File;
import java.io.Serializable;
import net.sf.jasperreports.compilers.JRBshEvaluator;
import net.sf.jasperreports.compilers.JRBshGenerator;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractCompiler;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRDefaultCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JREvaluator;

public class JRBshCompiler
extends JRAbstractCompiler {
    public static final String LANGUAGE_BSH = "bsh";

    public JRBshCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext, false);
    }

    public JRBshCompiler() {
        this(DefaultJasperReportsContext.getInstance());
    }

    @Override
    protected JREvaluator loadEvaluator(Serializable compileData, String unitName) throws JRException {
        return new JRBshEvaluator((String)((Object)compileData));
    }

    @Override
    protected void checkLanguage(String language) throws JRException {
        if (!LANGUAGE_BSH.equals(language) && !"java".equals(language)) {
            throw new JRException("compilers.language.not.supported", new Object[]{language, LANGUAGE_BSH, "java"});
        }
    }

    @Override
    protected JRCompilationSourceCode generateSourceCode(JRSourceCompileTask sourceTask) throws JRException {
        return new JRDefaultCompilationSourceCode(JRBshGenerator.generateScript(sourceTask), null);
    }

    @Override
    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) throws JRException {
        this.verifyScripts(units);
        for (int i = 0; i < units.length; ++i) {
            String script = units[i].getSourceCode();
            units[i].setCompileData((Serializable)((Object)script));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyScripts(JRCompilationUnit[] units) throws JRException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            classLoader.loadClass(JRCalculator.class.getName());
        }
        catch (ClassNotFoundException e) {
            classLoader = this.getClass().getClassLoader();
        }
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            for (int i = 0; i < units.length; ++i) {
                String script = units[i].getSourceCode();
                JRBshEvaluator bshEvaluator = new JRBshEvaluator(script);
                bshEvaluator.verify(units[i].getExpressions());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    @Override
    protected String getSourceFileName(String unitName) {
        return unitName + ".bsh";
    }
}

