/*
 * Decompiled with CFR 0.152.
 */
package zrastvenaustanova;

import Utill.ComboBoxCellDokument;
import Utill.KlasaKorisneMetode;
import dokumentiTvrtke.BazaDokumenti;
import java.awt.Desktop;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class HiperLink
extends Hyperlink {
    ProgressIndicator progressPane;
    private File temp = null;

    public HiperLink() {
        this.setOnAction(event -> {
            if (this.getText() != null || !this.getText().equals("")) {
                this.progressPane = new ProgressIndicator();
                this.progressPane.setPrefSize(25.0, 25.0);
                this.setGraphic((Node)this.progressPane);
                Task<Void> task = this.createTask();
                new Thread((Runnable)task).start();
                this.progressPane.progressProperty().bind((ObservableValue)task.progressProperty());
            }
        });
        this.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.setText("");
            }
        });
    }

    public String getLink() {
        return this.getText();
    }

    public void setLink(String link) {
        this.setText(link);
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(ComboBoxCellDokument.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.prikaziDokument();
                    this.updateMessage("Running...");
                }
                finally {
                    Platform.runLater(() -> HiperLink.this.setGraphic(null));
                }
                return null;
            }

            private void prikaziDokument() {
                try {
                    HiperLink.this.writeToFileSystem(new ByteArrayInputStream(BazaDokumenti.getDokument(HiperLink.this.getText())), HiperLink.this.getText());
                }
                catch (Exception ex) {
                    Logger.getLogger(ComboBoxCellDokument.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (HiperLink.this.temp.exists()) {
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().open(new File(HiperLink.this.temp.getAbsolutePath()));
                        }
                        catch (IOException eo) {
                            eo.printStackTrace();
                        }
                    } else {
                        System.out.println("Awt Desktop is not supported!");
                    }
                } else {
                    System.out.println("File is not exists!");
                }
            }
        };
    }

    private void writeToFileSystem(ByteArrayInputStream byteArrayInputStream, String nazivDokumenta) throws Exception {
        try {
            this.temp = File.createTempFile(nazivDokumenta, "." + KlasaKorisneMetode.getExtension(new File(nazivDokumenta)));
            this.temp.deleteOnExit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileOutputStream fileOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byteArray = new byte[byteArrayInputStream.available()];
        fileOutputStream = new FileOutputStream(this.temp);
        byteArrayOutputStream = new ByteArrayOutputStream(byteArrayInputStream.available());
        int x = byteArrayInputStream.read(byteArray, 0, byteArrayInputStream.available());
        byteArrayOutputStream.write(byteArray, 0, x);
        byteArrayOutputStream.writeTo(fileOutputStream);
        byteArrayInputStream.close();
        byteArrayOutputStream.close();
        fileOutputStream.close();
    }
}

