/*
 * Decompiled with CFR 0.152.
 */
package zos;

import TamplatePaneli.Template;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import ispisJasper.IspisReporta;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import zastitanaradu.GlavniPanelController;
import zos.BazaZOS;
import zos.UnosOsposibljavanjaZOSController;
import zos.Zos;

public class PopisOsposobljavanjaZOSController
implements Initializable {
    @FXML
    private MenuButton btnIspisU;
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private Button btnIspis;
    @FXML
    private TableView<Zos> tablicaPopisZOS;
    @FXML
    private TableColumn<Zos, String> kolPretraga;
    @FXML
    private TableColumn<Zos, String> kolRedBr;
    @FXML
    private TableColumn<Zos, String> kolBrojZapisnikia;
    @FXML
    private TableColumn<Zos, String> kolBrojUvjerenja;
    @FXML
    private TableColumn<Zos, LocalDate> kolDatumTeorija;
    @FXML
    private TableColumn<Zos, LocalDate> kolDatumPrakticni;
    @FXML
    private TableColumn<Zos, String> kolOib;
    @FXML
    private TableColumn<Zos, String> kolImePrezime;
    private static PopisOsposobljavanjaZOSController instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<Zos> listaZOS = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    BooleanProperty bp = new SimpleBooleanProperty(true);

    public static PopisOsposobljavanjaZOSController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.popuniButtonIspis();
        this.kreirajToolBarFilter();
        this.urediTablicuPopisZOS();
        this.popuniTablicuPopisZos();
        this.urediFilter(this.tablicaPopisZOS);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos ZOS")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos ZOS");
                GlavniPanelController.getInstance().nadodajPanel("Unos ZOS", "/zos/UnosOsposibljavanjaZOS.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos ZOS", "/zos/UnosOsposibljavanjaZOS.fxml");
            }
        });
        this.btnPromjena.setOnAction(event -> {
            Zos z;
            int selectdIndex = this.tablicaPopisZOS.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (z = (Zos)this.tablicaPopisZOS.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos ZOS")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos ZOS");
                    GlavniPanelController.getInstance().nadodajPanel("Unos ZOS", "/zos/UnosOsposibljavanjaZOS.fxml");
                    UnosOsposibljavanjaZOSController.getInstance().izmjenaZOS(z);
                    this.tablicaPopisZOS.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos ZOS", "/zos/UnosOsposibljavanjaZOS.fxml");
                    UnosOsposibljavanjaZOSController.getInstance().izmjenaZOS(z);
                    this.tablicaPopisZOS.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisZOS.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && this.tablicaPopisZOS.getSelectionModel().getSelectedItems().size() < 2 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati zos")).showAndWait()).get() == ButtonType.OK) {
                if (BazaZOS.obrisiZOS((Zos)this.tablicaPopisZOS.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuPopisZos();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan zos", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan zos", 2, "Error graphic");
                }
            }
        });
        this.btnIspis.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisZOS.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.ispis((ObservableList<Zos>)this.tablicaPopisZOS.getSelectionModel().getSelectedItems());
            }
        });
    }

    void popuniButtonIspis() {
        this.btnIspisU.disableProperty().bind((ObservableValue)this.tablicaPopisZOS.getSelectionModel().selectedItemProperty().isNull());
        MenuItem a4 = new MenuItem("Ispis zapisnika");
        a4.setOnAction(event -> {
            int selectdIndex = this.tablicaPopisZOS.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                ObservableList listaZOS = this.tablicaPopisZOS.getSelectionModel().getSelectedItems();
                String idArray = "";
                for (int i = 0; i < listaZOS.size(); ++i) {
                    idArray = i == 0 ? idArray + String.valueOf(((Zos)listaZOS.get(i)).getId()) : idArray + "," + String.valueOf(((Zos)listaZOS.get(i)).getId());
                }
                String sql = "SELECT DISTINCT \n\n    tvrtka.id as idtvrtka,\n    tvrtka.naziv_tvrtke,\n    tvrtka.pbr,\n    tvrtka.mjesto,\n    tvrtka.adresa,\n    tvrtka.oib as tvrtkaoib,\n  zos.*\n    FROM zos,\n    tvrtka\n  \n  WHERE   zos.idtvrtka =tvrtka.id and zos.id  IN (select(unnest(ARRAY [" + idArray + "])))and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
                IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspisU, "ObrazacZOS.jrxml");
            }
        });
        MenuItem a3 = new MenuItem("Ispis uvjerenja");
        a3.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisZOS.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                ObservableList listaZOS = this.tablicaPopisZOS.getSelectionModel().getSelectedItems();
                String idArray = "";
                for (int i = 0; i < listaZOS.size(); ++i) {
                    idArray = i == 0 ? idArray + String.valueOf(((Zos)listaZOS.get(i)).getId()) : idArray + "," + String.valueOf(((Zos)listaZOS.get(i)).getId());
                }
                String sql = "SELECT DISTINCT \n\n    tvrtka.id as idtvrtka,\n    tvrtka.naziv_tvrtke,\n    tvrtka.pbr,\n    tvrtka.mjesto,\n    tvrtka.adresa,\n    tvrtka.oib as tvrtkaoib,\n  zos.*\n    FROM zos,\n    tvrtka\n  \n  WHERE   zos.idtvrtka =tvrtka.id and zos.id  IN (select(unnest(ARRAY [" + idArray + "])))and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
                IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspisU, "UvjerenjeZOS.jrxml");
            }
        });
        this.btnIspisU.getItems().addAll((Object[])new MenuItem[]{a4, new SeparatorMenuItem(), a3});
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"ImePrezime", "Oib", "Broj uvjerenja"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"ImePrezime");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaZOS, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("ImePrezime") ? pregled.getNazivRadnika() != null && pregled.getNazivRadnika().toLowerCase().contains(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Oib") ? pregled.getOibRadnika() != null && pregled.getOibRadnika().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Broj uvjerenja") && pregled.getuBrojUvjerenja() != null && pregled.getuBrojUvjerenja().toLowerCase().startsWith(lowerCaseFilter));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediTablicuPopisZOS() {
        this.tablicaPopisZOS.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisZOS.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisOsposobljavanjaZOSController.this.tablicaPopisZOS.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((Zos)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOS.widthProperty().divide(20.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolBrojZapisnikia.setCellValueFactory(cellData -> ((Zos)cellData.getValue()).brojZapisnikaProperty());
        this.kolBrojZapisnikia.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOS.widthProperty().divide(10.0));
        this.kolBrojZapisnikia.setStyle("-fx-alignment: CENTER;");
        this.kolBrojUvjerenja.setCellValueFactory(cellData -> ((Zos)cellData.getValue()).uBrojUvjerenjaProperty());
        this.kolBrojUvjerenja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOS.widthProperty().divide(10.0));
        this.kolBrojUvjerenja.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumTeorija.setCellValueFactory(cellData -> ((Zos)cellData.getValue()).datumTOsposobljavanjaProperty());
        this.kolDatumTeorija.setCellFactory(dateCellFactory);
        this.kolDatumTeorija.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOS.widthProperty().divide(7.6923076923076925));
        this.kolDatumTeorija.setStyle("-fx-alignment: CENTER;");
        this.kolDatumTeorija.setEditable(false);
        this.kolDatumPrakticni.setCellValueFactory(cellData -> ((Zos)cellData.getValue()).datumPOsposobljavanjaProperty());
        this.kolDatumPrakticni.setCellFactory(dateCellFactory);
        this.kolDatumPrakticni.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOS.widthProperty().divide(7.6923076923076925));
        this.kolDatumPrakticni.setStyle("-fx-alignment: CENTER;");
        this.kolDatumPrakticni.setEditable(false);
        this.kolOib.setCellValueFactory(cellData -> ((Zos)cellData.getValue()).oibRadnikaProperty());
        this.kolOib.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOS.widthProperty().divide(10.0));
        this.kolOib.setStyle("-fx-alignment: CENTER;");
        this.kolImePrezime.setCellValueFactory(cellData -> ((Zos)cellData.getValue()).nazivRadnikaProperty());
        this.kolImePrezime.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOS.widthProperty().divide(3.5714285714285716));
        this.kolImePrezime.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledDjelatnika = new TableColumn("Pregled");
        kolPregledDjelatnika.setSortable(false);
        kolPregledDjelatnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOS.widthProperty().divide(10.0));
        kolPregledDjelatnika.setStyle("-fx-alignment: CENTER;");
        kolPregledDjelatnika.setCellFactory((Callback)new Callback<TableColumn<Zos, Boolean>, TableCell<Zos, Boolean>>(){

            public TableCell<Zos, Boolean> call(TableColumn<Zos, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledDjelatnika);
    }

    public void popuniTablicuPopisZos() {
        this.tablicaPopisZOS.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaZOS.clear();
        this.tablicaPopisZOS.getItems().clear();
    }

    private Task createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisOsposobljavanjaZOSController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaZOS.dajObrasceZos(GlavniPanelController.getOdabranaTvrtka());
                    PopisOsposobljavanjaZOSController.this.popuniTablicuPopisZos(rs);
                }
                finally {
                    Platform.runLater(() -> PopisOsposobljavanjaZOSController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuPopisZos(ResultSet rs) {
        Zos z = null;
        int br = 1;
        try {
            while (rs.next()) {
                z = new Zos();
                z.setId(rs.getInt("id"));
                z.setRedBroj(String.valueOf(br));
                z.setBrojZapisnika(rs.getString("brojzapisnika"));
                z.setNazivRadnika(rs.getString("nazivradnika"));
                z.setOibRadnika(rs.getString("oib"));
                z.setTeorijaMjestoOsposobljavanja(rs.getString("tmjesto"));
                z.setDatumTOsposobljavanja(DateUtil.getLocalDate(rs.getDate("tdatumosposobljavanja")));
                z.settStrucnjakZNR(rs.getString("tstrucnjakznr"));
                z.settOsposobljeniRadnik(rs.getString("tosposobljeniradnik"));
                z.setP1(rs.getBoolean("p1"));
                z.setP2(rs.getBoolean("p2"));
                z.setP3(rs.getBoolean("p3"));
                z.setP4(rs.getBoolean("p4"));
                z.setP5(rs.getBoolean("p5"));
                z.setP6(rs.getBoolean("p6"));
                z.setP7(rs.getBoolean("p7"));
                z.setP8(rs.getBoolean("p8"));
                z.setDatumPOsposobljavanja(DateUtil.getLocalDate(rs.getDate("pdatumprovjere")));
                z.setpMjesto(rs.getString("pmjesto"));
                z.setpOvlastenik(rs.getString("pneposredniovlastenik"));
                z.setpFunkcija(rs.getString("pfunkcija"));
                z.setpStrucnjakZNROsposobljavanje(rs.getString("pstrucnjakznrosposobljavanje"));
                z.setpStrucnjakZNR(rs.getString("pstrucnjakznr"));
                z.setuZaglavlje(rs.getString("uzaglavlje"));
                z.setuBrojUvjerenja(rs.getString("ubrojuvjerenja"));
                z.setuPolaznik(rs.getString("upolaznik"));
                z.setuRodjen(rs.getString("urodjen"));
                z.setuMjesto(rs.getString("umjestorodjenja"));
                z.setuOpcina(rs.getString("upcina"));
                z.setuZaposlenU(rs.getString("uzaposlenu"));
                z.setuRadnoMjesto(rs.getString("uradnomjesto"));
                z.setDatumUOsposobljavanja(DateUtil.getLocalDate(rs.getDate("udatumosposobljavanja")));
                z.setuProgramOsposobljavanja(rs.getString("uprogram"));
                z.setuUvjerenjeOpis(rs.getString("uopisuvjerenja"));
                z.setuUvjerenjeVrijediU(rs.getString("uuvjerenjevrijediu"));
                z.setuMjestoUvjerenja(rs.getString("umjestouvjerenja"));
                z.setDatumUUvjerenja(DateUtil.getLocalDate(rs.getDate("udatumuvjernja")));
                z.setuOvlasteniPotpisnik(rs.getString("uovlastenipotpisnik"));
                z.setUpodnozje(rs.getString("upodnozje"));
                this.listaZOS.add((Object)z);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisOsposobljavanjaZOSController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisOsposobljavanjaZOSController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisZOS.getItems().addAll(this.listaZOS);
    }

    private void ispis(ObservableList<Zos> lista) {
        String idArray = "";
        for (int i = 0; i < lista.size(); ++i) {
            idArray = i == 0 ? idArray + String.valueOf(((Zos)lista.get(i)).getId()) : idArray + "," + String.valueOf(((Zos)lista.get(i)).getId());
        }
        String sql = "SELECT DISTINCT \n\n    tvrtka.id as idtvrtka,\n    tvrtka.naziv_tvrtke,\n    tvrtka.pbr,\n    tvrtka.mjesto,\n    tvrtka.adresa,\n    tvrtka.oib as tvrtkaoib,\n  zos.*\n    FROM zos,\n    tvrtka\n  \n  WHERE   zos.idtvrtka =tvrtka.id and zos.id  IN (select(unnest(ARRAY [" + idArray + "])))and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
        IspisReporta.ispisButtonSaSubreportom(sql, this.btnIspis, "ObrazacZOS.jrxml");
    }

    private class ButtonCell
    extends TableCell<Zos, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    Zos z;
                    int selectdIndex = PopisOsposobljavanjaZOSController.this.tablicaPopisZOS.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (z = (Zos)PopisOsposobljavanjaZOSController.this.tablicaPopisZOS.getSelectionModel().getSelectedItem()) != null) {
                        Template.getTamplate().showTemplate("zos/UnosOsposibljavanjaZOS.fxml", "anchorPanel", "/ro2/ro2.css");
                        UnosOsposibljavanjaZOSController.getInstance().izmjenaZOS(z);
                        PopisOsposobljavanjaZOSController.this.tablicaPopisZOS.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PopisOsposobljavanjaZOSController.this.tablicaPopisZOS.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

