/*
 * Decompiled with CFR 0.152.
 */
package zoop;

import TamplatePaneli.Template;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import ispisJasper.IspisReporta;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import zastitanaradu.GlavniPanelController;
import zoop.BazaZoop;
import zoop.UnosZOOPController;
import zoop.Zoop;

public class PopisZOOPController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private MenuButton btnIspis;
    @FXML
    private TableView<Zoop> tablicaPopisZOOP;
    @FXML
    private TableColumn<Zoop, String> kolPretraga;
    @FXML
    private TableColumn<Zoop, String> kolRedBr;
    @FXML
    private TableColumn<Zoop, String> kolBrojZapisnika;
    @FXML
    private TableColumn<Zoop, String> kolBrojUvjerenja;
    @FXML
    private TableColumn<Zoop, LocalDate> kolDatumOsposobljavanja;
    @FXML
    private TableColumn<Zoop, String> kolOib;
    @FXML
    private TableColumn<Zoop, String> kolImePrezime;
    private static PopisZOOPController instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<Zoop> listaZOOP = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    BooleanProperty bp = new SimpleBooleanProperty(true);

    public static PopisZOOPController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.popuniButtonIspis();
        this.kreirajToolBarFilter();
        this.urediTablicuPopisZOOP();
        this.popuniTablicuPopisZOOP();
        this.urediFilter(this.tablicaPopisZOOP);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos ZOOP")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos ZOOP");
                GlavniPanelController.getInstance().nadodajPanel("Unos ZOOP", "/zoop/UnosZOOP.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos ZOOP", "/zoop/UnosZOOP.fxml");
            }
        });
        this.btnPromjena.setOnAction(event -> {
            Zoop z;
            int selectdIndex = this.tablicaPopisZOOP.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (z = (Zoop)this.tablicaPopisZOOP.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos ZOOP")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos ZOOP");
                    GlavniPanelController.getInstance().nadodajPanel("Unos ZOOP", "/zoop/UnosZOOP.fxml");
                    UnosZOOPController.getInstance().izmjenaZOOP(z);
                    this.tablicaPopisZOOP.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos ZOOP", "/zoop/UnosZOOP.fxml");
                    UnosZOOPController.getInstance().izmjenaZOOP(z);
                    this.tablicaPopisZOOP.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisZOOP.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && this.tablicaPopisZOOP.getSelectionModel().getSelectedItems().size() < 2 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati zoop")).showAndWait()).get() == ButtonType.OK) {
                if (BazaZoop.obrisiZOOP((Zoop)this.tablicaPopisZOOP.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuPopisZOOP();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan zoop", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan zoop", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"ImePrezime", "Oib", "Broj uvjerenja"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"ImePrezime");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaZOOP, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("ImePrezime") ? pregled.getNazivRadnika() != null && pregled.getNazivRadnika().toLowerCase().contains(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Oib") ? pregled.getOibRadnika() != null && pregled.getOibRadnika().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Broj uvjerenja") && pregled.getuBrojUvjerenja() != null && pregled.getuBrojUvjerenja().toLowerCase().startsWith(lowerCaseFilter));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    void popuniButtonIspis() {
        this.btnIspis.disableProperty().bind((ObservableValue)this.tablicaPopisZOOP.getSelectionModel().selectedItemProperty().isNull());
        MenuItem a4 = new MenuItem("Ispis zapisnika");
        a4.setOnAction(event -> {
            int selectdIndex = this.tablicaPopisZOOP.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                ObservableList listaZOS = this.tablicaPopisZOOP.getSelectionModel().getSelectedItems();
                String idArray = "";
                for (int i = 0; i < listaZOS.size(); ++i) {
                    idArray = i == 0 ? idArray + String.valueOf(((Zoop)listaZOS.get(i)).getId()) : idArray + "," + String.valueOf(((Zoop)listaZOS.get(i)).getId());
                }
                String sql = "SELECT DISTINCT \n\n    tvrtka.id as idtvrtka,\n    tvrtka.naziv_tvrtke,\n    tvrtka.pbr,\n    tvrtka.mjesto,\n    tvrtka.adresa,\n    tvrtka.oib as tvrtkaoib,\n  zoop.*\n    FROM zoop,\n    tvrtka\n  \n  WHERE   zoop.idtvrtka =tvrtka.id and zoop.id  IN (select(unnest(ARRAY [" + idArray + "])))and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
                IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspis, "ObrazacZOOP.jrxml");
            }
        });
        MenuItem a3 = new MenuItem("Ispis uvjerenja");
        a3.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisZOOP.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                ObservableList listaZOS = this.tablicaPopisZOOP.getSelectionModel().getSelectedItems();
                String idArray = "";
                for (int i = 0; i < listaZOS.size(); ++i) {
                    idArray = i == 0 ? idArray + String.valueOf(((Zoop)listaZOS.get(i)).getId()) : idArray + "," + String.valueOf(((Zoop)listaZOS.get(i)).getId());
                }
                String sql = "SELECT DISTINCT \n\n    tvrtka.id as idtvrtka,\n    tvrtka.naziv_tvrtke,\n    tvrtka.pbr,\n    tvrtka.mjesto,\n    tvrtka.adresa,\n    tvrtka.oib as tvrtkaoib,\n  zoop.*\n    FROM zoop,\n    tvrtka\n  \n  WHERE   zoop.idtvrtka =tvrtka.id and zoop.id  IN (select(unnest(ARRAY [" + idArray + "])))and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
                IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspis, "UvjerenjeZOOP.jrxml");
            }
        });
        this.btnIspis.getItems().addAll((Object[])new MenuItem[]{a4, new SeparatorMenuItem(), a3});
    }

    private void urediTablicuPopisZOOP() {
        this.tablicaPopisZOOP.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisZOOP.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisZOOPController.this.tablicaPopisZOOP.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((Zoop)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOOP.widthProperty().divide(20.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolBrojZapisnika.setCellValueFactory(cellData -> ((Zoop)cellData.getValue()).brojZapisnikaProperty());
        this.kolBrojZapisnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOOP.widthProperty().divide(10.0));
        this.kolBrojZapisnika.setStyle("-fx-alignment: CENTER;");
        this.kolBrojUvjerenja.setCellValueFactory(cellData -> ((Zoop)cellData.getValue()).uBrojUvjerenjaProperty());
        this.kolBrojUvjerenja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOOP.widthProperty().divide(10.0));
        this.kolBrojUvjerenja.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumOsposobljavanja.setCellValueFactory(cellData -> ((Zoop)cellData.getValue()).datumTOsposobljavanjaProperty());
        this.kolDatumOsposobljavanja.setCellFactory(dateCellFactory);
        this.kolDatumOsposobljavanja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOOP.widthProperty().divide(6.666666666666667));
        this.kolDatumOsposobljavanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumOsposobljavanja.setEditable(false);
        this.kolOib.setCellValueFactory(cellData -> ((Zoop)cellData.getValue()).oibRadnikaProperty());
        this.kolOib.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOOP.widthProperty().divide(10.0));
        this.kolOib.setStyle("-fx-alignment: CENTER;");
        this.kolImePrezime.setCellValueFactory(cellData -> ((Zoop)cellData.getValue()).nazivRadnikaProperty());
        this.kolImePrezime.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOOP.widthProperty().divide(2.5641025641025643));
        this.kolImePrezime.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledDjelatnika = new TableColumn("Pregled");
        kolPregledDjelatnika.setSortable(false);
        kolPregledDjelatnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZOOP.widthProperty().divide(10.0));
        kolPregledDjelatnika.setStyle("-fx-alignment: CENTER;");
        kolPregledDjelatnika.setCellFactory((Callback)new Callback<TableColumn<Zoop, Boolean>, TableCell<Zoop, Boolean>>(){

            public TableCell<Zoop, Boolean> call(TableColumn<Zoop, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledDjelatnika);
    }

    public void popuniTablicuPopisZOOP() {
        this.tablicaPopisZOOP.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaZOOP.clear();
        this.tablicaPopisZOOP.getItems().clear();
    }

    private Task createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisZOOPController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaZoop.dajObrasceZoop(GlavniPanelController.getOdabranaTvrtka());
                    PopisZOOPController.this.popuniTablicuPopisZoop(rs);
                }
                finally {
                    Platform.runLater(() -> PopisZOOPController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuPopisZoop(ResultSet rs) {
        Zoop z = null;
        int br = 1;
        try {
            while (rs.next()) {
                z = new Zoop();
                z.setId(rs.getInt("id"));
                z.setRedBroj(String.valueOf(br));
                z.setOsposobljavanje(rs.getString("osposobljavanje"));
                z.setBrojZapisnika(rs.getString("brojzapisnika"));
                z.setNazivRadnika(rs.getString("nazivradnika"));
                z.setOibRadnika(rs.getString("oib"));
                z.setTeorijaMjestoOsposobljavanja(rs.getString("tmjesto"));
                z.setDatumTOsposobljavanja(DateUtil.getLocalDate(rs.getDate("tdatumosposobljavanja")));
                z.settStrucnjakZNR(rs.getString("tstrucnjakznr"));
                z.settOsposobljeniRadnik(rs.getString("tosposobljeniradnik"));
                z.setP1(rs.getBoolean("p1"));
                z.setP2(rs.getBoolean("p2"));
                z.setP3(rs.getBoolean("p3"));
                z.setP4(rs.getBoolean("p4"));
                z.setP5(rs.getBoolean("p5"));
                z.setP6(rs.getBoolean("p6"));
                z.setP7(rs.getBoolean("p7"));
                z.setuZaglavlje(rs.getString("uzaglavlje"));
                z.setuBrojUvjerenja(rs.getString("ubrojuvjerenja"));
                z.setuPolaznik(rs.getString("upolaznik"));
                z.setuRodjen(rs.getString("urodjen"));
                z.setuMjesto(rs.getString("umjestorodjenja"));
                z.setuOpcina(rs.getString("upcina"));
                z.setuZaposlenU(rs.getString("uzaposlenu"));
                z.setuRadnoMjesto(rs.getString("uradnomjesto"));
                z.setDatumUOsposobljavanja(DateUtil.getLocalDate(rs.getDate("udatumosposobljavanja")));
                z.setuProgramOsposobljavanja(rs.getString("uprogram"));
                z.setuUvjerenjeOpis(rs.getString("uopisuvjerenja"));
                z.setuUvjerenjeVrijediU(rs.getString("uuvjerenjevrijediu"));
                z.setuMjestoUvjerenja(rs.getString("umjestouvjerenja"));
                z.setDatumUUvjerenja(DateUtil.getLocalDate(rs.getDate("udatumuvjernja")));
                z.setuOvlasteniPotpisnik(rs.getString("uovlastenipotpisnik"));
                z.setUpodnozje(rs.getString("upodnozje"));
                this.listaZOOP.add((Object)z);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisZOOPController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisZOOPController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisZOOP.getItems().addAll(this.listaZOOP);
    }

    private class ButtonCell
    extends TableCell<Zoop, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    Zoop z;
                    int selectdIndex = PopisZOOPController.this.tablicaPopisZOOP.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (z = (Zoop)PopisZOOPController.this.tablicaPopisZOOP.getSelectionModel().getSelectedItem()) != null) {
                        Template.getTamplate().showTemplate("zoop/UnosZOOP.fxml", "anchorPanel", "/ro2/ro2.css");
                        UnosZOOPController.getInstance().izmjenaZOOP(z);
                        PopisZOOPController.this.tablicaPopisZOOP.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PopisZOOPController.this.tablicaPopisZOOP.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

