/*
 * Decompiled with CFR 0.152.
 */
package zakoni;

import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import zakoni.BazaZakon;
import zakoni.PregledZakonaController;
import zakoni.Zakon;
import zastitanaradu.GlavniPanelController;

public class UnosZakonaController
implements Initializable {
    @FXML
    private Button btnSpremi;
    @FXML
    private TextField txtNaziv;
    @FXML
    private TextField txtPodrucije;
    @FXML
    private TextField txtNN;
    @FXML
    private TextField txtGodina;
    @FXML
    private CheckBox chboxNaSnazi;
    private static UnosZakonaController instance;
    private boolean izmjenaZakona = false;
    private Zakon z;

    public static UnosZakonaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtNaziv, this.txtPodrucije);
        this.btnSpremi.setOnAction(e -> this.unosZakon());
    }

    private void unosZakon() {
        boolean bNazivZakona = FormValidation.textFieldValidationonlyText(this.txtNaziv);
        if (bNazivZakona) {
            if (this.izmjenaZakona) {
                if (BazaZakon.izmjenaZakona(GlavniPanelController.getOdabranaTvrtka(), this.dajZakon(), this.z.getId())) {
                    PregledZakonaController.getInstance().popuniTablicuZakon();
                    GlavniPanelController.getInstance().zatvoriTab("Unos zakona/pravilnika");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena zakona", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena zakona", 2, "Error graphic");
                }
            } else if (BazaZakon.unesiNoviZakon(GlavniPanelController.getOdabranaTvrtka(), this.dajZakon())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesena zakona", 1, "Information graphic");
                PregledZakonaController.getInstance().popuniTablicuZakon();
                GlavniPanelController.getInstance().zatvoriTab("Unos zakona/pravilnika");
                this.izmjenaZakona = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesena zakona", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti naziv zakona");
            alert.showAndWait();
        }
    }

    private Zakon dajZakon() {
        Zakon z = new Zakon();
        z.setNaziv(this.txtNaziv.getText());
        z.setPodrucije(this.txtPodrucije.getText());
        z.setNN(this.txtNN.getText());
        z.setGodina(this.txtGodina.getText());
        z.setNasnazi(this.chboxNaSnazi.isSelected());
        return z;
    }

    public void izmjenaOdjela(Zakon z) {
        this.izmjenaZakona = true;
        this.z = z;
        this.txtNaziv.setText(z.getNaziv());
        this.txtPodrucije.setText(z.getPodrucije());
        this.txtNN.setText(z.getNN());
        this.txtGodina.setText(z.getGodina());
        this.chboxNaSnazi.setSelected(z.isNasnazi());
    }
}

