/*
 * Decompiled with CFR 0.152.
 */
package webview;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.application.HostServices;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import zastitanaradu.GlavniPanelController;

public class NavigationBar
extends HBox {
    private FileChooser fileChooser = new FileChooser();

    public NavigationBar(final WebView webView, String homePageUrl, boolean goToHomePage) {
        this.setSpacing(4.0);
        this.setAlignment(Pos.CENTER_LEFT);
        this.setStyle("-fx-padding: 10;-fx-border-style: solid inside;-fx-border-width: 2;-fx-border-insets: 5;-fx-border-radius: 5;-fx-border-color: gray;");
        Label label = new Label("URL:");
        label.setStyle("-fx-font-weight:bold");
        this.fileChooser.setTitle("Open Web Content");
        this.fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("HTML Files", new String[]{"*.html", "*.htm"})});
        final WebEngine webEngine = webView.getEngine();
        final TextField pageUrl = new TextField();
        Button refreshButton = new Button("Refresh");
        Button goButton = new Button("Go");
        Button homeButton = new Button("Home");
        Button openButton = new Button("Open");
        HBox.setHgrow((Node)pageUrl, (Priority)Priority.ALWAYS);
        pageUrl.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (!pageUrl.getText().contains("http://") || !pageUrl.getText().contains("https://")) {
                    webEngine.load("http://" + pageUrl.getText());
                } else {
                    webEngine.load(pageUrl.getText());
                }
            }
        });
        webEngine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ov, String oldvalue, String newvalue) {
                pageUrl.setText(newvalue);
                if (pageUrl.getText().contains(".pdf") || pageUrl.getText().contains(".doc") || pageUrl.getText().contains(".xls")) {
                    GlavniPanelController.getHosting().showDocument(pageUrl.getText());
                }
            }
        });
        refreshButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                webEngine.reload();
            }
        });
        goButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (pageUrl.getText().contains(".pdf")) {
                    GlavniPanelController.getHosting().showDocument(pageUrl.getText());
                }
                if (!pageUrl.getText().contains("http:") && !pageUrl.getText().contains("https:")) {
                    webEngine.load("http://" + pageUrl.getText());
                } else {
                    webEngine.load(pageUrl.getText());
                }
            }
        });
        homeButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                URL reportSrcFile = GlavniPanelController.getInstance().ucitajPostavke("Reporti/Pregled%20zakonske%20regulative.html");
                webEngine.load(reportSrcFile.toString());
            }
        });
        openButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                File selectedFile = NavigationBar.this.fileChooser.showOpenDialog(webView.getScene().getWindow());
                if (selectedFile != null) {
                    try {
                        webEngine.load(selectedFile.toURI().toURL().toExternalForm());
                    }
                    catch (MalformedURLException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.getChildren().addAll((Object[])new Node[]{label, pageUrl, goButton, refreshButton, homeButton, openButton});
        if (goToHomePage) {
            webEngine.load(homePageUrl);
        }
    }

    static URL ucitajPostavke(String putanjaFile) {
        HostServices hosting = GlavniPanelController.getHosting();
        URL configUrl = null;
        try {
            configUrl = new URL(hosting.resolveURI(hosting.getDocumentBase(), putanjaFile));
            System.out.println("Loading config properties from: " + configUrl);
        }
        catch (IOException e) {
            System.out.println("Unable to load config properties from: " + configUrl);
        }
        return configUrl;
    }
}

