/*
 * Decompiled with CFR 0.152.
 */
package webview;

import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import netscape.javascript.JSObject;

class Browser
extends Region {
    private final HBox toolBar;
    private static final String[] imageFiles = new String[]{"product.png", "blog.png", "documentation.png", "partners.png", "help.png"};
    private static final String[] captions = new String[]{"Products", "Blogs", "Documentation", "Partners", "Help"};
    private static final String[] urls = new String[]{"http://www.oracle.com/products/index.html", "http://blogs.oracle.com/", "http://docs.oracle.com/javase/index.html", "http://www.oracle.com/partners/index.html", "http://www.oracle.com/partners/index.html"};
    final ImageView selectedImage = new ImageView();
    final Hyperlink[] hpls = new Hyperlink[captions.length];
    final Image[] images = new Image[imageFiles.length];
    final WebView browser = new WebView();
    final WebEngine webEngine = this.browser.getEngine();
    final Button toggleHelpTopics = new Button("Toggle Help Topics");
    final WebView smallView = new WebView();
    final ComboBox comboBox = new ComboBox();
    private boolean needDocumentationButton = false;

    public Browser(Stage stage) {
        this.getStyleClass().add((Object)"browser");
        for (int i = 0; i < captions.length; ++i) {
            Hyperlink hpl = this.hpls[i] = new Hyperlink(captions[i]);
            String url = urls[i];
            boolean addButton = hpl.getText().equals("Help");
            hpl.setOnAction(e -> {
                this.needDocumentationButton = addButton;
                this.webEngine.load(url);
            });
        }
        this.comboBox.setPrefWidth(60.0);
        this.toolBar = new HBox();
        this.toolBar.setAlignment(Pos.CENTER);
        this.toolBar.getStyleClass().add((Object)"browser-toolbar");
        this.toolBar.getChildren().add((Object)this.comboBox);
        this.toolBar.getChildren().addAll((Object[])this.hpls);
        this.toolBar.getChildren().add((Object)this.createSpacer());
        this.toggleHelpTopics.setOnAction(t -> this.webEngine.executeScript("toggle_visibility('help_topics')"));
        this.smallView.setPrefSize(120.0, 80.0);
        this.webEngine.setCreatePopupHandler(config -> {
            this.smallView.setFontScale(0.8);
            if (!this.toolBar.getChildren().contains((Object)this.smallView)) {
                this.toolBar.getChildren().add((Object)this.smallView);
            }
            return this.smallView.getEngine();
        });
        WebHistory history = this.webEngine.getHistory();
        history.getEntries().addListener(c -> {
            c.next();
            c.getRemoved().stream().forEach(e -> this.comboBox.getItems().remove((Object)e.getUrl()));
            c.getAddedSubList().stream().forEach(e -> this.comboBox.getItems().add((Object)e.getUrl()));
        });
        this.comboBox.setOnAction(ev -> {
            int offset = this.comboBox.getSelectionModel().getSelectedIndex() - history.getCurrentIndex();
            history.go(offset);
        });
        this.webEngine.getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> {
            this.toolBar.getChildren().remove((Object)this.toggleHelpTopics);
            if (newState == Worker.State.SUCCEEDED) {
                JSObject win = (JSObject)this.webEngine.executeScript("window");
                win.setMember("app", new JavaApp());
                if (this.needDocumentationButton) {
                    this.toolBar.getChildren().add((Object)this.toggleHelpTopics);
                }
            }
        });
        ContextMenu cm = new ContextMenu();
        MenuItem cmItem1 = new MenuItem("Print");
        cm.getItems().add((Object)cmItem1);
        this.toolBar.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            if (e.getButton() == MouseButton.SECONDARY) {
                cm.show((Node)this.toolBar, e.getScreenX(), e.getScreenY());
            }
        });
        cmItem1.setOnAction(e -> {
            PrinterJob job = PrinterJob.createPrinterJob();
            if (job != null) {
                this.webEngine.print(job);
                job.endJob();
            }
        });
        this.webEngine.load("https://mozilla.github.io/pdf.js/web/viewer.html");
        this.getChildren().add((Object)this.toolBar);
        this.getChildren().add((Object)this.browser);
    }

    private Node createSpacer() {
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        return spacer;
    }

    protected void layoutChildren() {
        double w = this.getWidth();
        double h = this.getHeight();
        double tbHeight = this.toolBar.prefHeight(w);
        this.layoutInArea((Node)this.browser, 0.0, 0.0, w, h - tbHeight, 0.0, HPos.CENTER, VPos.CENTER);
        this.layoutInArea((Node)this.toolBar, 0.0, h - tbHeight, w, tbHeight, 0.0, HPos.CENTER, VPos.CENTER);
    }

    protected double computePrefWidth(double height) {
        return 900.0;
    }

    protected double computePrefHeight(double width) {
        return 600.0;
    }

    public class JavaApp {
        public void exit() {
            Platform.exit();
        }
    }
}

