/*
 * Decompiled with CFR 0.152.
 */
package vatrogasniaparatiredovnipregled;

import Utill.DateCell;
import Utill.DateUtil;
import Utill.FxDialogs;
import Utill.FxUtilTest;
import Utill.KlasaKorisneMetode;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ListCell;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.ComboBoxListCell;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import kadrovska.BazaDjelatnik;
import poslovnejedinice.PoslovneJedinice;
import vatrogasniaparatiredovnipregled.BazaRedovniPregled;
import vatrogasniaparatiredovnipregled.PopisRedovnogPregledaController;
import vatrogasniaparatiredovnipregled.RedovniPregled;
import vatrogasniaparatiredovnipregled.RedovniPregledAparati;
import zastitanaradu.GlavniPanelController;

public class UnosRedovnogPregledaController
implements Initializable {
    @FXML
    private MenuButton btnUnosVA;
    @FXML
    private Button btnSpremi;
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<RedovniPregledAparati> tablicaPopisAparata;
    @FXML
    private TableColumn<RedovniPregledAparati, String> kolRedbr;
    @FXML
    private TableColumn<RedovniPregledAparati, String> kolPoslovnaJedinica;
    @FXML
    private TableColumn<RedovniPregledAparati, String> kolLokacija;
    @FXML
    private TableColumn<RedovniPregledAparati, String> kolVrstaAparata;
    @FXML
    private TableColumn<RedovniPregledAparati, LocalDate> kolDatumPregleda;
    @FXML
    private TableColumn<RedovniPregledAparati, String> kol1;
    @FXML
    private TableColumn<RedovniPregledAparati, String> kol2;
    @FXML
    private TableColumn<RedovniPregledAparati, String> kol3;
    @FXML
    private TableColumn<RedovniPregledAparati, String> kol4;
    @FXML
    private TextArea txtAreaNedostaci;
    @FXML
    private TextField txtOtklonioDjelatnik;
    @FXML
    private DatePicker dateNedostaci;
    @FXML
    private TextField txtSatNedostaci;
    @FXML
    private TextArea txtAreaNazivOvlasteneOsobe;
    @FXML
    private TextField txtNedostaciOdgovornaOsoba;
    @FXML
    private TextField txtU;
    @FXML
    private DatePicker dateDatumKreiranja;
    @FXML
    private TextField txtVoditeljUpisnika;
    private boolean izmjenaPregleda = false;
    private RedovniPregled rp;
    private static UnosRedovnogPregledaController instance;
    ObservableList<String> listaZdrPregled = FXCollections.observableArrayList((Object[])new String[]{"Zadovoljava", "Ne zadovoljava"});
    private final ObservableList<RedovniPregledAparati> listaAparata = FXCollections.observableArrayList();
    private ProgressIndicator progressIndicator = new ProgressIndicator();
    private RedovniPregled pregled;

    public static UnosRedovnogPregledaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.urediTablicuPopisAparata();
        this.urediMenuButtonUnos();
        this.dateDatumKreiranja.setValue((Object)LocalDate.now());
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisAparata.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati aparat")).showAndWait()).get() == ButtonType.OK) {
                this.listaAparata.remove(selectdIndex);
            }
        });
        this.btnSpremi.setOnAction(e -> this.spremiUpisnik());
    }

    private void urediTablicuPopisAparata() {
        this.tablicaPopisAparata.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    UnosRedovnogPregledaController.this.tablicaPopisAparata.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedbr.setCellValueFactory(cellData -> ((RedovniPregledAparati)cellData.getValue()).redBrojProperty());
        this.kolRedbr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(25.0));
        this.kolRedbr.setStyle("-fx-alignment: CENTER;");
        this.kolPoslovnaJedinica.setCellValueFactory(cellData -> ((RedovniPregledAparati)cellData.getValue()).poslovnajedinicaProperty());
        this.kolPoslovnaJedinica.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(10.0));
        this.kolPoslovnaJedinica.setStyle("-fx-alignment: CENTER;");
        this.kolLokacija.setCellValueFactory(cellData -> ((RedovniPregledAparati)cellData.getValue()).poblizaLokacijaProperty());
        this.kolLokacija.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(5.0));
        this.kolLokacija.setStyle("-fx-alignment: CENTER;");
        this.kolVrstaAparata.setCellValueFactory(cellData -> ((RedovniPregledAparati)cellData.getValue()).opisAparataProperty());
        this.kolVrstaAparata.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(6.666666666666667));
        this.kolVrstaAparata.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumPregleda.setCellValueFactory(cellData -> ((RedovniPregledAparati)cellData.getValue()).datumPregledaProperty());
        this.kolDatumPregleda.setCellFactory(dateCellFactory);
        this.kolDatumPregleda.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(10.0));
        this.kolDatumPregleda.setStyle("-fx-alignment: CENTER;");
        this.kol1.setCellValueFactory(cellData -> ((RedovniPregledAparati)cellData.getValue()).utvrdenoStanje1Property());
        this.kol1.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(10.0));
        this.kol1.setCellFactory(t -> {
            ComboBoxTableCell myComboBoxTableCell = new ComboBoxTableCell(this.listaZdrPregled);
            myComboBoxTableCell.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    myComboBoxTableCell.commitEdit(null);
                }
                if (e.getCode() == KeyCode.ESCAPE) {
                    myComboBoxTableCell.cancelEdit();
                }
            });
            return myComboBoxTableCell;
        });
        this.kol1.setStyle("-fx-alignment: CENTER;");
        this.kol2.setCellValueFactory(cellData -> ((RedovniPregledAparati)cellData.getValue()).utvrdenoStanje2Property());
        this.kol2.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(10.0));
        this.kol2.setCellFactory(t -> {
            ComboBoxTableCell myComboBoxTableCell = new ComboBoxTableCell(this.listaZdrPregled);
            myComboBoxTableCell.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    myComboBoxTableCell.commitEdit(null);
                }
                if (e.getCode() == KeyCode.ESCAPE) {
                    myComboBoxTableCell.cancelEdit();
                }
            });
            return myComboBoxTableCell;
        });
        this.kol2.setStyle("-fx-alignment: CENTER;");
        this.kol3.setCellValueFactory(cellData -> ((RedovniPregledAparati)cellData.getValue()).utvrdenoStanje3Property());
        this.kol3.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(10.0));
        this.kol3.setCellFactory(t -> {
            ComboBoxTableCell myComboBoxTableCell = new ComboBoxTableCell(this.listaZdrPregled);
            myComboBoxTableCell.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    myComboBoxTableCell.commitEdit(null);
                }
                if (e.getCode() == KeyCode.ESCAPE) {
                    myComboBoxTableCell.cancelEdit();
                }
            });
            return myComboBoxTableCell;
        });
        this.kol3.setStyle("-fx-alignment: CENTER;");
        this.kol4.setCellValueFactory(cellData -> ((RedovniPregledAparati)cellData.getValue()).utvrdenoStanje4Property());
        this.kol4.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(10.0));
        this.kol4.setCellFactory(t -> {
            ComboBoxTableCell myComboBoxTableCell = new ComboBoxTableCell(this.listaZdrPregled);
            myComboBoxTableCell.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    myComboBoxTableCell.commitEdit(null);
                }
                if (e.getCode() == KeyCode.ESCAPE) {
                    myComboBoxTableCell.cancelEdit();
                }
            });
            return myComboBoxTableCell;
        });
        this.kol4.setStyle("-fx-alignment: CENTER;");
    }

    private void popuniTablicuPopisAparata(String sql) {
        this.tablicaPopisAparata.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask(sql);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaAparata.clear();
        this.tablicaPopisAparata.getItems().clear();
    }

    private Task createTask(final String sql) {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(UnosRedovnogPregledaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaRedovniPregled.dajAparateZaPreglede(sql);
                    UnosRedovnogPregledaController.this.popuniVA(rs);
                }
                finally {
                    Platform.runLater(() -> UnosRedovnogPregledaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void urediMenuButtonUnos() {
        MenuItem m1 = new MenuItem("Unesi sve aparate");
        m1.setOnAction(event -> {
            String sql = "SELECT \n  nazivstroja.oznaka, \n  nazivstroja.naziv, \n  poslovnejedinice.nazivposlovnice, \n  odjeli.nazivodjela, \n  vrstavatrogasnihaparata.naziv as vrstaaparata, \n  vatrogasniaparati.mjestoadresa, \n  vatrogasniaparati.oznakalokacije, \n  vatrogasniaparati.proizvodjac, \n  vatrogasniaparati.model, \n  vatrogasniaparati.tvornickibroj, \n  vatrogasniaparati.inventurnibroj, \n  vatrogasniaparati.godinaproizvodnje, \n  vatrogasniaparati.datumstavljanjauuporabu, \n  vatrogasniaparati.aparatuvozilu, \n  vatrogasniaparati.registracijavozila, \n  vatrogasniaparati.servisnanaljepnica, \n  vatrogasniaparati.datumservisnenaljepnice, \n  vatrogasniaparati.rashodovan, \n  vatrogasniaparati.napomena, \n  vatrogasniaparati.idtvrtka, \n  vatrogasniaparati.id\nFROM \n  public.vatrogasniaparati, \n  public.nazivstroja, \n  public.poslovnejedinice, \n  public.odjeli, \n  public.vrstavatrogasnihaparata\nWHERE \n  nazivstroja.id = vatrogasniaparati.idstroja AND\n  poslovnejedinice.id = vatrogasniaparati.poslovnajedinica AND\n  odjeli.id = vatrogasniaparati.odjel AND\n  vrstavatrogasnihaparata.id = vatrogasniaparati.vrstaaparata   and  idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "' and rashodovan=false";
            this.popuniTablicuPopisAparata(sql);
        });
        Menu men = new Menu("Unesi aparate iz poslovnoj jedinice");
        men.getItems().addAll((Object[])new MenuItem[]{new MenuItem(null, (Node)this.getCBoxPoslovneJedinice())});
        this.btnUnosVA.getItems().addAll((Object[])new MenuItem[]{m1, men});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComboBox getCBoxPoslovneJedinice() {
        ObservableMap map = FXCollections.observableHashMap();
        ResultSet rs = BazaDjelatnik.dajPoslovnujednicu(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                PoslovneJedinice pj = new PoslovneJedinice();
                pj.setId(rs.getInt("id"));
                pj.setNazivPoslovnice(rs.getString("nazivposlovnice"));
                pj.setAdresaPoslovnice(rs.getString("adresa"));
                pj.setMjesto(rs.getString("mjesto"));
                map.put((Object)rs.getString("nazivposlovnice"), (Object)pj);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosRedovnogPregledaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosRedovnogPregledaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        final ComboBox cBoxPoslovnaJedinica = new ComboBox();
        cBoxPoslovnaJedinica.setId("combopj");
        cBoxPoslovnaJedinica.setPromptText("Odaberi poslovnu jedinicu");
        cBoxPoslovnaJedinica.getItems().addAll(map.values());
        FxUtilTest.autoCompleteComboBoxPlus(cBoxPoslovnaJedinica, (typedText, itemToCompare) -> itemToCompare.getNazivPoslovnice().toLowerCase().startsWith(typedText.toLowerCase()));
        cBoxPoslovnaJedinica.setConverter((StringConverter)new StringConverter<PoslovneJedinice>(){
            private Map<String, PoslovneJedinice> map = new HashMap<String, PoslovneJedinice>();

            public String toString(PoslovneJedinice t) {
                if (t != null) {
                    String str = t.getNazivPoslovnice();
                    this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public PoslovneJedinice fromString(String string) {
                if (!this.map.containsKey(string)) {
                    cBoxPoslovnaJedinica.setValue(null);
                    cBoxPoslovnaJedinica.getEditor().clear();
                    return null;
                }
                return this.map.get(string);
            }
        });
        cBoxPoslovnaJedinica.setCellFactory(p -> {
            ListCell<PoslovneJedinice> cell = new ListCell<PoslovneJedinice>(){

                protected void updateItem(PoslovneJedinice item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty) {
                        this.setText("");
                    } else {
                        this.setText(item.getNazivPoslovnice());
                        this.setAlignment(Pos.CENTER);
                        this.setPadding(new Insets(3.0, 3.0, 3.0, 0.0));
                    }
                }
            };
            return cell;
        });
        cBoxPoslovnaJedinica.setButtonCell((ListCell)new ComboBoxListCell<PoslovneJedinice>(){

            public void updateItem(PoslovneJedinice s, boolean empty) {
                super.updateItem((Object)s, empty);
                if (empty || s == null) {
                    this.setStyle("-fx-text-fill: derive(-fx-control-inner-background,-30%)");
                } else {
                    this.setStyle("-fx-text-fill: -fx-text-inner-color");
                    this.setText(null);
                }
            }
        });
        cBoxPoslovnaJedinica.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal != null) {
                Platform.runLater(() -> cBoxPoslovnaJedinica.setValue(oldVal));
            }
        });
        cBoxPoslovnaJedinica.setOnAction(e -> {
            PoslovneJedinice rmr;
            if (cBoxPoslovnaJedinica.getValue() != null && (rmr = (PoslovneJedinice)cBoxPoslovnaJedinica.getSelectionModel().getSelectedItem()) != null) {
                String sql = "SELECT \n  nazivstroja.oznaka, \n  nazivstroja.naziv, \n  poslovnejedinice.nazivposlovnice, \n  odjeli.nazivodjela, \n  vrstavatrogasnihaparata.naziv as vrstaaparata, \n  vatrogasniaparati.mjestoadresa, \n  vatrogasniaparati.oznakalokacije, \n  vatrogasniaparati.proizvodjac, \n  vatrogasniaparati.model, \n  vatrogasniaparati.tvornickibroj, \n  vatrogasniaparati.inventurnibroj, \n  vatrogasniaparati.godinaproizvodnje, \n  vatrogasniaparati.datumstavljanjauuporabu, \n  vatrogasniaparati.aparatuvozilu, \n  vatrogasniaparati.registracijavozila, \n  vatrogasniaparati.servisnanaljepnica, \n  vatrogasniaparati.datumservisnenaljepnice, \n  vatrogasniaparati.rashodovan, \n  vatrogasniaparati.napomena, \n  vatrogasniaparati.idtvrtka, \n  vatrogasniaparati.id\nFROM \n  public.vatrogasniaparati, \n  public.nazivstroja, \n  public.poslovnejedinice, \n  public.odjeli, \n  public.vrstavatrogasnihaparata\nWHERE \n  nazivstroja.id = vatrogasniaparati.idstroja AND\n  poslovnejedinice.id = vatrogasniaparati.poslovnajedinica AND\n  odjeli.id = vatrogasniaparati.odjel AND\n  vrstavatrogasnihaparata.id = vatrogasniaparati.vrstaaparata   and  idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "' and rashodovan=false and poslovnajedinica='" + rmr.getId() + "'";
                this.popuniTablicuPopisAparata(sql);
            }
        });
        return cBoxPoslovnaJedinica;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniVA(ResultSet rs) {
        RedovniPregledAparati va = null;
        int br = 1;
        try {
            while (rs.next()) {
                va = new RedovniPregledAparati();
                va.setId(rs.getInt("id"));
                va.setRedBroj(String.valueOf(br));
                va.setSifraAparata(rs.getString("oznaka"));
                va.setNazivAparata(rs.getString("naziv"));
                va.setProizvodjac(rs.getString("proizvodjac"));
                va.setModel(rs.getString("model"));
                va.setTvornickibroj(rs.getString("tvornickibroj"));
                va.setInventurnibroj(rs.getString("inventurnibroj"));
                va.setGodinaProizvodnje(rs.getString("godinaproizvodnje"));
                va.setDatumStavljanjauPogon(DateUtil.getLocalDate(rs.getDate("datumstavljanjauuporabu")));
                va.setVrstaAparata(rs.getString("vrstaaparata"));
                va.setMjestoIAdresa(rs.getString("mjestoadresa"));
                va.setPoblizaLokacija(rs.getString("oznakalokacije"));
                va.setAparatUVozilu(rs.getBoolean("aparatuvozilu"));
                va.setRegistracijaVozila(rs.getString("registracijavozila"));
                va.setServisnaNaljepnica(rs.getString("servisnanaljepnica"));
                va.setDatumServisneNaljepnice(DateUtil.getLocalDate(rs.getDate("datumservisnenaljepnice")));
                va.setNapomena(rs.getString("napomena"));
                va.setPoslovnajedinica(rs.getString("nazivposlovnice"));
                va.setOdjel(rs.getString("nazivodjela"));
                va.setRashodovan(rs.getBoolean("rashodovan"));
                va.setOpisAparata(rs.getString("vrstaaparata") + "\n inv.br: " + rs.getString("inventurnibroj") + " \n tv.br: " + rs.getString("tvornickibroj") + " - god. " + rs.getString("godinaproizvodnje") + "\n ser.br.na: " + rs.getString("servisnanaljepnica"));
                this.listaAparata.add((Object)va);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosRedovnogPregledaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosRedovnogPregledaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisAparata.setItems(this.listaAparata);
    }

    private void spremiUpisnik() {
        if (this.tablicaPopisAparata.getItems().size() > 0) {
            if (this.izmjenaPregleda) {
                if (BazaRedovniPregled.izmjenaUpisnika((ObservableList<RedovniPregledAparati>)this.tablicaPopisAparata.getItems(), GlavniPanelController.getOdabranaTvrtka(), this.dajUpisnik(), this.pregled.getId())) {
                    if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos redovnog pregleda vatrogasnih aparata")) {
                        PopisRedovnogPregledaController.getInstance().popuniTablicuPopisUpisnika();
                    }
                    GlavniPanelController.getInstance().zatvoriTab("Unos redovnog pregleda vatrogasnih aparata");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena upisnika", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena upisnika", 2, "Error graphic");
                }
            } else if (BazaRedovniPregled.unesiNoviUpisnik((ObservableList<RedovniPregledAparati>)this.tablicaPopisAparata.getItems(), GlavniPanelController.getOdabranaTvrtka(), this.dajUpisnik())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen upisnik", 1, "Information graphic");
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos redovnog pregleda vatrogasnih aparata")) {
                    PopisRedovnogPregledaController.getInstance().popuniTablicuPopisUpisnika();
                }
                GlavniPanelController.getInstance().zatvoriTab("Unos redovnog pregleda vatrogasnih aparata");
                this.izmjenaPregleda = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen upisnik", 2, "Error graphic");
            }
        } else {
            this.tablicaPopisAparata.setStyle("-fx-border-width: 2;\n    -fx-border-color: red");
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate  unjeti vatrogasne aparate");
            alert.showAndWait();
        }
    }

    public RedovniPregled dajUpisnik() {
        RedovniPregled rp = new RedovniPregled();
        rp.setOpisNedostataka(this.txtAreaNedostaci.getText());
        rp.setNedostatkeOtklonio(this.txtOtklonioDjelatnik.getText());
        rp.setNedostaciDatum((LocalDate)this.dateNedostaci.getValue());
        rp.setNedostaciSat(this.txtSatNedostaci.getText());
        rp.setNedostaciOdgovornaOsoba(this.txtNedostaciOdgovornaOsoba.getText());
        rp.setNazivPravneOsobe(this.txtAreaNazivOvlasteneOsobe.getText());
        rp.setMjestoPregleda(this.txtU.getText());
        rp.setDatumKreiranja((LocalDate)this.dateDatumKreiranja.getValue());
        rp.setVoditelj(this.txtVoditeljUpisnika.getText());
        return rp;
    }

    public void izmjenaUpisnika(RedovniPregled rp) {
        this.izmjenaPregleda = true;
        this.pregled = rp;
        this.txtAreaNedostaci.setText(rp.getOpisNedostataka());
        this.txtOtklonioDjelatnik.setText(rp.getNedostatkeOtklonio());
        this.dateNedostaci.setValue((Object)rp.getNedostaciDatum());
        this.txtSatNedostaci.setText(rp.getNedostaciSat());
        this.txtNedostaciOdgovornaOsoba.setText(rp.getNedostaciOdgovornaOsoba());
        this.txtAreaNazivOvlasteneOsobe.setText(rp.getNazivPravneOsobe());
        this.txtU.setText(rp.getMjestoPregleda());
        this.dateDatumKreiranja.setValue((Object)rp.getDatumKreiranja());
        this.txtVoditeljUpisnika.setText(rp.getVoditelj());
        this.popuniTablicuPopisAparataIzmjena(rp.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuPopis(ResultSet rs) {
        RedovniPregledAparati va = null;
        int br = 1;
        try {
            while (rs.next()) {
                va = new RedovniPregledAparati();
                va.setId(rs.getInt("id"));
                va.setRedBroj(String.valueOf(br));
                va.setProizvodjac(rs.getString("proizvodjac"));
                va.setModel(rs.getString("model"));
                va.setTvornickibroj(rs.getString("tvornickibroj"));
                va.setInventurnibroj(rs.getString("inventurnibroj"));
                va.setGodinaProizvodnje(rs.getString("godinaproizvodnje"));
                va.setVrstaAparata(rs.getString("vrstaaparata"));
                va.setPoblizaLokacija(rs.getString("mjestoaparata"));
                va.setServisnaNaljepnica(rs.getString("servisnanaljepnica"));
                va.setPoslovnajedinica(rs.getString("poslovnajedinica"));
                va.setOpisAparata(rs.getString("vrstaaparata") + "\n inv.br: " + rs.getString("inventurnibroj") + " \n tv.br: " + rs.getString("tvornickibroj") + " - god. " + rs.getString("godinaproizvodnje") + "\n ser.br.na: " + rs.getString("servisnanaljepnica"));
                va.setUtvrdenoStanje1(rs.getString("utvrdenostanje1"));
                va.setUtvrdenoStanje2(rs.getString("utvrdenostanje2"));
                va.setUtvrdenoStanje3(rs.getString("utvrdenostanje3"));
                va.setUtvrdenoStanje4(rs.getString("utvrdenostanje4"));
                va.setDatumPregleda(DateUtil.getLocalDate(rs.getDate("datumpregleda")));
                this.listaAparata.add((Object)va);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosRedovnogPregledaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosRedovnogPregledaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisAparata.setItems(this.listaAparata);
    }

    private void popuniTablicuPopisAparataIzmjena(int idUpisnika) {
        this.tablicaPopisAparata.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskIzmjena(idUpisnika);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaAparata.clear();
        this.tablicaPopisAparata.getItems().clear();
    }

    private Task createTaskIzmjena(final int idUpisnika) {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(UnosRedovnogPregledaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaRedovniPregled.dajAparateIzUpisnika(idUpisnika);
                    UnosRedovnogPregledaController.this.popuniTablicuPopis(rs);
                }
                finally {
                    Platform.runLater(() -> UnosRedovnogPregledaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }
}

