/*
 * Decompiled with CFR 0.152.
 */
package vatrogasniaparati;

import TamplatePaneli.Template;
import Utill.DateUtil;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import filter.MenuButtonReporti;
import ispisJasper.IspisReporta;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import vatrogasniaparati.BazaVatrogasniAparati;
import vatrogasniaparati.UnosVatrogasnogAparataController;
import vatrogasniaparati.VatrogasniAparat;
import zastitanaradu.GlavniPanelController;

public class PopisVatrogasnihAparataController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private Button btnIspis;
    @FXML
    private TableView<VatrogasniAparat> tablicaPopisAparata;
    @FXML
    private TableColumn<VatrogasniAparat, String> kolPretraga;
    @FXML
    private TableColumn<VatrogasniAparat, String> kolRedBr;
    @FXML
    private TableColumn<VatrogasniAparat, String> kolInvBroj;
    @FXML
    private TableColumn<VatrogasniAparat, String> kolTvBroj;
    @FXML
    private TableColumn<VatrogasniAparat, String> kolSifraAparata;
    @FXML
    private TableColumn<VatrogasniAparat, String> kolNazivAparata;
    @FXML
    private TableColumn<VatrogasniAparat, String> kolVrstaAparata;
    @FXML
    private TableColumn<VatrogasniAparat, String> kolPoslovnica;
    private static PopisVatrogasnihAparataController instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<VatrogasniAparat> listaVA = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();

    public static PopisVatrogasnihAparataController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFIlter();
        this.urediTablicuPopisAparata();
        this.popuniTablicuPopisAparata(BazaVatrogasniAparati.Opcije.aparate_u_uporabi);
        this.urediFilter(this.tablicaPopisAparata);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos vatrogasnog aparata")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos vatrogasnog aparata");
                GlavniPanelController.getInstance().nadodajPanel("Unos vatrogasnog aparata", "/vatrogasniaparati/UnosVatrogasnogAparata.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos vatrogasnog aparata", "/vatrogasniaparati/UnosVatrogasnogAparata.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            VatrogasniAparat va;
            int selectdIndex = this.tablicaPopisAparata.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (va = (VatrogasniAparat)this.tablicaPopisAparata.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos vatrogasnog aparata")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos vatrogasnog aparata");
                    GlavniPanelController.getInstance().nadodajPanel("Unos vatrogasnog aparata", "/vatrogasniaparati/UnosVatrogasnogAparata.fxml");
                    UnosVatrogasnogAparataController.getInstance().izmjenaAparata(va);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos vatrogasnog aparata", "/vatrogasniaparati/UnosVatrogasnogAparata.fxml");
                    UnosVatrogasnogAparataController.getInstance().izmjenaAparata(va);
                }
                this.tablicaPopisAparata.getSelectionModel().clearSelection();
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisAparata.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati aparat")).showAndWait()).get() == ButtonType.OK) {
                boolean uspjelo = BazaVatrogasniAparati.obrisiAparat((VatrogasniAparat)this.tablicaPopisAparata.getSelectionModel().getSelectedItem(), GlavniPanelController.getOdabranaTvrtka());
                if (uspjelo) {
                    this.popuniTablicuPopisAparata();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan aparat", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan aparat", 2, "Error graphic");
                }
            }
        });
        this.btnIspis.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisAparata.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.ispis((ObservableList<VatrogasniAparat>)this.tablicaPopisAparata.getSelectionModel().getSelectedItems());
            }
        });
    }

    private void urediFilter(TableView<VatrogasniAparat> tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaVA, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("\u0160ifra VA") ? pregled.getSifraAparata() != null && pregled.getSifraAparata().toLowerCase().startsWith(this.tfilter.getText().toLowerCase()) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv VA") ? pregled.getNazivAparata() != null && pregled.getNazivAparata().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") ? pregled.getPoslovnajedinica() != null && pregled.getPoslovnajedinica().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Inv. broj") ? pregled.getInventurnibroj() != null && pregled.getInventurnibroj().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Tv. broj") ? pregled.getTvornickibroj() != null && pregled.getTvornickibroj().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Vrsta VA") && pregled.getTvornickibroj() != null && pregled.getVrstaAparata().toLowerCase().startsWith(lowerCaseFilter)))));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void kreirajToolBarFIlter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Inv. broj", "Tv. broj", "\u0160ifra VA", "Naziv VA", "Vrsta VA", "Poslovna jedinica"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Inv. broj");
        this.cbFilter.setPrefWidth(200.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter, this.getMenuButton(), MenuButtonReporti.getMenuButtonVatrogasniAparatiIspis()});
    }

    private MenuButton getMenuButton() {
        MenuItem m1 = new MenuItem("Prikazi sve aparate");
        m1.setOnAction(event -> this.popuniTablicuPopisAparata(BazaVatrogasniAparati.Opcije.sve_aparate));
        MenuItem m2 = new MenuItem("Prikazi aparate u uporabi");
        m2.setOnAction(event -> this.popuniTablicuPopisAparata(BazaVatrogasniAparati.Opcije.aparate_u_uporabi));
        MenuItem m3 = new MenuItem("Prikazi rashodovane aparate");
        m3.setOnAction(event -> this.popuniTablicuPopisAparata(BazaVatrogasniAparati.Opcije.rashodovane_aparate));
        MenuButton mb = new MenuButton("Pregled aparata", null, new MenuItem[]{m1, m2, m3});
        return mb;
    }

    private void urediTablicuPopisAparata() {
        this.tablicaPopisAparata.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisAparata.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisVatrogasnihAparataController.this.tablicaPopisAparata.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cell -> ((VatrogasniAparat)cell.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(20.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolInvBroj.setCellValueFactory(cell -> ((VatrogasniAparat)cell.getValue()).inventurnibrojProperty());
        this.kolInvBroj.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(10.0));
        this.kolInvBroj.setStyle("-fx-alignment: CENTER;");
        this.kolTvBroj.setCellValueFactory(cell -> ((VatrogasniAparat)cell.getValue()).tvornickibrojProperty());
        this.kolTvBroj.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(10.0));
        this.kolTvBroj.setStyle("-fx-alignment: CENTER;");
        this.kolSifraAparata.setCellValueFactory(cell -> ((VatrogasniAparat)cell.getValue()).sifraAparataProperty());
        this.kolSifraAparata.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(10.0));
        this.kolSifraAparata.setStyle("-fx-alignment: CENTER;");
        this.kolNazivAparata.setCellValueFactory(cell -> ((VatrogasniAparat)cell.getValue()).nazivAparataProperty());
        this.kolNazivAparata.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(4.0));
        this.kolNazivAparata.setStyle("-fx-alignment: CENTER;");
        this.kolVrstaAparata.setCellValueFactory(cell -> ((VatrogasniAparat)cell.getValue()).vrstaAparataProperty());
        this.kolVrstaAparata.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(10.0));
        this.kolVrstaAparata.setStyle("-fx-alignment: CENTER;");
        this.kolPoslovnica.setCellValueFactory(cell -> ((VatrogasniAparat)cell.getValue()).poslovnajedinicaProperty());
        this.kolPoslovnica.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(5.0));
        this.kolPoslovnica.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledDjelatnika = new TableColumn("Pregled");
        kolPregledDjelatnika.setSortable(false);
        kolPregledDjelatnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisAparata.widthProperty().divide(11.11111111111111));
        kolPregledDjelatnika.setStyle("-fx-alignment: CENTER;");
        kolPregledDjelatnika.setCellFactory((Callback)new Callback<TableColumn<VatrogasniAparat, Boolean>, TableCell<VatrogasniAparat, Boolean>>(){

            public TableCell<VatrogasniAparat, Boolean> call(TableColumn<VatrogasniAparat, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledDjelatnika);
    }

    public void popuniTablicuPopisAparata() {
        this.tablicaPopisAparata.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask(BazaVatrogasniAparati.Opcije.aparate_u_uporabi);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaVA.clear();
        this.tablicaPopisAparata.getItems().clear();
    }

    public void popuniTablicuPopisAparata(BazaVatrogasniAparati.Opcije opcija) {
        this.tablicaPopisAparata.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask(opcija);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaVA.clear();
        this.tablicaPopisAparata.getItems().clear();
    }

    private Task createTask(final BazaVatrogasniAparati.Opcije opcija) {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisVatrogasnihAparataController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaVatrogasniAparati.dajAparate(GlavniPanelController.getOdabranaTvrtka(), opcija);
                    PopisVatrogasnihAparataController.this.popuniTablicuAparata(rs);
                }
                finally {
                    Platform.runLater(() -> PopisVatrogasnihAparataController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuAparata(ResultSet rs) {
        VatrogasniAparat va = null;
        int br = 1;
        try {
            while (rs.next()) {
                va = new VatrogasniAparat();
                va.setId(rs.getInt("id"));
                va.setRedBroj(String.valueOf(br));
                va.setSifraAparata(rs.getString("oznaka"));
                va.setNazivAparata(rs.getString("naziv"));
                va.setProizvodjac(rs.getString("proizvodjac"));
                va.setModel(rs.getString("model"));
                va.setTvornickibroj(rs.getString("tvornickibroj"));
                va.setInventurnibroj(rs.getString("inventurnibroj"));
                va.setGodinaProizvodnje(rs.getString("godinaproizvodnje"));
                va.setDatumStavljanjauPogon(DateUtil.getLocalDate(rs.getDate("datumstavljanjauuporabu")));
                va.setVrstaAparata(rs.getString("vrstaaparata"));
                va.setMjestoIAdresa(rs.getString("mjestoadresa"));
                va.setPoblizaLokacija(rs.getString("oznakalokacije"));
                va.setAparatUVozilu(rs.getBoolean("aparatuvozilu"));
                va.setRegistracijaVozila(rs.getString("registracijavozila"));
                va.setServisnaNaljepnica(rs.getString("servisnanaljepnica"));
                va.setDatumServisneNaljepnice(DateUtil.getLocalDate(rs.getDate("datumservisnenaljepnice")));
                va.setNapomena(rs.getString("napomena"));
                va.setPoslovnajedinica(rs.getString("nazivposlovnice"));
                va.setOdjel(rs.getString("nazivodjela"));
                va.setRashodovan(rs.getBoolean("rashodovan"));
                this.listaVA.add((Object)va);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisVatrogasnihAparataController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisVatrogasnihAparataController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisAparata.getItems().addAll(this.listaVA);
    }

    private void ispis(ObservableList<VatrogasniAparat> listaVA) {
        String idArray = "";
        for (int i = 0; i < listaVA.size(); ++i) {
            idArray = i == 0 ? idArray + String.valueOf(((VatrogasniAparat)listaVA.get(i)).getId()) : idArray + "," + String.valueOf(((VatrogasniAparat)listaVA.get(i)).getId());
        }
        String sql = "SELECT \ntvrtka.id as idtvrtka,\n  tvrtka.naziv_tvrtke, \n  tvrtka.oib, \n  tvrtka.adresa, \n  tvrtka.mjesto, \n  tvrtka.pbr, \n  nazivstroja.naziv, \n  nazivstroja.oznaka, \n  poslovnejedinice.nazivposlovnice, \n  odjeli.nazivodjela, \n  vatrogasniaparati.id, \n  vatrogasniaparati.sifraaparata, \n  vatrogasniaparati.mjestoadresa, \n  vatrogasniaparati.oznakalokacije, \n  vatrogasniaparati.proizvodjac, \n  vatrogasniaparati.model, \n  vatrogasniaparati.tvornickibroj, \n  vatrogasniaparati.inventurnibroj, \n  vatrogasniaparati.godinaproizvodnje, \n  vatrogasniaparati.datumstavljanjauuporabu, \n  vatrogasniaparati.aparatuvozilu, \n  vatrogasniaparati.registracijavozila, \n  vatrogasniaparati.servisnanaljepnica, \n  vatrogasniaparati.datumservisnenaljepnice, \n  vatrogasniaparati.rashodovan, \n  vatrogasniaparati.napomena, \n  vrstavatrogasnihaparata.naziv AS vrstavatrogasnogaparata\nFROM \n  public.vatrogasniaparati, \n  public.tvrtka, \n  public.nazivstroja, \n  public.poslovnejedinice, \n  public.odjeli, \n  public.vrstavatrogasnihaparata\nWHERE \n  vatrogasniaparati.idstroja = nazivstroja.id AND\n  vatrogasniaparati.poslovnajedinica = poslovnejedinice.id AND\n  vatrogasniaparati.odjel = odjeli.id AND\n  tvrtka.id = vatrogasniaparati.idtvrtka AND\n  vrstavatrogasnihaparata.id = vatrogasniaparati.vrstaaparata   AND vatrogasniaparati.idtvrtka =tvrtka.id   and vatrogasniaparati.id  IN (select(unnest(ARRAY [" + idArray + "])))";
        IspisReporta.ispisButtonSaSubreportom(sql, this.btnIspis, "EK-VA.jrxml");
    }

    private class ButtonCell
    extends TableCell<VatrogasniAparat, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    VatrogasniAparat va;
                    int selectdIndex = PopisVatrogasnihAparataController.this.tablicaPopisAparata.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (va = (VatrogasniAparat)PopisVatrogasnihAparataController.this.tablicaPopisAparata.getSelectionModel().getSelectedItem()) != null) {
                        Template.getTamplate().showTemplate("vatrogasniaparati/UnosVatrogasnogAparata.fxml", "anchorPanelStroj");
                        UnosVatrogasnogAparataController.getInstance().izmjenaAparata(va);
                        PopisVatrogasnihAparataController.this.tablicaPopisAparata.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PopisVatrogasnihAparataController.this.tablicaPopisAparata.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

