/*
 * Decompiled with CFR 0.152.
 */
package vatrogasniaparati;

import Utill.FxUtilTest;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import vatrogasniaparati.BazaVatrogasniAparati;
import vatrogasniaparati.VatrogasniAparatPregled;

public class ComboBoxCellVAPregled
extends TableCell<VatrogasniAparatPregled, String> {
    private ComboBox<VatrogasniAparatPregled> comboBox;

    ComboBoxCellVAPregled(ObservableList<VatrogasniAparatPregled> listaVAPregled, String pretraga) {
        this.comboBox = new ComboBox(listaVAPregled);
        this.comboBox.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.commitEdit(null);
            }
            if (event.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
            }
        });
        if (pretraga.toLowerCase().equals("naziv")) {
            this.comboBox.setPromptText("Pretraga po nazivu");
            this.comboBox.setCellFactory((Callback)new Callback<ListView<VatrogasniAparatPregled>, ListCell<VatrogasniAparatPregled>>(){

                public ListCell<VatrogasniAparatPregled> call(ListView<VatrogasniAparatPregled> p) {
                    ListCell<VatrogasniAparatPregled> cell = new ListCell<VatrogasniAparatPregled>(){

                        protected void updateItem(VatrogasniAparatPregled t, boolean bln) {
                            super.updateItem((Object)t, bln);
                            if (t != null) {
                                this.setText(t.getVrstaPregleda());
                            } else {
                                this.setText(null);
                            }
                        }
                    };
                    return cell;
                }
            });
            FxUtilTest.autoCompleteComboBoxPlus(this.comboBox, (typedText, itemToCompare) -> itemToCompare.getVrstaPregleda().toLowerCase().startsWith(typedText.toLowerCase()));
        }
        FxUtilTest.getComboBoxValue(this.comboBox);
        this.comboBox.setConverter((StringConverter)new StringConverter<VatrogasniAparatPregled>(){

            public String toString(VatrogasniAparatPregled rm) {
                if (rm == null) {
                    return null;
                }
                return rm.getVrstaPregleda();
            }

            public VatrogasniAparatPregled fromString(String userId) {
                return null;
            }
        });
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.comboBox.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
            this.comboBox.setOnAction(e -> {
                VatrogasniAparatPregled d = (VatrogasniAparatPregled)this.comboBox.getSelectionModel().getSelectedItem();
                if (d != null) {
                    this.commitEdit(FxUtilTest.getComboBoxValue(this.comboBox).getVrstaPregleda());
                    ((VatrogasniAparatPregled)this.getTableView().getSelectionModel().getSelectedItem()).setVrstaPregleda(d.getVrstaPregleda());
                    BazaVatrogasniAparati.unesiPromjenuVAPregled((VatrogasniAparatPregled)this.getTableView().getSelectionModel().getSelectedItem());
                }
            });
            this.setText(null);
            this.setGraphic((Node)this.comboBox);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText((String)this.getItem());
        this.setGraphic(null);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            this.setText(null);
            this.setGraphic((Node)this.comboBox);
        } else {
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }
    }

    private String getString() {
        return this.getItem() == null ? "" : (String)this.getItem();
    }
}

