/*
 * Decompiled with CFR 0.152.
 */
package tvrtka;

import Utill.DateUtil;
import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import javafx.util.StringConverter;
import kadrovska.UnosDjelatnikaController;
import login.LoginControler;
import login.LoginManager;
import tvrtka.BazaKorisnik;
import tvrtka.BazaTvrtka;
import tvrtka.Korisnik;
import tvrtka.Tvrtka;
import tvrtka.TvrtkaController;
import zastitanaradu.GlavniPanelController;

public class UnosKorisnikaController
implements Initializable {
    @FXML
    private AnchorPane rootPane;
    @FXML
    private TableView<Korisnik> tablicaKorisnici;
    @FXML
    private TableColumn<Korisnik, String> kolPretraga;
    @FXML
    private TableColumn<Korisnik, String> kolRedBroj;
    @FXML
    private TableColumn<Korisnik, String> kolIme;
    @FXML
    private TableColumn<Korisnik, String> kolTvrtka;
    @FXML
    private AnchorPane panelUnos;
    @FXML
    private TableView<Tvrtka> tablicaTvrtke;
    @FXML
    private TableColumn<Tvrtka, String> kolRedBrTvrrtka;
    @FXML
    private TableColumn<Tvrtka, String> kolNazivTvrtke;
    @FXML
    private TableColumn<Tvrtka, String> kolSjedisteTvrtke;
    @FXML
    private TableColumn<Tvrtka, String> kolOIBTvrtke;
    @FXML
    private TextField txtIme;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnSpremi;
    @FXML
    private TextField txtPrezime;
    @FXML
    private TextField txtUsername;
    @FXML
    private PasswordField txtPassword;
    @FXML
    private ComboBox<String> cboxGrupaKorisnika;
    @FXML
    private ComboBox<String> cBoxTvrtka;
    @FXML
    private ButtonBar buttonBarAdmin;
    @FXML
    private Button btnCancelAdmin;
    @FXML
    private Button btnSpremiAdmin;
    @FXML
    private Button btnRefreshAdmin;
    @FXML
    private Button btnBrisanjeAdmin;
    @FXML
    private HBox hBoxLicenca;
    @FXML
    private DatePicker dateLicenca;
    @FXML
    private TextField txtTvrtka;
    @FXML
    private Spinner<Integer> spinerBrojTvrtki;
    protected static final String INITAL_VALUE = "1";
    private static UnosKorisnikaController instance;
    private Stage scene;
    private LoginManager lm;
    private boolean promjena = false;
    private int id;
    private Korisnik k;
    final ObservableList<Tvrtka> listaTvrtke = FXCollections.observableArrayList();
    private final ObservableList<Korisnik> listaKorisnici = FXCollections.observableArrayList();
    private ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static UnosKorisnikaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciKorisnik();
        this.popuniTablicuKorisnik();
        this.urediFilter(this.tablicaKorisnici);
        this.urediKOloneUtabliciTvrtke();
        this.urediContextMenuTvrtka();
        this.urediContextMenuKorisnik();
        this.popuniComboBox();
        this.dateLicenca.setValue((Object)LocalDate.now());
        this.btnBrisanjeAdmin.disableProperty().bind((ObservableValue)Bindings.equal((ObservableNumberValue)this.tablicaKorisnici.getSelectionModel().selectedIndexProperty(), (int)-1));
        this.spinerBrojTvrtki.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(0, 10000, Integer.parseInt(INITAL_VALUE)));
        this.btnSpremi.setOnAction(e -> {
            boolean btvrtka;
            boolean bpassword;
            boolean busername;
            boolean bprezime;
            boolean bime = FormValidation.textFieldValidationonlyText(this.txtIme);
            if (bime & (bprezime = FormValidation.textFieldValidationonlyText(this.txtPrezime)) & (busername = FormValidation.textFieldValidationonlyText(this.txtUsername)) & (bpassword = FormValidation.textFieldValidationonlyText((TextField)this.txtPassword)) & (btvrtka = FormValidation.textFieldValidationonlyText(this.txtTvrtka))) {
                if (this.promjena) {
                    if (BazaKorisnik.unesiIzmjenaKorisnika(this.getKorisnik(), this.id)) {
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na promjena korisnika", 1, "Information graphic");
                    } else {
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no promjena korisnika", 2, "Error graphic");
                    }
                    this.promjena = false;
                    LoginControler.setLoginUser(this.k);
                    GlavniPanelController.getInstance().postaviKorisnika(LoginControler.getLoginUser(), GlavniPanelController.getOdabranaTvrtka());
                    GlavniPanelController.getInstance().setBlurEfekt(null);
                    this.scene.hide();
                } else {
                    if (BazaKorisnik.unesiNovogKorisnika(this.getKorisnik())) {
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen korisnik", 1, "Information graphic");
                    } else {
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen korisnik", 2, "Error graphic");
                    }
                    this.lm.logout();
                    this.scene.hide();
                }
            } else {
                Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti sva polja");
                alert.showAndWait();
            }
        });
        this.btnCancel.setOnAction(e -> {
            if (this.promjena) {
                GlavniPanelController.getInstance().setBlurEfekt(null);
            }
            this.scene.hide();
        });
        this.btnCancelAdmin.setOnAction(e -> this.scene.hide());
        this.btnSpremiAdmin.setOnAction(e -> {
            boolean btvrtka;
            boolean bpassword;
            boolean busername;
            boolean bprezime;
            boolean bime = FormValidation.textFieldValidationonlyText(this.txtIme);
            if (bime & (bprezime = FormValidation.textFieldValidationonlyText(this.txtPrezime)) & (busername = FormValidation.textFieldValidationonlyText(this.txtUsername)) & (bpassword = FormValidation.textFieldValidationonlyText((TextField)this.txtPassword)) & (btvrtka = FormValidation.textFieldValidationonlyText(this.txtTvrtka))) {
                if (this.promjena) {
                    if (BazaKorisnik.unesiIzmjenaKorisnika(this.getKorisnik(), this.id)) {
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na promjena korisnika", 1, "Information graphic");
                        this.promjena = false;
                        this.popuniTablicuKorisnik();
                        this.clearForme();
                        this.obrisiTablicuTvrtka();
                    } else {
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no promjena korisnika", 2, "Error graphic");
                    }
                } else if (BazaKorisnik.unesiNovogKorisnika(this.getKorisnik())) {
                    this.popuniTablicuKorisnik();
                    this.clearForme();
                    this.obrisiTablicuTvrtka();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen korisnik", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen korisnik", 2, "Error graphic");
                }
            } else {
                Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti sva polja");
                alert.showAndWait();
            }
        });
        this.btnBrisanjeAdmin.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaKorisnici.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati korisnika")).showAndWait()).get() == ButtonType.OK) {
                if (BazaKorisnik.obrisiKorisnika((Korisnik)this.tablicaKorisnici.getSelectionModel().getSelectedItem())) {
                    if (BazaTvrtka.ukloniKorisnikaIzTabliceTvrtkaDjelatnici((Korisnik)this.tablicaKorisnici.getSelectionModel().getSelectedItem())) {
                        this.popuniTablicuKorisnik();
                        this.obrisiTablicuTvrtka();
                        this.clearForme();
                    } else {
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan korisnik", 2, "Error graphic");
                    }
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan korisnik", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan korisnik", 2, "Error graphic");
                }
            }
        });
        this.btnRefreshAdmin.setOnAction(e -> {
            this.clearForme();
            this.obrisiTablicuTvrtka();
        });
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaKorisnici, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv korisnika") ? pregled.getImePrezime() != null && pregled.getImePrezime().toLowerCase().contains(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Tvrtka") && pregled.getTvrtka() != null && pregled.getTvrtka().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Naziv korisnika", "Tvrtka"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv korisnika");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private Korisnik getKorisnik() {
        this.k = new Korisnik();
        this.k.setIme(this.txtIme.getText());
        this.k.setPrezime(this.txtPrezime.getText());
        this.k.setUsername(this.txtUsername.getText());
        this.k.setPassword(this.txtPassword.getText());
        this.k.setKorisnik((String)this.cboxGrupaKorisnika.getValue());
        this.k.setBrojTvrtki((Integer)this.spinerBrojTvrtki.getValue());
        if (this.promjena) {
            this.k.setId(this.id);
        }
        this.k.setDatumLicence((LocalDate)this.dateLicenca.getValue());
        this.k.setTvrtka(this.txtTvrtka.getText());
        return this.k;
    }

    public void setScene(Stage s, LoginManager lm) {
        this.scene = s;
        this.lm = lm;
    }

    public void setScene(Stage s) {
        this.scene = s;
    }

    public void setKorisnik(Korisnik k) {
        this.promjena = true;
        this.btnCancel.setVisible(true);
        this.btnSpremi.setVisible(true);
        this.btnSpremi.setGraphic(null);
        this.id = k.getId();
        this.txtIme.setText(k.getIme());
        this.txtIme.setDisable(true);
        this.txtPrezime.setText(k.getPrezime());
        this.txtPrezime.setDisable(true);
        this.txtUsername.setText(k.getUsername());
        this.txtUsername.setDisable(true);
        this.txtPassword.setText(k.getPassword());
        this.cboxGrupaKorisnika.getSelectionModel().select((Object)k.getKorisnik());
        this.cboxGrupaKorisnika.setDisable(true);
        this.spinerBrojTvrtki.getValueFactory().setValue((Object)k.getBrojTvrtki());
        this.spinerBrojTvrtki.setDisable(true);
        this.hBoxLicenca.setVisible(false);
        this.dateLicenca.setValue((Object)k.getDatumLicence());
        this.txtTvrtka.setText(k.getTvrtka());
        this.txtTvrtka.setDisable(true);
    }

    private void setKorisnikAdmin(Korisnik k) {
        this.promjena = true;
        this.id = k.getId();
        this.txtIme.setText(k.getIme());
        this.txtPrezime.setText(k.getPrezime());
        this.txtUsername.setText(k.getUsername());
        this.txtPassword.setText(k.getPassword());
        this.txtTvrtka.setText(k.getTvrtka());
        this.cboxGrupaKorisnika.getSelectionModel().select((Object)k.getKorisnik());
        this.spinerBrojTvrtki.getValueFactory().setValue((Object)k.getBrojTvrtki());
        this.dateLicenca.setValue((Object)k.getDatumLicence());
    }

    private void popuniComboBox() {
        ResultSet rs = BazaKorisnik.getGrupaKorisnika();
        try {
            while (rs.next()) {
                this.cboxGrupaKorisnika.getItems().add((Object)rs.getString("naziv_grupe"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosKorisnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosKorisnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cboxGrupaKorisnika.getSelectionModel().select((Object)"Korisnik");
    }

    private void urediKoloneUTabliciKorisnik() {
        this.kolRedBroj.setCellValueFactory(cellData -> ((Korisnik)cellData.getValue()).redBrojProperty());
        this.kolRedBroj.prefWidthProperty().bind((ObservableValue)this.tablicaKorisnici.widthProperty().divide(6.666666666666667));
        this.kolRedBroj.setStyle("-fx-alignment: CENTER;");
        this.kolIme.setCellValueFactory(cellData -> ((Korisnik)cellData.getValue()).imePrezimeProperty());
        this.kolIme.prefWidthProperty().bind((ObservableValue)this.tablicaKorisnici.widthProperty().divide(1.8518518518518519));
        this.kolIme.setStyle("-fx-alignment: CENTER;");
        this.kolTvrtka.setCellValueFactory(cellData -> ((Korisnik)cellData.getValue()).tvrtkaProperty());
        this.kolTvrtka.prefWidthProperty().bind((ObservableValue)this.tablicaKorisnici.widthProperty().divide(3.3333333333333335));
        this.kolTvrtka.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    private void urediKOloneUtabliciTvrtke() {
        this.kolRedBrTvrrtka.setCellValueFactory(cellData -> ((Tvrtka)cellData.getValue()).redBrojProperty());
        this.kolRedBrTvrrtka.prefWidthProperty().bind((ObservableValue)this.tablicaTvrtke.widthProperty().divide(10.0));
        this.kolRedBrTvrrtka.setStyle("-fx-alignment: CENTER;");
        this.kolNazivTvrtke.setCellValueFactory(cellData -> ((Tvrtka)cellData.getValue()).nazivTvrtkeProperty());
        this.kolNazivTvrtke.prefWidthProperty().bind((ObservableValue)this.tablicaTvrtke.widthProperty().divide(3.3333333333333335));
        this.kolNazivTvrtke.setStyle("-fx-alignment: CENTER;");
        this.kolSjedisteTvrtke.setCellValueFactory(cellData -> ((Tvrtka)cellData.getValue()).sjedisteProperty());
        this.kolSjedisteTvrtke.prefWidthProperty().bind((ObservableValue)this.tablicaTvrtke.widthProperty().divide(3.3333333333333335));
        this.kolSjedisteTvrtke.setStyle("-fx-alignment: CENTER;");
        this.kolOIBTvrtke.setCellValueFactory(cellData -> ((Tvrtka)cellData.getValue()).oibProperty());
        this.kolOIBTvrtke.prefWidthProperty().bind((ObservableValue)this.tablicaTvrtke.widthProperty().divide(3.5714285714285716));
        this.kolOIBTvrtke.setStyle("-fx-alignment: CENTER;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popuniTablicuTvrtka(int idKorisnika) {
        int br = 1;
        ResultSet rs = BazaTvrtka.dajSveTvrtke(idKorisnika);
        try {
            while (rs.next()) {
                Tvrtka tv = new Tvrtka();
                tv.setId(rs.getInt("ID"));
                tv.setRedBroj(String.valueOf(br));
                tv.setNazivTvrtke(rs.getString("naziv_tvrtke"));
                tv.setOib(rs.getString("oib"));
                tv.setAdresa(rs.getString("adresa"));
                tv.setMjesto(rs.getString("mjesto"));
                tv.setPostbroj(rs.getString("pbr"));
                tv.setSjediste(rs.getString("adresa") + ",\n" + rs.getString("pbr") + " " + rs.getString("mjesto"));
                this.listaTvrtke.add((Object)tv);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaTvrtke.getItems().setAll(this.listaTvrtke);
    }

    private void popuniTablicuTvrtkaPodaci(int idKorisnika) {
        this.tablicaTvrtke.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskTvrtke(idKorisnika);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaTvrtke.clear();
        this.tablicaTvrtke.getItems().clear();
    }

    private Task createTaskTvrtke(final int id) {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    UnosKorisnikaController.this.popuniTablicuTvrtka(id);
                }
                finally {
                    Platform.runLater(() -> UnosKorisnikaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void popuniTablicuKorisnik() {
        this.tablicaKorisnici.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task<Void> task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaKorisnici.clear();
        this.tablicaKorisnici.getItems().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuKorisnici() {
        ResultSet rs = BazaKorisnik.getKorisnik();
        Korisnik k = null;
        int br = 1;
        try {
            while (rs.next()) {
                k = new Korisnik();
                k.setId(rs.getInt("id"));
                k.setRedBroj(String.valueOf(br));
                k.setIme(rs.getString("ime"));
                k.setPrezime(rs.getString("prezime"));
                k.setUsername(rs.getString("username"));
                k.setPassword(rs.getString("lozinka"));
                k.setTvrtka(rs.getString("tvrtka"));
                k.setKorisnik(rs.getString("naziv_grupe"));
                k.setBrojTvrtki(rs.getInt("brojtvrtki"));
                k.setDatumLicence(DateUtil.getLocalDate(rs.getDate("datumlicence")));
                k.setImePrezime(rs.getString("ime") + " " + rs.getString("prezime"));
                this.listaKorisnici.add((Object)k);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(LoginControler.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(LoginControler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaKorisnici.getItems().addAll(this.listaKorisnici);
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(UnosKorisnikaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    UnosKorisnikaController.this.popuniTablicuKorisnici();
                }
                finally {
                    Platform.runLater(() -> UnosKorisnikaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void clearForme() {
        this.txtIme.clear();
        this.txtPrezime.clear();
        this.txtPassword.clear();
        this.txtUsername.clear();
        this.txtTvrtka.clear();
        this.cboxGrupaKorisnika.getSelectionModel().select((Object)"Korisnik");
        this.spinerBrojTvrtki.getValueFactory().setValue((Object)1);
        this.dateLicenca.setValue((Object)LocalDate.now());
        this.promjena = false;
    }

    private void obrisiTablicuTvrtka() {
        this.listaTvrtke.clear();
        this.tablicaTvrtke.getItems().clear();
        this.tablicaKorisnici.getSelectionModel().clearSelection();
    }

    private void urediContextMenuTvrtka() {
        ImageView image2 = new ImageView(this.getClass().getResource("/resorces/icon/brisanje26.png").toString());
        MenuItem obrisiRed = new MenuItem("Obri\u0161i Tvrtku", (Node)image2);
        obrisiRed.setOnAction(event -> {
            int selectdIndex = this.tablicaTvrtke.getSelectionModel().getSelectedIndex();
            Alert alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje Tvrtke", "\u017delite li obrisati tvrtku ?\nTvrtka \u0107e biti potpuno obrisana! ");
            Optional result = alert.showAndWait();
            if (selectdIndex != -1 && result.get() == ButtonType.OK) {
                if (BazaTvrtka.obrisiTvrtkuSve((Tvrtka)this.tablicaTvrtke.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuTvrtkaPodaci(((Korisnik)this.tablicaKorisnici.getSelectionModel().getSelectedItem()).getId());
                } else {
                    Alert error = FxDialogs.getDialog(Alert.AlertType.ERROR, "Brisanje Tvrtke", "Neuspjelo brisanje Tvrtku");
                    error.showAndWait();
                }
            }
        });
        ImageView image1 = new ImageView(this.getClass().getResource("/resorces/icon/brisanje26.png").toString());
        MenuItem obrisiTvrtkuSaPopisa = new MenuItem("Ukloni tvrtku sa popisa", (Node)image1);
        obrisiTvrtkuSaPopisa.setOnAction(e -> {
            int selectdIndex = this.tablicaTvrtke.getSelectionModel().getSelectedIndex();
            Alert alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje Tvrtke", "\u017delite li ukloniti tvrtku sa popisa?");
            Optional result = alert.showAndWait();
            if (selectdIndex != -1 && result.get() == ButtonType.OK) {
                if (BazaTvrtka.ukloniTvrtkuUTabliciTvetkaDjelatnici((Tvrtka)this.tablicaTvrtke.getSelectionModel().getSelectedItem(), ((Korisnik)this.tablicaKorisnici.getSelectionModel().getSelectedItem()).getId())) {
                    this.popuniTablicuTvrtkaPodaci(((Korisnik)this.tablicaKorisnici.getSelectionModel().getSelectedItem()).getId());
                } else {
                    Alert error = FxDialogs.getDialog(Alert.AlertType.ERROR, "Brisanje Tvrtke", "Neuspjelo brisanje Tvrtku");
                    error.showAndWait();
                }
            }
        });
        ContextMenu men = new ContextMenu(new MenuItem[]{obrisiTvrtkuSaPopisa, obrisiRed});
        this.tablicaTvrtke.setOnMousePressed(event -> {
            if (event.isSecondaryButtonDown() & this.tablicaTvrtke.getSelectionModel().getSelectedIndex() != -1) {
                men.show(this.tablicaTvrtke, event.getScreenX(), event.getScreenY());
            } else {
                men.hide();
            }
        });
    }

    private void urediContextMenuKorisnik() {
        ImageView image2 = new ImageView(this.getClass().getResource("/resorces/icon/promjena26.png").toString());
        MenuItem editKorisnika = new MenuItem("Uredi korisnika", (Node)image2);
        editKorisnika.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                int selectdIndex = UnosKorisnikaController.this.tablicaKorisnici.getSelectionModel().getSelectedIndex();
                if (selectdIndex != -1) {
                    UnosKorisnikaController.this.setKorisnikAdmin((Korisnik)UnosKorisnikaController.this.tablicaKorisnici.getSelectionModel().getSelectedItem());
                }
            }
        });
        ImageView image1 = new ImageView(this.getClass().getResource("/resorces/icon/unos26.png").toString());
        MenuItem nadodajTvrtku = new MenuItem("Nadodaj Tvrtku", (Node)image1);
        nadodajTvrtku.setOnAction(e -> {
            int index = this.tablicaKorisnici.getSelectionModel().getSelectedIndex();
            if (index != -1) {
                this.nadodajTvrtku(((Korisnik)this.tablicaKorisnici.getSelectionModel().getSelectedItem()).getId());
            }
        });
        ContextMenu men = new ContextMenu(new MenuItem[]{editKorisnika, nadodajTvrtku});
        this.tablicaKorisnici.setOnMousePressed(event -> {
            if (event.isPrimaryButtonDown() & this.tablicaKorisnici.getSelectionModel().getSelectedIndex() != -1) {
                this.clearForme();
                this.popuniTablicuTvrtkaPodaci(((Korisnik)this.tablicaKorisnici.getSelectionModel().getSelectedItem()).getId());
            }
            if (event.isSecondaryButtonDown() & this.tablicaKorisnici.getSelectionModel().getSelectedIndex() != -1) {
                men.show(this.tablicaKorisnici, event.getScreenX(), event.getScreenY());
            } else {
                men.hide();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nadodajTvrtku(int idKorisnika) {
        ObservableList listaT = FXCollections.observableArrayList();
        ResultSet rs = BazaTvrtka.dajSveTvrtke();
        try {
            while (rs.next()) {
                Tvrtka tv = new Tvrtka();
                tv.setId(rs.getInt("ID"));
                tv.setNazivTvrtke(rs.getString("naziv_tvrtke"));
                tv.setOib(rs.getString("oib"));
                tv.setAdresa(rs.getString("adresa"));
                tv.setMjesto(rs.getString("mjesto"));
                tv.setPostbroj(rs.getString("pbr"));
                tv.setSjediste(rs.getString("adresa") + ",\n" + rs.getString("pbr") + " " + rs.getString("mjesto"));
                listaT.add((Object)tv);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Dialog dialog = new Dialog();
        final ComboBox comboBox = new ComboBox(listaT);
        comboBox.setPromptText("Izaberite tvrtku");
        comboBox.setConverter((StringConverter)new StringConverter<Tvrtka>(){

            public String toString(Tvrtka tvrtka) {
                if (tvrtka == null) {
                    return null;
                }
                return tvrtka.getNazivTvrtka() + "\n" + tvrtka.getMjesto() + "," + tvrtka.getAdresa();
            }

            public Tvrtka fromString(String userId) {
                return null;
            }
        });
        dialog.setHeaderText("Izaberite Tvrtku:");
        dialog.initStyle(StageStyle.TRANSPARENT);
        dialog.getDialogPane().setContent((Node)new VBox(new Node[]{comboBox}));
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getStylesheets().add((Object)UnosDjelatnikaController.class.getResource("/Utill/Dialog.css").toExternalForm());
        dialogPane.getStyleClass().add((Object)"myDialog");
        final ButtonType buttonTypeOk = new ButtonType("Ok", ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{buttonTypeOk, buttonTypeCancel});
        dialog.setResultConverter((Callback)new Callback<ButtonType, Tvrtka>(){

            public Tvrtka call(ButtonType b) {
                if (b == buttonTypeOk) {
                    return (Tvrtka)comboBox.getSelectionModel().getSelectedItem();
                }
                return null;
            }
        });
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            System.out.println("Your choice: " + ((Tvrtka)result.get()).getNazivTvrtka());
            if (BazaTvrtka.spremiUTablicuTvrtkaDjelatnici(idKorisnika, ((Tvrtka)result.get()).getId())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesena tvrtka", 1, "Information graphic");
                this.popuniTablicuTvrtkaPodaci(idKorisnika);
                dialog.hide();
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesena tvrtka", 2, "Error graphic");
            }
        }
    }
}

