/*
 * Decompiled with CFR 0.152.
 */
package tvrtka;

import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.FxUtil;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.util.Pair;
import tvrtka.BazaTvrtka;
import tvrtka.Tvrtka;
import zastitanaradu.GlavniPanelController;

public class TvrtkaMainController
implements Initializable {
    @FXML
    private Button btnDjelatnosti;
    @FXML
    private Button btnSpremi;
    @FXML
    private AnchorPane anhPaneOpis;
    @FXML
    private Pane paneOpis;
    @FXML
    private TextArea textAreaOpis;
    @FXML
    private TextField txtBrojZO;
    @FXML
    private TextField txtEMail;
    @FXML
    private TextField txtBrojZaposlenih;
    @FXML
    private TextField txtBrojObvezeObveznikaUplate;
    @FXML
    private TextField txtBrutoPlaca;
    @FXML
    private TextField txtAdresa;
    @FXML
    private TextField txtNaziv;
    @FXML
    private TextField txtDirektor;
    @FXML
    private TextField txtKontaktOsoba;
    @FXML
    private TextField txtOib;
    @FXML
    private ComboBox<String> cboxMjesto;
    @FXML
    private ComboBox<String> cboxZupanija;
    @FXML
    private ComboBox<String> cboxDrzava;
    @FXML
    private ComboBox<String> cboxOpcina;
    @FXML
    private TextField txtTelefon;
    @FXML
    private TextField txtFax;
    @FXML
    private TextField txtMobitel;
    @FXML
    private TextField txtIBAN;
    @FXML
    private TextField txtBankaIban;
    @FXML
    private TextArea txtOpisDjelatnosti;
    @FXML
    private TextField txtSifraDjelatnosti;
    @FXML
    private TextField txtVrstaDjelatnosti;
    @FXML
    private TextField txtPBR;
    private static TvrtkaMainController instance;

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtNaziv, this.txtVrstaDjelatnosti);
        ResizeComponent.makeResizeTextArea(this.txtOpisDjelatnosti);
        this.popuniComboBoxove();
        this.dohvatiTvrtku();
        this.cboxZupanija.setOnAction(event -> this.popuniMjestaZaOdabranuZupaniju((String)this.cboxZupanija.getValue()));
        this.cboxMjesto.setOnAction(event -> this.txtPBR.setText(this.popuniPBRzaOdabranoMjesto((String)this.cboxMjesto.getValue(), (String)this.cboxZupanija.getValue())));
        this.btnSpremi.setOnAction(e -> {
            boolean bOib;
            boolean bNazivTvrtke = FormValidation.textFieldValidationonlyText(this.txtNaziv);
            if (bNazivTvrtke & (bOib = FormValidation.textFieldValidationonlyTextOIB(this.txtOib))) {
                WorkingButton wb = new WorkingButton(this.btnSpremi);
                wb.setOnSucceeded(t -> {
                    if (((Boolean)wb.getValue()).booleanValue()) {
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesena tvrtka", 1, "Information graphic");
                    } else {
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesena tvrtka", 2, "Error graphic");
                    }
                });
                wb.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

                    public void handle(WorkerStateEvent t) {
                        System.out.println("Connection error.");
                    }
                });
                new Thread((Runnable)((Object)wb)).start();
            } else {
                Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti sva oznacena polja");
                alert.showAndWait();
            }
        });
        this.btnDjelatnosti.setOnAction(e -> this.getDjelatnosti());
    }

    private void getDjelatnosti() {
        Dialog<Pair<String, String>> d = FxDialogs.getDialogDjelatnosti();
        Optional result = d.showAndWait();
        result.ifPresent(nkd -> {
            this.txtSifraDjelatnosti.setText(((String)nkd.getValue()).replace(",", "."));
            this.txtVrstaDjelatnosti.setText((String)nkd.getKey());
        });
    }

    public static TvrtkaMainController getInstance() {
        return instance;
    }

    private void popuniCboxMjesta() {
        ResultSet rs = BazaTvrtka.dajMjesta();
        try {
            while (rs.next()) {
                this.cboxMjesto.getItems().add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TvrtkaMainController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(TvrtkaMainController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void popuniCboxZupanije() {
        ResultSet rs = BazaTvrtka.dajZupanije();
        try {
            while (rs.next()) {
                this.cboxZupanija.getItems().add((Object)rs.getString("nazivzupanije"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TvrtkaMainController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(TvrtkaMainController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void popuniCboxDrzave() {
        ResultSet rs = BazaTvrtka.dajDrzave();
        try {
            while (rs.next()) {
                this.cboxDrzava.getItems().add((Object)rs.getString("naziv_ispis"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TvrtkaMainController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(TvrtkaMainController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniMjestaZaOdabranuZupaniju(String nazivZupanije) {
        System.out.println("usao u metodu odabrana zup");
        this.cboxMjesto.getItems().clear();
        this.cboxOpcina.getItems().clear();
        ResultSet rs = BazaTvrtka.dohvatiGradove(nazivZupanije);
        try {
            while (rs.next()) {
                this.cboxMjesto.getItems().add((Object)rs.getString("nazivgrada"));
                this.cboxOpcina.getItems().add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TvrtkaMainController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(TvrtkaMainController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cboxMjesto.getSelectionModel().selectFirst();
        this.cboxOpcina.getSelectionModel().selectFirst();
        this.popuniPBRzaOdabranoMjesto((String)this.cboxMjesto.getValue(), (String)this.cboxZupanija.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String popuniPBRzaOdabranoMjesto(String mjesto, String zupanija) {
        String pbr = "";
        System.out.println("usao u metodu pbr");
        ResultSet rs = BazaTvrtka.dohvatiPbr(mjesto, zupanija);
        try {
            while (rs.next()) {
                pbr = rs.getString("postbroj");
                System.out.println(pbr);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TvrtkaMainController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(TvrtkaMainController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return pbr;
    }

    private void popuniComboBoxove() {
        this.popuniCboxDrzave();
        this.popuniCboxMjesta();
        this.popuniCboxZupanije();
        this.popuniCboxOpcine();
        FxUtil.autoCompleteComboBox(this.cboxMjesto, FxUtil.AutoCompleteMode.STARTS_WITH);
        FxUtil.autoCompleteComboBox(this.cboxZupanija, FxUtil.AutoCompleteMode.STARTS_WITH);
        FxUtil.autoCompleteComboBox(this.cboxDrzava, FxUtil.AutoCompleteMode.STARTS_WITH);
        FxUtil.autoCompleteComboBox(this.cboxOpcina, FxUtil.AutoCompleteMode.STARTS_WITH);
        this.cboxMjesto.getItems().add((Object)"Sva mjesta");
        this.cboxOpcina.getItems().add((Object)"Sva mjesta");
    }

    private void popuniCboxOpcine() {
        ResultSet rs = BazaTvrtka.dajMjesta();
        try {
            while (rs.next()) {
                this.cboxOpcina.getItems().add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TvrtkaMainController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(TvrtkaMainController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dohvatiTvrtku() {
        ResultSet rs = BazaTvrtka.dajTvrtku(GlavniPanelController.getOdabranaTvrtka());
        Tvrtka t = null;
        try {
            while (rs.next()) {
                t = new Tvrtka();
                t.setId(rs.getInt("id"));
                t.setNazivTvrtke(rs.getString("naziv_tvrtke"));
                t.setOib(rs.getString("oib"));
                t.setAdresa(rs.getString("adresa"));
                t.setZupanija(rs.getString("zupanija"));
                t.setPbr(rs.getString("pbr"));
                t.setMjesto(rs.getString("mjesto"));
                t.setOpcina(rs.getString("opcina"));
                t.setDrzava(rs.getString("drzava"));
                t.setDirektor(rs.getString("direktor"));
                t.setKontaktOsoba(rs.getString("kontakt_osoba"));
                t.setTelefon(rs.getString("telefon"));
                t.setFax(rs.getString("fax"));
                t.setMobitel(rs.getString("mobitel"));
                t.setIban(rs.getString("iban"));
                t.setBankaIban(rs.getString("bankaiban"));
                t.setSifraDjelatnosti(rs.getString("sifra_djelatnosti"));
                t.setVrstaDjelatnosti(rs.getString("vrsta_djelatnisti"));
                t.setOpisdjelatnosti(rs.getString("opis_djelatnosti"));
                t.setEmail(rs.getString("email"));
                t.setRegistraciskiBrojZdrastvenogOsiguranja(rs.getString("reg_broj_zo"));
                t.setBrojObvezeObveznikaUplate(rs.getString("broj_obveze_uplate"));
                t.setBrutoPlaca(rs.getString("bruto_placa"));
                t.setNapomena(rs.getString("napomena"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TvrtkaMainController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(TvrtkaMainController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        int i = BazaTvrtka.dajBrojDjelatnika(GlavniPanelController.getOdabranaTvrtka());
        t.setBrojZaposlenih(String.valueOf(i));
        this.popuniTvrtku(t);
    }

    private void popuniTvrtku(Tvrtka t) {
        this.txtNaziv.setText(t.getNazivTvrtka());
        this.txtOib.setText(t.getOib());
        this.txtAdresa.setText(t.getAdresa());
        if (t.getZupanija() != null) {
            this.cboxZupanija.getSelectionModel().select((Object)t.getZupanija());
        } else {
            this.cboxZupanija.getSelectionModel().selectFirst();
        }
        if (t.getPbr() != null) {
            this.txtPBR.setText(t.getPbr());
        } else {
            this.txtPBR.setText("00000");
        }
        if (t.getMjesto() != null) {
            this.cboxMjesto.getSelectionModel().select((Object)t.getMjesto());
        } else {
            this.cboxMjesto.getSelectionModel().select((Object)"Sva mjesta");
        }
        if (t.getOpcina() != null) {
            this.cboxOpcina.getSelectionModel().select((Object)t.getOpcina());
        } else {
            this.cboxOpcina.getSelectionModel().select((Object)"Sva mjesta");
        }
        if (t.getDrzava() != null) {
            this.cboxDrzava.getSelectionModel().select((Object)t.getDrzava());
        } else {
            this.cboxDrzava.getSelectionModel().select((Object)"Hrvatska");
        }
        this.txtDirektor.setText(t.getDirektor());
        this.txtKontaktOsoba.setText(t.getKontaktOsoba());
        this.txtTelefon.setText(t.getTelefon());
        this.txtFax.setText(t.getFax());
        this.txtMobitel.setText(t.getMobitel());
        this.txtIBAN.setText(t.getIban());
        this.txtBankaIban.setText(t.getBankaIban());
        this.txtSifraDjelatnosti.setText(t.getSifraDjelatnosti());
        this.txtVrstaDjelatnosti.setText(t.getVrstaDjelatnosti());
        this.txtOpisDjelatnosti.setText(t.getOpisdjelatnosti());
        this.txtEMail.setText(t.getEmail());
        this.txtBrojZO.setText(t.getRegistraciskiBrojZdrastvenogOsiguranja());
        this.txtBrojObvezeObveznikaUplate.setText(t.getBrojObvezeObveznikaUplate());
        this.txtBrojZaposlenih.setText(t.getBrojZaposlenih());
        this.txtBrutoPlaca.setText(t.getBrutoPlaca());
        this.textAreaOpis.setText(t.getNapomena());
    }

    private boolean spremiTvrtku() {
        Tvrtka t = new Tvrtka();
        t.setNazivTvrtke(this.txtNaziv.getText());
        t.setOib(this.txtOib.getText());
        t.setAdresa(this.txtAdresa.getText());
        t.setZupanija((String)this.cboxZupanija.getValue());
        t.setPbr(this.txtPBR.getText());
        t.setMjesto((String)this.cboxMjesto.getValue());
        t.setOpcina((String)this.cboxOpcina.getValue());
        t.setDrzava((String)this.cboxDrzava.getValue());
        t.setDirektor(this.txtDirektor.getText());
        t.setKontaktOsoba(this.txtKontaktOsoba.getText());
        t.setTelefon(this.txtTelefon.getText());
        t.setFax(this.txtFax.getText());
        t.setMobitel(this.txtMobitel.getText());
        t.setIban(this.txtIBAN.getText());
        t.setBankaIban(this.txtBankaIban.getText());
        t.setSifraDjelatnosti(this.txtSifraDjelatnosti.getText());
        t.setVrstaDjelatnosti(this.txtVrstaDjelatnosti.getText());
        t.setOpisdjelatnosti(this.txtOpisDjelatnosti.getText());
        t.setEmail(this.txtEMail.getText());
        t.setRegistraciskiBrojZdrastvenogOsiguranja(this.txtBrojZO.getText());
        t.setBrojObvezeObveznikaUplate(this.txtBrojObvezeObveznikaUplate.getText());
        t.setBrutoPlaca(this.txtBrutoPlaca.getText());
        t.setNapomena(this.textAreaOpis.getText());
        return BazaTvrtka.unesiNovuTvrtku(GlavniPanelController.getOdabranaTvrtka().getId(), t);
    }

    public class WorkingButton
    extends Task<Boolean> {
        Button b = new Button();
        Button orginal;
        ProgressIndicator progressPane = new ProgressIndicator();

        public WorkingButton(Button btn) {
            this.b.setGraphic(btn.getGraphic());
            this.orginal = btn;
            this.progressPane.setPrefSize(26.0, 26.0);
            btn.setGraphic((Node)this.progressPane);
            this.progressPane.progressProperty().bind((ObservableValue)this.progressProperty());
        }

        protected Boolean call() throws Exception {
            Boolean boll;
            try {
                this.updateProgress(-1.0, 1.0);
                this.updateMessage("Waiting...");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                boll = TvrtkaMainController.this.spremiTvrtku();
                this.updateMessage("Running...");
            }
            finally {
                Platform.runLater(() -> this.orginal.setGraphic(this.b.getGraphic()));
            }
            return boll;
        }
    }
}

