/*
 * Decompiled with CFR 0.152.
 */
package tvrtka;

import Utill.DateUtil;
import java.io.IOException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import login.LogFileMonitoring;
import login.LoginControler;
import login.LoginManager;
import login.PostavkeBazeController;
import login.PostavkeStatic;
import postavke.PostavkePrograma;
import postavke.PregledBazeController;
import tvrtka.BazaTvrtka;
import tvrtka.Tvrtka;
import tvrtka.TvrtkaPopis;
import tvrtka.UnosKorisnikaController;
import tvrtka.UnosTvrtkeController;
import zastitanaradu.GlavniPanelController;

public class TvrtkaController
implements Initializable {
    @FXML
    private Button btnKorisnik;
    @FXML
    private Button btnNadodajTvrtku;
    @FXML
    private Button btnOk;
    @FXML
    private StackPane paneTablica;
    @FXML
    private Button btnLogof;
    @FXML
    private Button btnPostavke;
    @FXML
    private Button btnPregledBaza;
    @FXML
    private TableView<TvrtkaPopis> tablicaTvrtke;
    final ObservableList<TvrtkaPopis> listaTvrtke = FXCollections.observableArrayList();
    private static TvrtkaController tvrtkaController;

    public void initialize(URL url, ResourceBundle rb) {
        tvrtkaController = this;
        this.urediKOloneUtabliciTvrtke();
        this.popuniTablicu();
        if (LoginControler.getLoginUser().getKorisnik().equals("Administrator")) {
            this.btnKorisnik.setVisible(true);
            this.btnLogof.setVisible(true);
            this.btnPostavke.setVisible(true);
            this.btnPregledBaza.setVisible(true);
        } else {
            this.btnKorisnik.setVisible(false);
            this.btnPostavke.setVisible(false);
            this.btnPregledBaza.setVisible(false);
        }
        this.btnNadodajTvrtku.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tablicaTvrtke.getItems()).isEqualTo(LoginControler.getLoginUser().getBrojTvrtki()).or((ObservableBooleanValue)Bindings.size((ObservableList)this.tablicaTvrtke.getItems()).greaterThan(LoginControler.getLoginUser().getBrojTvrtki())));
        this.btnNadodajTvrtku.setOnAction(e -> {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("UnosTvrtke.fxml"));
            Stage dialog = new Stage();
            dialog.initStyle(StageStyle.TRANSPARENT);
            dialog.initModality(Modality.APPLICATION_MODAL);
            dialog.setTitle("Unos tvrtke");
            Scene scene = null;
            try {
                Parent p = (Parent)loader.load();
                p.setStyle("-fx-padding: 5; -fx-background-color:white; -fx-border-width:5; -fx-border-style: solid;-fx-background-insets: 0, 1, 2;-fx-border-radius: 0; -fx-border-color: #046272 ");
                scene = new Scene(p);
            }
            catch (IOException ex) {
                Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
            }
            dialog.setScene(scene);
            dialog.show();
            UnosTvrtkeController.getInstance().setScene(dialog);
        });
        this.tablicaTvrtke.setRowFactory(tv -> new TableRow<TvrtkaPopis>(){

            public void updateItem(TvrtkaPopis item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null) {
                    this.setStyle(null);
                } else if (item.getDatumIspitivanja() != null) {
                    this.izracunaj(item.getDatumIspitivanja());
                } else {
                    this.setStyle(null);
                }
            }

            private void izracunaj(LocalDate d) {
                Tooltip tip = new Tooltip();
                tip.setStyle("-fx-font-size:12pt;-fx-text-fill:white");
                LocalDate datePocetni = LocalDate.now();
                LocalDate dateEnd = d;
                Period p = Period.between(datePocetni, dateEnd);
                long p2 = ChronoUnit.DAYS.between(datePocetni, dateEnd);
                if (p2 <= 30L) {
                    this.setStyle("-fx-background-color:-fx-table-cell-border-color, tomato ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em;");
                    tip.setText(" " + p.getYears() + " god. " + p.getMonths() + " mj. ,\n i  " + p.getDays() + " dana do isteka periodike .\n ( ukupno  " + p2 + "  dana )");
                    this.setTooltip(tip);
                } else {
                    this.setStyle(null);
                    Tooltip.uninstall((Node)this, (Tooltip)tip);
                }
            }
        });
        this.btnPostavke.setOnAction(e -> {
            FXMLLoader loader = new FXMLLoader(PostavkeStatic.class.getResource("PostavkeBaze.fxml"));
            Stage dialog = new Stage();
            dialog.initStyle(StageStyle.UTILITY);
            dialog.initModality(Modality.APPLICATION_MODAL);
            dialog.setTitle("Unos postavki");
            Scene scene = null;
            try {
                Parent p = (Parent)loader.load();
                scene = new Scene(p);
            }
            catch (IOException ex) {
                Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
            }
            dialog.setScene(scene);
            PostavkeBazeController.getInstance().setScene(dialog);
            try {
                PostavkeBazeController.getInstance().ucitajpostavke();
            }
            catch (IOException ex) {
                Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
            }
            dialog.showAndWait();
        });
        this.btnPregledBaza.setOnAction(e -> {
            FXMLLoader loader = new FXMLLoader(PostavkeStatic.class.getResource("/postavke/PregledBaze.fxml"));
            Stage dialog = new Stage();
            dialog.initStyle(StageStyle.DECORATED);
            dialog.initModality(Modality.APPLICATION_MODAL);
            dialog.setTitle("Pregled baza");
            Scene scene = null;
            try {
                Parent p = (Parent)loader.load();
                scene = new Scene(p);
            }
            catch (IOException ex) {
                Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
            }
            dialog.setScene(scene);
            PregledBazeController.getInstance().setScene(dialog);
            dialog.showAndWait();
        });
    }

    public static TvrtkaController getInstance() {
        return tvrtkaController;
    }

    public void initSessionID(LoginManager loginManager) {
        this.btnOk.disableProperty().bind((ObservableValue)Bindings.equal((ObservableNumberValue)this.tablicaTvrtke.getSelectionModel().selectedIndexProperty(), (int)-1));
        this.btnOk.setOnAction(event -> {
            int selectdIndex = this.tablicaTvrtke.getSelectionModel().getSelectedIndex();
            Tvrtka t = (Tvrtka)this.tablicaTvrtke.getSelectionModel().getSelectedItem();
            if (selectdIndex != -1) {
                PostavkePrograma.getInstance().obrisiPostavke();
                PostavkePrograma.getInstance().postaviPostavke(t);
                loginManager.showMainPanel();
                GlavniPanelController.getInstance().postaviKorisnika(LoginControler.getLoginUser(), t);
            }
        });
        this.btnKorisnik.setOnAction(e -> {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("UnosKorisnika.fxml"));
            Stage dialog = new Stage();
            dialog.initStyle(StageStyle.DECORATED);
            dialog.initModality(Modality.APPLICATION_MODAL);
            dialog.setTitle("Administracija korisnika");
            Scene scene = null;
            try {
                Parent p = (Parent)loader.load();
                scene = new Scene(p);
            }
            catch (IOException ex) {
                Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
            }
            dialog.setScene(scene);
            dialog.show();
            UnosKorisnikaController.getInstance().setScene(dialog, loginManager);
        });
        this.btnLogof.setOnAction(e -> {
            try {
                PostavkeStatic.ucitajPostavkeBaze();
            }
            catch (IOException ex) {
                Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
            }
            loginManager.logout();
            LogFileMonitoring.obrisiULogInfo();
        });
    }

    private void urediKOloneUtabliciTvrtke() {
        TableColumn colonaNazivTvrtke = new TableColumn("Naziv tvrtke");
        colonaNazivTvrtke.setCellValueFactory(cellData -> ((TvrtkaPopis)cellData.getValue()).nazivTvrtkeProperty());
        colonaNazivTvrtke.prefWidthProperty().bind((ObservableValue)this.tablicaTvrtke.widthProperty().divide(3.0303030303030303));
        colonaNazivTvrtke.setCellFactory(tc -> {
            TableCell cell = new TableCell();
            Text text = new Text();
            cell.setGraphic((Node)text);
            cell.setPrefHeight(-1.0);
            text.wrappingWidthProperty().bind((ObservableValue)colonaNazivTvrtke.widthProperty());
            text.textProperty().bind((ObservableValue)cell.itemProperty());
            return cell;
        });
        colonaNazivTvrtke.setStyle("-fx-alignment: CENTER;-fx-font-size: 18; -fx-font-weight: bold; -fx-font-family:Arial;");
        TableColumn colonaSjediste = new TableColumn("Sjedi\u0161te tvrtke");
        colonaSjediste.setCellValueFactory(cellData -> ((TvrtkaPopis)cellData.getValue()).sjedisteProperty());
        colonaSjediste.prefWidthProperty().bind((ObservableValue)this.tablicaTvrtke.widthProperty().divide(3.0303030303030303));
        colonaSjediste.setStyle("-fx-alignment: CENTER;");
        TableColumn colonaOib = new TableColumn("OIB");
        colonaOib.setCellValueFactory(cellData -> ((TvrtkaPopis)cellData.getValue()).oibProperty());
        colonaOib.prefWidthProperty().bind((ObservableValue)this.tablicaTvrtke.widthProperty().divide(3.0303030303030303));
        colonaOib.setStyle("-fx-alignment: CENTER;");
        this.tablicaTvrtke.getColumns().addAll((Object[])new TableColumn[]{colonaNazivTvrtke, colonaSjediste, colonaOib});
    }

    void popuniTablicu(TvrtkaPopis t) {
        this.listaTvrtke.add((Object)t);
        this.tablicaTvrtke.getItems().setAll(this.listaTvrtke);
    }

    public void popuniTablicu() {
        this.listaTvrtke.clear();
        ResultSet rs = BazaTvrtka.dajSveTvrtke(LoginControler.getLoginUser().getId());
        try {
            while (rs.next()) {
                TvrtkaPopis tv = new TvrtkaPopis();
                tv.setId(rs.getInt("ID"));
                tv.setNazivTvrtke(rs.getString("naziv_tvrtke"));
                tv.setOib(rs.getString("oib"));
                tv.setAdresa(rs.getString("adresa"));
                tv.setMjesto(rs.getString("mjesto"));
                tv.setPostbroj(rs.getString("pbr"));
                tv.setSjediste(rs.getString("adresa") + ",\n" + rs.getString("pbr") + " " + rs.getString("mjesto"));
                tv.setDatumIspitivanja(DateUtil.getLocalDate(rs.getDate("datumponovogpregleda")));
                this.listaTvrtke.add((Object)tv);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaTvrtke.getItems().setAll(this.listaTvrtke);
    }
}

