/*
 * Decompiled with CFR 0.152.
 */
package testovi;

import Utill.FormValidation;
import Utill.FxDialogs;
import ispisJasper.IspisReporta;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import kadrovska.Djelatnik;
import org.controlsfx.control.CheckListView;
import testovi.BazaTestovi;
import testovi.Osoba;
import testovi.Test;
import zastitanaradu.GlavniPanelController;

public class IspisTestovaController
implements Initializable {
    @FXML
    private TextField txtTNazivRadnika;
    @FXML
    private TextField txtTOib;
    @FXML
    private Button btnPretragaDjelatnika;
    @FXML
    private TextField txtDatumRo\u0111enja;
    @FXML
    private TextField txtTNazivTvrtkr;
    @FXML
    private TextField txtTRadnoMjesto;
    @FXML
    private Button btnIspis;
    @FXML
    private Button btnIspisSaTestom;
    @FXML
    private TextField txtTMjestoRodjenja;
    @FXML
    private CheckListView<Test> listPopisTestova;
    ObservableList<Test> listaTestovi = FXCollections.observableArrayList();
    ObservableList<Test> listaOdabraniTestovi = FXCollections.observableArrayList();
    private Djelatnik d;

    public void initialize(URL url, ResourceBundle rb) {
        this.urediListu();
        this.popuniListu();
        this.btnPretragaDjelatnika.setOnAction(e -> {
            this.d = FxDialogs.getDjelatnikDijalog();
            if (this.d != null) {
                this.popuniDjelatnika(this.d);
            }
        });
        this.btnIspisSaTestom.setOnAction(e -> {
            ArrayList<Osoba> employeeList = new ArrayList<Osoba>();
            boolean bNazivRadnika = FormValidation.textFieldValidationonlyText(this.txtTNazivRadnika);
            if (bNazivRadnika & !this.listaOdabraniTestovi.isEmpty()) {
                for (Test test : this.listaOdabraniTestovi) {
                    Osoba o = new Osoba();
                    o.setIme(this.txtTNazivRadnika.getText());
                    o.setDatumrodjenja(this.txtDatumRo\u0111enja.getText());
                    o.setOib(this.txtTOib.getText());
                    o.setMjestorodjenja(this.txtTMjestoRodjenja.getText());
                    o.setNaziv_tvrtke(this.txtTNazivTvrtkr.getText());
                    o.setRadnomjesto(this.txtTRadnoMjesto.getText());
                    o.setOznaka(test.getOznaka());
                    o.setNazivtesta(test.getNazivTesta());
                    o.setNazivDokumenta(test.getNazivDokumenta());
                    employeeList.add(o);
                }
                IspisReporta.ispisButtonSaPojo(employeeList, this.btnIspisSaTestom, "Pojo.jrxml");
            } else {
                Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti radnika i  testove");
                alert.showAndWait();
            }
        });
        this.btnIspis.setOnAction(e -> {
            ArrayList<Osoba> employeeList = new ArrayList<Osoba>();
            boolean bNazivRadnika = FormValidation.textFieldValidationonlyText(this.txtTNazivRadnika);
            if (bNazivRadnika & !this.listaOdabraniTestovi.isEmpty()) {
                for (Test test : this.listaOdabraniTestovi) {
                    Osoba o = new Osoba();
                    o.setIme(this.txtTNazivRadnika.getText());
                    o.setDatumrodjenja(this.txtDatumRo\u0111enja.getText());
                    o.setOib(this.txtTOib.getText());
                    o.setMjestorodjenja(this.txtTMjestoRodjenja.getText());
                    o.setNaziv_tvrtke(this.txtTNazivTvrtkr.getText());
                    o.setRadnomjesto(this.txtTRadnoMjesto.getText());
                    o.setOznaka(test.getOznaka());
                    o.setNazivtesta(test.getNazivTesta());
                    o.setNazivDokumenta(test.getNazivDokumenta());
                    employeeList.add(o);
                }
                IspisReporta.ispisButtonSaPojoBezTesta(employeeList, this.btnIspis, "Pojo.jrxml");
            } else {
                Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti radnika i  testove");
                alert.showAndWait();
            }
        });
    }

    private void urediListu() {
        this.listPopisTestova.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    IspisTestovaController.this.listPopisTestova.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.listPopisTestova.setCellFactory(lv -> new CheckBoxListCell<Test>(arg_0 -> this.listPopisTestova.getItemBooleanProperty(arg_0)){

            public void updateItem(Test t, boolean empty) {
                super.updateItem((Object)t, empty);
                this.setText(t == null ? "" : t.getOznaka() + " - " + t.getNazivTesta());
            }
        });
        this.listPopisTestova.getCheckModel().getCheckedIndices().addListener((ListChangeListener)new ListChangeListener<Integer>(){

            public void onChanged(ListChangeListener.Change<? extends Integer> c) {
                while (c.next()) {
                    int i;
                    Iterator iterator;
                    if (c.wasAdded()) {
                        iterator = c.getAddedSubList().iterator();
                        while (iterator.hasNext()) {
                            i = (Integer)iterator.next();
                            System.out.println(((Test)IspisTestovaController.this.listPopisTestova.getItems().get(i)).getNazivTesta() + " selected");
                            IspisTestovaController.this.listaOdabraniTestovi.add(IspisTestovaController.this.listPopisTestova.getItems().get(i));
                        }
                    }
                    if (!c.wasRemoved()) continue;
                    iterator = c.getRemoved().iterator();
                    while (iterator.hasNext()) {
                        i = (Integer)iterator.next();
                        System.out.println(((Test)IspisTestovaController.this.listPopisTestova.getItems().get(i)).getNazivTesta() + " deselected");
                        IspisTestovaController.this.listaOdabraniTestovi.remove(IspisTestovaController.this.listPopisTestova.getItems().get(i));
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniListu() {
        ResultSet rs = BazaTestovi.dajTestove();
        int br = 1;
        try {
            while (rs.next()) {
                Test t = new Test();
                t.setId(rs.getInt("id"));
                t.setRedBroj(String.valueOf(br));
                t.setOznaka(rs.getString("oznaka"));
                t.setNazivTesta(rs.getString("nazivtesta"));
                t.setNazivDokumenta(rs.getString("nazivdokumenta"));
                this.listaTestovi.add((Object)t);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(IspisTestovaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(IspisTestovaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.listPopisTestova.getItems().addAll(this.listaTestovi);
    }

    private void popuniDjelatnika(Djelatnik d) {
        this.txtTNazivRadnika.setText(d.getIme() + " " + d.getPrezime());
        this.txtTOib.setText(d.getOIB());
        this.txtDatumRo\u0111enja.setText(d.getDatumRodjenja().format(DateTimeFormatter.ofPattern("dd.MM.yyyy")));
        this.txtTNazivTvrtkr.setText(GlavniPanelController.getOdabranaTvrtka().getNazivTvrtka());
        this.txtTMjestoRodjenja.setText(d.getMjestoRodjenja() + "-" + d.getOpcinaRodjenja());
        this.txtTRadnoMjesto.setText(d.getRadnoMjesto());
    }
}

