/*
 * Decompiled with CFR 0.152.
 */
package strojevi;

import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import strojevi.BazaProizvodjac;
import strojevi.PopisProizvodjacaController;
import strojevi.Proizvodjac;
import zastitanaradu.GlavniPanelController;

public class UnosProizvodjacaController
implements Initializable {
    @FXML
    private Button btnSpremi;
    @FXML
    private TextField txtNaziv;
    @FXML
    private TextField txtTip;
    private static UnosProizvodjacaController instance;
    private boolean izmjenaOsposobljavanja = false;
    private Proizvodjac p;

    public static UnosProizvodjacaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtNaziv, this.txtTip);
        this.btnSpremi.setOnAction(e -> this.unosProizvodjaca());
    }

    private Proizvodjac dajProizvodjaca() {
        Proizvodjac pr = new Proizvodjac();
        pr.setTip(this.txtTip.getText());
        pr.setNazivProizvodjaca(this.txtNaziv.getText());
        return pr;
    }

    public void izmjenaProizvodjaca(Proizvodjac p) {
        this.izmjenaOsposobljavanja = true;
        this.p = p;
        this.txtNaziv.setText(p.getNazivProizvodjaca());
        this.txtTip.setText(p.getTip());
    }

    private void unosProizvodjaca() {
        boolean bNazivProizvodjaca = FormValidation.textFieldValidationonlyText(this.txtNaziv);
        if (bNazivProizvodjaca) {
            if (this.izmjenaOsposobljavanja) {
                if (BazaProizvodjac.izmjenaProizvodjaca(GlavniPanelController.getOdabranaTvrtka(), this.dajProizvodjaca(), this.p.getId())) {
                    PopisProizvodjacaController.getInstance().popuniTablicuProizvodjaci();
                    GlavniPanelController.getInstance().zatvoriTab("Unos Proizvodjaca");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena Proizvodjaca", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena Proizvodjaca", 2, "Error graphic");
                }
            } else if (BazaProizvodjac.unesiNoviProizvodjac(GlavniPanelController.getOdabranaTvrtka(), this.dajProizvodjaca())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen Proizvodjac", 1, "Information graphic");
                PopisProizvodjacaController.getInstance().popuniTablicuProizvodjaci();
                GlavniPanelController.getInstance().zatvoriTab("Unos Proizvodjaca");
                this.izmjenaOsposobljavanja = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen Proizvodjac", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti naziv proizvodjaca");
            alert.showAndWait();
        }
    }
}

