/*
 * Decompiled with CFR 0.152.
 */
package strojevi;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import strojevi.BazaProizvodjac;
import strojevi.Proizvodjac;
import strojevi.UnosProizvodjacaController;
import zastitanaradu.GlavniPanelController;

public class PopisProizvodjacaController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<Proizvodjac> tablicaPopisProizvodjaca;
    @FXML
    private TableColumn<Proizvodjac, String> kolPretraga;
    @FXML
    private TableColumn<Proizvodjac, String> kolRedBr;
    @FXML
    private TableColumn<Proizvodjac, String> kolTip;
    @FXML
    private TableColumn<Proizvodjac, String> kolNazivProizvodjaca;
    private static PopisProizvodjacaController instance;
    private final ObservableList<Proizvodjac> listaProizvodjaca = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisProizvodjacaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciProizvodjaci();
        this.popuniTablicuProizvodjaci();
        this.urediFilter(this.tablicaPopisProizvodjaca);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Proizvodjaca")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos Proizvodjaca");
                GlavniPanelController.getInstance().nadodajPanel("Unos Proizvodjaca", "/strojevi/UnosProizvodjaca.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos Proizvodjaca", "/strojevi/UnosProizvodjaca.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            Proizvodjac p;
            int selectdIndex = this.tablicaPopisProizvodjaca.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (p = (Proizvodjac)this.tablicaPopisProizvodjaca.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Proizvodjaca")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos Proizvodjaca");
                    GlavniPanelController.getInstance().nadodajPanel("Unos Proizvodjaca", "/strojevi/UnosProizvodjaca.fxml");
                    UnosProizvodjacaController.getInstance().izmjenaProizvodjaca(p);
                    this.tablicaPopisProizvodjaca.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos Proizvodjaca", "/strojevi/UnosProizvodjaca.fxml");
                    UnosProizvodjacaController.getInstance().izmjenaProizvodjaca(p);
                    this.tablicaPopisProizvodjaca.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisProizvodjaca.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati Proizvodjaca")).showAndWait()).get() == ButtonType.OK) {
                if (BazaProizvodjac.obrisiProizvodjac((Proizvodjac)this.tablicaPopisProizvodjaca.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuProizvodjaci();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan Proizvodjac", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan Proizvodjac", 2, "Error graphic");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaProizvodjac.dajProizvodjace(GlavniPanelController.getOdabranaTvrtka());
        int br = 1;
        try {
            while (rs.next()) {
                Proizvodjac p = new Proizvodjac();
                p.setId(rs.getInt("id"));
                p.setRedBroj(String.valueOf(br));
                p.setTip(rs.getString("tip"));
                p.setNazivProizvodjaca(rs.getString("nazivProizvodjaca"));
                this.listaProizvodjaca.add((Object)p);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisProizvodjacaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisProizvodjacaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisProizvodjaca.getItems().addAll(this.listaProizvodjaca);
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Tip-Model", "Naziv"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaProizvodjaca, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Tip-Model") ? pregled.getTip() != null && pregled.getTip().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") && pregled.getNazivProizvodjaca() != null && pregled.getNazivProizvodjaca().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciProizvodjaci() {
        this.tablicaPopisProizvodjaca.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisProizvodjacaController.this.tablicaPopisProizvodjaca.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisProizvodjaca.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolTip.setCellValueFactory((Callback)new PropertyValueFactory("tip"));
        this.kolTip.prefWidthProperty().bind((ObservableValue)this.tablicaPopisProizvodjaca.widthProperty().divide(5.0));
        this.kolTip.setStyle("-fx-alignment: CENTER;");
        this.kolNazivProizvodjaca.setCellValueFactory((Callback)new PropertyValueFactory("nazivProizvodjaca"));
        this.kolNazivProizvodjaca.prefWidthProperty().bind((ObservableValue)this.tablicaPopisProizvodjaca.widthProperty().divide(1.4492753623188406));
        this.kolNazivProizvodjaca.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    public void popuniTablicuProizvodjaci() {
        this.tablicaPopisProizvodjaca.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Random rng = new Random();
        Task<Void> task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaProizvodjaca.clear();
        this.tablicaPopisProizvodjaca.getItems().clear();
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisProizvodjacaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisProizvodjacaController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisProizvodjacaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }
}

