/*
 * Decompiled with CFR 0.152.
 */
package strojevi;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.UtillBaza;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import strojevi.BazaProizvodjac;
import strojevi.GrupaStrojeva;
import strojevi.UnosGrupeStrojevaController;
import zastitanaradu.GlavniPanelController;

public class PopisGrupaStrojevaController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<GrupaStrojeva> tablicaPopisGrupaStrojeva;
    @FXML
    private TableColumn<GrupaStrojeva, String> kolPretraga;
    @FXML
    private TableColumn<GrupaStrojeva, String> kolRedBr;
    @FXML
    private TableColumn<GrupaStrojeva, String> kolOznaka;
    @FXML
    private TableColumn<GrupaStrojeva, String> kolNaziv;
    private static PopisGrupaStrojevaController instance;
    private final ObservableList<GrupaStrojeva> listagrupaStrojeva = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisGrupaStrojevaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciGrupeStrojeva();
        this.popuniTablicuGrupeStrojeva();
        this.urediFilter(this.tablicaPopisGrupaStrojeva);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos grupe strojeva")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos grupe strojeva");
                GlavniPanelController.getInstance().nadodajPanel("Unos grupe strojeva", "/strojevi/UnosGrupeStrojeva.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos grupe strojeva", "/strojevi/UnosGrupeStrojeva.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            GrupaStrojeva g;
            int selectdIndex = this.tablicaPopisGrupaStrojeva.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (g = (GrupaStrojeva)this.tablicaPopisGrupaStrojeva.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos grupe strojeva")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos grupe strojeva");
                    GlavniPanelController.getInstance().nadodajPanel("Unos grupe strojeva", "/strojevi/UnosGrupeStrojeva.fxml");
                    UnosGrupeStrojevaController.getInstance().izmjenaGrupeStrojeva(g);
                    this.tablicaPopisGrupaStrojeva.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos grupe strojeva", "/strojevi/UnosGrupeStrojeva.fxml");
                    UnosGrupeStrojevaController.getInstance().izmjenaGrupeStrojeva(g);
                    this.tablicaPopisGrupaStrojeva.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisGrupaStrojeva.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati grupu")).showAndWait()).get() == ButtonType.OK && !UtillBaza.provjeraGrupaStroja((GrupaStrojeva)this.tablicaPopisGrupaStrojeva.getSelectionModel().getSelectedItem())) {
                if (BazaProizvodjac.obrisiGrupuStrojeva((GrupaStrojeva)this.tablicaPopisGrupaStrojeva.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuGrupeStrojeva();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisana grupa", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisana grupa", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Oznaka", "Naziv"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listagrupaStrojeva, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Oznaka") ? pregled.getSifra() != null && pregled.getSifra().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") && pregled.getNaziv() != null && pregled.getNaziv().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciGrupeStrojeva() {
        this.tablicaPopisGrupaStrojeva.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisGrupaStrojevaController.this.tablicaPopisGrupaStrojeva.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisGrupaStrojeva.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolOznaka.setCellValueFactory((Callback)new PropertyValueFactory("sifra"));
        this.kolOznaka.prefWidthProperty().bind((ObservableValue)this.tablicaPopisGrupaStrojeva.widthProperty().divide(5.0));
        this.kolOznaka.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory((Callback)new PropertyValueFactory("naziv"));
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisGrupaStrojeva.widthProperty().divide(1.4492753623188406));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaProizvodjac.dajGrupeStrojeva(GlavniPanelController.getOdabranaTvrtka());
        GrupaStrojeva g = null;
        int br = 1;
        try {
            while (rs.next()) {
                g = new GrupaStrojeva();
                g.setId(rs.getInt("id"));
                g.setRedBroj(String.valueOf(br));
                g.setSifra(rs.getString("oznaka"));
                g.setNaziv(rs.getString("naziv"));
                this.listagrupaStrojeva.add((Object)g);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisGrupaStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisGrupaStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisGrupaStrojeva.getItems().addAll(this.listagrupaStrojeva);
    }

    public void popuniTablicuGrupeStrojeva() {
        this.tablicaPopisGrupaStrojeva.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Random rng = new Random();
        Task<Void> task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listagrupaStrojeva.clear();
        this.tablicaPopisGrupaStrojeva.getItems().clear();
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisGrupaStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisGrupaStrojevaController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisGrupaStrojevaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }
}

