/*
 * Decompiled with CFR 0.152.
 */
package ro2;

import Utill.DateUtil;
import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.AnchorPane;
import kadrovska.Djelatnik;
import kadrovska.UnosDjelatnikaController;
import ro2.BazaRO2;
import ro2.PregledRO2Controller;
import ro2.RO2;
import uputnice.RA1Controller;
import zastitanaradu.GlavniPanelController;

public class RO2ObrazacController
implements Initializable {
    @FXML
    private AnchorPane anchorPanel;
    @FXML
    private AnchorPane root;
    @FXML
    private Button btnSpremi;
    @FXML
    private TextField txtOIB;
    @FXML
    private TextField txtIme;
    @FXML
    private TextField txtPrezime;
    @FXML
    private TextField txtImeOca;
    @FXML
    private Button btnPretragaDjelatnika;
    @FXML
    private DatePicker dateDatumRodjenja;
    @FXML
    private TextField txtBrojOI;
    @FXML
    private TextField txtZanimanje;
    @FXML
    private ComboBox<String> cboxSkolskaSprema;
    @FXML
    private DatePicker dateDatumKreiranja;
    @FXML
    private TextField txtRadniStazRM;
    @FXML
    private TextField txtUkupniStaz;
    @FXML
    private TextField txtNazivRM;
    @FXML
    private Button btnTPPregledRadnihMjesta;
    @FXML
    private TextField txtTocke;
    @FXML
    private DatePicker datePosljednjaOcjena;
    @FXML
    private RadioButton rbDA;
    @FXML
    private RadioButton rbNE;
    private static RO2ObrazacController instance;
    private ToggleGroup toggleGroup = new ToggleGroup();
    private Boolean izmjenaRO2 = false;
    RO2 ro = null;
    Djelatnik d;

    public static RO2ObrazacController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtZanimanje, this.txtNazivRM);
        this.popuniCBoxStrucnaSprema();
        this.rbDA.setToggleGroup(this.toggleGroup);
        this.rbNE.setToggleGroup(this.toggleGroup);
        this.dateDatumKreiranja.setValue((Object)LocalDate.now());
        this.btnPretragaDjelatnika.setOnAction(e -> {
            this.d = FxDialogs.getDjelatnikDijalog();
            if (this.d != null) {
                this.popuniOsobu(this.d);
            }
        });
        this.btnSpremi.setOnAction(e -> this.spremiRO2uputnicu());
    }

    private void popuniCBoxStrucnaSprema() {
        ResultSet rs = BazaRO2.dajStrucnuSpremu();
        try {
            while (rs.next()) {
                this.cboxSkolskaSprema.getItems().add((Object)rs.getString("naziv"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(RA1Controller.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(RO2ObrazacController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void popuniOsobu(Djelatnik d) {
        ResultSet rs = BazaRO2.dajDjelatnika(d, GlavniPanelController.getOdabranaTvrtka());
        RO2 r = null;
        try {
            while (rs.next()) {
                r = new RO2();
                r.setIddjelatnika(rs.getInt("id"));
                r.setIme(rs.getString("ime"));
                r.setPrezime(rs.getString("prezime"));
                r.setDatumZaposlenja(DateUtil.getLocalDate(rs.getDate("datumzaposlenja")));
                r.setRadniStazUtvrtci(rs.getString("stazutvrtci"));
                r.setRadnoMjesto(rs.getString("radnomjesto"));
                r.setTocka(rs.getString("tockepregleda"));
                r.setStrucnaSprema(rs.getString("sprema"));
                r.setOib(rs.getString("oib"));
                r.setDatumRodjenja(DateUtil.getLocalDate(rs.getDate("datumrodjenja")));
                r.setZanimianje(rs.getString("zanimanje"));
                r.setImeOca(rs.getString("imeoca"));
                r.setStazIzvanTvrtke(rs.getString("stazizvantvrtke"));
                r.setImeMajke(rs.getString("imemajke"));
                r.setBrojOsobne(rs.getString("brojosobne"));
                r.setDatumPosljednjegPregleda(DateUtil.getLocalDate(rs.getDate("datumpregleda")));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(RO2ObrazacController.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.popuniObrazac(r);
    }

    public void popuniObrazac(RO2 r) {
        this.txtOIB.setText(r.getOib());
        this.txtIme.setText(r.getIme());
        this.txtPrezime.setText(r.getPrezime());
        if (r.getImeOca().equals("")) {
            this.txtImeOca.setText(r.getImeMajke());
        } else {
            this.txtImeOca.setText(r.getImeOca());
        }
        this.dateDatumRodjenja.setValue((Object)r.getDatumRodjenja());
        this.txtZanimanje.setText(r.getZanimianje());
        this.cboxSkolskaSprema.setValue((Object)r.getStrucnaSprema());
        this.txtBrojOI.setText(r.getBrojOsobne());
        this.txtRadniStazRM.setText(r.getRadniStazUtvrtci());
        this.txtNazivRM.setText(r.getRadnoMjesto());
        this.txtTocke.setText(r.getTocka());
        this.datePosljednjaOcjena.setValue((Object)r.getDatumPosljednjegPregleda());
        this.izracunajStaz(r.getDatumZaposlenja(), r.getStazIzvanTvrtke());
    }

    private void izracunajStaz(LocalDate datumZaposlenja, String stazIzvanTvrtke) {
        if (datumZaposlenja != null && stazIzvanTvrtke != null) {
            LocalDate dateEnd = LocalDate.now();
            long p2 = ChronoUnit.DAYS.between(datumZaposlenja, dateEnd);
            Period p1 = Period.between(datumZaposlenja, dateEnd);
            this.txtRadniStazRM.setText(p1.getYears() + "g " + p1.getMonths() + "m " + p1.getDays() + "d ");
            String line = stazIzvanTvrtke;
            StringTokenizer stringTokenizer = new StringTokenizer(UnosDjelatnikaController.reduceToAlphaNumerics(line));
            int y = 0;
            int m = 0;
            int d = 0;
            while (stringTokenizer.hasMoreElements()) {
                y = Integer.parseInt(stringTokenizer.nextElement().toString());
                m = Integer.parseInt(stringTokenizer.nextElement().toString());
                d = Integer.parseInt(stringTokenizer.nextElement().toString());
            }
            dateEnd = dateEnd.plus(Period.of(y, m, d));
            Period p = Period.between(datumZaposlenja, dateEnd);
            this.txtUkupniStaz.setText(p.getYears() + "g " + p.getMonths() + "m " + p.getDays() + "d ");
        } else {
            this.txtUkupniStaz.setText("0g 0m 0d");
        }
    }

    private void spremiRO2uputnicu() {
        boolean bprezime;
        boolean bime;
        boolean bOib = FormValidation.textFieldValidationonlyText(this.txtOIB);
        if (bOib & (bime = FormValidation.textFieldValidationonlyText(this.txtIme)) & (bprezime = FormValidation.textFieldValidationonlyText(this.txtPrezime))) {
            if (this.izmjenaRO2.booleanValue()) {
                if (BazaRO2.izmjenaRo2(GlavniPanelController.getOdabranaTvrtka(), this.dajRO2(), this.ro.getId())) {
                    PregledRO2Controller.getInstance().popuniTablicuPopisRO2Uputnica(1);
                    GlavniPanelController.getInstance().zatvoriTab("Unos RO uputnice");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena obrasca", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena obrasca", 2, "Error graphic");
                }
            } else if (BazaRO2.unesiNoviRo2(GlavniPanelController.getOdabranaTvrtka(), this.dajRO2())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen obrasc", 1, "Information graphic");
                PregledRO2Controller.getInstance().popuniTablicuPopisRO2Uputnica(1);
                GlavniPanelController.getInstance().zatvoriTab("Unos RO uputnice");
                this.izmjenaRO2 = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen obrasc", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti sva oznacena polja");
            alert.showAndWait();
        }
    }

    public RO2 dajRO2() {
        RO2 r = new RO2();
        r.setDatumKreiranja((LocalDate)this.dateDatumKreiranja.getValue());
        r.setOib(this.txtOIB.getText());
        r.setIme(this.txtIme.getText());
        r.setPrezime(this.txtPrezime.getText());
        r.setImeOca_Majke(this.txtImeOca.getText());
        r.setDatumRodjenja((LocalDate)this.dateDatumRodjenja.getValue());
        r.setBrojOsobne(this.txtBrojOI.getText());
        r.setStrucnaSprema((String)this.cboxSkolskaSprema.getValue());
        r.setZanimianje(this.txtZanimanje.getText());
        r.setRadniStazUtvrtci(this.txtRadniStazRM.getText());
        r.setUkupanStaz(this.txtUkupniStaz.getText());
        r.setRadnoMjesto(this.txtNazivRM.getText());
        r.setTocka(this.txtTocke.getText());
        r.setDatumPosljednjegPregleda((LocalDate)this.datePosljednjaOcjena.getValue());
        if (this.rbDA.isSelected()) {
            r.setMjenjanoMjesto(true);
        }
        if (this.rbNE.isSelected()) {
            r.setMjenjanoMjesto(false);
        }
        this.txtRadniStazRM.setText(r.getRadniStazUtvrtci());
        this.txtUkupniStaz.setText(r.getUkupanStaz());
        return r;
    }

    void izmjenaUputnice(RO2 r) {
        this.izmjenaRO2 = true;
        this.ro = r;
        this.txtOIB.setText(r.getOib());
        this.txtIme.setText(r.getIme());
        this.txtPrezime.setText(r.getPrezime());
        this.txtImeOca.setText(r.getImeOca_Majke());
        this.dateDatumRodjenja.setValue((Object)r.getDatumRodjenja());
        this.txtZanimanje.setText(r.getZanimianje());
        this.cboxSkolskaSprema.setValue((Object)r.getStrucnaSprema());
        this.txtBrojOI.setText(r.getBrojOsobne());
        this.txtRadniStazRM.setText(r.getRadniStazUtvrtci());
        this.txtNazivRM.setText(r.getRadnoMjesto());
        this.txtTocke.setText(r.getTocka());
        this.datePosljednjaOcjena.setValue((Object)r.getDatumPosljednjegPregleda());
        this.txtUkupniStaz.setText(r.getUkupanStaz());
        if (r.isMjenjanoMjesto()) {
            this.toggleGroup.selectToggle((Toggle)this.rbDA);
        } else {
            this.toggleGroup.selectToggle((Toggle)this.rbNE);
        }
    }
}

