/*
 * Decompiled with CFR 0.152.
 */
package radniokolis;

import Utill.ComboBoxCellDokument;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import Utill.ScanDokument;
import dokumentiTvrtke.BazaDokumenti;
import dokumentiTvrtke.DokumentHiperlinkCell;
import ispisJasper.IspisReporta;
import java.io.File;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javafx.util.StringConverter;
import kadrovska.BazaDjelatnik;
import kadrovska.UnosDjelatnikaController;
import monitoringnovi.ServiceRestart;
import odjeli.BazaOdjeli;
import poslovnejedinice.PoslovneJedinice;
import radniokolis.BazaFRO;
import radniokolis.FROIspitivanja;
import radniokolis.MjernoMjestoFRO;
import radniokolis.PregledMjernoMjestoFROController;
import zastitanaradu.GlavniPanelController;

public class UnosFROController
implements Initializable {
    @FXML
    private TabPane tabPanePodaci;
    @FXML
    private Button btnSpremi;
    @FXML
    private AnchorPane anchorPanelStroj;
    @FXML
    private TextField txtNazivRM;
    @FXML
    private ComboBox<PoslovneJedinice> cBoxPoslovnaJedinica;
    @FXML
    private ComboBox<String> cBoxOdjel;
    @FXML
    private TextField txtNazivRadneProstorije;
    @FXML
    private TextField txtMjestoAdresa;
    @FXML
    private TextArea txtAreaOznakaLokacije;
    @FXML
    private Tab tabEvidencijaPregleda;
    @FXML
    private Button btnUnosFRO;
    @FXML
    private Button btnBrisanjeFRO;
    @FXML
    private Button btnIspisEK5FRO;
    @FXML
    private TableView<FROIspitivanja> tablicaEvidencijaPregleda;
    @FXML
    private TableColumn<FROIspitivanja, String> kolRedBrFRO;
    @FXML
    private TableColumn<FROIspitivanja, String> kolToplinskiUvjeti;
    @FXML
    private TableColumn<FROIspitivanja, String> kolBuka;
    @FXML
    private TableColumn<FROIspitivanja, String> kolOpasneTvari;
    @FXML
    private TableColumn<FROIspitivanja, String> kolOpasnaZracenja;
    @FXML
    private TableColumn<FROIspitivanja, String> kolOsvjetljenost;
    @FXML
    private TableColumn<FROIspitivanja, String> kolOkolnosti;
    @FXML
    private TableColumn<FROIspitivanja, LocalDate> kolDatumIspitivanja;
    @FXML
    private TableColumn<FROIspitivanja, String> kolNazivOrganizacije;
    @FXML
    private TableColumn<FROIspitivanja, String> kolBrojIsprave;
    @FXML
    private TableColumn<FROIspitivanja, LocalDate> kolDatumIzdavanjaIsprave;
    @FXML
    private TableColumn<FROIspitivanja, String> kolIspunaUvjeta;
    @FXML
    private TableColumn<FROIspitivanja, LocalDate> kolDatumPonovogIspitivanja;
    @FXML
    private TableColumn<FROIspitivanja, String> kolDokument;
    @FXML
    private TableColumn<FROIspitivanja, String> kolPodatkeUpisao;
    @FXML
    private Tab tabDokumenti;
    @FXML
    private TextField txtOpis;
    @FXML
    private TableView<ScanDokument> tablicaDokumenti;
    @FXML
    private TableColumn<ScanDokument, String> kolNazivDokumenta;
    @FXML
    private TableColumn<ScanDokument, String> kolRedBr;
    @FXML
    private Button btnSpremiDokument;
    @FXML
    private Button btnBrisanjeDokument;
    @FXML
    private CheckBox chBoxZatvoreno;
    private static UnosFROController instance;
    private final ObservableList<String> listaDANE = FXCollections.observableArrayList((Object[])new String[]{"Da", "Ne", ""});
    private ObservableList<ScanDokument> listaDokumenti = FXCollections.observableArrayList();
    private ObservableList<FROIspitivanja> listaFROispitivanja = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private Boolean izmjenaFRO = false;
    BooleanProperty bp = new SimpleBooleanProperty(false);
    List<String> listaBrojevaOznakePregleda = new ArrayList<String>();
    private MjernoMjestoFRO mm;

    public TabPane getTabPanePodaci() {
        return this.tabPanePodaci;
    }

    public static UnosFROController getInstance() {
        return instance;
    }

    public MjernoMjestoFRO getMm() {
        return this.mm;
    }

    public void setMm(MjernoMjestoFRO mm) {
        this.mm = mm;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtOpis, this.txtNazivRadneProstorije);
        this.popuniCBoxPoslovnice();
        this.cBoxPoslovnaJedinica.valueProperty().addListener((o, ov, nv) -> {
            PoslovneJedinice p = nv;
            this.popuniOdjelePoslovneJedinice(p.getId());
        });
        this.tabDokumenti.disableProperty().bind((ObservableValue)this.bp.not());
        this.tabEvidencijaPregleda.disableProperty().bind((ObservableValue)this.bp.not());
        this.urediTblicuEvidencijaIspitivanja();
        this.popuniTablicuEvidencijaIspitivanja();
        this.urediKoloneUTabliciDokumenti();
        this.popuniTablicuDokumenti();
        this.btnBrisanjeDokument.disableProperty().bind((ObservableValue)Bindings.equal((ObservableNumberValue)this.tablicaDokumenti.getSelectionModel().selectedIndexProperty(), (int)-1));
        this.btnBrisanjeDokument.setOnAction(event -> {
            int selectedIdx = this.tablicaDokumenti.getSelectionModel().getSelectedIndex();
            ScanDokument sc = (ScanDokument)this.tablicaDokumenti.getSelectionModel().getSelectedItem();
            Alert alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje Dokumenta", "\u017delite li obrisati dokument ?");
            Optional result = alert.showAndWait();
            if (selectedIdx != -1) {
                if (result.get() == ButtonType.OK) {
                    if (BazaDokumenti.deleteDokument(sc)) {
                        this.popuniTablicuDokumenti();
                    } else {
                        Alert error = FxDialogs.getDialog(Alert.AlertType.ERROR, "Brisanje dokumenta", "Neuspjelo brisanje dokumenta");
                        error.showAndWait();
                    }
                } else {
                    this.tablicaDokumenti.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnSpremiDokument.setOnAction(e -> {
            block6: {
                boolean bopis = FormValidation.textFieldValidationonlyText(this.txtOpis);
                if (bopis) {
                    FileChooser fileChooser = new FileChooser();
                    File selectedFile = fileChooser.showOpenDialog(null);
                    if (selectedFile != null) {
                        try {
                            byte[] byteImage = KlasaKorisneMetode.ImageToByte(new File(selectedFile.getAbsolutePath()));
                            if (BazaFRO.addDokumentFRO(this.txtOpis.getText() + " (" + LocalDate.now().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)) + ")." + KlasaKorisneMetode.getExtension(selectedFile), GlavniPanelController.getOdabranaTvrtka(), this.mm.getId(), byteImage, GlavniPanelController.getInstance().getKorisnik().punoIme())) {
                                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen dokument", 1, "Information graphic");
                                this.txtOpis.clear();
                                this.popuniTablicuDokumenti();
                                break block6;
                            }
                            KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen dokument", 2, "Error graphic");
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti naziv Dokumenta");
                    alert.showAndWait();
                }
            }
        });
        this.btnUnosFRO.setOnAction(e -> {
            FROIspitivanja fro = new FROIspitivanja();
            fro.setPodatkeUpisao(GlavniPanelController.getInstance().getKorisnik().punoIme());
            if (BazaFRO.unesiNovoIspitivanja(fro, GlavniPanelController.getOdabranaTvrtka().getId(), this.mm.getId())) {
                this.popuniTablicuEvidencijaIspitivanja();
            } else {
                FxDialogs.showError("Gre\u0161ka unosa", "Neuspje\u0161an unos pregleda");
            }
        });
        this.btnBrisanjeFRO.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaEvidencijaPregleda.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati ispitivanje")).showAndWait()).get() == ButtonType.OK) {
                if (BazaFRO.obrisiIspitivanjePregled((FROIspitivanja)this.tablicaEvidencijaPregleda.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuEvidencijaIspitivanja();
                    ServiceRestart.restartService(ServiceRestart.RService.fro);
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no brisanje ", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no brisanje", 2, "Error graphic");
                }
            }
        });
        this.btnSpremi.setOnAction(e -> this.spremiMjernoMjesto());
        this.btnIspisEK5FRO.setOnAction(e -> {
            String sql = "Select * from viewfro where mjernomjesto_id='" + this.mm.getId() + "'and tvrtka_id='" + GlavniPanelController.getOdabranaTvrtka().getId() + "' ORDER BY datumispitivanja ";
            IspisReporta.ispisButtonSaSubreportom(sql, this.btnIspisEK5FRO, "Ek-5.jrxml");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniOdjelePoslovneJedinice(int idPoslovneJedinice) {
        this.cBoxOdjel.getItems().clear();
        ResultSet rs = BazaOdjeli.dajOdjel(GlavniPanelController.getOdabranaTvrtka(), idPoslovneJedinice);
        try {
            while (rs.next()) {
                this.cBoxOdjel.getItems().add((Object)rs.getString("nazivodjela"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosFROController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosFROController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniCBoxPoslovnice() {
        final ObservableMap map = FXCollections.observableHashMap();
        ResultSet rs = BazaDjelatnik.dajPoslovnujednicu(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                PoslovneJedinice pj = new PoslovneJedinice();
                pj.setId(rs.getInt("id"));
                pj.setNazivPoslovnice(rs.getString("nazivposlovnice"));
                pj.setAdresaPoslovnice(rs.getString("adresa"));
                pj.setMjesto(rs.getString("mjesto"));
                map.put((Object)rs.getString("nazivposlovnice"), (Object)pj);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cBoxPoslovnaJedinica.getItems().addAll(map.values());
        this.cBoxPoslovnaJedinica.setConverter((StringConverter)new StringConverter<PoslovneJedinice>(){

            public String toString(PoslovneJedinice t) {
                if (t != null) {
                    String str = t.getNazivPoslovnice();
                    map.put((Object)str, (Object)t);
                    return str;
                }
                return "";
            }

            public PoslovneJedinice fromString(String string) {
                if (!map.containsKey((Object)string)) {
                    UnosFROController.this.cBoxPoslovnaJedinica.setValue(null);
                    UnosFROController.this.cBoxPoslovnaJedinica.getEditor().clear();
                    return null;
                }
                return (PoslovneJedinice)map.get((Object)string);
            }
        });
        this.cBoxPoslovnaJedinica.setCellFactory((Callback)new Callback<ListView<PoslovneJedinice>, ListCell<PoslovneJedinice>>(){

            public ListCell<PoslovneJedinice> call(ListView<PoslovneJedinice> p) {
                ListCell<PoslovneJedinice> cell = new ListCell<PoslovneJedinice>(){

                    protected void updateItem(PoslovneJedinice item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setText("");
                        } else {
                            this.setText(item.getNazivPoslovnice());
                            this.setAlignment(Pos.CENTER);
                            this.setPadding(new Insets(3.0, 3.0, 3.0, 0.0));
                        }
                    }
                };
                return cell;
            }
        });
    }

    private void urediKoloneUTabliciDokumenti() {
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaDokumenti.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolNazivDokumenta.setCellValueFactory((Callback)new PropertyValueFactory("opisDokumenta"));
        this.kolNazivDokumenta.prefWidthProperty().bind((ObservableValue)this.tablicaDokumenti.widthProperty().divide(1.1235955056179776));
        this.kolNazivDokumenta.setStyle("-fx-alignment: CENTER;");
        Callback cellScanDokument = param -> new DokumentHiperlinkCell(this.listaDokumenti);
        this.kolNazivDokumenta.setCellFactory(cellScanDokument);
    }

    private void popuniTablicuDokumenti() {
        this.tablicaDokumenti.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskDokumenti();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaDokumenti.clear();
        this.tablicaDokumenti.getItems().clear();
    }

    private Task createTaskDokumenti() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(UnosFROController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    UnosFROController.this.popuniTablicuDokumentiizBaze();
                }
                finally {
                    Platform.runLater(() -> UnosFROController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void popuniTablicuDokumentiizBaze() {
        int br = 1;
        ResultSet rs = BazaFRO.getDokumentiFRO(GlavniPanelController.getOdabranaTvrtka().getId(), this.mm.getId());
        try {
            while (rs.next()) {
                ScanDokument cd = new ScanDokument();
                cd.setId(rs.getInt("id"));
                cd.setRedBroj(String.valueOf(br));
                cd.setOpisDokumenta(rs.getString("naziv"));
                this.listaDokumenti.add((Object)cd);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.tablicaDokumenti.getItems().addAll(this.listaDokumenti);
    }

    private String addBroj(String s, String oznaka) {
        StringBuilder sb = new StringBuilder();
        if (oznaka.equals("Da")) {
            this.listaBrojevaOznakePregleda.add(s);
        } else {
            this.listaBrojevaOznakePregleda.remove(s);
        }
        HashSet<String> hs = new HashSet<String>();
        hs.addAll(this.listaBrojevaOznakePregleda);
        this.listaBrojevaOznakePregleda.clear();
        this.listaBrojevaOznakePregleda.addAll(hs);
        for (String ls : this.listaBrojevaOznakePregleda) {
            System.out.print((Object)ls);
            sb.append(ls + " ");
        }
        return sb.toString();
    }

    private Label getLabel(String nazivKolone) {
        Label l1 = new Label(nazivKolone);
        l1.setAlignment(Pos.CENTER);
        l1.setTextAlignment(TextAlignment.CENTER);
        return l1;
    }

    private void urediTblicuEvidencijaIspitivanja() {
        this.tablicaEvidencijaPregleda.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE && UnosFROController.this.tablicaEvidencijaPregleda.getEditingCell() == null) {
                    UnosFROController.this.tablicaEvidencijaPregleda.getSelectionModel().clearSelection();
                    e.consume();
                }
            }
        });
        this.kolRedBrFRO.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).redBrojProperty());
        this.kolRedBrFRO.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(20.0));
        this.kolRedBrFRO.setStyle("-fx-alignment: CENTER;");
        this.kolToplinskiUvjeti.setText("");
        this.kolToplinskiUvjeti.setGraphic((Node)this.getLabel("Toplinski uvjeti \n (temperatura,vla\u017enost \n i brzina kretanja zraka) \n (DA-NE)\n1"));
        this.kolToplinskiUvjeti.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).toplinskiUvjetiProperty());
        this.kolToplinskiUvjeti.setCellFactory(t -> {
            ComboBoxTableCell myComboBoxTableCell = new ComboBoxTableCell(this.listaDANE);
            myComboBoxTableCell.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    myComboBoxTableCell.commitEdit(null);
                }
                if (e.getCode() == KeyCode.ESCAPE) {
                    myComboBoxTableCell.cancelEdit();
                }
            });
            return myComboBoxTableCell;
        });
        this.kolToplinskiUvjeti.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolToplinskiUvjeti.setStyle("-fx-alignment: CENTER;");
        this.kolToplinskiUvjeti.setOnEditCommit(t -> {
            ((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow())).setToplinskiUvjeti((String)t.getNewValue());
            BazaFRO.unesiPromjenuPregledIspitivanja((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolBuka.setText("");
        this.kolBuka.setGraphic((Node)this.getLabel("\n Buka \n \n(DA-NE)\n 2"));
        this.kolBuka.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).bukaProperty());
        this.kolBuka.setCellFactory(t -> {
            ComboBoxTableCell myComboBoxTableCell = new ComboBoxTableCell(this.listaDANE);
            myComboBoxTableCell.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    myComboBoxTableCell.commitEdit(null);
                }
                if (e.getCode() == KeyCode.ESCAPE) {
                    myComboBoxTableCell.cancelEdit();
                }
            });
            return myComboBoxTableCell;
        });
        this.kolBuka.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(20.0));
        this.kolBuka.setStyle("-fx-alignment: CENTER;");
        this.kolBuka.setOnEditCommit(t -> {
            ((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow())).setBuka((String)t.getNewValue());
            BazaFRO.unesiPromjenuPregledIspitivanja((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolOpasneTvari.setText("");
        this.kolOpasneTvari.setGraphic((Node)this.getLabel("Opasne tvari ili\n organizmi \u0161tetni \n na zdravlje  \n (DA-NE)\n 3"));
        this.kolOpasneTvari.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).opasneTvariProperty());
        this.kolOpasneTvari.setCellFactory(t -> {
            ComboBoxTableCell myComboBoxTableCell = new ComboBoxTableCell(this.listaDANE);
            myComboBoxTableCell.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    myComboBoxTableCell.commitEdit(null);
                }
                if (e.getCode() == KeyCode.ESCAPE) {
                    myComboBoxTableCell.cancelEdit();
                }
            });
            return myComboBoxTableCell;
        });
        this.kolOpasneTvari.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(12.5));
        this.kolOpasneTvari.setStyle("-fx-alignment: CENTER;");
        this.kolOpasneTvari.setOnEditCommit(t -> {
            ((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow())).setOpasneTvari((String)t.getNewValue());
            BazaFRO.unesiPromjenuPregledIspitivanja((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolOpasnaZracenja.setText("");
        this.kolOpasnaZracenja.setGraphic((Node)this.getLabel("\n Opasna zra\u010denja \n \n (DA-NE) \n 4"));
        this.kolOpasnaZracenja.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).opasnaZracenjaProperty());
        this.kolOpasnaZracenja.setCellFactory(t -> {
            ComboBoxTableCell myComboBoxTableCell = new ComboBoxTableCell(this.listaDANE);
            myComboBoxTableCell.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    myComboBoxTableCell.commitEdit(null);
                }
                if (e.getCode() == KeyCode.ESCAPE) {
                    myComboBoxTableCell.cancelEdit();
                }
            });
            return myComboBoxTableCell;
        });
        this.kolOpasnaZracenja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(12.5));
        this.kolOpasnaZracenja.setStyle("-fx-alignment: CENTER;");
        this.kolOpasnaZracenja.setOnEditCommit(t -> {
            ((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow())).setOpasnaZracenja((String)t.getNewValue());
            BazaFRO.unesiPromjenuPregledIspitivanja((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolOsvjetljenost.setText("");
        this.kolOsvjetljenost.setGraphic((Node)this.getLabel("\n Osvjetljenost \n \n(DA-NE)\n 5"));
        this.kolOsvjetljenost.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).osvjetljenostProperty());
        this.kolOsvjetljenost.setCellFactory(t -> {
            ComboBoxTableCell myComboBoxTableCell = new ComboBoxTableCell(this.listaDANE);
            myComboBoxTableCell.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    myComboBoxTableCell.commitEdit(null);
                }
                if (e.getCode() == KeyCode.ESCAPE) {
                    myComboBoxTableCell.cancelEdit();
                }
            });
            return myComboBoxTableCell;
        });
        this.kolOsvjetljenost.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolOsvjetljenost.setStyle("-fx-alignment: CENTER;");
        this.kolOsvjetljenost.setOnEditCommit(t -> {
            ((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow())).setOsvjetljenost((String)t.getNewValue());
            BazaFRO.unesiPromjenuPregledIspitivanja((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolOkolnosti.setText("");
        this.kolOkolnosti.setGraphic((Node)this.getLabel("Ispitivanje radne okoline\n izvr\u0161eno je na \n okolnosti"));
        this.kolOkolnosti.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).ispitivanjeIzvrsenoNaOkolnostiProperty());
        this.kolOkolnosti.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolOkolnosti.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolOkolnosti.setStyle("-fx-alignment: CENTER;");
        this.kolOkolnosti.setOnEditCommit(t -> {
            ((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow())).setIspitivanjeIzvrsenoNaOkolnosti((String)t.getNewValue());
            BazaFRO.unesiPromjenuPregledIspitivanja((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Callback cellDokument = param -> new ComboBoxCellDokument(this.listaDokumenti);
        this.kolDokument.setText("");
        this.kolDokument.setGraphic((Node)this.getLabel("Dokument"));
        this.kolDokument.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).nazivDokumentaProperty());
        this.kolDokument.setCellFactory(cellDokument);
        this.kolDokument.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(6.666666666666667));
        this.kolDokument.setStyle("-fx-alignment: CENTER;");
        this.kolDokument.setOnEditCommit(t -> {
            ((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivDokumenta((String)t.getNewValue());
            BazaFRO.unesiPromjenuPregledIspitivanja((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumIspitivanja.setText("");
        this.kolDatumIspitivanja.setGraphic((Node)this.getLabel("Datum obavljenog \n ispitivanja"));
        this.kolDatumIspitivanja.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).datumIspitivanjaProperty());
        this.kolDatumIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(12.5));
        this.kolDatumIspitivanja.setCellFactory(dateCellFactory);
        this.kolDatumIspitivanja.setOnEditCommit(t -> {
            ((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumIspitivanja((LocalDate)t.getNewValue());
            BazaFRO.unesiPromjenuPregledIspitivanja((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolNazivOrganizacije.setText("");
        this.kolNazivOrganizacije.setGraphic((Node)this.getLabel("Naziv organizacije koja\n je izvr\u0161ila \n ispitivanja"));
        this.kolNazivOrganizacije.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).nazivOrganizacijeIzvrsenjaIspitivanjaProperty());
        this.kolNazivOrganizacije.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolNazivOrganizacije.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(6.666666666666667));
        this.kolNazivOrganizacije.setStyle("-fx-alignment: CENTER;");
        this.kolNazivOrganizacije.setOnEditCommit(t -> {
            ((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivOrganizacijeIzvrsenjaIspitivanja((String)t.getNewValue());
            BazaFRO.unesiPromjenuPregledIspitivanja((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolBrojIsprave.setText("");
        this.kolBrojIsprave.setGraphic((Node)this.getLabel("Broj isprave\n ispitivanja"));
        this.kolBrojIsprave.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).brojIspraveProperty());
        this.kolBrojIsprave.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolBrojIsprave.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(20.0));
        this.kolBrojIsprave.setStyle("-fx-alignment: CENTER;");
        this.kolBrojIsprave.setOnEditCommit(t -> {
            ((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow())).setBrojIsprave((String)t.getNewValue());
            BazaFRO.unesiPromjenuPregledIspitivanja((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolDatumIzdavanjaIsprave.setText("");
        this.kolDatumIzdavanjaIsprave.setGraphic((Node)this.getLabel("Datum izdavanja \n isprave o ispitivanju"));
        this.kolDatumIzdavanjaIsprave.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).datumIzdavanjeIspraveProperty());
        this.kolDatumIzdavanjaIsprave.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(12.5));
        this.kolDatumIzdavanjaIsprave.setCellFactory(dateCellFactory);
        this.kolDatumIzdavanjaIsprave.setOnEditCommit(t -> {
            ((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumIzdavanjeIsprave((LocalDate)t.getNewValue());
            BazaFRO.unesiPromjenuPregledIspitivanja((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolIspunaUvjeta.setText("");
        this.kolIspunaUvjeta.setGraphic((Node)this.getLabel("Da li radna okolina  \n ispunjava propisane uvjete \n za kori\u0161tenje\n (DA-NE)"));
        this.kolIspunaUvjeta.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).ispunjavaUvjeteProperty());
        this.kolIspunaUvjeta.setCellFactory(t -> {
            ComboBoxTableCell myComboBoxTableCell = new ComboBoxTableCell(this.listaDANE);
            myComboBoxTableCell.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    myComboBoxTableCell.commitEdit(null);
                }
                if (e.getCode() == KeyCode.ESCAPE) {
                    myComboBoxTableCell.cancelEdit();
                }
            });
            return myComboBoxTableCell;
        });
        this.kolIspunaUvjeta.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolIspunaUvjeta.setStyle("-fx-alignment: CENTER;");
        this.kolIspunaUvjeta.setOnEditCommit(t -> {
            ((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow())).setIspunjavaUvjete((String)t.getNewValue());
            BazaFRO.unesiPromjenuPregledIspitivanja((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolDatumPonovogIspitivanja.setText("");
        this.kolDatumPonovogIspitivanja.setGraphic((Node)this.getLabel("Datum ponovog \n ispitivanja"));
        this.kolDatumPonovogIspitivanja.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).datumPonovogIspitivanjaProperty());
        this.kolDatumPonovogIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(12.5));
        this.kolDatumPonovogIspitivanja.setCellFactory(dateCellFactory);
        this.kolDatumPonovogIspitivanja.setOnEditCommit(t -> {
            ((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumPonovogIspitivanja((LocalDate)t.getNewValue());
            BazaFRO.unesiPromjenuPregledIspitivanja((FROIspitivanja)t.getTableView().getItems().get(t.getTablePosition().getRow()));
            ServiceRestart.restartService(ServiceRestart.RService.fro);
        });
        this.kolPodatkeUpisao.setText("");
        this.kolPodatkeUpisao.setGraphic((Node)this.getLabel("Prezime i ime \n radnika koji je \n upisao podatke u \n evidenciju"));
        this.kolPodatkeUpisao.setCellValueFactory(cellData -> ((FROIspitivanja)cellData.getValue()).podatkeUpisaoProperty());
        this.kolPodatkeUpisao.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(6.666666666666667));
        this.kolPodatkeUpisao.setStyle("-fx-alignment: CENTER;");
    }

    public void popuniTablicuEvidencijaIspitivanja() {
        this.tablicaEvidencijaPregleda.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Random rng = new Random();
        Task task = this.createTaskPregledIspitivanje();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaFROispitivanja.clear();
        this.tablicaEvidencijaPregleda.getItems().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuPodatkeEvidencijaIspitivanja() {
        ResultSet rs = BazaFRO.dajFROIspitivanja(GlavniPanelController.getOdabranaTvrtka().getId(), this.mm.getId());
        FROIspitivanja fro = null;
        int br = 1;
        try {
            while (rs.next()) {
                fro = new FROIspitivanja();
                fro.setId(rs.getInt("id"));
                fro.setRedBroj(String.valueOf(br));
                fro.setToplinskiUvjeti(rs.getString("toplinskiuvjeti"));
                fro.setBuka(rs.getString("buka"));
                fro.setOpasnaZracenja(rs.getString("opasnazracenja"));
                fro.setOpasneTvari(rs.getString("opasnetvari"));
                fro.setOsvjetljenost(rs.getString("osvjetljenost"));
                fro.setIspitivanjeIzvrsenoNaOkolnosti(rs.getString("ispitivanjenaokolnosti"));
                fro.setDatumIspitivanja(DateUtil.getLocalDate(rs.getDate("datumispitivanja")));
                fro.setNazivOrganizacijeIzvrsenjaIspitivanja(rs.getString("nazivorganizacije"));
                fro.setBrojIsprave(rs.getString("brojispraveispitivanja"));
                fro.setDatumIzdavanjeIsprave(DateUtil.getLocalDate(rs.getDate("datumizdavanja")));
                fro.setIspunjavaUvjete(rs.getString("ispunjavaliuvjete"));
                fro.setDatumPonovogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumponovogispitivanja")));
                fro.setNazivDokumenta(rs.getString("dokument"));
                fro.setPodatkeUpisao(rs.getString("podatkeupisao"));
                this.listaFROispitivanja.add((Object)fro);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaEvidencijaPregleda.setItems(this.listaFROispitivanja);
    }

    private Task createTaskPregledIspitivanje() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(UnosFROController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    UnosFROController.this.popuniTablicuPodatkeEvidencijaIspitivanja();
                }
                finally {
                    Platform.runLater(() -> UnosFROController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void spremiMjernoMjesto() {
        boolean bNazivMjernogMjesta = FormValidation.textFieldValidationonlyText(this.txtNazivRadneProstorije);
        boolean bPoslovnica = FormValidation.comboBoxValidationText(this.cBoxPoslovnaJedinica);
        boolean bOdjel = FormValidation.comboBoxValidationText(this.cBoxOdjel);
        boolean bAdresa = FormValidation.textFieldValidationonlyText(this.txtMjestoAdresa);
        if (bNazivMjernogMjesta & bAdresa & bPoslovnica & bOdjel) {
            if (this.izmjenaFRO.booleanValue()) {
                if (BazaFRO.izmjenaMjernogMjesta(GlavniPanelController.getOdabranaTvrtka(), this.dajMjernoMjesto(), this.mm.getId())) {
                    if (!GlavniPanelController.getInstance().getTabByIdifExist("Popis mjernih mjesta (FRO)")) {
                        PregledMjernoMjestoFROController.getInstance().popuniTablicuPopisMjernihMjesta();
                    }
                    GlavniPanelController.getInstance().zatvoriTab("Unos mjernog mjesta");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena stroja", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena stroja", 2, "Error graphic");
                }
            } else if (BazaFRO.unesiNovoMjernoMjesto(GlavniPanelController.getOdabranaTvrtka(), this.dajMjernoMjesto())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen stroja", 1, "Information graphic");
                PregledMjernoMjestoFROController.getInstance().popuniTablicuPopisMjernihMjesta();
                GlavniPanelController.getInstance().zatvoriTab("Unos mjernog mjesta");
                this.izmjenaFRO = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen stroja", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti sva oznacena polja");
            alert.showAndWait();
        }
    }

    public void postaviPoslovnicu(String naziv) {
        this.cBoxPoslovnaJedinica.setValue(this.cBoxPoslovnaJedinica.getConverter().fromString(naziv));
    }

    private MjernoMjestoFRO dajMjernoMjesto() {
        MjernoMjestoFRO m = new MjernoMjestoFRO();
        m.setNazivMjernogMjesta(this.txtNazivRadneProstorije.getText());
        m.setPoslovnaJedinica(((PoslovneJedinice)this.cBoxPoslovnaJedinica.getValue()).getNazivPoslovnice());
        m.setOdjel((String)this.cBoxOdjel.getValue());
        m.setMjestoAdresa(this.txtMjestoAdresa.getText());
        m.setOznakaLokacije(this.txtAreaOznakaLokacije.getText());
        m.setZatvoren(this.chBoxZatvoreno.isSelected());
        return m;
    }

    public void izmjenaFRO(MjernoMjestoFRO mm) {
        this.izmjenaFRO = true;
        this.bp.set(true);
        this.mm = mm;
        this.txtNazivRadneProstorije.setText(mm.getNazivMjernogMjesta());
        this.postaviPoslovnicu(mm.getPoslovnaJedinica());
        this.cBoxOdjel.setValue((Object)mm.getOdjel());
        this.txtMjestoAdresa.setText(mm.getMjestoAdresa());
        this.txtAreaOznakaLokacije.setText(mm.getOznakaLokacije());
        this.chBoxZatvoreno.setSelected(mm.isZatvoren());
    }
}

