/*
 * Decompiled with CFR 0.152.
 */
package radnaoprema;

import Utill.ComboBoxCellDokument;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import Utill.ScanDokument;
import dokumentiTvrtke.BazaDokumenti;
import dokumentiTvrtke.DokumentHiperlinkCell;
import ispisJasper.IspisReporta;
import ispitivanja.PopisIspitivanjaController;
import java.io.File;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javafx.util.StringConverter;
import kadrovska.BazaDjelatnik;
import kadrovska.Djelatnik;
import kadrovska.UnosDjelatnikaController;
import monitoringnovi.ServiceRestart;
import odjeli.BazaOdjeli;
import poslovnejedinice.PoslovneJedinice;
import radnaoprema.BazaStroj;
import radnaoprema.ComboBoxCellDjelatnici;
import radnaoprema.PopisEvidencijeStrojaController;
import radnaoprema.StrojEvidencija;
import radnaoprema.StrojPregled;
import radnaoprema.StrojZaduzeneOsobe;
import strojevi.Strojevi;
import zastitanaradu.GlavniPanelController;

public class UnosStrojevaController
implements Initializable {
    @FXML
    private Button btnPretragaStroja;
    @FXML
    private TextField txtGodinaProizvodnje;
    @FXML
    private TabPane tabPanePodaci;
    @FXML
    private CheckBox chBoxRazduzen;
    @FXML
    private Tab tabZaduzeneOsobe;
    @FXML
    private Tab tabEvidencijaPregleda;
    @FXML
    private Tab tabDokumenti;
    @FXML
    private Button btnSpremi;
    @FXML
    private TextField txtSifraStroja;
    @FXML
    private TextField txtNazivStroja;
    @FXML
    private ComboBox<PoslovneJedinice> cBoxPoslovnaJedinica;
    @FXML
    private ComboBox<String> cBoxOdjel;
    @FXML
    private ComboBox<String> cboxProizvodjac;
    @FXML
    private ComboBox<String> cboxModel;
    @FXML
    private ComboBox<String> cboxGrupaStroja;
    @FXML
    private ComboBox<String> cBoxVrstaStroja;
    @FXML
    private TextField txtInventurniBroj;
    @FXML
    private TextField txtTvornickiBroj;
    @FXML
    private TextArea txtAreaNapomena;
    @FXML
    private DatePicker dateStavljanjeUPogon;
    @FXML
    private TableView<StrojZaduzeneOsobe> tablicaZaduzeneOsobe;
    @FXML
    private TableColumn<StrojZaduzeneOsobe, String> kolRedBrZO;
    @FXML
    private TableColumn<StrojZaduzeneOsobe, String> kolNaziv;
    @FXML
    private TableColumn<StrojZaduzeneOsobe, String> kolSifra;
    @FXML
    private Button btnUnosZOsobe;
    @FXML
    private Button btnBrisanjeZOsobe;
    @FXML
    private Button btnIspisZOsobe;
    @FXML
    private Button btnUnosPStroja;
    @FXML
    private Button btnBrisanjePStroja;
    @FXML
    private Button btnIspisEK24PStroja;
    @FXML
    private TextField txtOpis;
    @FXML
    private TableView<ScanDokument> tablicaDokumenti;
    @FXML
    private TableColumn<ScanDokument, String> kolNazivDokumenta;
    @FXML
    private TableColumn<ScanDokument, String> kolRedBr;
    @FXML
    private TableView<StrojPregled> tablicaEvidencijaPregleda;
    @FXML
    private TableColumn<StrojPregled, String> kolRedBrPregledStroja;
    @FXML
    private TableColumn<StrojPregled, LocalDate> kolDatumObavljenogIspitivanja;
    @FXML
    private TableColumn<StrojPregled, String> kolOrganizacija;
    @FXML
    private TableColumn<StrojPregled, LocalDate> kolDatumIzdavanja;
    @FXML
    private TableColumn<StrojPregled, String> kolBrojIsprave;
    @FXML
    private TableColumn<StrojPregled, String> kolUvjeti;
    @FXML
    private TableColumn<StrojPregled, LocalDate> kolDatumPonovogIspitivanja;
    @FXML
    private TableColumn<StrojPregled, String> kolDokument;
    @FXML
    private TableColumn<StrojPregled, String> kolPodatkeUpisao;
    @FXML
    private Button btnSpremiDokument;
    @FXML
    private Button btnBrisanjeDokument;
    private static UnosStrojevaController instance;
    private final ObservableList<String> listaVrstaStroja = FXCollections.observableArrayList((Object[])new String[]{"Fiksni", "Mobilni"});
    private ObservableList<ScanDokument> listaDokumenti = FXCollections.observableArrayList();
    private ObservableList<StrojPregled> listaStrojPregled = FXCollections.observableArrayList();
    private ObservableList<StrojZaduzeneOsobe> listaStrojZaduzeneOsobe = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private Boolean izmjenaStroja = false;
    BooleanProperty bp = new SimpleBooleanProperty(false);
    private StrojEvidencija se = null;

    public TabPane getTabPanePodaci() {
        return this.tabPanePodaci;
    }

    public static UnosStrojevaController getInstance() {
        return instance;
    }

    public StrojEvidencija getStrojEvidencija() {
        return this.se;
    }

    public void setStrojEvidencija(StrojEvidencija se) {
        this.se = se;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtOpis);
        this.cBoxVrstaStroja.getItems().addAll(this.listaVrstaStroja);
        this.popuniCBoxPoslovnice();
        this.cBoxPoslovnaJedinica.valueProperty().addListener((o, ov, nv) -> {
            PoslovneJedinice p = nv;
            this.popuniOdjelePoslovneJedinice(p.getId());
        });
        this.cboxProizvodjac.valueProperty().addListener((o, ov, nv) -> this.popuniCBoxModel((String)nv));
        this.popuniCBoxProizvodjac();
        this.popuniCBoxGrupaStrojeva();
        ResizeComponent.makeComboBoxDeleteItem(this.cboxProizvodjac, this.cboxModel, this.cboxGrupaStroja, this.cBoxVrstaStroja);
        this.tabDokumenti.disableProperty().bind((ObservableValue)this.bp.not());
        this.tabEvidencijaPregleda.disableProperty().bind((ObservableValue)this.bp.not());
        this.tabZaduzeneOsobe.disableProperty().bind((ObservableValue)this.bp.not());
        this.urediZablicuZaduzeneOsobe();
        this.popuniTablicuZaduzeneOsobe();
        this.urediTblicuEvidencijaPregleda();
        this.popuniTablicuEvidencijaPregleda();
        this.urediKoloneUTabliciDokumenti();
        this.popuniTablicuDokumenti();
        this.btnBrisanjeDokument.disableProperty().bind((ObservableValue)Bindings.equal((ObservableNumberValue)this.tablicaDokumenti.getSelectionModel().selectedIndexProperty(), (int)-1));
        this.btnBrisanjeDokument.setOnAction(event -> {
            int selectedIdx = this.tablicaDokumenti.getSelectionModel().getSelectedIndex();
            ScanDokument sc = (ScanDokument)this.tablicaDokumenti.getSelectionModel().getSelectedItem();
            Alert alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje Dokumenta", "\u017delite li obrisati dokument ?");
            Optional result = alert.showAndWait();
            if (selectedIdx != -1) {
                if (result.get() == ButtonType.OK) {
                    if (BazaDokumenti.deleteDokument(sc)) {
                        this.popuniTablicuDokumenti();
                    } else {
                        Alert error = FxDialogs.getDialog(Alert.AlertType.ERROR, "Brisanje dokumenta", "Neuspjelo brisanje dokumenta");
                        error.showAndWait();
                    }
                } else {
                    this.tablicaDokumenti.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnSpremiDokument.setOnAction(e -> {
            block6: {
                boolean bopis = FormValidation.textFieldValidationonlyText(this.txtOpis);
                if (bopis) {
                    FileChooser fileChooser = new FileChooser();
                    File selectedFile = fileChooser.showOpenDialog(null);
                    if (selectedFile != null) {
                        try {
                            byte[] byteImage = KlasaKorisneMetode.ImageToByte(new File(selectedFile.getAbsolutePath()));
                            if (BazaDokumenti.addDokumentStroj(this.txtOpis.getText() + " (" + LocalDate.now().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)) + ")." + KlasaKorisneMetode.getExtension(selectedFile), GlavniPanelController.getOdabranaTvrtka(), this.se.getId(), byteImage, GlavniPanelController.getInstance().getKorisnik().punoIme())) {
                                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen dokument", 1, "Information graphic");
                                this.txtOpis.clear();
                                this.popuniTablicuDokumenti();
                                break block6;
                            }
                            KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen dokument", 2, "Error graphic");
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti naziv Dokumenta");
                    alert.showAndWait();
                }
            }
        });
        this.btnUnosPStroja.setOnAction(e -> {
            StrojPregled st = new StrojPregled();
            st.setPodatkeUpisao(GlavniPanelController.getInstance().getKorisnik().punoIme());
            if (BazaStroj.unesiNoviStrojPregled(st, GlavniPanelController.getOdabranaTvrtka().getId(), this.se.getId())) {
                this.popuniTablicuEvidencijaPregleda();
            } else {
                FxDialogs.showError("Gre\u0161ka unosa", "Neuspje\u0161an unos pregleda");
            }
        });
        this.btnBrisanjePStroja.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaEvidencijaPregleda.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati  pregled")).showAndWait()).get() == ButtonType.OK) {
                if (BazaStroj.obrisiStrojPregled((StrojPregled)this.tablicaEvidencijaPregleda.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuEvidencijaPregleda();
                    ServiceRestart.restartService(ServiceRestart.RService.strojevi);
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no brisanje ", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no brisanje", 2, "Error graphic");
                }
            }
        });
        this.btnUnosZOsobe.setOnAction(e -> {
            StrojZaduzeneOsobe zo = new StrojZaduzeneOsobe();
            if (BazaStroj.unesiNovuZaduzenuOsobu(zo, GlavniPanelController.getOdabranaTvrtka().getId(), this.se.getId())) {
                this.popuniTablicuZaduzeneOsobe();
            } else {
                FxDialogs.showError("Gre\u0161ka unosa", "Neuspje\u0161an unos osobe");
            }
        });
        this.btnBrisanjeZOsobe.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaZaduzeneOsobe.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati djelatnika")).showAndWait()).get() == ButtonType.OK) {
                if (BazaStroj.obrisiZaduzenuOsobu((StrojZaduzeneOsobe)this.tablicaZaduzeneOsobe.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuZaduzeneOsobe();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no brisanje ", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no brisanje", 2, "Error graphic");
                }
            }
        });
        this.btnSpremi.setOnAction(e -> this.spremiStroj());
        this.btnIspisEK24PStroja.setOnAction(e -> {
            String sql = "Select * from ek4 where id='" + this.se.getId() + "'and tvrtka_id='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
            IspisReporta.ispisButtonSaSubreportom(sql, this.btnIspisEK24PStroja, "Ek-4.jrxml");
        });
        this.btnPretragaStroja.setOnAction(e -> {
            Strojevi st = FxDialogs.getDialogNazivStrojeva();
            if (st != null) {
                this.txtNazivStroja.setText(st.getNaziv());
                this.txtSifraStroja.setText(st.getOznaka());
            }
        });
    }

    private void urediTblicuEvidencijaPregleda() {
        this.tablicaEvidencijaPregleda.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE && UnosStrojevaController.this.tablicaEvidencijaPregleda.getEditingCell() == null) {
                    UnosStrojevaController.this.tablicaEvidencijaPregleda.getSelectionModel().clearSelection();
                    e.consume();
                }
            }
        });
        this.kolRedBrPregledStroja.setCellValueFactory(cellData -> ((StrojPregled)cellData.getValue()).redBrojProperty());
        this.kolRedBrPregledStroja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(20.0));
        this.kolRedBrPregledStroja.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory = param -> new DateCell();
        Label l1 = new Label("Datum \n obavljenog \n ispitivanja");
        this.kolDatumObavljenogIspitivanja.setGraphic((Node)l1);
        this.kolDatumObavljenogIspitivanja.setCellValueFactory(cellData -> ((StrojPregled)cellData.getValue()).datumObavljenogIspitivanjaProperty());
        this.kolDatumObavljenogIspitivanja.setCellFactory(dateCellFactory);
        this.kolDatumObavljenogIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolDatumObavljenogIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumObavljenogIspitivanja.setOnEditCommit(t -> {
            ((StrojPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumObavljenogIspitivanja((LocalDate)t.getNewValue());
            BazaStroj.unesiPromjenuStrojPregled((StrojPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Label l2 = new Label("Naziv \n organizacije koja \n je obavila \n ispitivanje");
        this.kolOrganizacija.setGraphic((Node)l2);
        this.kolOrganizacija.setCellValueFactory(cellData -> ((StrojPregled)cellData.getValue()).nazivOrganizacijeIspitivanjaProperty());
        this.kolOrganizacija.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolOrganizacija.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(5.0));
        this.kolOrganizacija.setStyle("-fx-alignment: CENTER;");
        this.kolOrganizacija.setOnEditCommit(t -> {
            ((StrojPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivOrganizacijeIspitivanja((String)t.getNewValue());
            BazaStroj.unesiPromjenuStrojPregled((StrojPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Label l3 = new Label("Broj isprave \n ispitivanja");
        this.kolBrojIsprave.setGraphic((Node)l3);
        this.kolBrojIsprave.setCellValueFactory(cellData -> ((StrojPregled)cellData.getValue()).brojIspraveProperty());
        this.kolBrojIsprave.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolBrojIsprave.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(12.5));
        this.kolBrojIsprave.setStyle("-fx-alignment: CENTER;");
        this.kolBrojIsprave.setOnEditCommit(t -> {
            ((StrojPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setBrojIsprave((String)t.getNewValue());
            BazaStroj.unesiPromjenuStrojPregled((StrojPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Label l3a = new Label("Datum \n izdavanja isprave \n o ispitivanju");
        this.kolDatumIzdavanja.setGraphic((Node)l3a);
        this.kolDatumIzdavanja.setCellValueFactory(cellData -> ((StrojPregled)cellData.getValue()).datumIzdavanjaIspraveProperty());
        this.kolDatumIzdavanja.setCellFactory(dateCellFactory);
        this.kolDatumIzdavanja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolDatumIzdavanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumIzdavanja.setOnEditCommit(t -> {
            ((StrojPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumIzdavanjaIsprave((LocalDate)t.getNewValue());
            BazaStroj.unesiPromjenuStrojPregled((StrojPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        ObservableList listaDaNe = FXCollections.observableArrayList((Object[])new String[]{"Da", "Ne"});
        Label l4 = new Label("Da li stroj i \n ure\u0111aj ispunjava \n propisane uvjete \n za upotrebu");
        this.kolUvjeti.setGraphic((Node)l4);
        this.kolUvjeti.setCellValueFactory(cellData -> ((StrojPregled)cellData.getValue()).ispunjavaUvjeteProperty());
        this.kolUvjeti.setCellFactory(t -> {
            ComboBoxTableCell myComboBoxTableCell = new ComboBoxTableCell(listaDaNe);
            myComboBoxTableCell.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.DELETE) {
                    myComboBoxTableCell.commitEdit(null);
                }
                if (e.getCode() == KeyCode.ESCAPE) {
                    myComboBoxTableCell.cancelEdit();
                }
            });
            return myComboBoxTableCell;
        });
        this.kolUvjeti.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolUvjeti.setStyle("-fx-alignment: CENTER;");
        this.kolUvjeti.setOnEditCommit(t -> {
            ((StrojPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setIspunjavaUvjete((String)t.getNewValue());
            BazaStroj.unesiPromjenuStrojPregled((StrojPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Label l5 = new Label("Datum \n ponovog \n ispitivanja");
        this.kolDatumPonovogIspitivanja.setGraphic((Node)l5);
        this.kolDatumPonovogIspitivanja.setCellValueFactory(cellData -> ((StrojPregled)cellData.getValue()).datumPonovogIspitivanjaProperty());
        this.kolDatumPonovogIspitivanja.setCellFactory(dateCellFactory);
        this.kolDatumPonovogIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolDatumPonovogIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumPonovogIspitivanja.setOnEditCommit(t -> {
            ((StrojPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumPonovogIspitivanja((LocalDate)t.getNewValue());
            BazaStroj.unesiPromjenuStrojPregled((StrojPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
            ServiceRestart.restartService(ServiceRestart.RService.strojevi);
        });
        Callback cellDokument = param -> new ComboBoxCellDokument(this.listaDokumenti);
        Label l6 = new Label("Dokument");
        this.kolDokument.setGraphic((Node)l6);
        this.kolDokument.setCellValueFactory(cellData -> ((StrojPregled)cellData.getValue()).nazivDokumentaProperty());
        this.kolDokument.setCellFactory(cellDokument);
        this.kolDokument.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(6.666666666666667));
        this.kolDokument.setStyle("-fx-alignment: CENTER;");
        this.kolDokument.setOnEditCommit(t -> {
            ((StrojPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivDokumenta((String)t.getNewValue());
            BazaStroj.unesiPromjenuStrojPregled((StrojPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Label l7 = new Label("Prezime i ime \n radnika koji je \n upisao podatke u \n evidenciju");
        this.kolPodatkeUpisao.setGraphic((Node)l7);
        this.kolPodatkeUpisao.setCellValueFactory(cellData -> ((StrojPregled)cellData.getValue()).podatkeUpisaoProperty());
        this.kolPodatkeUpisao.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(6.666666666666667));
        this.kolPodatkeUpisao.setStyle("-fx-alignment: CENTER;");
    }

    private void urediKoloneUTabliciDokumenti() {
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaDokumenti.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolNazivDokumenta.setCellValueFactory((Callback)new PropertyValueFactory("opisDokumenta"));
        this.kolNazivDokumenta.prefWidthProperty().bind((ObservableValue)this.tablicaDokumenti.widthProperty().divide(1.1235955056179776));
        this.kolNazivDokumenta.setStyle("-fx-alignment: CENTER;");
        Callback cellScanDokument = param -> new DokumentHiperlinkCell(this.listaDokumenti);
        this.kolNazivDokumenta.setCellFactory(cellScanDokument);
    }

    private void popuniTablicuDokumenti() {
        this.tablicaDokumenti.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Random rng = new Random();
        Task task = this.createTaskDokumenti();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaDokumenti.clear();
        this.tablicaDokumenti.getItems().clear();
    }

    private Task createTaskDokumenti() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisIspitivanjaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    UnosStrojevaController.this.popuniTablicuDokumentiizBaze();
                }
                finally {
                    Platform.runLater(() -> UnosStrojevaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void popuniTablicuDokumentiizBaze() {
        int br = 1;
        ResultSet rs = BazaDokumenti.getDokumentiStroj(GlavniPanelController.getOdabranaTvrtka().getId(), this.se.getId());
        try {
            while (rs.next()) {
                ScanDokument cd = new ScanDokument();
                cd.setId(rs.getInt("id"));
                cd.setRedBroj(String.valueOf(br));
                cd.setOpisDokumenta(rs.getString("naziv"));
                this.listaDokumenti.add((Object)cd);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.tablicaDokumenti.getItems().addAll(this.listaDokumenti);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniOdjelePoslovneJedinice(int idPoslovneJedinice) {
        this.cBoxOdjel.getItems().clear();
        ResultSet rs = BazaOdjeli.dajOdjel(GlavniPanelController.getOdabranaTvrtka(), idPoslovneJedinice);
        try {
            while (rs.next()) {
                this.cBoxOdjel.getItems().add((Object)rs.getString("nazivodjela"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void postaviPoslovnicu(String naziv) {
        this.cBoxPoslovnaJedinica.setValue(this.cBoxPoslovnaJedinica.getConverter().fromString(naziv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniCBoxPoslovnice() {
        final ObservableMap map = FXCollections.observableHashMap();
        ResultSet rs = BazaDjelatnik.dajPoslovnujednicu(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                PoslovneJedinice pj = new PoslovneJedinice();
                pj.setId(rs.getInt("id"));
                pj.setNazivPoslovnice(rs.getString("nazivposlovnice"));
                pj.setAdresaPoslovnice(rs.getString("adresa"));
                pj.setMjesto(rs.getString("mjesto"));
                map.put((Object)rs.getString("nazivposlovnice"), (Object)pj);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cBoxPoslovnaJedinica.getItems().addAll(map.values());
        this.cBoxPoslovnaJedinica.setConverter((StringConverter)new StringConverter<PoslovneJedinice>(){

            public String toString(PoslovneJedinice t) {
                if (t != null) {
                    String str = t.getNazivPoslovnice();
                    map.put((Object)str, (Object)t);
                    return str;
                }
                return "";
            }

            public PoslovneJedinice fromString(String string) {
                if (!map.containsKey((Object)string)) {
                    UnosStrojevaController.this.cBoxPoslovnaJedinica.setValue(null);
                    UnosStrojevaController.this.cBoxPoslovnaJedinica.getEditor().clear();
                    return null;
                }
                return (PoslovneJedinice)map.get((Object)string);
            }
        });
        this.cBoxPoslovnaJedinica.setCellFactory((Callback)new Callback<ListView<PoslovneJedinice>, ListCell<PoslovneJedinice>>(){

            public ListCell<PoslovneJedinice> call(ListView<PoslovneJedinice> p) {
                ListCell<PoslovneJedinice> cell = new ListCell<PoslovneJedinice>(){

                    protected void updateItem(PoslovneJedinice item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setText("");
                        } else {
                            this.setText(item.getNazivPoslovnice());
                            this.setAlignment(Pos.CENTER);
                            this.setPadding(new Insets(3.0, 3.0, 3.0, 0.0));
                        }
                    }
                };
                return cell;
            }
        });
    }

    private void popuniCBoxProizvodjac() {
        ResultSet rs = BazaStroj.dajProizvodjace(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                this.cboxProizvodjac.getItems().add((Object)rs.getString("nazivproizvodjaca"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniCBoxModel(String proizvodjac) {
        this.cboxModel.getItems().clear();
        ResultSet rs = BazaStroj.dajProizvodjace(GlavniPanelController.getOdabranaTvrtka(), proizvodjac);
        try {
            while (rs.next()) {
                this.cboxModel.getItems().add((Object)rs.getString("tip"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void popuniCBoxGrupaStrojeva() {
        ResultSet rs = BazaStroj.dajGrupeStrojeva(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                this.cboxGrupaStroja.getItems().add((Object)rs.getString("naziv"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void popuniTablicuEvidencijaPregleda() {
        this.tablicaEvidencijaPregleda.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskStrojPregled();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaStrojPregled.clear();
        this.tablicaEvidencijaPregleda.getItems().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuPodatkeEvidencijaPregleda() {
        ResultSet rs = BazaStroj.dajStrojPreglede(GlavniPanelController.getOdabranaTvrtka().getId(), this.se.getId());
        StrojPregled st = null;
        int br = 1;
        try {
            while (rs.next()) {
                st = new StrojPregled();
                st.setId(rs.getInt("id"));
                st.setRedBroj(String.valueOf(br));
                st.setDatumObavljenogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumobavljenogispitivanja")));
                st.setNazivOrganizacijeIspitivanja(rs.getString("nazivorganizacije"));
                st.setBrojIsprave(rs.getString("brojispitivanja"));
                st.setDatumIzdavanjaIsprave(DateUtil.getLocalDate(rs.getDate("datumispitivanja")));
                st.setIspunjavaUvjete(rs.getString("ispunjavauvjete"));
                st.setDatumPonovogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumponovogpregleda")));
                st.setNazivDokumenta(rs.getString("dokument"));
                st.setPodatkeUpisao(rs.getString("podatkeupisao"));
                this.listaStrojPregled.add((Object)st);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaEvidencijaPregleda.setItems(this.listaStrojPregled);
    }

    private Task createTaskStrojPregled() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisIspitivanjaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    UnosStrojevaController.this.popuniTablicuPodatkeEvidencijaPregleda();
                }
                finally {
                    Platform.runLater(() -> UnosStrojevaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void urediZablicuZaduzeneOsobe() {
        this.kolRedBrZO.setCellValueFactory(cellData -> ((StrojZaduzeneOsobe)cellData.getValue()).redBrojProperty());
        this.kolRedBrZO.prefWidthProperty().bind((ObservableValue)this.tablicaZaduzeneOsobe.widthProperty().divide(10.0));
        this.kolRedBrZO.setStyle("-fx-alignment: CENTER;");
        ObservableList listaDjelatnika = FXCollections.observableArrayList();
        ObservableList listaSifraOsobe = FXCollections.observableArrayList();
        ObservableList listaNazivOsobe = FXCollections.observableArrayList();
        ResultSet rs = BazaDjelatnik.dajDjelatnike(GlavniPanelController.getOdabranaTvrtka(), BazaDjelatnik.Opcije.zaposlene_djelatnike);
        try {
            while (rs.next()) {
                Djelatnik d = new Djelatnik();
                d.setId(rs.getInt("id"));
                d.setSifraDjelatnika(rs.getString("sifradjelatnika"));
                d.setIme(rs.getString("ime"));
                d.setPrezime(rs.getString("prezime"));
                listaDjelatnika.add((Object)d);
                listaSifraOsobe.add((Object)rs.getString("sifradjelatnika"));
                listaNazivOsobe.add((Object)(rs.getString("ime") + " " + rs.getString("prezime")));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Callback comboCellFactoryPrezime = param -> new ComboBoxCellDjelatnici((ObservableList<Djelatnik>)listaDjelatnika, "prezime");
        Callback comboCellFactorySifra = param -> new ComboBoxCellDjelatnici((ObservableList<Djelatnik>)listaDjelatnika, "sifra");
        this.kolSifra.setCellValueFactory(cellData -> ((StrojZaduzeneOsobe)cellData.getValue()).sifraOsobeProperty());
        this.kolSifra.prefWidthProperty().bind((ObservableValue)this.tablicaZaduzeneOsobe.widthProperty().divide(5.0));
        this.kolSifra.setStyle("-fx-alignment: CENTER;");
        this.kolSifra.setCellFactory(comboCellFactorySifra);
        this.kolSifra.setOnEditCommit(t -> ((StrojZaduzeneOsobe)t.getTableView().getItems().get(t.getTablePosition().getRow())).setSifraOsobe((String)t.getNewValue()));
        this.kolNaziv.setCellValueFactory(cellData -> ((StrojZaduzeneOsobe)cellData.getValue()).nazivOsobeProperty());
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaZaduzeneOsobe.widthProperty().divide(1.4285714285714286));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellFactory(comboCellFactoryPrezime);
        this.kolNaziv.setOnEditCommit(t -> ((StrojZaduzeneOsobe)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivOsobe((String)t.getNewValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuZaduzeneOsobePodaci() {
        ResultSet rs = BazaStroj.dajStrojZaduzeneOsobe(GlavniPanelController.getOdabranaTvrtka().getId(), this.se.getId());
        StrojZaduzeneOsobe zo = null;
        int br = 1;
        try {
            while (rs.next()) {
                zo = new StrojZaduzeneOsobe();
                zo.setId(rs.getInt("id"));
                zo.setRedBroj(String.valueOf(br));
                zo.setNazivOsobe(rs.getString("nazivosobe"));
                zo.setSifraOsobe(rs.getString("sifraosobe"));
                this.listaStrojZaduzeneOsobe.add((Object)zo);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaZaduzeneOsobe.setItems(this.listaStrojZaduzeneOsobe);
    }

    private void popuniTablicuZaduzeneOsobe() {
        this.tablicaZaduzeneOsobe.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskStrojZO();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaStrojZaduzeneOsobe.clear();
        this.tablicaZaduzeneOsobe.getItems().clear();
    }

    private Task createTaskStrojZO() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisIspitivanjaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    UnosStrojevaController.this.popuniTablicuZaduzeneOsobePodaci();
                }
                finally {
                    Platform.runLater(() -> UnosStrojevaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void spremiStroj() {
        boolean bSifraStroja = FormValidation.textFieldValidationonlyText(this.txtSifraStroja);
        boolean bNazivStroja = FormValidation.textFieldValidationonlyText(this.txtNazivStroja);
        boolean bPoslovnica = FormValidation.comboBoxValidationText(this.cBoxPoslovnaJedinica);
        boolean bOdjel = FormValidation.comboBoxValidationText(this.cBoxOdjel);
        boolean bGrupaStroja = FormValidation.comboBoxValidationText(this.cboxGrupaStroja);
        if (bSifraStroja & bNazivStroja & bGrupaStroja & bPoslovnica & bOdjel) {
            if (this.izmjenaStroja.booleanValue()) {
                if (BazaStroj.izmjenaStroja(GlavniPanelController.getOdabranaTvrtka(), this.dajStroj(), this.se.getId())) {
                    if (!GlavniPanelController.getInstance().getTabByIdifExist("Pregled strojeva")) {
                        PopisEvidencijeStrojaController.getInstance().popuniTablicuPopisStrojeva();
                    }
                    GlavniPanelController.getInstance().zatvoriTab("Unos Stroja");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena stroja", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena stroja", 2, "Error graphic");
                }
            } else if (BazaStroj.unesiNoviStroj(GlavniPanelController.getOdabranaTvrtka(), this.dajStroj())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen stroja", 1, "Information graphic");
                PopisEvidencijeStrojaController.getInstance().popuniTablicuPopisStrojeva();
                GlavniPanelController.getInstance().zatvoriTab("Unos Stroja");
                this.izmjenaStroja = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen stroja", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti sva oznacena polja");
            alert.showAndWait();
        }
    }

    private StrojEvidencija dajStroj() {
        StrojEvidencija se = new StrojEvidencija();
        se.setSifrastroja(this.txtSifraStroja.getText());
        se.setNazivstroja(this.txtNazivStroja.getText());
        se.setPoslovnajedinica(((PoslovneJedinice)this.cBoxPoslovnaJedinica.getValue()).getNazivPoslovnice());
        se.setOdjel((String)this.cBoxOdjel.getValue());
        se.setProizvodjac((String)this.cboxProizvodjac.getValue());
        se.setModel((String)this.cboxModel.getValue());
        se.setInventurnibroj(this.txtInventurniBroj.getText());
        se.setTvornickibroj(this.txtTvornickiBroj.getText());
        se.setGodinaProizvodnje(this.txtGodinaProizvodnje.getText());
        se.setDatumStavljanjauPogon((LocalDate)this.dateStavljanjeUPogon.getValue());
        se.setGrupaStroja((String)this.cboxGrupaStroja.getValue());
        se.setVrstaStroja((String)this.cBoxVrstaStroja.getValue());
        se.setNapomena(this.txtAreaNapomena.getText());
        se.setRashodovan(this.chBoxRazduzen.isSelected());
        return se;
    }

    public void izmjenaStroja(StrojEvidencija se) {
        this.izmjenaStroja = true;
        this.bp.set(true);
        this.se = se;
        this.txtSifraStroja.setText(se.getSifrastroja());
        this.txtNazivStroja.setText(se.getNazivstroja());
        this.postaviPoslovnicu(se.getPoslovnajedinica());
        this.cBoxOdjel.setValue((Object)se.getOdjel());
        this.cboxProizvodjac.setValue((Object)se.getProizvodjac());
        this.cboxModel.setValue((Object)se.getModel());
        this.txtInventurniBroj.setText(se.getInventurnibroj());
        this.txtTvornickiBroj.setText(se.getTvornickibroj());
        this.txtGodinaProizvodnje.setText(se.getGodinaProizvodnje());
        this.dateStavljanjeUPogon.setValue((Object)se.getDatumStavljanjauPogon());
        this.cboxGrupaStroja.setValue((Object)se.getGrupaStroja());
        this.cBoxVrstaStroja.setValue((Object)se.getVrstaStroja());
        this.txtAreaNapomena.setText(se.getNapomena());
        this.chBoxRazduzen.setSelected(se.isRashodovan());
    }
}

