/*
 * Decompiled with CFR 0.152.
 */
package radnaoprema;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import radnaoprema.StrojPregled;

public class DateCellPregledStroja
extends TableCell<StrojPregled, LocalDate> {
    private DatePicker datePicker;
    int prvoUpozorenje;
    int drugoUpozorenje;
    boolean bPregled = false;

    DateCellPregledStroja() {
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createDatePicker();
            this.setText(null);
            this.setGraphic((Node)this.datePicker);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        if (this.bPregled) {
            this.setText("");
        } else {
            this.setText(this.getDate().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
        }
        this.setGraphic(null);
    }

    public void updateItem(LocalDate item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
            this.setStyle(null);
            this.setTooltip(null);
        } else if (item == null) {
            this.setText("---");
            this.bPregled = true;
            this.setStyle(null);
            this.setTooltip(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.datePicker != null) {
                this.datePicker.setValue((Object)this.getDate());
            }
            this.setText(null);
            this.setGraphic((Node)this.datePicker);
        } else {
            this.setText(null);
            this.izracunaj();
            this.setGraphic(null);
        }
    }

    private void createDatePicker() {
        this.datePicker = new DatePicker((LocalDate)this.getItem());
        this.datePicker.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.datePicker.setOnAction(e -> {
            this.bPregled = false;
            this.commitEdit(this.datePicker.getValue());
            this.izracunaj();
        });
        this.datePicker.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.datePicker.setValue(this.datePicker.getConverter().fromString(this.datePicker.getEditor().getText()));
                this.commitEdit(this.datePicker.getValue());
                this.setStyle(null);
                this.setTooltip(null);
            }
            if (event.getCode() == KeyCode.ESCAPE) {
                this.bPregled = false;
                this.cancelEdit();
            }
        });
    }

    private void izracunaj() {
        this.setText(this.getDate().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
        this.setGraphic(null);
    }

    private LocalDate getDate() {
        return this.getItem() == null ? LocalDate.now() : (LocalDate)this.getItem();
    }
}

