/*
 * Decompiled with CFR 0.152.
 */
package radnamjesta;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.UtillBaza;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import radnamjesta.BazaRadnaMjesta;
import radnamjesta.RadnoMjesto;
import radnamjesta.UnosRadnogMjestaController;
import zastitanaradu.GlavniPanelController;

public class PregledRadnihMjestaController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<RadnoMjesto> tablicaPopisRadnihMjesta;
    @FXML
    private TableColumn<RadnoMjesto, String> kolPretraga;
    @FXML
    private TableColumn<RadnoMjesto, String> kolRedBr;
    @FXML
    private TableColumn<RadnoMjesto, String> kolNaziv;
    @FXML
    private TableColumn<RadnoMjesto, String> kolPur;
    @FXML
    private TableColumn<RadnoMjesto, String> kolPRAC;
    private static PregledRadnihMjestaController instance;
    private final ObservableList<RadnoMjesto> listaRadnihMjesta = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PregledRadnihMjestaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciPopisRadnihMjesta();
        this.popuniTablicuRadnihMjesta();
        this.urediFilter(this.tablicaPopisRadnihMjesta);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos radnog mjesta")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos radnog mjesta");
                GlavniPanelController.getInstance().nadodajPanel("Unos radnog mjesta", "/radnamjesta/UnosRadnogMjesta.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos radnog mjesta", "/radnamjesta/UnosRadnogMjesta.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            RadnoMjesto rm;
            int selectdIndex = this.tablicaPopisRadnihMjesta.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (rm = (RadnoMjesto)this.tablicaPopisRadnihMjesta.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos radnog mjesta")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos radnog mjesta");
                    GlavniPanelController.getInstance().nadodajPanel("Unos radnog mjesta", "/radnamjesta/UnosRadnogMjesta.fxml");
                    UnosRadnogMjestaController.getInstance().izmjenaRadnogMjesta(rm);
                    this.tablicaPopisRadnihMjesta.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos radnog mjesta", "/radnamjesta/UnosRadnogMjesta.fxml");
                    UnosRadnogMjestaController.getInstance().izmjenaRadnogMjesta(rm);
                    this.tablicaPopisRadnihMjesta.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisRadnihMjesta.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "Ako \u017eelite obrisati radno mjesto potrebno je prebaciti radnike na drugo radno mjesto\n\u017delite li obrisati radno mjesto ?")).showAndWait()).get() == ButtonType.OK) {
                RadnoMjesto r = null;
                if (UtillBaza.provjera((RadnoMjesto)this.tablicaPopisRadnihMjesta.getSelectionModel().getSelectedItem())) {
                    r = FxDialogs.getRadnoMjestoDijalog();
                }
                if (r != null && !BazaRadnaMjesta.promjeniRadnoMjestoRadnicima(r, GlavniPanelController.getOdabranaTvrtka(), ((RadnoMjesto)this.tablicaPopisRadnihMjesta.getSelectionModel().getSelectedItem()).getId())) {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no promjena radno mjesto", 2, "Error graphic");
                }
                if (!UtillBaza.provjera((RadnoMjesto)this.tablicaPopisRadnihMjesta.getSelectionModel().getSelectedItem())) {
                    if (BazaRadnaMjesta.obrisiRadnoMjesto((RadnoMjesto)this.tablicaPopisRadnihMjesta.getSelectionModel().getSelectedItem())) {
                        this.popuniTablicuRadnihMjesta();
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisano radno mjesto", 1, "Information graphic");
                    } else {
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisano radno mjesto", 2, "Error graphic");
                    }
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Podatke koje poku\u0161avate obrisati su povezani sa drugim podacima te ih nije mogu\u0107e obrisati", 3, "Information graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Naziv"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaRadnihMjesta, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") && pregled.getNaziv() != null && pregled.getNaziv().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciPopisRadnihMjesta() {
        this.tablicaPopisRadnihMjesta.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PregledRadnihMjestaController.this.tablicaPopisRadnihMjesta.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisRadnihMjesta.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolPur.setCellValueFactory((Callback)new PropertyValueFactory("pur"));
        this.kolPur.prefWidthProperty().bind((ObservableValue)this.tablicaPopisRadnihMjesta.widthProperty().divide(10.0));
        this.kolPur.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory((Callback)new PropertyValueFactory("naziv"));
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisRadnihMjesta.widthProperty().divide(1.4705882352941178));
        this.kolPRAC.setCellValueFactory(cell -> ((RadnoMjesto)cell.getValue()).pRacunaloProperty());
        this.kolPRAC.prefWidthProperty().bind((ObservableValue)this.tablicaPopisRadnihMjesta.widthProperty().divide(10.0));
        this.kolPRAC.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    public void popuniTablicuRadnihMjesta() {
        this.tablicaPopisRadnihMjesta.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task<Void> task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaRadnihMjesta.clear();
        this.tablicaPopisRadnihMjesta.getItems().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaRadnaMjesta.dajRadnaMjesta(GlavniPanelController.getOdabranaTvrtka());
        RadnoMjesto rm = null;
        int br = 1;
        try {
            while (rs.next()) {
                rm = new RadnoMjesto();
                rm.setId(rs.getInt("id"));
                rm.setRedBroj(String.valueOf(br));
                rm.setPur(rs.getString("pur"));
                rm.setNaziv(rs.getString("naziv"));
                rm.setOpasnostiRM(rs.getString("opasnosti"));
                rm.setClanak(rs.getString("clanak"));
                rm.setTockePregleda(rs.getString("tockepregleda"));
                rm.setpRacunalo(rs.getString("pracunalo"));
                rm.setGasenjePozara(rs.getString("gasenjepozara"));
                rm.setPrvaPomoc(rs.getString("prvapomoc"));
                rm.setNaznakaSadrzaja(rs.getString("naznakasadrzaja"));
                rm.setDobZivota(rs.getString("dobzivota"));
                rm.setSpol(rs.getString("spol"));
                rm.setStrucnaSprema(rs.getString("strucnasprema"));
                rm.setZdrastvenoStanje(rs.getString("zdrastvenostanje"));
                rm.setPsihoSposobnost(rs.getString("psihosposobnost"));
                rm.setOpisPosla(rs.getString("opisposla"));
                rm.setStrojevi(rs.getString("strojevi"));
                rm.setPredmeti(rs.getString("predmeti"));
                rm.setMRuZatvorenom(rs.getBoolean("mruzatvorenom"));
                rm.setMRnaOtvorenom(rs.getBoolean("mrnaotvorenom"));
                rm.setMRnaVisini(rs.getBoolean("mrnavisini"));
                rm.setMRuJami(rs.getBoolean("mrujami"));
                rm.setMRuVodi(rs.getBoolean("mruvodi"));
                rm.setMRpodVodom(rs.getBoolean("mrpodvodom"));
                rm.setMRuMokrom(rs.getBoolean("mrumokrom"));
                rm.setORuSmjenama(rs.getBoolean("orusmjenama"));
                rm.setORnocniRad(rs.getBoolean("ornocnorad"));
                rm.setORterenskiRad(rs.getBoolean("orterenskirad"));
                rm.setORradiSam(rs.getBoolean("orradisam"));
                rm.setORradUGrupama(rs.getBoolean("orradugrupama"));
                rm.setORradSaStrankama(rs.getBoolean("orradsastrankama"));
                rm.setORradNaTraci(rs.getBoolean("orradnatraci"));
                rm.setORbrziTempoRada(rs.getBoolean("orbrzitemporada"));
                rm.setORritamOdredjen(rs.getBoolean("orritamodredjen"));
                rm.setORmonotonija(rs.getBoolean("ormonotomija"));
                rm.setPTradStojeci(rs.getBoolean("ptradstojeci"));
                rm.setPTradSjedeci(rs.getBoolean("ptradsjedeci"));
                rm.setPTradUPokretu(rs.getBoolean("ptradupokretu"));
                rm.setPTKombinirano(rs.getBoolean("ptkombinirano"));
                rm.setPTdizanjeTereta(rs.getBoolean("ptdizanjetereta"));
                rm.setPTDizanjeTeretaKg(rs.getString("ptdizanjeteretakg"));
                rm.setPTUcestaloSagibanje(rs.getBoolean("ptucestalosagibanje"));
                rm.setPTzakretanjeTrupa(rs.getBoolean("ptzakretanjetrupa"));
                rm.setPTklecanje(rs.getBoolean("ptklecanje"));
                rm.setPTcucanje(rs.getBoolean("ptcucanje"));
                rm.setPTprenosTereta(rs.getBoolean("ptprenostereta"));
                rm.setPTprenosTeretaKg(rs.getString("ptprenosteretakg"));
                rm.setPTpodvlacenje(rs.getBoolean("ptpodvlacenje"));
                rm.setPTbalansiranje(rs.getBoolean("ptbalansiranje"));
                rm.setPTuspinjanjeLjestvama(rs.getBoolean("ptuspinjanjeljestvama"));
                rm.setPTuspinjanjeStepenicama(rs.getBoolean("ptuspinjanjestepenicama"));
                rm.setPTguranjeTereta(rs.getBoolean("ptguranjetereta"));
                rm.setPTguranjeTeretaKg(rs.getString("ptguranjeteretakg"));
                rm.setVidNaDaljinu(rs.getBoolean("vidnadaljinu"));
                rm.setVidNaBlizinu(rs.getBoolean("vidnablizinu"));
                rm.setRaspoznavanjeBoja(rs.getBoolean("raspoznavanjeboja"));
                rm.setDobarSluh(rs.getBoolean("dobarsluh"));
                rm.setJasanGovor(rs.getBoolean("jasangovor"));
                rm.setVisokaTemperatura(rs.getBoolean("visokatemperatura"));
                rm.setVisokaVlaznost(rs.getBoolean("visokavlaznost"));
                rm.setNiskaTemperatura(rs.getBoolean("niskatemperatura"));
                rm.setBuka(rs.getBoolean("buka"));
                rm.setVibracijeStroja(rs.getBoolean("vibracijastroja"));
                rm.setVibracijePoda(rs.getBoolean("vibracijapoda"));
                rm.setPovisenATTlak(rs.getBoolean("povisenattlak"));
                rm.setPovecanaIzloOzljedama(rs.getBoolean("povecanaizlozenostozljedama"));
                rm.setIonizaciskoZracenje(rs.getBoolean("ionizaciskozracenje"));
                rm.setNeionizaciskoZracenje(rs.getBoolean("neionizaciskozracenje"));
                rm.setPrasina(rs.getBoolean("prasina"));
                rm.setKemiskeTvari(rs.getString("kemisketveri"));
                rm.setBioloskeStetnosti(rs.getString("bioloskestetnosti"));
                this.listaRadnihMjesta.add((Object)rm);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PregledRadnihMjestaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PregledRadnihMjestaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisRadnihMjesta.getItems().addAll(this.listaRadnihMjesta);
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PregledRadnihMjestaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PregledRadnihMjestaController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PregledRadnihMjestaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }
}

