/*
 * Decompiled with CFR 0.152.
 */
package poslovnejedinice;

import Utill.FormValidation;
import Utill.FxUtil;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import Utill.UtillBaza;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import poslovnejedinice.BazaPoslovneJedinice;
import poslovnejedinice.PoslovneJedinice;
import poslovnejedinice.PregledPoslovnihJedinicaController;
import zastitanaradu.GlavniPanelController;

public class UnosPoslovniceController
implements Initializable {
    @FXML
    private Button btnSpremi;
    @FXML
    private AnchorPane anchorPanelPoslovnica;
    @FXML
    private GridPane paneBorder;
    @FXML
    private ComboBox<String> cboxMjesto;
    @FXML
    private TextField txtNazivPoslovnice;
    @FXML
    private TextField txtAdresa;
    @FXML
    private TextField txtNazivPoslovodje;
    @FXML
    private TextField txtTelefon;
    @FXML
    private TextField txtFax;
    @FXML
    private TextField txtEmail;
    @FXML
    private ComboBox<String> cboxZupanija;
    @FXML
    private ComboBox<String> cboxDrzava;
    @FXML
    private TextField txtNazivTvrtke;
    @FXML
    private ComboBox<String> cboxOpcina;
    @FXML
    private TextField txtOznakaPoslovnice;
    @FXML
    private TextField txtIBAN;
    @FXML
    private TextField txtBankaIban;
    private static UnosPoslovniceController instance;
    private boolean izmjenaPoslovnice = false;
    PoslovneJedinice poslovnajedJediniceizmjena;

    public static UnosPoslovniceController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtNazivPoslovnice, this.txtOznakaPoslovnice);
        this.popuniComboBoxove();
        this.cboxZupanija.setOnAction(event -> this.popuniMjestaZaOdabranuZupaniju((String)this.cboxZupanija.getValue()));
        this.btnSpremi.setOnAction(e -> this.unosPoslovnice());
    }

    private void popuniComboBoxove() {
        this.txtNazivTvrtke.setText(GlavniPanelController.getInstance().getTvrtka().getNazivTvrtka());
        this.popuniCboxDrzave();
        this.popuniCboxMjesta();
        this.popuniCboxZupanije();
        this.popuniCboxOpcine();
        FxUtil.autoCompleteComboBox(this.cboxMjesto, FxUtil.AutoCompleteMode.STARTS_WITH);
        FxUtil.autoCompleteComboBox(this.cboxZupanija, FxUtil.AutoCompleteMode.STARTS_WITH);
        FxUtil.autoCompleteComboBox(this.cboxDrzava, FxUtil.AutoCompleteMode.STARTS_WITH);
        FxUtil.autoCompleteComboBox(this.cboxOpcina, FxUtil.AutoCompleteMode.STARTS_WITH);
        this.cboxMjesto.getItems().add((Object)"Sva mjesta");
        this.cboxMjesto.getSelectionModel().select((Object)"Sva mjesta");
        this.cboxOpcina.getItems().add((Object)"Sva mjesta");
        this.cboxOpcina.getSelectionModel().select((Object)"Sva mjesta");
        this.cboxDrzava.getSelectionModel().select((Object)"Hrvatska");
        this.cboxZupanija.getSelectionModel().selectFirst();
    }

    private void popuniCboxMjesta() {
        ResultSet rs = BazaPoslovneJedinice.dajMjesta();
        try {
            while (rs.next()) {
                this.cboxMjesto.getItems().add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosPoslovniceController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosPoslovniceController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void popuniCboxZupanije() {
        ResultSet rs = BazaPoslovneJedinice.dajZupanije();
        try {
            while (rs.next()) {
                this.cboxZupanija.getItems().add((Object)rs.getString("nazivzupanije"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosPoslovniceController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosPoslovniceController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void popuniCboxDrzave() {
        ResultSet rs = BazaPoslovneJedinice.dajDrzave();
        try {
            while (rs.next()) {
                this.cboxDrzava.getItems().add((Object)rs.getString("naziv_ispis"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosPoslovniceController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosPoslovniceController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void popuniCboxOpcine() {
        ResultSet rs = BazaPoslovneJedinice.dajMjesta();
        try {
            while (rs.next()) {
                this.cboxOpcina.getItems().add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosPoslovniceController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosPoslovniceController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniMjestaZaOdabranuZupaniju(String nazivZupanije) {
        System.out.println("usao u metodu odabrana zup");
        this.cboxMjesto.getItems().clear();
        this.cboxOpcina.getItems().clear();
        ResultSet rs = BazaPoslovneJedinice.dohvatiGradove(nazivZupanije);
        try {
            while (rs.next()) {
                this.cboxMjesto.getItems().add((Object)rs.getString("nazivgrada"));
                this.cboxOpcina.getItems().add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosPoslovniceController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosPoslovniceController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cboxMjesto.getSelectionModel().selectFirst();
        this.cboxOpcina.getSelectionModel().selectFirst();
    }

    private PoslovneJedinice dajPoslovnuJedinicu() {
        PoslovneJedinice pj = new PoslovneJedinice();
        pj.setOznakaPoslovnice(this.txtOznakaPoslovnice.getText());
        pj.setNazivPoslovnice(this.txtNazivPoslovnice.getText());
        pj.setAdresaPoslovnice(this.txtAdresa.getText());
        pj.setMjesto((String)this.cboxMjesto.getValue());
        pj.setOpcina((String)this.cboxOpcina.getValue());
        pj.setZupanija((String)this.cboxZupanija.getValue());
        pj.setDrzava((String)this.cboxDrzava.getValue());
        pj.setPoslovodja(this.txtNazivPoslovodje.getText());
        pj.setTelefon(this.txtTelefon.getText());
        pj.setFax(this.txtFax.getText());
        pj.setEmail(this.txtEmail.getText());
        pj.setIban(this.txtIBAN.getText());
        pj.setBankaIban(this.txtBankaIban.getText());
        return pj;
    }

    private void unosPoslovnice() {
        boolean bNazivPoslovnice = FormValidation.textFieldValidationonlyText(this.txtNazivPoslovnice);
        if (bNazivPoslovnice) {
            if (this.izmjenaPoslovnice) {
                if (UtillBaza.provjeraUnosa("select nazivposlovnice from poslovnejedinice where nazivposlovnice='" + this.txtNazivPoslovnice.getText() + "'and id !='" + this.poslovnajedJediniceizmjena.getId() + "'and nazivtvrtke='" + GlavniPanelController.getOdabranaTvrtka().getId() + "';", this.txtNazivPoslovnice.getText())) {
                    if (BazaPoslovneJedinice.izmjenaPoslovneJedinice(GlavniPanelController.getOdabranaTvrtka(), this.dajPoslovnuJedinicu(), this.poslovnajedJediniceizmjena.getId())) {
                        PregledPoslovnihJedinicaController.getInstance().popuniTablicuPoslovneJedinice();
                        GlavniPanelController.getInstance().zatvoriTab("Unos poslovne jedinice");
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena poslovnica", 1, "Information graphic");
                    } else {
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena poslovnice", 2, "Error graphic");
                    }
                }
            } else if (UtillBaza.provjeraUnosa("select nazivposlovnice from poslovnejedinice where nazivposlovnice='" + this.txtNazivPoslovnice.getText() + "'and nazivtvrtke='" + GlavniPanelController.getOdabranaTvrtka().getId() + "';", this.txtNazivPoslovnice.getText())) {
                if (BazaPoslovneJedinice.unesiNovuPoslovnicu(GlavniPanelController.getOdabranaTvrtka(), this.dajPoslovnuJedinicu())) {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesena poslovnica", 1, "Information graphic");
                    PregledPoslovnihJedinicaController.getInstance().popuniTablicuPoslovneJedinice();
                    GlavniPanelController.getInstance().zatvoriTab("Unos poslovne jedinice");
                    this.izmjenaPoslovnice = false;
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesena poslovnica", 2, "Error graphic");
                    System.out.println("neuspje\u0161no izmjenjena  djelatnika");
                }
            }
        }
    }

    void izmjenaPoslovnice(PoslovneJedinice pj) {
        this.poslovnajedJediniceizmjena = pj;
        this.izmjenaPoslovnice = true;
        this.popuniComboBoxove();
        this.txtOznakaPoslovnice.setText(pj.getOznakaPoslovnice());
        this.txtNazivPoslovnice.setText(pj.getNazivPoslovnice());
        this.txtAdresa.setText(pj.getAdresaPoslovnice());
        if (pj.getZupanija() != null) {
            this.cboxZupanija.getSelectionModel().select((Object)pj.getZupanija());
        } else {
            this.cboxZupanija.getSelectionModel().selectFirst();
        }
        if (pj.getMjesto() != null) {
            this.cboxMjesto.getSelectionModel().select((Object)pj.getMjesto());
        } else {
            this.cboxMjesto.getSelectionModel().select((Object)"Sva mjesta");
        }
        if (pj.getOpcina() != null) {
            this.cboxOpcina.getSelectionModel().select((Object)pj.getOpcina());
        } else {
            this.cboxOpcina.getSelectionModel().select((Object)"Sva mjesta");
        }
        if (pj.getDrzava() != null) {
            this.cboxDrzava.getSelectionModel().select((Object)pj.getDrzava());
        } else {
            this.cboxDrzava.getSelectionModel().select((Object)"Hrvatska");
        }
        this.txtNazivPoslovodje.setText(pj.getPoslovodja());
        this.txtTelefon.setText(pj.getTelefon());
        this.txtFax.setText(pj.getFax());
        this.txtEmail.setText(pj.getEmail());
        this.txtIBAN.setText(pj.getIban());
        this.txtBankaIban.setText(pj.getBankaIban());
    }
}

