/*
 * Decompiled with CFR 0.152.
 */
package poslovnejedinice;

import TamplatePaneli.Template;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.UtillBaza;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import poslovnejedinice.BazaPoslovneJedinice;
import poslovnejedinice.PoslovneJedinice;
import poslovnejedinice.UnosPoslovniceController;
import zastitanaradu.GlavniPanelController;

public class PregledPoslovnihJedinicaController
implements Initializable {
    @FXML
    private AnchorPane anhorGlavniPoslovnice;
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<PoslovneJedinice> tablicaPoslovneJedinice;
    @FXML
    private TableColumn<PoslovneJedinice, String> kolPretraga;
    @FXML
    private TableColumn<PoslovneJedinice, String> kolRedBr;
    @FXML
    private TableColumn<PoslovneJedinice, String> kolNaziv;
    @FXML
    private TableColumn<PoslovneJedinice, String> kolAdresa;
    @FXML
    private TableColumn<PoslovneJedinice, String> kolMjesto;
    @FXML
    private TableColumn<PoslovneJedinice, String> kolPoslovodja;
    @FXML
    private TableColumn<PoslovneJedinice, String> kolTelefon;
    @FXML
    private TableColumn<PoslovneJedinice, String> kolFax;
    @FXML
    private TableColumn<PoslovneJedinice, String> kolOznaka;
    private final ObservableList<PoslovneJedinice> listaPoslovnihJedinica = FXCollections.observableArrayList();
    private static PregledPoslovnihJedinicaController instance;
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PregledPoslovnihJedinicaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneuTabliciPoslovneJedinice();
        this.popuniTablicuPoslovneJedinice();
        this.urediFilter(this.tablicaPoslovneJedinice);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos poslovne jedinice")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos poslovne jedinice");
                GlavniPanelController.getInstance().nadodajPanel("Unos poslovne jedinice", "/poslovnejedinice/UnosPoslovnice.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos poslovne jedinice", "/poslovnejedinice/UnosPoslovnice.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            int selectdIndex = this.tablicaPoslovneJedinice.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                PoslovneJedinice pjt = (PoslovneJedinice)this.tablicaPoslovneJedinice.getSelectionModel().getSelectedItem();
                System.out.println("id iz tablice " + pjt.getId());
                if (pjt != null) {
                    if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos poslovne jedinice")) {
                        GlavniPanelController.getInstance().zatvoriTab("Unos poslovne jedinice");
                        GlavniPanelController.getInstance().nadodajPanel("Unos poslovne jedinice", "/poslovnejedinice/UnosPoslovnice.fxml");
                        UnosPoslovniceController.getInstance().izmjenaPoslovnice(pjt);
                        this.tablicaPoslovneJedinice.getSelectionModel().clearSelection();
                    } else {
                        GlavniPanelController.getInstance().nadodajPanel("Unos poslovne jedinice", "/poslovnejedinice/UnosPoslovnice.fxml");
                        UnosPoslovniceController.getInstance().izmjenaPoslovnice(pjt);
                        this.tablicaPoslovneJedinice.getSelectionModel().clearSelection();
                    }
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPoslovneJedinice.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati poslovnu jedinicu")).showAndWait()).get() == ButtonType.OK && !UtillBaza.provjeraPoslovneJedinice((PoslovneJedinice)this.tablicaPoslovneJedinice.getSelectionModel().getSelectedItem())) {
                if (BazaPoslovneJedinice.obrisiPoslovnicu((PoslovneJedinice)this.tablicaPoslovneJedinice.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuPoslovneJedinice();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na obrisana poslovna jedinica", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na obrisana poslovna jedinica", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Oznaka", "Naziv", "Mjesto"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaPoslovnihJedinica, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Oznaka") ? pregled.getOznakaPoslovnice() != null && pregled.getOznakaPoslovnice().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") ? pregled.getNazivPoslovnice() != null && pregled.getNazivPoslovnice().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Mjesto") && pregled.getMjesto() != null && pregled.getMjesto().toLowerCase().startsWith(lowerCaseFilter));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneuTabliciPoslovneJedinice() {
        this.tablicaPoslovneJedinice.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PregledPoslovnihJedinicaController.this.tablicaPoslovneJedinice.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redniBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPoslovneJedinice.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolOznaka.setCellValueFactory((Callback)new PropertyValueFactory("oznakaPoslovnice"));
        this.kolOznaka.prefWidthProperty().bind((ObservableValue)this.tablicaPoslovneJedinice.widthProperty().divide(10.0));
        this.kolOznaka.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory((Callback)new PropertyValueFactory("nazivPoslovnice"));
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPoslovneJedinice.widthProperty().divide(3.3333333333333335));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolAdresa.setCellValueFactory((Callback)new PropertyValueFactory("adresaPoslovnice"));
        this.kolAdresa.prefWidthProperty().bind((ObservableValue)this.tablicaPoslovneJedinice.widthProperty().divide(5.0));
        this.kolAdresa.setStyle("-fx-alignment: CENTER;");
        this.kolMjesto.setCellValueFactory((Callback)new PropertyValueFactory("mjesto"));
        this.kolMjesto.prefWidthProperty().bind((ObservableValue)this.tablicaPoslovneJedinice.widthProperty().divide(5.555555555555555));
        this.kolMjesto.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledPoslovnice = new TableColumn("Pregled");
        kolPregledPoslovnice.setSortable(false);
        kolPregledPoslovnice.prefWidthProperty().bind((ObservableValue)this.tablicaPoslovneJedinice.widthProperty().divide(10.0));
        kolPregledPoslovnice.setStyle("-fx-alignment: CENTER;");
        kolPregledPoslovnice.setCellFactory((Callback)new Callback<TableColumn<PoslovneJedinice, Boolean>, TableCell<PoslovneJedinice, Boolean>>(){

            public TableCell<PoslovneJedinice, Boolean> call(TableColumn<PoslovneJedinice, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledPoslovnice);
    }

    void iskljuciBlurEfekt() {
        this.anhorGlavniPoslovnice.setEffect(null);
        this.tablicaPoslovneJedinice.getSelectionModel().clearSelection();
    }

    public void popuniTablicuPoslovneJedinice() {
        this.tablicaPoslovneJedinice.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Random rng = new Random();
        Task<Void> task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaPoslovnihJedinica.clear();
        this.tablicaPoslovneJedinice.getItems().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaPoslovneJedinice.dajPoslovnujednicu(GlavniPanelController.getOdabranaTvrtka());
        int br = 1;
        try {
            while (rs.next()) {
                PoslovneJedinice pj = new PoslovneJedinice();
                pj.setId(rs.getInt("id"));
                pj.setRedniBroj(String.valueOf(br));
                pj.setOznakaPoslovnice(rs.getString("oznakaposlovnice"));
                pj.setNazivPoslovnice(rs.getString("nazivposlovnice"));
                pj.setAdresaPoslovnice(rs.getString("adresa"));
                pj.setZupanija(rs.getString("zupanija"));
                pj.setMjesto(rs.getString("mjesto"));
                pj.setOpcina(rs.getString("opcina"));
                pj.setDrzava(rs.getString("drzava"));
                pj.setPoslovodja(rs.getString("nazivposlovodje"));
                pj.setTelefon(rs.getString("telefon"));
                pj.setFax(rs.getString("fax"));
                pj.setEmail(rs.getString("email"));
                pj.setIban(rs.getString("iban"));
                pj.setBankaIban(rs.getString("bankaiban"));
                this.listaPoslovnihJedinica.add((Object)pj);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PregledPoslovnihJedinicaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PregledPoslovnihJedinicaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPoslovneJedinice.getItems().addAll(this.listaPoslovnihJedinica);
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PregledPoslovnihJedinicaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PregledPoslovnihJedinicaController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PregledPoslovnihJedinicaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private class ButtonCell
    extends TableCell<PoslovneJedinice, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    PoslovneJedinice pjt;
                    int selectdIndex = PregledPoslovnihJedinicaController.this.tablicaPoslovneJedinice.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (pjt = (PoslovneJedinice)PregledPoslovnihJedinicaController.this.tablicaPoslovneJedinice.getSelectionModel().getSelectedItem()) != null) {
                        GlavniPanelController.getInstance().setBlurEfekt(new GaussianBlur(10.0));
                        Template.getTamplate().showTemplate("poslovnejedinice/UnosPoslovnice.fxml", "anchorPanelPoslovnica");
                        UnosPoslovniceController.getInstance().izmjenaPoslovnice(pjt);
                        PregledPoslovnihJedinicaController.this.tablicaPoslovneJedinice.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PregledPoslovnihJedinicaController.this.tablicaPoslovneJedinice.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

