/*
 * Decompiled with CFR 0.152.
 */
package ozs;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import ozs.BazaOZS;
import ozs.Ozs;
import ozs.UnosOZSController;
import zastitanaradu.GlavniPanelController;

public class OzsController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<Ozs> tablicaPopisOZS;
    @FXML
    private TableColumn<Ozs, String> kolPretraga;
    @FXML
    private TableColumn<Ozs, String> kolRedBr;
    @FXML
    private TableColumn<Ozs, String> kolOznaka;
    @FXML
    private TableColumn<Ozs, String> kolNaziv;
    @FXML
    private TableColumn<Ozs, String> kolOzsgrupa;
    @FXML
    private TableColumn<Ozs, String> kolPerZaduzenja;
    @FXML
    private TableColumn<Ozs, String> kolHRNorma;
    private static OzsController instance;
    private final ObservableList<Ozs> listaOZS = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static OzsController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciOzs();
        this.popuniTablicuOZS();
        this.urediFilter(this.tablicaPopisOZS);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos OZS")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos OZS");
                GlavniPanelController.getInstance().nadodajPanel("Unos OZS", "/ozs/UnosOZS.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos OZS", "/ozs/UnosOZS.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            Ozs o;
            int selectdIndex = this.tablicaPopisOZS.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (o = (Ozs)this.tablicaPopisOZS.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos OZS")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos OZS");
                    GlavniPanelController.getInstance().nadodajPanel("Unos OZS", "/ozs/UnosOZS.fxml");
                    UnosOZSController.getInstance().izmjenaOdjela(o);
                    this.tablicaPopisOZS.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos OZS", "/ozs/UnosOZS.fxml");
                    UnosOZSController.getInstance().izmjenaOdjela(o);
                    this.tablicaPopisOZS.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisOZS.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati OZS")).showAndWait()).get() == ButtonType.OK) {
                if (BazaOZS.obrisiOdjel((Ozs)this.tablicaPopisOZS.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuOZS();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan OZS", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan OZS", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Oznaka", "Naziv", "Grupa"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaOZS, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Oznaka") ? pregled.getOznaka() != null && pregled.getOznaka().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") ? pregled.getNaziv() != null && pregled.getNaziv().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Grupa") && pregled.getGrupaOzs() != null && pregled.getGrupaOzs().toLowerCase().startsWith(lowerCaseFilter));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciOzs() {
        this.tablicaPopisOZS.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    OzsController.this.tablicaPopisOZS.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOZS.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolOznaka.setCellValueFactory((Callback)new PropertyValueFactory("oznaka"));
        this.kolOznaka.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOZS.widthProperty().divide(10.0));
        this.kolOznaka.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory((Callback)new PropertyValueFactory("naziv"));
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOZS.widthProperty().divide(3.3333333333333335));
        this.kolOzsgrupa.setCellValueFactory((Callback)new PropertyValueFactory("grupaOzs"));
        this.kolOzsgrupa.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOZS.widthProperty().divide(5.0));
        this.kolOzsgrupa.setStyle("-fx-alignment: CENTER;");
        this.kolPerZaduzenja.setCellValueFactory((Callback)new PropertyValueFactory("periodika"));
        this.kolPerZaduzenja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOZS.widthProperty().divide(6.666666666666667));
        this.kolPerZaduzenja.setStyle("-fx-alignment: CENTER;");
        this.kolHRNorma.setCellValueFactory((Callback)new PropertyValueFactory("hrNorma"));
        this.kolHRNorma.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOZS.widthProperty().divide(7.142857142857143));
        this.kolHRNorma.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaOZS.dajOZS(GlavniPanelController.getOdabranaTvrtka());
        int br = 1;
        try {
            while (rs.next()) {
                Ozs o = new Ozs();
                o.setId(rs.getInt("id"));
                o.setRedBroj(String.valueOf(br));
                o.setOznaka(rs.getString("oznaka"));
                o.setNaziv(rs.getString("naziv"));
                if (rs.getString("nazivgrupe") != null) {
                    o.setGrupaOzs(rs.getString("nazivgrupe"));
                } else {
                    o.setGrupaOzs("");
                }
                o.setHrNorma(rs.getString("hrnorma"));
                o.setPeriodika(rs.getString("periodika"));
                this.listaOZS.add((Object)o);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(OzsController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(OzsController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisOZS.getItems().addAll(this.listaOZS);
    }

    public void popuniTablicuOZS() {
        this.tablicaPopisOZS.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Random rng = new Random();
        Task<Void> task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaOZS.clear();
        this.tablicaPopisOZS.getItems().clear();
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(OzsController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    OzsController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> OzsController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }
}

