/*
 * Decompiled with CFR 0.152.
 */
package ozljedanaradu;

import TamplatePaneli.Template;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import ispisJasper.IspisReporta;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import ozljedanaradu.BazaOzljedaNaRadu;
import ozljedanaradu.OzljedaNaRadu;
import ozljedanaradu.UnosOzljedaNaRaduController;
import zastitanaradu.GlavniPanelController;

public class PregledOzljedaNaRaduController
implements Initializable {
    @FXML
    private AnchorPane anchorPanel;
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private Button btnIspis;
    @FXML
    private MenuButton btnIspis1;
    @FXML
    private TableView<OzljedaNaRadu> tablicaPopisOzljedaNaradu;
    @FXML
    private TableColumn<OzljedaNaRadu, String> kolPretraga;
    @FXML
    private TableColumn<OzljedaNaRadu, String> kolRedBr;
    @FXML
    private TableColumn<OzljedaNaRadu, LocalDate> kolDatumIzdavanja;
    @FXML
    private TableColumn<OzljedaNaRadu, String> kolOib;
    @FXML
    private TableColumn<OzljedaNaRadu, String> kolNaziv;
    private static PregledOzljedaNaRaduController instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<OzljedaNaRadu> listaOzljeda = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();

    public static PregledOzljedaNaRaduController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediTablicuPopisOzljeda();
        this.popuniTablicuPopisOzljeda();
        this.popuniButtonIspis();
        this.urediFilter(this.tablicaPopisOzljedaNaradu);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos ozljede na radu")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos ozljede na radu");
                GlavniPanelController.getInstance().nadodajPanel("Unos ozljede na radu", "/ozljedanaradu/UnosOzljedaNaRadu.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos ozljede na radu", "/ozljedanaradu/UnosOzljedaNaRadu.fxml");
            }
        });
        this.btnPromjena.setOnAction(event -> {
            OzljedaNaRadu oz;
            int selectdIndex = this.tablicaPopisOzljedaNaradu.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (oz = (OzljedaNaRadu)this.tablicaPopisOzljedaNaradu.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos ozljede na radu")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos ozljede na radu");
                    GlavniPanelController.getInstance().nadodajPanel("Unos ozljede na radu", "/ozljedanaradu/UnosOzljedaNaRadu.fxml");
                    UnosOzljedaNaRaduController.getInstance().izmjenaPrijave(oz);
                    this.tablicaPopisOzljedaNaradu.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos ozljede na radu", "/ozljedanaradu/UnosOzljedaNaRadu.fxml");
                    UnosOzljedaNaRaduController.getInstance().izmjenaPrijave(oz);
                    this.tablicaPopisOzljedaNaradu.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisOzljedaNaradu.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati prijavu")).showAndWait()).get() == ButtonType.OK) {
                if (BazaOzljedaNaRadu.obrisiPrijavu((OzljedaNaRadu)this.tablicaPopisOzljedaNaradu.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuPopisOzljeda();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisana prijava", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisana prijava", 2, "Error graphic");
                }
            }
        });
        this.btnIspis.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisOzljedaNaradu.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.ispis((ObservableList<OzljedaNaRadu>)this.tablicaPopisOzljedaNaradu.getSelectionModel().getSelectedItems());
            }
        });
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaOzljeda, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") ? pregled.getTxt9() != null && pregled.getTxt9().toLowerCase().contains(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("OIB") && pregled.getTxt12() != null && pregled.getTxt12().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Naziv", "OIB"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediTablicuPopisOzljeda() {
        this.tablicaPopisOzljedaNaradu.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisOzljedaNaradu.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PregledOzljedaNaRaduController.this.tablicaPopisOzljedaNaradu.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((OzljedaNaRadu)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOzljedaNaradu.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumIzdavanja.setCellValueFactory(cellData -> ((OzljedaNaRadu)cellData.getValue()).datumPodnosenjaPrijaveProperty());
        this.kolDatumIzdavanja.setCellFactory(dateCellFactory);
        this.kolDatumIzdavanja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOzljedaNaradu.widthProperty().divide(5.0));
        this.kolDatumIzdavanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumIzdavanja.setEditable(false);
        this.kolOib.setCellValueFactory(cellData -> ((OzljedaNaRadu)cellData.getValue()).txt12Property());
        this.kolOib.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOzljedaNaradu.widthProperty().divide(3.3333333333333335));
        this.kolOib.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory(cellData -> ((OzljedaNaRadu)cellData.getValue()).txt9Property());
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOzljedaNaradu.widthProperty().divide(3.3333333333333335));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledOzljeda = new TableColumn("Pregled");
        kolPregledOzljeda.setSortable(false);
        kolPregledOzljeda.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOzljedaNaradu.widthProperty().divide(10.0));
        kolPregledOzljeda.setStyle("-fx-alignment: CENTER;");
        kolPregledOzljeda.setCellFactory((Callback)new Callback<TableColumn<OzljedaNaRadu, Boolean>, TableCell<OzljedaNaRadu, Boolean>>(){

            public TableCell<OzljedaNaRadu, Boolean> call(TableColumn<OzljedaNaRadu, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledOzljeda);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuOzljeda(ResultSet rs) {
        OzljedaNaRadu oz = null;
        int br = 1;
        try {
            while (rs.next()) {
                oz = new OzljedaNaRadu();
                oz.setId(rs.getInt("id"));
                oz.setIdHZZO(rs.getInt("idhzzo"));
                oz.setRedBroj(String.valueOf(br));
                oz.setTxt1(rs.getString("a1"));
                oz.setTxt2(rs.getString("a2"));
                oz.setTxt3(rs.getString("a3"));
                oz.setTxt4(rs.getString("a4"));
                oz.setTxt5(rs.getString("a5"));
                oz.setTxt6(rs.getString("a6"));
                oz.setTxt7(rs.getString("a7"));
                oz.setTxt8(rs.getString("a8"));
                oz.setTxt9(rs.getString("b9"));
                oz.setDatum10(DateUtil.getLocalDate(rs.getDate("b10")));
                oz.setTxt11Ulica(rs.getString("b11ulica"));
                oz.setTxt11KCbr(rs.getString("b11kcbr"));
                oz.setTxt11Mjesto(rs.getString("b11mjesto"));
                oz.setTxt11PBr(rs.getString("b11pbr"));
                oz.setTxt11Tel(rs.getString("b11tel"));
                oz.setTxt11Email(rs.getString("b11email"));
                oz.setTxt12(rs.getString("b12"));
                oz.setTxt13(rs.getString("b13"));
                oz.setTxt14(rs.getString("b14"));
                oz.setTxt15(rs.getString("b15"));
                oz.setTxt15Nazivdrzavljanstva(rs.getString("b15drzavljanstvo"));
                oz.setTxt16(rs.getString("b16"));
                oz.setTxt17(rs.getString("b17"));
                oz.setTxt18(rs.getString("b18"));
                oz.setTxt19OD(rs.getString("b19od"));
                oz.setTxt19DO(rs.getString("b19do"));
                oz.setTxt20(rs.getString("b20"));
                oz.setTxt21(rs.getString("b21"));
                oz.setTxt22(rs.getString("b22"));
                oz.setDatum23(DateUtil.getLocalDate(rs.getDate("c23")));
                oz.setTxt24(rs.getString("c24"));
                oz.setTxt25(rs.getString("c25"));
                oz.setTxt26(rs.getString("c26"));
                oz.setTxt27(rs.getString("c27"));
                oz.setTxt28(rs.getString("c28"));
                oz.setTxt29(rs.getString("c29"));
                oz.setTxt30(rs.getString("c30"));
                oz.setTxt31(rs.getString("c31"));
                oz.setTxt32(rs.getString("c32"));
                oz.setTxt33(rs.getString("c33"));
                oz.setTxt34(rs.getString("c34"));
                oz.setTxt35(rs.getString("c35"));
                oz.setTxt36(rs.getString("c36"));
                oz.setTxt37(rs.getString("c37"));
                oz.setTxt37a(rs.getString("c37a"));
                oz.setTxt38(rs.getString("c38"));
                oz.setTxt39(rs.getString("c39"));
                oz.setTxt40(rs.getString("c40"));
                oz.setTxt41(rs.getString("c41"));
                oz.setTxt42(rs.getString("c42"));
                oz.setTxt43(rs.getString("c43"));
                oz.setTxt44(rs.getString("c44"));
                oz.setTxt45(rs.getString("c45"));
                oz.setTxt45Opis(rs.getString("c45opis"));
                oz.setTxt46(rs.getString("c46"));
                oz.setTxt47(rs.getString("c47"));
                oz.setTxt48Ime(rs.getString("d48ime"));
                oz.setTxt48Tel(rs.getString("d48tel"));
                oz.setTxt49Adresa(rs.getString("d49adresa"));
                oz.setTxt49Email(rs.getString("d49email"));
                oz.setTxt50Ime(rs.getString("e50ime"));
                oz.setTxt50Tel(rs.getString("e50tel"));
                oz.setTxt51Adresa(rs.getString("e51adresa"));
                oz.setTxt51Email(rs.getString("e51email"));
                oz.setTxt52Ime(rs.getString("f52ime"));
                oz.setTxt52Tel(rs.getString("f52tel"));
                oz.setTxt53RadnoMjesto(rs.getString("f53radnomjesto"));
                oz.setTxt53Email(rs.getString("f53email"));
                oz.setDatumPodnosenjaPrijave(DateUtil.getLocalDate(rs.getDate("datumpodnosenjaprijave")));
                oz.setOdgovornaOsoba(rs.getString("imeprezimeodgovorneosobe"));
                this.listaOzljeda.add((Object)oz);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PregledOzljedaNaRaduController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PregledOzljedaNaRaduController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisOzljedaNaradu.getItems().addAll(this.listaOzljeda);
    }

    public void popuniTablicuPopisOzljeda() {
        this.tablicaPopisOzljedaNaradu.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaOzljeda.clear();
        this.tablicaPopisOzljedaNaradu.getItems().clear();
    }

    private Task createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PregledOzljedaNaRaduController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaOzljedaNaRadu.dajOzljede(GlavniPanelController.getOdabranaTvrtka());
                    PregledOzljedaNaRaduController.this.popuniTablicuOzljeda(rs);
                }
                finally {
                    Platform.runLater(() -> PregledOzljedaNaRaduController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void ispis(ObservableList<OzljedaNaRadu> listaOzljeda) {
        String idArray = "";
        for (int i = 0; i < listaOzljeda.size(); ++i) {
            idArray = i == 0 ? idArray + String.valueOf(((OzljedaNaRadu)listaOzljeda.get(i)).getId()) : idArray + "," + String.valueOf(((OzljedaNaRadu)listaOzljeda.get(i)).getId());
        }
        String sql = "SELECT \n  hzzo.naziv, \n  hzzo.sifra, \n  hzzo.adresa, \n  hzzo.mjesto, \n  hzzo.telefon, \n  hzzo.fax,\n  ozljedanaradu.*\nFROM \n  public.ozljedanaradu, \n  public.hzzo\nWHERE \n  ozljedanaradu.idhzzo = hzzo.id   and ozljedanaradu.id IN (select(unnest(ARRAY [" + idArray + "])))and ozljedanaradu.idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
        IspisReporta.ispisButtonSaSubreportom(sql, this.btnIspis, "PrijavaOzljedeNaRadu.jrxml");
    }

    void popuniButtonIspis() {
        this.btnIspis1.disableProperty().bind((ObservableValue)this.tablicaPopisOzljedaNaradu.getSelectionModel().selectedItemProperty().isNull());
        MenuItem a4 = new MenuItem("Ispis A4");
        a4.setOnAction(event -> {
            int selectdIndex = this.tablicaPopisOzljedaNaradu.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                ObservableList listaOzljeda = this.tablicaPopisOzljedaNaradu.getSelectionModel().getSelectedItems();
                String idArray = "";
                for (int i = 0; i < listaOzljeda.size(); ++i) {
                    idArray = i == 0 ? idArray + String.valueOf(((OzljedaNaRadu)listaOzljeda.get(i)).getId()) : idArray + "," + String.valueOf(((OzljedaNaRadu)listaOzljeda.get(i)).getId());
                }
                String sql = "SELECT \n  hzzo.naziv, \n  hzzo.sifra, \n  hzzo.adresa, \n  hzzo.mjesto, \n  hzzo.telefon, \n  hzzo.fax,\n  ozljedanaradu.*\nFROM \n  public.ozljedanaradu, \n  public.hzzo\nWHERE \n  ozljedanaradu.idhzzo = hzzo.id   and ozljedanaradu.id IN (select(unnest(ARRAY [" + idArray + "])))and ozljedanaradu.idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
                IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspis1, "PrijavaOzljedeNaRadu.jrxml");
            }
        });
        MenuItem a3 = new MenuItem("Ispis A3");
        a3.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisOzljedaNaradu.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                ObservableList listaOzljeda = this.tablicaPopisOzljedaNaradu.getSelectionModel().getSelectedItems();
                String idArray = "";
                for (int i = 0; i < listaOzljeda.size(); ++i) {
                    idArray = i == 0 ? idArray + String.valueOf(((OzljedaNaRadu)listaOzljeda.get(i)).getId()) : idArray + "," + String.valueOf(((OzljedaNaRadu)listaOzljeda.get(i)).getId());
                }
                String sql = "SELECT \n  hzzo.naziv, \n  hzzo.sifra, \n  hzzo.adresa, \n  hzzo.mjesto, \n  hzzo.telefon, \n  hzzo.fax,\n  ozljedanaradu.*\nFROM \n  public.ozljedanaradu, \n  public.hzzo\nWHERE \n  ozljedanaradu.idhzzo = hzzo.id   and ozljedanaradu.id IN (select(unnest(ARRAY [" + idArray + "])))and ozljedanaradu.idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
                IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspis1, "OzljedaNaRaduA3.jrxml");
            }
        });
        this.btnIspis1.getItems().addAll((Object[])new MenuItem[]{a4, new SeparatorMenuItem(), a3});
    }

    private class ButtonCell
    extends TableCell<OzljedaNaRadu, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    OzljedaNaRadu ra;
                    int selectdIndex = PregledOzljedaNaRaduController.this.tablicaPopisOzljedaNaradu.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (ra = (OzljedaNaRadu)PregledOzljedaNaRaduController.this.tablicaPopisOzljedaNaradu.getSelectionModel().getSelectedItem()) != null) {
                        GlavniPanelController.getInstance().setBlurEfekt(new GaussianBlur(10.0));
                        Template.getTamplate().showTemplate("ozljedanaradu/UnosOzljedaNaRadu.fxml", "anchorPanel");
                        UnosOzljedaNaRaduController.getInstance().izmjenaPrijave(ra);
                        PregledOzljedaNaRaduController.this.tablicaPopisOzljedaNaradu.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PregledOzljedaNaRaduController.this.tablicaPopisOzljedaNaradu.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

