/*
 * Decompiled with CFR 0.152.
 */
package osposobljavanje;

import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import Utill.UtillBaza;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.stage.Stage;
import osposobljavanje.BazaOsposobljavanje;
import osposobljavanje.Osposobljavanje;
import osposobljavanje.PopisOsposobljavanjaController;
import zastitanaradu.GlavniPanelController;

public class UnosOsposobljavanjaController
implements Initializable {
    @FXML
    private CheckBox chboxEK1a;
    @FXML
    private CheckBox chboxEK1b;
    @FXML
    private CheckBox chboxEK2;
    @FXML
    private CheckBox chboxLijecnicki;
    @FXML
    private CheckBox chboxEKZOP;
    @FXML
    private CheckBox chboxEKPP;
    @FXML
    private CheckBox chboxNocniRad;
    @FXML
    private ComboBox<String> cboxVrsteOsposobljavanja;
    @FXML
    private Button btnSpremi;
    @FXML
    private TextField txtNaziv;
    @FXML
    private TextField txtOznaka;
    private static UnosOsposobljavanjaController instance;
    private boolean izmjenaOsposobljavanja = false;
    private Osposobljavanje o;
    private Stage dialog;

    public static UnosOsposobljavanjaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtNaziv, this.txtOznaka);
        ResizeComponent.makeComboBoxResize(this.cboxVrsteOsposobljavanja);
        this.popuniComboBox();
        this.chboxEK1a.setTooltip(new Tooltip("Upis u EK-1 \n I Podaci o osposobljavanju radnika za samostalan rad na siguran na\u010din"));
        this.chboxEK1b.setTooltip(new Tooltip("Upis u EK-1 \n II Podaci o povremenoj provjeri znanja radnika iz za\u0161tite na radu"));
        this.btnSpremi.setOnAction(e -> this.unosOsposobljavanja());
    }

    private void popuniComboBox() {
        ResultSet rs = BazaOsposobljavanje.dajVrsteOsposobljavanja(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                this.cboxVrsteOsposobljavanja.getItems().add((Object)rs.getString("naziv"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosOsposobljavanjaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosOsposobljavanjaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        ResizeComponent.sizeComboBoxToText(this.cboxVrsteOsposobljavanja, (String)this.cboxVrsteOsposobljavanja.getValue());
    }

    private void unosOsposobljavanja() {
        boolean bVrstaOsposobljavanja;
        boolean bOznakaOsposobljavanja;
        boolean bNazivOsposobljavanja = FormValidation.textFieldValidationonlyText(this.txtNaziv);
        if (bNazivOsposobljavanja & (bOznakaOsposobljavanja = FormValidation.textFieldValidationonlyText(this.txtOznaka)) & (bVrstaOsposobljavanja = FormValidation.comboBoxValidationText(this.cboxVrsteOsposobljavanja))) {
            if (this.izmjenaOsposobljavanja) {
                if (UtillBaza.provjeraUnosa("select * from osposobljavanja where nazivosposobljavanja='" + this.txtNaziv.getText() + "'and id !='" + this.o.getId() + "'and nazivtvrtke='" + GlavniPanelController.getOdabranaTvrtka().getId() + "';", this.txtNaziv.getText())) {
                    if (BazaOsposobljavanje.izmjenaOsposobljavanja(GlavniPanelController.getOdabranaTvrtka(), this.dajOsposobljavanje(), this.o.getId())) {
                        PopisOsposobljavanjaController.getInstance().popuniTablicuOsposobljavanje();
                        GlavniPanelController.getInstance().zatvoriTab("Unos Osposobljavanja");
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena osposobljavanja", 1, "Information graphic");
                    } else {
                        KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena osposobljavanja", 2, "Error graphic");
                    }
                }
            } else if (UtillBaza.provjeraUnosa("select * from osposobljavanja where nazivosposobljavanja='" + this.txtNaziv.getText() + "'and nazivtvrtke='" + GlavniPanelController.getOdabranaTvrtka().getId() + "';", this.txtNaziv.getText())) {
                if (BazaOsposobljavanje.unesiNovoOsposobljavanje(GlavniPanelController.getOdabranaTvrtka(), this.dajOsposobljavanje())) {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesena osposobljavanja", 1, "Information graphic");
                    PopisOsposobljavanjaController.getInstance().popuniTablicuOsposobljavanje();
                    GlavniPanelController.getInstance().zatvoriTab("Unos Osposobljavanja");
                    this.izmjenaOsposobljavanja = false;
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesena osposobljavanja", 2, "Error graphic");
                }
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti text");
            alert.showAndWait();
        }
    }

    private Osposobljavanje dajOsposobljavanje() {
        Osposobljavanje os = new Osposobljavanje();
        os.setOznaka(this.txtOznaka.getText());
        os.setNazivOsposobljavanja(this.txtNaziv.getText());
        if (this.cboxVrsteOsposobljavanja.getValue() != null) {
            os.setVrstaOsposobljavanja((String)this.cboxVrsteOsposobljavanja.getValue());
        } else {
            os.setVrstaOsposobljavanja("");
        }
        os.setEk1a(this.chboxEK1a.isSelected());
        os.setEk1b(this.chboxEK1b.isSelected());
        os.setEk2(this.chboxEK2.isSelected());
        os.setLjecnickiPregled(this.chboxLijecnicki.isSelected());
        os.setEkZop(this.chboxEKZOP.isSelected());
        os.setEkPP(this.chboxEKPP.isSelected());
        os.setNocniRad(this.chboxNocniRad.isSelected());
        return os;
    }

    public void izmjenaOsposobljavanja(Osposobljavanje o) {
        this.izmjenaOsposobljavanja = true;
        this.o = o;
        this.txtNaziv.setText(o.getNazivOsposobljavanja());
        this.txtOznaka.setText(o.getOznaka());
        if (o.getVrstaOsposobljavanja().equals("") || o.getVrstaOsposobljavanja() == null) {
            this.cboxVrsteOsposobljavanja.setPromptText("Odaberi vrstu osposobljavanja");
        } else {
            this.cboxVrsteOsposobljavanja.getSelectionModel().select((Object)o.getVrstaOsposobljavanja());
        }
        this.chboxEK1a.setSelected(o.isEk1a());
        this.chboxEK1b.setSelected(o.isEk1b());
        this.chboxEK2.setSelected(o.isEk2());
        this.chboxLijecnicki.setSelected(o.isLjecnickiPregled());
        this.chboxEKZOP.setSelected(o.isEkZop());
        this.chboxEKPP.setSelected(o.isEkPP());
        this.chboxNocniRad.setSelected(o.isNocniRad());
    }

    void setScene(Stage dialog) {
        this.dialog = dialog;
    }
}

