/*
 * Decompiled with CFR 0.152.
 */
package osposobljavanje;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.UtillBaza;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import osposobljavanje.BazaOsposobljavanje;
import osposobljavanje.UnosVrsteOsposobljavanjaController;
import osposobljavanje.VrstaOsposobljavanja;
import zastitanaradu.GlavniPanelController;

public class PopisVrsteOsposobljavanjaController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<VrstaOsposobljavanja> tablicaPopisVrstaOsposobljavanja;
    @FXML
    private TableColumn<VrstaOsposobljavanja, String> kolPretraga;
    @FXML
    private TableColumn<VrstaOsposobljavanja, String> kolRedBr;
    @FXML
    private TableColumn<VrstaOsposobljavanja, String> kolOznaka;
    @FXML
    private TableColumn<VrstaOsposobljavanja, String> kolNaziv;
    private static PopisVrsteOsposobljavanjaController instance;
    private final ObservableList<VrstaOsposobljavanja> listaVrstaOsposobljavanja = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisVrsteOsposobljavanjaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciVrstaOsposobljavanja();
        this.popuniTablicuVrstaOsposobljavanja();
        this.urediFilter(this.tablicaPopisVrstaOsposobljavanja);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos vrste osposobljavanja")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos vrste osposobljavanja");
                GlavniPanelController.getInstance().nadodajPanel("Unos vrste osposobljavanja", "/osposobljavanje/UnosVrsteOsposobljavanja.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos vrste osposobljavanja", "/osposobljavanje/UnosVrsteOsposobljavanja.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            VrstaOsposobljavanja vo;
            int selectdIndex = this.tablicaPopisVrstaOsposobljavanja.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (vo = (VrstaOsposobljavanja)this.tablicaPopisVrstaOsposobljavanja.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos vrste osposobljavanja")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos vrste osposobljavanja");
                    GlavniPanelController.getInstance().nadodajPanel("Unos vrste osposobljavanja", "/osposobljavanje/UnosVrsteOsposobljavanja.fxml");
                    UnosVrsteOsposobljavanjaController.getInstance().izmjenaGrupe(vo);
                    this.tablicaPopisVrstaOsposobljavanja.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos vrste osposobljavanja", "/osposobljavanje/UnosVrsteOsposobljavanja.fxml");
                    UnosVrsteOsposobljavanjaController.getInstance().izmjenaGrupe(vo);
                    this.tablicaPopisVrstaOsposobljavanja.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisVrstaOsposobljavanja.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati vrstu osposobljavanja")).showAndWait()).get() == ButtonType.OK && !UtillBaza.provjeraVrsteOsposobljavanja((VrstaOsposobljavanja)this.tablicaPopisVrstaOsposobljavanja.getSelectionModel().getSelectedItem())) {
                if (BazaOsposobljavanje.obrisiVrstuOsposobljavanja((VrstaOsposobljavanja)this.tablicaPopisVrstaOsposobljavanja.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuVrstaOsposobljavanja();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisana vrsta osposobljavanja", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisana vrsta osposobljavanja", 2, "Error graphic");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaOsposobljavanje.dajVrsteOsposobljavanja(GlavniPanelController.getOdabranaTvrtka());
        VrstaOsposobljavanja vo = null;
        int br = 1;
        try {
            while (rs.next()) {
                vo = new VrstaOsposobljavanja();
                vo.setId(rs.getInt("id"));
                vo.setRedBroj(String.valueOf(br));
                vo.setOznaka(rs.getString("oznaka"));
                vo.setNaziv(rs.getString("naziv"));
                this.listaVrstaOsposobljavanja.add((Object)vo);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisVrsteOsposobljavanjaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisVrsteOsposobljavanjaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisVrstaOsposobljavanja.getItems().addAll(this.listaVrstaOsposobljavanja);
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Oznaka", "Naziv"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaVrstaOsposobljavanja, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Oznaka") ? pregled.getOznaka() != null && pregled.getOznaka().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") && pregled.getNaziv() != null && pregled.getNaziv().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciVrstaOsposobljavanja() {
        this.tablicaPopisVrstaOsposobljavanja.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisVrsteOsposobljavanjaController.this.tablicaPopisVrstaOsposobljavanja.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisVrstaOsposobljavanja.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolOznaka.setCellValueFactory((Callback)new PropertyValueFactory("oznaka"));
        this.kolOznaka.prefWidthProperty().bind((ObservableValue)this.tablicaPopisVrstaOsposobljavanja.widthProperty().divide(5.0));
        this.kolOznaka.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory((Callback)new PropertyValueFactory("naziv"));
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisVrstaOsposobljavanja.widthProperty().divide(1.4492753623188406));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    public void popuniTablicuVrstaOsposobljavanja() {
        this.tablicaPopisVrstaOsposobljavanja.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Random rng = new Random();
        Task<Void> task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaVrstaOsposobljavanja.clear();
        this.tablicaPopisVrstaOsposobljavanja.getItems().clear();
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisVrsteOsposobljavanjaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisVrsteOsposobljavanjaController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisVrsteOsposobljavanjaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }
}

