/*
 * Decompiled with CFR 0.152.
 */
package odjeli;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.UtillBaza;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import odjeli.BazaOdjeli;
import odjeli.Odjel;
import odjeli.UnosOdjelaController;
import poslovnejedinice.PregledPoslovnihJedinicaController;
import zastitanaradu.GlavniPanelController;

public class PopisOdjelaController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<Odjel> tablicaPopisOdjela;
    @FXML
    private TableColumn<Odjel, String> kolPretraga;
    @FXML
    private TableColumn<Odjel, String> kolRedBr;
    @FXML
    private TableColumn<Odjel, String> kolOznaka;
    @FXML
    private TableColumn<Odjel, String> kolNaziv;
    private static PopisOdjelaController instance;
    private final ObservableList<Odjel> listaOdjela = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisOdjelaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciOdjeli();
        this.popuniTablicuOdjeli();
        this.urediFilter(this.tablicaPopisOdjela);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos odjela")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos odjela");
                GlavniPanelController.getInstance().nadodajPanel("Unos odjela", "/odjeli/UnosOdjela.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos odjela", "/odjeli/UnosOdjela.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            Odjel o;
            int selectdIndex = this.tablicaPopisOdjela.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (o = (Odjel)this.tablicaPopisOdjela.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos odjela")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos odjela");
                    GlavniPanelController.getInstance().nadodajPanel("Unos odjela", "/odjeli/UnosOdjela.fxml");
                    UnosOdjelaController.getInstance().izmjenaOdjela(o);
                    this.tablicaPopisOdjela.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos odjela", "/odjeli/UnosOdjela.fxml");
                    UnosOdjelaController.getInstance().izmjenaOdjela(o);
                    this.tablicaPopisOdjela.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisOdjela.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati odjel")).showAndWait()).get() == ButtonType.OK && !UtillBaza.provjeraOdjela((Odjel)this.tablicaPopisOdjela.getSelectionModel().getSelectedItem())) {
                if (BazaOdjeli.obrisiOdjel((Odjel)this.tablicaPopisOdjela.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuOdjeli();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan odjel", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan odjel", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Oznaka", "Naziv"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaOdjela, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Oznaka") ? pregled.getOznakaOdjela() != null && pregled.getOznakaOdjela().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") && pregled.getNazivOdjela() != null && pregled.getNazivOdjela().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciOdjeli() {
        this.tablicaPopisOdjela.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisOdjelaController.this.tablicaPopisOdjela.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOdjela.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolOznaka.setCellValueFactory((Callback)new PropertyValueFactory("oznakaOdjela"));
        this.kolOznaka.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOdjela.widthProperty().divide(5.0));
        this.kolOznaka.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory((Callback)new PropertyValueFactory("nazivOdjela"));
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOdjela.widthProperty().divide(1.4705882352941178));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaOdjeli.dajOdjel(GlavniPanelController.getOdabranaTvrtka());
        Odjel o = null;
        int br = 1;
        try {
            while (rs.next()) {
                o = new Odjel();
                o.setId(rs.getInt("id"));
                o.setRedBroj(String.valueOf(br));
                o.setOznakaOdjela(rs.getString("oznakaodjela"));
                o.setNazivOdjela(rs.getString("nazivodjela"));
                o.setPoslovnaJedinica(rs.getString("nazivposlovnice"));
                this.listaOdjela.add((Object)o);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisOdjelaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisOdjelaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisOdjela.getItems().addAll(this.listaOdjela);
    }

    public void popuniTablicuOdjeli() {
        this.tablicaPopisOdjela.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Random rng = new Random();
        Task<Void> task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaOdjela.clear();
        this.tablicaPopisOdjela.getItems().clear();
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PregledPoslovnihJedinicaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisOdjelaController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisOdjelaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }
}

