/*
 * Decompiled with CFR 0.152.
 */
package nr1;

import TamplatePaneli.Template;
import Utill.CheckboxCell;
import Utill.DateCell;
import Utill.DateUtil;
import ispisJasper.IspisReporta;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import monitoringnovi.ServiceRestart;
import nr1.BazaNR1;
import nr1.Nr1;
import nr1.Nr1ObrazacController;
import zastitanaradu.GlavniPanelController;

public class PregledNR1Controller
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private Button btnIspis;
    @FXML
    private TableView<Nr1> tablicaPopisNr1Uputnica;
    @FXML
    private TableColumn<Nr1, String> kolPretraga;
    @FXML
    private TableColumn<Nr1, Boolean> kolPregledObavljen;
    @FXML
    private TableColumn<Nr1, String> kolRedBr;
    @FXML
    private TableColumn<Nr1, LocalDate> kolDatumIzdavanja;
    @FXML
    private TableColumn<Nr1, String> kolBrojUputnice;
    @FXML
    private TableColumn<Nr1, String> kolOib;
    @FXML
    private TableColumn<Nr1, String> kolPrezime;
    @FXML
    private TableColumn<Nr1, String> kolIme;
    private static PregledNR1Controller instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<Nr1> listaNr1uputnica = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    BooleanProperty bp = new SimpleBooleanProperty(false);

    public static PregledNR1Controller getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediTablicuPopisNr1Uputnica();
        this.popuniTablicuPopisNR1Uputnica(1);
        this.urediFilter(this.tablicaPopisNr1Uputnica);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos NR-1 uputnice")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos NR-1 uputnice");
                GlavniPanelController.getInstance().nadodajPanel("Unos NR-1 uputnice", "/nr1/Nr1Obrazac.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos NR-1 uputnice", "/nr1/Nr1Obrazac.fxml");
            }
        });
        this.btnPromjena.setOnAction(event -> {
            Nr1 ra;
            int selectdIndex = this.tablicaPopisNr1Uputnica.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && this.tablicaPopisNr1Uputnica.getSelectionModel().getSelectedItems().size() < 2 && (ra = (Nr1)this.tablicaPopisNr1Uputnica.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos NR-1 uputnice")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos NR-1 uputnice");
                    GlavniPanelController.getInstance().nadodajPanel("Unos NR-1 uputnice", "/nr1/Nr1Obrazac.fxml");
                    Nr1ObrazacController.getInstance().izmjenaUputnice(ra);
                    this.tablicaPopisNr1Uputnica.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos NR-1 uputnice", "/nr1/Nr1Obrazac.fxml");
                    Nr1ObrazacController.getInstance().izmjenaUputnice(ra);
                    this.tablicaPopisNr1Uputnica.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnPromjena.disableProperty().bind((ObservableValue)this.bp.not());
        this.tablicaPopisNr1Uputnica.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                this.bp.set(!newSelection.isPregledObavljen());
            }
        });
        this.btnIspis.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisNr1Uputnica.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.ispis((ObservableList<Nr1>)this.tablicaPopisNr1Uputnica.getSelectionModel().getSelectedItems());
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Prezime", "OIB"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Prezime");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter, this.getMenuButton()});
    }

    private MenuButton getMenuButton() {
        MenuItem m1 = new MenuItem("Prikazi sve uputnice");
        m1.setOnAction(event -> this.popuniTablicuPopisNR1Uputnica(1));
        MenuItem m2 = new MenuItem("Prikazi samo obavljene preglede");
        m2.setOnAction(event -> this.popuniTablicuPopisNR1Uputnica(2));
        MenuItem m3 = new MenuItem("Prikazi samo neobavljene preglede");
        m3.setOnAction(event -> this.popuniTablicuPopisNR1Uputnica(3));
        MenuButton mb = new MenuButton("Pregled uputnica", null, new MenuItem[]{m1, m2, m3});
        return mb;
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaNr1uputnica, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Prezime") ? pregled.getPrezime() != null && pregled.getPrezime().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("OIB") && pregled.getOib() != null && pregled.getOib().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediTablicuPopisNr1Uputnica() {
        this.tablicaPopisNr1Uputnica.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisNr1Uputnica.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PregledNR1Controller.this.tablicaPopisNr1Uputnica.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((Nr1)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisNr1Uputnica.widthProperty().divide(12.5));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolPregledObavljen.setCellValueFactory(cellData -> ((Nr1)cellData.getValue()).pregledObavljenProperty());
        this.kolPregledObavljen.prefWidthProperty().bind((ObservableValue)this.tablicaPopisNr1Uputnica.widthProperty().divide(10.0));
        this.kolPregledObavljen.setStyle("-fx-alignment: CENTER;");
        Callback<TableColumn<Nr1, Boolean>, TableCell<Nr1, Boolean>> booleanCellFactory = new Callback<TableColumn<Nr1, Boolean>, TableCell<Nr1, Boolean>>(){

            public TableCell<Nr1, Boolean> call(TableColumn<Nr1, Boolean> p) {
                return new CheckboxCell<Nr1>();
            }
        };
        this.kolPregledObavljen.setCellFactory((Callback)booleanCellFactory);
        this.kolPregledObavljen.setOnEditCommit(t -> {
            ((Nr1)t.getTableView().getItems().get(t.getTablePosition().getRow())).setPregledObavljen((Boolean)t.getNewValue());
            this.bp.set((Boolean)t.getNewValue() == false);
            BazaNR1.pregledObavljen((Nr1)t.getTableView().getItems().get(t.getTablePosition().getRow()));
            ServiceRestart.restartService(ServiceRestart.RService.djelatnik);
        });
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumIzdavanja.setCellValueFactory(cellData -> ((Nr1)cellData.getValue()).datumIzdavanjaUputniceProperty());
        this.kolDatumIzdavanja.setCellFactory(dateCellFactory);
        this.kolDatumIzdavanja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisNr1Uputnica.widthProperty().divide(10.0));
        this.kolDatumIzdavanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumIzdavanja.setEditable(false);
        this.kolBrojUputnice.setCellValueFactory(cellData -> ((Nr1)cellData.getValue()).brojUputniceProperty());
        this.kolBrojUputnice.prefWidthProperty().bind((ObservableValue)this.tablicaPopisNr1Uputnica.widthProperty().divide(10.0));
        this.kolBrojUputnice.setStyle("-fx-alignment: CENTER;");
        this.kolOib.setCellValueFactory(cellData -> ((Nr1)cellData.getValue()).oibProperty());
        this.kolOib.prefWidthProperty().bind((ObservableValue)this.tablicaPopisNr1Uputnica.widthProperty().divide(10.0));
        this.kolOib.setStyle("-fx-alignment: CENTER;");
        this.kolPrezime.setCellValueFactory(cellData -> ((Nr1)cellData.getValue()).prezimeProperty());
        this.kolPrezime.prefWidthProperty().bind((ObservableValue)this.tablicaPopisNr1Uputnica.widthProperty().divide(5.0));
        this.kolPrezime.setStyle("-fx-alignment: CENTER;");
        this.kolIme.setCellValueFactory(cellData -> ((Nr1)cellData.getValue()).imeProperty());
        this.kolIme.prefWidthProperty().bind((ObservableValue)this.tablicaPopisNr1Uputnica.widthProperty().divide(5.0));
        this.kolIme.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledDjelatnika = new TableColumn("Pregled");
        kolPregledDjelatnika.setSortable(false);
        kolPregledDjelatnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisNr1Uputnica.widthProperty().divide(10.0));
        kolPregledDjelatnika.setStyle("-fx-alignment: CENTER;");
        kolPregledDjelatnika.setCellFactory((Callback)new Callback<TableColumn<Nr1, Boolean>, TableCell<Nr1, Boolean>>(){

            public TableCell<Nr1, Boolean> call(TableColumn<Nr1, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledDjelatnika);
    }

    public void popuniTablicuPopisNR1Uputnica(int opcija) {
        this.tablicaPopisNr1Uputnica.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask(opcija);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaNr1uputnica.clear();
        this.tablicaPopisNr1Uputnica.getItems().clear();
    }

    private Task createTask(final int opcija) {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PregledNR1Controller.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaNR1.dajNr1Uputnice(GlavniPanelController.getOdabranaTvrtka(), opcija);
                    PregledNR1Controller.this.popuniTablicuPopisNR11(rs);
                }
                finally {
                    Platform.runLater(() -> PregledNR1Controller.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuPopisNR11(ResultSet rs) {
        Nr1 ra = null;
        int br = 1;
        try {
            while (rs.next()) {
                ra = new Nr1();
                ra.setId(rs.getInt("id"));
                ra.setRedBroj(String.valueOf(br));
                ra.setPregledObavljen(rs.getBoolean("pregledobavljen"));
                ra.setBrojUputnice(rs.getString("brojuputnice"));
                ra.setOib(rs.getString("oib"));
                ra.setIme(rs.getString("ime"));
                ra.setPrezime(rs.getString("prezime"));
                ra.setDatumIzdavanjaUputnice(DateUtil.getLocalDate(rs.getDate("datumizdavanjauputnice")));
                ra.setImeOca_Majke(rs.getString("imeocamajke"));
                ra.setDatumRodjenja(DateUtil.getLocalDate(rs.getDate("datumrodjenja")));
                ra.setMjestoRodjenja(rs.getString("mjestorodjenja"));
                ra.setZanimianje(rs.getString("zanimanje"));
                ra.setStrucnaSprema(rs.getString("strucnasprema"));
                ra.setBrojOsobne(rs.getString("brojoi"));
                ra.setRadnoMjesto(rs.getString("radnomjesto"));
                ra.setZrastveniPregled(rs.getString("zrastvenipregled"));
                ra.setDatumPosljednjegPregleda(DateUtil.getLocalDate(rs.getDate("datumposljednjegpregleda")));
                ra.setZaNocniRad(rs.getString("zanocnirad"));
                ra.setOcjenaZrastveneSposobnosti(rs.getString("ocjenazdrastvenesposobnosti"));
                ra.setOpisPosla(rs.getString("opisposla"));
                ra.setStrojevi(rs.getString("strojevi"));
                ra.setPredmeti(rs.getString("predmeti"));
                ra.setMRuZatvorenom(rs.getBoolean("mruzatvorenom"));
                ra.setMRnaOtvorenom(rs.getBoolean("mrnaotvorenom"));
                ra.setMRnaVisini(rs.getBoolean("mrnavisini"));
                ra.setMRuJami(rs.getBoolean("mrujami"));
                ra.setMRuVodi(rs.getBoolean("mruvodi"));
                ra.setMRpodVodom(rs.getBoolean("mrpodvodom"));
                ra.setMRuMokrom(rs.getBoolean("mrumokrom"));
                ra.setORuSmjenama(rs.getBoolean("orusmjenama"));
                ra.setORnocniRad(rs.getBoolean("ornocnorad"));
                ra.setORterenskiRad(rs.getBoolean("orterenskirad"));
                ra.setORradiSam(rs.getBoolean("orradisam"));
                ra.setORradUGrupama(rs.getBoolean("orradugrupama"));
                ra.setORradSaStrankama(rs.getBoolean("orradsastrankama"));
                ra.setORradNaTraci(rs.getBoolean("orradnatraci"));
                ra.setORbrziTempoRada(rs.getBoolean("orbrzitemporada"));
                ra.setORritamOdredjen(rs.getBoolean("orritamodredjen"));
                ra.setORmonotonija(rs.getBoolean("ormonotomija"));
                ra.setPTradStojeci(rs.getBoolean("ptradstojeci"));
                ra.setPTradSjedeci(rs.getBoolean("ptradsjedeci"));
                ra.setPTradUPokretu(rs.getBoolean("ptradupokretu"));
                ra.setPTKombinirano(rs.getBoolean("ptkombinirano"));
                ra.setPTdizanjeTereta(rs.getBoolean("ptdizanjetereta"));
                ra.setPTDizanjeTeretaKg(rs.getString("ptdizanjeteretakg"));
                ra.setPTUcestaloSagibanje(rs.getBoolean("ptucestalosagibanje"));
                ra.setPTzakretanjeTrupa(rs.getBoolean("ptzakretanjetrupa"));
                ra.setPTklecanje(rs.getBoolean("ptklecanje"));
                ra.setPTcucanje(rs.getBoolean("ptcucanje"));
                ra.setPTprenosTereta(rs.getBoolean("ptprenostereta"));
                ra.setPTprenosTeretaKg(rs.getString("ptprenosteretakg"));
                ra.setPTpodvlacenje(rs.getBoolean("ptpodvlacenje"));
                ra.setPTbalansiranje(rs.getBoolean("ptbalansiranje"));
                ra.setPTuspinjanjeLjestvama(rs.getBoolean("ptuspinjanjeljestvama"));
                ra.setPTuspinjanjeStepenicama(rs.getBoolean("ptuspinjanjestepenicama"));
                ra.setPTguranjeTereta(rs.getBoolean("ptguranjetereta"));
                ra.setPTguranjeTeretaKg(rs.getString("ptguranjeteretakg"));
                ra.setVidNaDaljinu(rs.getBoolean("vidnadaljinu"));
                ra.setVidNaBlizinu(rs.getBoolean("vidnablizinu"));
                ra.setRaspoznavanjeBoja(rs.getBoolean("raspoznavanjeboja"));
                ra.setDobarSluh(rs.getBoolean("dobarsluh"));
                ra.setJasanGovor(rs.getBoolean("jasangovor"));
                ra.setVisokaTemperatura(rs.getBoolean("visokatemperatura"));
                ra.setVisokaVlaznost(rs.getBoolean("visokavlaznost"));
                ra.setNiskaTemperatura(rs.getBoolean("niskatemperatura"));
                ra.setBuka(rs.getBoolean("buka"));
                ra.setVibracijeStroja(rs.getBoolean("vibracijastroja"));
                ra.setVibracijePoda(rs.getBoolean("vibracijapoda"));
                ra.setPovisenATTlak(rs.getBoolean("povisenattlak"));
                ra.setPovecanaIzloOzljedama(rs.getBoolean("povecanaizlozenostozljedama"));
                ra.setIonizaciskoZracenje(rs.getBoolean("ionizaciskozracenje"));
                ra.setNeionizaciskoZracenje(rs.getBoolean("neionizaciskozracenje"));
                ra.setPrasina(rs.getBoolean("prasina"));
                ra.setKemiskeTvari(rs.getString("kemisketveri"));
                ra.setBioloskeStetnosti(rs.getString("bioloskestetnosti"));
                ra.setBrojUputnice(rs.getString("brojuputnice"));
                this.listaNr1uputnica.add((Object)ra);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PregledNR1Controller.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PregledNR1Controller.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisNr1Uputnica.getItems().addAll(this.listaNr1uputnica);
    }

    private void ispis(ObservableList<Nr1> listaRA1uputnica) {
        String idArray = "";
        for (int i = 0; i < listaRA1uputnica.size(); ++i) {
            idArray = i == 0 ? idArray + String.valueOf(((Nr1)listaRA1uputnica.get(i)).getId()) : idArray + "," + String.valueOf(((Nr1)listaRA1uputnica.get(i)).getId());
        }
        String sql = "SELECT nr1obrazac.* FROM nr1obrazac WHERE nr1obrazac.id IN (select(unnest(ARRAY [" + idArray + "])))and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
        IspisReporta.ispisButtonSaSubreportom(sql, this.btnIspis, "UputnicaNr1.jrxml");
    }

    private class ButtonCell
    extends TableCell<Nr1, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    Nr1 ra;
                    int selectdIndex = PregledNR1Controller.this.tablicaPopisNr1Uputnica.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (ra = (Nr1)PregledNR1Controller.this.tablicaPopisNr1Uputnica.getSelectionModel().getSelectedItem()) != null) {
                        Template.getTamplate().showTemplate("nr1/Nr1Obrazac.fxml", "anchorPanel", "/ro2/ro2.css");
                        Nr1ObrazacController.getInstance().izmjenaUputnice(ra);
                        PregledNR1Controller.this.tablicaPopisNr1Uputnica.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PregledNR1Controller.this.tablicaPopisNr1Uputnica.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

