/*
 * Decompiled with CFR 0.152.
 */
package monitoringnovi;

import Utill.DateUtil;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.util.Callback;
import monitoringnovi.BazaMonitoringNovi;
import monitoringnovi.NadzorVAtrogasniAparat;
import org.controlsfx.control.PopOver;
import vatrogasniaparati.UnosVatrogasnogAparataController;
import vatrogasniaparati.VatrogasniAparatPregled;
import zastitanaradu.GlavniPanelController;

public class VatrogasniAparatPopupController
implements Initializable {
    @FXML
    private Label lblLokacija;
    @FXML
    private Label lblNazivObjekta;
    @FXML
    private Label lblPoslovnaJedinica;
    @FXML
    private Label lblAdresa;
    @FXML
    private TableView<VatrogasniAparatPregled> tablicaPregleda;
    @FXML
    private TableColumn<VatrogasniAparatPregled, String> kolNazivPregleda;
    @FXML
    private TableColumn<VatrogasniAparatPregled, LocalDate> kolDatumPregleda;
    @FXML
    private TableColumn<VatrogasniAparatPregled, LocalDate> kolDatumPonovogPegleda;
    @FXML
    private Button btnCancel;
    @FXML
    private Button btnPrikaziVA;
    private NadzorVAtrogasniAparat va;
    ObservableList<VatrogasniAparatPregled> listaOep = FXCollections.observableArrayList();
    private static VatrogasniAparatPopupController instance;
    private PopOver p = null;

    public static VatrogasniAparatPopupController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.urediTablicuPregleda();
        this.btnCancel.setOnAction(e -> this.p.hide());
        this.btnPrikaziVA.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos vatrogasnog aparata")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos vatrogasnog aparata");
                GlavniPanelController.getInstance().nadodajPanel("Unos vatrogasnog aparata", "/vatrogasniaparati/UnosVatrogasnogAparata.fxml");
                UnosVatrogasnogAparataController.getInstance().izmjenaAparata(this.va);
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos vatrogasnog aparata", "/vatrogasniaparati/UnosVatrogasnogAparata.fxml");
                UnosVatrogasnogAparataController.getInstance().izmjenaAparata(this.va);
            }
            UnosVatrogasnogAparataController.getInstance().getTabPanelPodaci().getSelectionModel().select(2);
            this.p.hide();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prikaziVAtrogasniAparat(NadzorVAtrogasniAparat va, PopOver p) {
        this.p = p;
        ResultSet rs = BazaMonitoringNovi.dajVatrogasneAparatePopup(va.getId());
        VatrogasniAparatPregled op = null;
        try {
            while (rs.next()) {
                op = new VatrogasniAparatPregled();
                op.setVrstaPregleda(rs.getString("nazivpregledava"));
                op.setDatumObavljenogPregleda(DateUtil.getLocalDate(rs.getDate("datumpregleda")));
                op.setDatumPonovogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumponovogpregleda")));
                this.listaOep.add((Object)op);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(VatrogasniAparatPopupController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(VatrogasniAparatPopupController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        va.setListaPregleda(this.listaOep);
        this.lblNazivObjekta.setText(va.getOdjel());
        this.lblPoslovnaJedinica.setText(va.getPoslovnajedinica());
        this.lblAdresa.setText(va.getMjestoIAdresa());
        this.lblLokacija.setText(va.getPoblizaLokacija());
        this.listaOep.stream().sorted(Comparator.comparing(VatrogasniAparatPregled::getDatumPonovogIspitivanja, Comparator.nullsFirst(Comparator.naturalOrder())));
        this.tablicaPregleda.setItems(this.listaOep);
        this.va = va;
    }

    private void urediTablicuPregleda() {
        Callback dateCellFactory = param -> new DatumValueCell();
        this.kolNazivPregleda.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).vrstaPregledaProperty());
        this.kolNazivPregleda.prefWidthProperty().bind((ObservableValue)this.tablicaPregleda.widthProperty().divide(3.0303030303030303));
        this.kolNazivPregleda.setStyle("-fx-alignment: CENTER;");
        this.kolDatumPregleda.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).datumObavljenogPregledaProperty());
        this.kolDatumPregleda.prefWidthProperty().bind((ObservableValue)this.tablicaPregleda.widthProperty().divide(3.7037037037037037));
        this.kolDatumPregleda.setStyle("-fx-alignment: CENTER;");
        this.kolDatumPregleda.setCellFactory(dateCellFactory);
        this.kolDatumPonovogPegleda.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).datumPonovogIspitivanjaProperty());
        this.kolDatumPonovogPegleda.prefWidthProperty().bind((ObservableValue)this.tablicaPregleda.widthProperty().divide(2.5641025641025643));
        this.kolDatumPonovogPegleda.setStyle("-fx-alignment: CENTER;");
        this.kolDatumPonovogPegleda.setCellFactory(dateCellFactory);
    }

    class DatumValueCell
    extends TableCell<VatrogasniAparatPregled, LocalDate> {
        DatumValueCell() {
        }

        protected void updateItem(LocalDate item, boolean empty) {
            super.updateItem((Object)item, empty);
            Object lol = null;
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setStyle(null);
                this.setTooltip(null);
            } else if (item == null) {
                this.setText("---");
                this.setStyle(null);
                this.setTooltip(null);
                this.setGraphic(null);
            } else if (item != null) {
                if (this.getTableColumn().getText().equals("Datum pregleda")) {
                    this.setText(item.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                } else {
                    this.izracunaj(item);
                }
            } else {
                this.setText(null);
                this.setGraphic(null);
            }
        }

        private void izracunaj(LocalDate d) {
            Tooltip tip = new Tooltip();
            tip.setStyle("-fx-font-size:12pt;-fx-text-fill:white");
            LocalDate datePocetni = LocalDate.now();
            LocalDate dateEnd = d;
            Period p = Period.between(datePocetni, dateEnd);
            long p2 = ChronoUnit.DAYS.between(datePocetni, dateEnd);
            if (p2 < 0L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, darkgray ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Pro\u0161lo je vi\u0161e od " + p.getYears() + " god. " + p.getMonths() + " mj. ,\n i  " + p.getDays() + " dana od isteka.\n ( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 <= 15L || p2 == 0L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, red ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj.,\n i " + p.getDays() + "  dana do isteka. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 <= 30L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, goldenrod ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do isteka. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 > 30L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, yellowgreen ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do isteka. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else {
                this.setTooltip(null);
                this.setGraphic(null);
                Tooltip.uninstall((Node)this, (Tooltip)tip);
            }
        }
    }
}

