/*
 * Decompiled with CFR 0.152.
 */
package monitoringnovi;

import Utill.DateUtil;
import Utill.KlasaKorisneMetode;
import Utill.Konekcija;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import monitoringnovi.MonitoringNoviController;
import monitoringnovi.NadzorVAtrogasniAparat;
import tvrtka.Tvrtka;
import zastitanaradu.GlavniPanelController;

public class VatrogasniAparatNadzorService
extends Service<ObservableList<NadzorVAtrogasniAparat>> {
    private final MonitoringNoviController mk;

    public VatrogasniAparatNadzorService(MonitoringNoviController mk) {
        this.mk = mk;
    }

    protected Task<ObservableList<NadzorVAtrogasniAparat>> createTask() {
        return new VAtrogasniAparatNadzorTask();
    }

    public void addVatrogasniAparatUI(final ObservableList<NadzorVAtrogasniAparat> listaVA) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                VatrogasniAparatNadzorService.this.mk.setListaVatrogasnihAparata((ObservableList<NadzorVAtrogasniAparat>)listaVA);
            }
        });
    }

    private class VAtrogasniAparatNadzorTask
    extends Task<ObservableList<NadzorVAtrogasniAparat>> {
        private Tvrtka t = GlavniPanelController.getOdabranaTvrtka();
        ObservableList<NadzorVAtrogasniAparat> listaVA = FXCollections.observableArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ObservableList<NadzorVAtrogasniAparat> call() throws Exception {
            Konekcija k = new Konekcija();
            String sql = "SELECT ob.*,\n(SELECT  naziv FROM vrstavatrogasnihaparata where id=ob.vrstaaparata)as vrstaaparatanaziv,\n(SELECT  naziv FROM nazivstroja where id=ob.idstroja),\n  (SELECT  nazivposlovnice FROM poslovnejedinice where id=ob.poslovnajedinica), \n  (SELECT  nazivodjela FROM odjeli where id=ob.odjel),ob.mjestoadresa,\n  ev.* \n  from vatrogasniaparati ob \nleft join  (\n\n\nselect ev.idvatrogasniaparat,ev.idtvrtka,min(datumponovogpregleda)as datumponovogpregleda  \n    from (\n\n        select *\nfrom\n  ( select pregledvatrogasnihaparata.naziv as nazivpregledava,\n  vatrogasniaparatipregled.*,\n           rank() over (partition by idvatrogasniaparat,pregled\n                        order by  datumponovogpregleda desc nulls last , datumkreiranja desc ) as rnk\n    from \n       vatrogasniaparatipregled  \n        LEFT JOIN pregledvatrogasnihaparata on  pregledvatrogasnihaparata.id = vatrogasniaparatipregled.pregled \n  ) as t \nwhere rnk = 1   ORDER  BY  datumponovogpregleda \n    \n    \n\n\n\n    ) \n    ev  group by ev.idvatrogasniaparat,ev.idtvrtka\n\n     )\n    ev on (ev.idvatrogasniaparat = ob.id )\n    \n    where ob.idtvrtka='" + this.t.getId() + "' and rashodovan=false order by datumponovogpregleda ";
            ResultSet rs = k.getResultSet(sql, true);
            KlasaKorisneMetode.ispisiSql(sql);
            try {
                while (rs.next()) {
                    NadzorVAtrogasniAparat va = new NadzorVAtrogasniAparat();
                    va.setId(rs.getInt("id"));
                    va.setSifraAparata(rs.getString("sifraaparata"));
                    va.setNazivAparata(rs.getString("naziv"));
                    va.setProizvodjac(rs.getString("proizvodjac"));
                    va.setModel(rs.getString("model"));
                    va.setTvornickibroj(rs.getString("tvornickibroj"));
                    va.setInventurnibroj(rs.getString("inventurnibroj"));
                    va.setGodinaProizvodnje(rs.getString("godinaproizvodnje"));
                    va.setDatumStavljanjauPogon(DateUtil.getLocalDate(rs.getDate("datumstavljanjauuporabu")));
                    va.setVrstaAparata(rs.getString("vrstaaparatanaziv"));
                    va.setMjestoIAdresa(rs.getString("mjestoadresa"));
                    va.setPoblizaLokacija(rs.getString("oznakalokacije"));
                    va.setAparatUVozilu(rs.getBoolean("aparatuvozilu"));
                    va.setRegistracijaVozila(rs.getString("registracijavozila"));
                    va.setServisnaNaljepnica(rs.getString("servisnanaljepnica"));
                    va.setDatumServisneNaljepnice(DateUtil.getLocalDate(rs.getDate("datumservisnenaljepnice")));
                    va.setNapomena(rs.getString("napomena"));
                    va.setPoslovnajedinica(rs.getString("nazivposlovnice"));
                    va.setOdjel(rs.getString("nazivodjela"));
                    va.setRashodovan(rs.getBoolean("rashodovan"));
                    va.setdatumIstekaPregleda(DateUtil.getLocalDate(rs.getDate("datumponovogpregleda")));
                    this.listaVA.add((Object)va);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(VatrogasniAparatNadzorService.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(VatrogasniAparatNadzorService.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            VatrogasniAparatNadzorService.this.addVatrogasniAparatUI(this.listaVA);
            return this.listaVA;
        }

        private void sortirajStrojTablicu() {
            Map<Object, Object> map = new HashMap();
            ObservableList listaNajmanjihDatuma = FXCollections.observableArrayList();
            for (int i = 0; i < this.listaVA.size(); ++i) {
                if (((NadzorVAtrogasniAparat)this.listaVA.get(i)).getdatumIstekaPregleda() == null) continue;
                listaNajmanjihDatuma.add((Object)((NadzorVAtrogasniAparat)this.listaVA.get(i)).getdatumIstekaPregleda());
                FXCollections.sort((ObservableList)listaNajmanjihDatuma, Comparator.nullsLast(Comparator.naturalOrder()));
                if (listaNajmanjihDatuma.get(0) == null) {
                    map.put(this.listaVA.get(i), listaNajmanjihDatuma.get(1));
                } else {
                    map.put(this.listaVA.get(i), listaNajmanjihDatuma.get(0));
                }
                listaNajmanjihDatuma.clear();
            }
            map = this.sortByValue(map);
            this.listaVA.clear();
            map.forEach((k, v) -> this.listaVA.add(k));
            map.clear();
        }

        public <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
            LinkedHashMap result = new LinkedHashMap();
            Stream st = map.entrySet().stream();
            st.sorted(Comparator.comparing(e -> (Comparable)e.getValue(), Comparator.nullsLast(Comparator.naturalOrder()))).forEachOrdered(e -> {
                Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
            });
            return result;
        }
    }
}

