/*
 * Decompiled with CFR 0.152.
 */
package monitoringnovi;

import Utill.DateUtil;
import Utill.KlasaKorisneMetode;
import Utill.Konekcija;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import monitoring.NadzorMjerniInstrumentPregled;
import monitoringnovi.MonitoringNoviController;
import tvrtka.Tvrtka;
import zastitanaradu.GlavniPanelController;

public class MjerniInstrumentiService
extends Service<ObservableList<NadzorMjerniInstrumentPregled>> {
    private final MonitoringNoviController mk;

    public MjerniInstrumentiService(MonitoringNoviController mk) {
        this.mk = mk;
    }

    protected Task<ObservableList<NadzorMjerniInstrumentPregled>> createTask() {
        return new MjerniInstrumentiNadzorTask();
    }

    private void addStrojUI(final ObservableList<NadzorMjerniInstrumentPregled> listaMjerniInstrumenti) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MjerniInstrumentiService.this.mk.setListaMjerniInstrumenti((ObservableList<NadzorMjerniInstrumentPregled>)listaMjerniInstrumenti);
            }
        });
    }

    class MjerniInstrumentiNadzorTask
    extends Task<ObservableList<NadzorMjerniInstrumentPregled>> {
        private Tvrtka t = GlavniPanelController.getOdabranaTvrtka();
        ObservableList<NadzorMjerniInstrumentPregled> listaMjerniInstrumenti = FXCollections.observableArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ObservableList<NadzorMjerniInstrumentPregled> call() throws Exception {
            Konekcija k = new Konekcija();
            String sql = "select  isp.ispitivanje,uredjaj.* from ( SELECT DISTINCT  nazivstroja.id as uredjajid,    nazivstroja.oznaka,   nazivstroja.naziv,   poslovnejedinice.nazivposlovnice as poslovnajedinica,   odjeli.nazivodjela,   uredjaj.*,    grupastrojeva.naziv as grupastrojevanaziv  FROM   public.uredjaj,  public.poslovnejedinice,   public.odjeli,   public.grupastrojeva,   public.nazivstroja WHERE \n  uredjaj.poslovnajedinica = poslovnejedinice.id AND  uredjaj.odjel = odjeli.id AND  uredjaj.grupastrojeva = grupastrojeva.id AND    nazivstroja.id= uredjaj.iduredjaj ) uredjaj    left join \n    (\n    select max (datumponovogpregleda)as ispitivanje,iduredjaj \n    from uredjajpregled \n    group by iduredjaj  \n    )isp on (isp.iduredjaj = uredjaj.id )\nwhere  idtvrtka='" + this.t.getId() + "'  and rashodovan=false order by ispitivanje ";
            ResultSet rs = k.getResultSet(sql, true);
            KlasaKorisneMetode.ispisiSql(sql);
            NadzorMjerniInstrumentPregled mip = null;
            try {
                while (rs.next()) {
                    mip = new NadzorMjerniInstrumentPregled();
                    mip.setId(rs.getInt("id"));
                    mip.setSifrastroja(rs.getString("oznaka"));
                    mip.setNazivstroja(rs.getString("naziv"));
                    mip.setProizvodjac(rs.getString("proizvodjac"));
                    mip.setModel(rs.getString("model"));
                    mip.setTvornickibroj(rs.getString("tvornickibroj"));
                    mip.setInventurnibroj(rs.getString("inventurnibroj"));
                    mip.setDokazOVlasnistvu(rs.getString("dokumentovlasnistvu"));
                    mip.setGodinaProizvodnje(rs.getString("godinaproizvodnje"));
                    mip.setDatumStavljanjauPogon(DateUtil.getLocalDate(rs.getDate("datumstavljanjaupogon")));
                    mip.setGrupaStroja(rs.getString("grupastrojevanaziv"));
                    mip.setVrstaStroja(rs.getString("vrstastroja"));
                    mip.setNapomena(rs.getString("napomena"));
                    mip.setPoslovnajedinica(rs.getString("poslovnajedinica"));
                    mip.setOdjel(rs.getString("nazivodjela"));
                    mip.setRashodovan(rs.getBoolean("rashodovan"));
                    mip.setVlasnistvo(rs.getString("vlasnistvo"));
                    mip.setdatumIstekaPregleda(DateUtil.getLocalDate(rs.getDate("ispitivanje")));
                    this.listaMjerniInstrumenti.add((Object)mip);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(MjerniInstrumentiNadzorTask.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(MjerniInstrumentiNadzorTask.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            MjerniInstrumentiService.this.addStrojUI((ObservableList<NadzorMjerniInstrumentPregled>)this.listaMjerniInstrumenti);
            return this.listaMjerniInstrumenti;
        }

        private void sortirajMjerniInstrumentiTablicu() {
            Map<Object, Object> map = new HashMap();
            ObservableList listaNajmanjihDatuma = FXCollections.observableArrayList();
            for (int i = 0; i < this.listaMjerniInstrumenti.size(); ++i) {
                if (((NadzorMjerniInstrumentPregled)this.listaMjerniInstrumenti.get(i)).getdatumIstekaPregleda() == null) continue;
                listaNajmanjihDatuma.add((Object)((NadzorMjerniInstrumentPregled)this.listaMjerniInstrumenti.get(i)).getdatumIstekaPregleda());
                FXCollections.sort((ObservableList)listaNajmanjihDatuma, Comparator.nullsLast(Comparator.naturalOrder()));
                if (listaNajmanjihDatuma.get(0) == null) {
                    map.put(this.listaMjerniInstrumenti.get(i), listaNajmanjihDatuma.get(1));
                } else {
                    map.put(this.listaMjerniInstrumenti.get(i), listaNajmanjihDatuma.get(0));
                }
                listaNajmanjihDatuma.clear();
            }
            map = this.sortByValue(map);
            this.listaMjerniInstrumenti.clear();
            map.forEach((k, v) -> this.listaMjerniInstrumenti.add(k));
            map.clear();
        }

        public <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
            LinkedHashMap result = new LinkedHashMap();
            Stream st = map.entrySet().stream();
            st.sorted(Comparator.comparing(e -> (Comparable)e.getValue(), Comparator.nullsLast(Comparator.naturalOrder()))).forEachOrdered(e -> {
                Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
            });
            return result;
        }
    }
}

