/*
 * Decompiled with CFR 0.152.
 */
package monitoring;

import Utill.DateUtil;
import Utill.KlasaKorisneMetode;
import Utill.Konekcija;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import monitoring.BazaMonitoring;
import monitoring.MonitoringController;
import monitoring.NadzorStrojPregled;
import tvrtka.Tvrtka;
import zastitanaradu.GlavniPanelController;

public class StrojNadzorService
extends Service<ObservableList<NadzorStrojPregled>> {
    private final MonitoringController mk;

    public StrojNadzorService(MonitoringController mk) {
        this.mk = mk;
    }

    protected Task<ObservableList<NadzorStrojPregled>> createTask() {
        return new StrojNadzorTask();
    }

    private void addStrojUI(final ObservableList<NadzorStrojPregled> listaStrojeva) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                StrojNadzorService.this.mk.setListaStrojeva((ObservableList<NadzorStrojPregled>)listaStrojeva);
            }
        });
    }

    private class StrojNadzorTask
    extends Task<ObservableList<NadzorStrojPregled>> {
        private Tvrtka t = GlavniPanelController.getOdabranaTvrtka();
        ObservableList<NadzorStrojPregled> listaStrojeva = FXCollections.observableArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ObservableList<NadzorStrojPregled> call() throws Exception {
            Konekcija k = new Konekcija();
            String sql = "SELECT DISTINCT  strojevi.id,  strojevi.nazivstroja, strojevi.model, strojevi.tvornickibroj, strojevi.inventurnibroj, strojevi.godinaproizvodnje, strojevi.datumstavljanjaupogon,  strojevi.vrstastroja,  strojevi.napomena,  strojevi.proizvodjac,  strojevi.sifrastroja, strojevi.rashodovan,  odjeli.nazivodjela as odjel ,  poslovnejedinice.nazivposlovnice as poslovnajedinica,   grupastrojeva.naziv as grupastrojeva,   nazivstroja.naziv,   nazivstroja.oznaka FROM \n  public.strojevi,   public.grupastrojeva,   public.poslovnejedinice,   public.odjeli,   public.nazivstroja WHERE   strojevi.grupastrojeva = grupastrojeva.id AND    strojevi.poslovnajedinica = poslovnejedinice.id AND    strojevi.odjel = odjeli.id AND    nazivstroja.id = strojevi.idstroja and  idtvrtka='" + this.t.getId() + "' and rashodovan=false";
            ResultSet rs = k.getResultSet(sql, true);
            KlasaKorisneMetode.ispisiSql(sql);
            try {
                while (rs.next()) {
                    NadzorStrojPregled se = new NadzorStrojPregled();
                    se.setId(rs.getInt("id"));
                    se.setSifrastroja(rs.getString("oznaka"));
                    se.setNazivstroja(rs.getString("naziv"));
                    se.setProizvodjac(rs.getString("proizvodjac"));
                    se.setModel(rs.getString("model"));
                    se.setTvornickibroj(rs.getString("tvornickibroj"));
                    se.setInventurnibroj(rs.getString("inventurnibroj"));
                    se.setGodinaProizvodnje(rs.getString("godinaproizvodnje"));
                    se.setDatumStavljanjauPogon(DateUtil.getLocalDate(rs.getDate("datumstavljanjaupogon")));
                    se.setGrupaStroja(rs.getString("grupastrojeva"));
                    se.setVrstaStroja(rs.getString("vrstastroja"));
                    se.setNapomena(rs.getString("napomena"));
                    se.setPoslovnajedinica(rs.getString("poslovnajedinica"));
                    se.setOdjel(rs.getString("odjel"));
                    se.setRashodovan(rs.getBoolean("rashodovan"));
                    se.setdatumIstekaPregleda(this.dajDatumIstekaPregleda(rs.getInt("id"), this.t.getId()));
                    this.listaStrojeva.add((Object)se);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(StrojNadzorService.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(StrojNadzorService.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.sortirajStrojTablicu();
            StrojNadzorService.this.addStrojUI((ObservableList<NadzorStrojPregled>)this.listaStrojeva);
            return this.listaStrojeva;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LocalDate dajDatumIstekaPregleda(int idStroja, int idTvrtka) {
            LocalDate datum = null;
            Konekcija k = new Konekcija();
            String sql = "select max (datumponovogpregleda)as ispitivanje from strojpregled where idstroj='" + idStroja + "' and idtvrtka='" + idTvrtka + "'";
            ResultSet rs = k.getResultSet(sql, true);
            KlasaKorisneMetode.ispisiSql(sql);
            try {
                while (rs.next()) {
                    datum = DateUtil.getLocalDate(rs.getDate("ispitivanje"));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return datum;
        }

        private void sortirajStrojTablicu() {
            Map<Object, Object> map = new HashMap();
            ObservableList listaNajmanjihDatuma = FXCollections.observableArrayList();
            for (int i = 0; i < this.listaStrojeva.size(); ++i) {
                if (((NadzorStrojPregled)this.listaStrojeva.get(i)).getdatumIstekaPregleda() == null) continue;
                listaNajmanjihDatuma.add((Object)((NadzorStrojPregled)this.listaStrojeva.get(i)).getdatumIstekaPregleda());
                FXCollections.sort((ObservableList)listaNajmanjihDatuma, Comparator.nullsLast(Comparator.naturalOrder()));
                if (listaNajmanjihDatuma.get(0) == null) {
                    map.put(this.listaStrojeva.get(i), listaNajmanjihDatuma.get(1));
                } else {
                    map.put(this.listaStrojeva.get(i), listaNajmanjihDatuma.get(0));
                }
                listaNajmanjihDatuma.clear();
            }
            map = this.sortByValue(map);
            this.listaStrojeva.clear();
            map.forEach((k, v) -> this.listaStrojeva.add(k));
            map.clear();
        }

        public <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
            LinkedHashMap result = new LinkedHashMap();
            Stream st = map.entrySet().stream();
            st.sorted(Comparator.comparing(e -> (Comparable)e.getValue(), Comparator.nullsLast(Comparator.naturalOrder()))).forEachOrdered(e -> {
                Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
            });
            return result;
        }
    }
}

