/*
 * Decompiled with CFR 0.152.
 */
package monitoring;

import Utill.DateUtil;
import Utill.KlasaKorisneMetode;
import Utill.Konekcija;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import monitoring.MonitoringController;
import monitoring.ObjektNadzor;
import objektiispitivanja.BazaObjektiIspitivanja;
import objektiispitivanja.ObjekatEvidencijaPregleda;
import tvrtka.Tvrtka;
import zastitanaradu.GlavniPanelController;

public class ObjektNadzorService
extends Service<ObservableList<ObjektNadzor>> {
    private final MonitoringController mk;

    public ObjektNadzorService(MonitoringController mk) {
        this.mk = mk;
    }

    protected Task<ObservableList<ObjektNadzor>> createTask() {
        return new ObjektNadzorTask();
    }

    private void addObjektUI(final ObservableList<ObjektNadzor> listaObjekt) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ObjektNadzorService.this.mk.setListaObjekti((ObservableList<ObjektNadzor>)listaObjekt);
            }
        });
    }

    private class ObjektNadzorTask
    extends Task<ObservableList<ObjektNadzor>> {
        private Tvrtka t = GlavniPanelController.getOdabranaTvrtka();
        ObservableList<ObjektNadzor> listaObjekti = FXCollections.observableArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ObservableList<ObjektNadzor> call() throws Exception {
            ResultSet rs = BazaObjektiIspitivanja.dajObjekte(this.t, BazaObjektiIspitivanja.Opcije.otvorene_objekte);
            ObjektNadzor oi = null;
            int br = 1;
            try {
                while (rs.next()) {
                    oi = new ObjektNadzor();
                    oi.setId(rs.getInt("id"));
                    oi.setRedBroj(String.valueOf(br));
                    oi.setPoslovnaJedinica(rs.getString("nazivposlovnice"));
                    oi.setNazivObjekta(rs.getString("nazivodjela"));
                    oi.setAdresa(rs.getString("adresa"));
                    oi.setListaPregleda(this.dohvatiListuObjektiPregled(rs.getInt("id"), this.t.getId()));
                    this.listaObjekti.add((Object)oi);
                    ++br;
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(ObjektNadzorTask.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(ObjektNadzorTask.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.listaObjekti.stream().forEach(on -> on.setDatumPonovogIspitivanja(this.vratiDatumIsteka(on.getListaPregleda())));
            this.sortirajObjektiTablicu();
            ObjektNadzorService.this.addObjektUI((ObservableList<ObjektNadzor>)this.listaObjekti);
            return this.listaObjekti;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObservableList<ObjekatEvidencijaPregleda> dohvatiListuObjektiPregled(int idObjekat, int idTvrtka) {
            ObservableList listaOep = FXCollections.observableArrayList();
            Konekcija k = new Konekcija();
            String sql = "select  DISTINCT ON (idispitivanja)   *    from objektevidencijapregleda LEFT JOIN pregleditvrtke ON objektevidencijapregleda.idispitivanja = pregleditvrtke.id  where idtvrtka='" + idTvrtka + "'and idobjekta='" + idObjekat + "' and datumponovogispitivanja IS NOT NULL ORDER  BY idispitivanja, datumponovogispitivanja  DESC ";
            ResultSet rs = k.getResultSet(sql, true);
            KlasaKorisneMetode.ispisiSql(sql);
            ObjekatEvidencijaPregleda op = null;
            int br = 1;
            try {
                while (rs.next()) {
                    op = new ObjekatEvidencijaPregleda();
                    op.setId(rs.getInt("id"));
                    op.setRedBroj(String.valueOf(br));
                    op.setOznakaIspitivanja(rs.getString("oznaka"));
                    op.setNazivIspitivanja(rs.getString("nazivpregleda"));
                    op.setDatumObavljenogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumobavljenogispitivanja")));
                    op.setDatumPonovogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumponovogispitivanja")));
                    op.setNazivOrganizacijeIspitivanja(rs.getString("ustanova"));
                    op.setBrojZapisnika(rs.getString("brojzapisnika"));
                    op.setNazivDokumenta(rs.getString("dokument"));
                    op.setPodatkeUpisao(rs.getString("podatkeupisao"));
                    listaOep.add((Object)op);
                    ++br;
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(ObjektNadzorTask.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(ObjektNadzorTask.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return listaOep;
        }

        private LocalDate vratiDatumIsteka(ObservableList<ObjekatEvidencijaPregleda> listaPregleda) {
            SortedList sortedList = new SortedList(listaPregleda, (d1, d2) -> {
                if (d1.getDatumPonovogIspitivanja() == null || d2.getDatumPonovogIspitivanja() == null) {
                    return 0;
                }
                return d1.getDatumPonovogIspitivanja().compareTo(d2.getDatumPonovogIspitivanja());
            });
            listaPregleda.setAll((Collection)sortedList);
            if (listaPregleda.size() > 0) {
                return ((ObjekatEvidencijaPregleda)listaPregleda.get(0)).getDatumPonovogIspitivanja();
            }
            return null;
        }

        private void sortirajObjektiTablicu() {
            Map<Object, Object> map = new HashMap();
            ObservableList listaNajmanjihDatuma = FXCollections.observableArrayList();
            for (int i = 0; i < this.listaObjekti.size(); ++i) {
                if (((ObjektNadzor)this.listaObjekti.get(i)).getDatumPonovogIspitivanja() == null) continue;
                listaNajmanjihDatuma.add((Object)((ObjektNadzor)this.listaObjekti.get(i)).getDatumPonovogIspitivanja());
                FXCollections.sort((ObservableList)listaNajmanjihDatuma, Comparator.nullsLast(Comparator.naturalOrder()));
                if (listaNajmanjihDatuma.get(0) == null) {
                    map.put(this.listaObjekti.get(i), listaNajmanjihDatuma.get(1));
                } else {
                    map.put(this.listaObjekti.get(i), listaNajmanjihDatuma.get(0));
                }
                listaNajmanjihDatuma.clear();
            }
            map = this.sortByValue(map);
            this.listaObjekti.clear();
            map.forEach((k, v) -> this.listaObjekti.add(k));
            map.clear();
        }

        public <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
            LinkedHashMap result = new LinkedHashMap();
            Stream st = map.entrySet().stream();
            st.sorted(Comparator.comparing(e -> (Comparable)e.getValue(), Comparator.nullsLast(Comparator.naturalOrder()))).forEachOrdered(e -> {
                Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
            });
            return result;
        }
    }
}

