/*
 * Decompiled with CFR 0.152.
 */
package monitoring;

import Utill.DateUtil;
import Utill.KlasaKorisneMetode;
import Utill.Konekcija;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import kadrovska.BazaDjelatnik;
import kadrovska.DjelatnikOZS;
import kadrovska.DjelatnikOsposobljavanja;
import kadrovska.DjelatnikOstaliPregledi;
import monitoring.BazaMonitoring;
import monitoring.DjelatnikPregled;
import monitoring.MonitoringController;
import tvrtka.Tvrtka;
import zastitanaradu.GlavniPanelController;

public class DjelatnikNadzorService
extends Service<ObservableList<DjelatnikPregled>> {
    private final MonitoringController nadzor;

    DjelatnikNadzorService(MonitoringController nadzor) {
        this.nadzor = nadzor;
    }

    protected Task createTask() {
        return new DjelatnikNadzorTask();
    }

    private void addDjelatnikaUI(final ObservableList<DjelatnikPregled> listaDjelatnika) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DjelatnikNadzorService.this.nadzor.setListaDjelatnika((ObservableList<DjelatnikPregled>)listaDjelatnika);
            }
        });
    }

    public class DjelatnikNadzorTask
    extends Task<ObservableList<DjelatnikPregled>> {
        private final Tvrtka odabranaTvrtka = GlavniPanelController.getOdabranaTvrtka();
        ObservableList<DjelatnikPregled> listaDjelatnika = FXCollections.observableArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ObservableList<DjelatnikPregled> call() throws Exception {
            ResultSet rs = BazaDjelatnik.dajDjelatnike(this.odabranaTvrtka, BazaDjelatnik.Opcije.zaposlene_djelatnike);
            DjelatnikPregled d = null;
            try {
                while (rs.next()) {
                    d = new DjelatnikPregled();
                    d.setId(rs.getInt("id"));
                    d.setIme(rs.getString("ime"));
                    d.setPrezime(rs.getString("prezime"));
                    d.setOIB(rs.getString("oib"));
                    d.setSifraDjelatnika(rs.getString("sifradjelatnika"));
                    d.setPoslovnaJedinica(rs.getString("nazivposlovnice"));
                    d.setOdjel(rs.getString("nazivodjela"));
                    d.setNazivRukovoditelja(rs.getString("nazivrukovoditelja"));
                    d.setRadnoMjesto(rs.getString("radnomjesto"));
                    d.setPur(rs.getBoolean("pur"));
                    d.setDatumPocetkaPUR(DateUtil.getLocalDate(rs.getDate("datumpocetkapur")));
                    d.setDatumZaposlenja(DateUtil.getLocalDate(rs.getDate("datumzaposlenja")));
                    d.setVrstaZaposlenja(rs.getString("vrstazaposlenja"));
                    d.setRadnoVrijeme(rs.getString("radnovrijeme"));
                    d.setStazUTvrtci(rs.getString("stazutvrtci"));
                    d.setStazIzvanTvrtke(rs.getString("stazizvantvrtke"));
                    d.setOdjavljen(rs.getBoolean("odjavljen"));
                    d.setDatumOdjave(DateUtil.getLocalDate(rs.getDate("datumodjave")));
                    d.setRazlogOdjave(rs.getString("razlogodjave"));
                    d.setSpol(rs.getString("spol"));
                    d.setStrucnaSprema(rs.getString("nazivss"));
                    d.setStupanjObrazovanja(rs.getString("nazivso"));
                    d.setDatumRodjenja(DateUtil.getLocalDate(rs.getDate("datumrodjenja")));
                    d.setZanimianje(rs.getString("zanimanje"));
                    d.setMjestoRodjenja(rs.getString("mjestorodjenja"));
                    d.setOpcinaRodjenja(rs.getString("opcinarodjenja"));
                    d.setDrzavaRodjenja(rs.getString("drzava"));
                    d.setMjestoStanovanja(rs.getString("mjestostanovanja"));
                    d.setAdresa(rs.getString("adresa"));
                    d.setImeOca(rs.getString("imeoca"));
                    d.setImeMajke(rs.getString("imemajke"));
                    d.setBrOsobneIskaznice(rs.getString("brojosobne"));
                    d.setBrOsiguraneOsobe(rs.getString("brojosiguraneosobe"));
                    d.setKontaktTelefon(rs.getString("kontakttelefon"));
                    d.setNapomena(rs.getString("napomena"));
                    d.setVelicinaZastitneObuce(rs.getString("velicinaobuce"));
                    d.setVelicinaZastitneOdjece(rs.getString("velicinaodjece"));
                    d.setVelicinaZastiteZaGlavu(rs.getString("velicinazaglavu"));
                    d.setVelicinaRukavica(rs.getString("velicinarukavica"));
                    d.setDatumTrajanjaUgovora(DateUtil.getLocalDate(rs.getDate("datumtrajanjaugovora")));
                    d.setEmail(rs.getString("email"));
                    d.setPbr(rs.getString("pbr"));
                    d.setKcbr(rs.getString("kcbr"));
                    d.setOznakaNKZ(rs.getString("oznakankz"));
                    d.setDatumIstekaLJPregleda(this.dajDatumIstekaPregleda(rs.getInt("id"), this.odabranaTvrtka.getId()));
                    d.setListaOZO(this.dohvatiListuOZO(rs.getInt("id"), this.odabranaTvrtka.getId()));
                    d.setListaOsposobljavanje(this.dohvatiListuOsposobljavanje(rs.getInt("id"), this.odabranaTvrtka.getId()));
                    d.setListaOstaliPregledi(this.dohvatiListuOstaliPregled(rs.getInt("id"), this.odabranaTvrtka.getId()));
                    d.setDatumIzdavanjaUputnice(this.dajDatumObavljenPregled(rs.getString("oib"), this.odabranaTvrtka.getId()));
                    this.listaDjelatnika.add((Object)d);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.listaDjelatnika.stream().forEach(dj -> {
                dj.setOzo(this.vratiDatumIsteka(dj.getListaOZO()));
                dj.setOsposobljavanje(this.vratiDatumOsposobljavanje(dj.getListaOsposobljavanje()));
                dj.setOstaliPregled(this.vratiDatumOstaliPregledi(dj.getListaOstaliPregledi()));
            });
            this.sortirajDjelatnikTablicu();
            DjelatnikNadzorService.this.addDjelatnikaUI((ObservableList<DjelatnikPregled>)this.listaDjelatnika);
            return this.listaDjelatnika;
        }

        public ObservableList<DjelatnikPregled> getListaDjelatnika() {
            return this.listaDjelatnika;
        }

        public void setListaDjelatnika(ObservableList<DjelatnikPregled> listaDjelatnika) {
            this.listaDjelatnika = listaDjelatnika;
        }

        void sortirajDjelatnikTablicu() {
            Map<Object, Object> map = new HashMap();
            ObservableList listaNajmanjihDatuma = FXCollections.observableArrayList();
            for (int i = 0; i < this.listaDjelatnika.size(); ++i) {
                listaNajmanjihDatuma.add((Object)((DjelatnikPregled)this.listaDjelatnika.get(i)).getDatumIstekaLJPregleda());
                listaNajmanjihDatuma.add((Object)((DjelatnikPregled)this.listaDjelatnika.get(i)).getOzo());
                listaNajmanjihDatuma.add((Object)((DjelatnikPregled)this.listaDjelatnika.get(i)).getOstaliPregled());
                listaNajmanjihDatuma.add((Object)((DjelatnikPregled)this.listaDjelatnika.get(i)).getOsposobljavanje());
                FXCollections.sort((ObservableList)listaNajmanjihDatuma, Comparator.nullsLast(Comparator.naturalOrder()));
                if (listaNajmanjihDatuma.get(0) == null) {
                    map.put(this.listaDjelatnika.get(i), listaNajmanjihDatuma.get(1));
                } else {
                    map.put(this.listaDjelatnika.get(i), listaNajmanjihDatuma.get(0));
                }
                listaNajmanjihDatuma.clear();
            }
            map = this.sortByValue(map);
            this.listaDjelatnika.clear();
            map.forEach((k, v) -> this.listaDjelatnika.add(k));
            map.clear();
        }

        public <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
            LinkedHashMap result = new LinkedHashMap();
            Stream st = map.entrySet().stream();
            st.sorted(Comparator.comparing(e -> (Comparable)e.getValue(), Comparator.nullsLast(Comparator.naturalOrder()))).forEachOrdered(e -> {
                Comparable cfr_ignored_0 = (Comparable)result.put(e.getKey(), e.getValue());
            });
            return result;
        }

        private LocalDate vratiDatumIsteka(ObservableList<DjelatnikOZS> listaOZO) {
            SortedList sortedList = new SortedList(listaOZO, (d1, d2) -> {
                if (d1.getDatumIsteka() == null || d2.getDatumIsteka() == null) {
                    return 0;
                }
                return d1.getDatumIsteka().compareTo(d2.getDatumIsteka());
            });
            listaOZO.setAll((Collection)sortedList);
            if (listaOZO.size() > 0) {
                return ((DjelatnikOZS)listaOZO.get(0)).getDatumIsteka();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LocalDate dajDatumIstekaPregleda(int idDjelatnik, int idTvrtka) {
            LocalDate datum = null;
            Konekcija k = new Konekcija();
            String sql = "select max (datumponovogpregleda)as ljecnicki from djelatnikljpregled where iddjelatnik='" + idDjelatnik + "' and idtvrtka='" + idTvrtka + "'";
            ResultSet rs = k.getResultSet(sql, true);
            KlasaKorisneMetode.ispisiSql(sql);
            try {
                while (rs.next()) {
                    datum = DateUtil.getLocalDate(rs.getDate("ljecnicki"));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return datum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObservableList<DjelatnikOZS> dohvatiListuOZO(int idDjelatnik, int idTvrtka) {
            ObservableList ozo = FXCollections.observableArrayList();
            DjelatnikOZS dozs = null;
            Konekcija k = new Konekcija();
            String sql = "select  DISTINCT ON (idozo)  djelatnikozs.id,  djelatnikozs.datumzaduzenja, djelatnikozs.datumisteka,ozs.* from djelatnikozs LEFT JOIN ozs ON djelatnikozs.idozo = ozs.id  where idtvrtka='" + idTvrtka + "'and iddjelatnik='" + idDjelatnik + "' and datumisteka is not null ORDER  BY idozo, datumisteka DESC";
            ResultSet rs = k.getResultSet(sql, true);
            KlasaKorisneMetode.ispisiSql(sql);
            try {
                while (rs.next()) {
                    dozs = new DjelatnikOZS();
                    dozs.setId(rs.getInt("id"));
                    dozs.setOznakaOZS(rs.getString("oznaka"));
                    dozs.setNazivOZS(rs.getString("naziv"));
                    dozs.setDatumZaduzenja(DateUtil.getLocalDate(rs.getDate("datumzaduzenja")));
                    dozs.setDatumIsteka(DateUtil.getLocalDate(rs.getDate("datumisteka")));
                    ozo.add((Object)dozs);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return ozo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LocalDate dajDatumObavljenPregled(String oib, int idTvrtka) {
            LocalDate datum = null;
            Konekcija k = new Konekcija();
            String sql = "select DISTINCT ON (1) oib, pregledobavljen,datumizdavanjauputnice from ra1uputnica where  pregledobavljen=false and  idtvrtka='" + idTvrtka + "' and oib='" + oib + "'";
            ResultSet rs = k.getResultSet(sql, true);
            KlasaKorisneMetode.ispisiSql(sql);
            try {
                while (rs.next()) {
                    datum = DateUtil.getLocalDate(rs.getDate("datumizdavanjauputnice"));
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return datum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObservableList<DjelatnikOsposobljavanja> dohvatiListuOsposobljavanje(int idDjelatnik, int idTvrtka) {
            ObservableList osposobljavanje = FXCollections.observableArrayList();
            DjelatnikOsposobljavanja d = null;
            Konekcija k = new Konekcija();
            String sql = "select  DISTINCT ON (idosposobljavanja) djelatnikosposobljavanja.id,datumteorija,datumizdavanja, datumisteka ,osposobljavanja.* from djelatnikosposobljavanja LEFT JOIN osposobljavanja ON djelatnikosposobljavanja.idosposobljavanja = osposobljavanja.id   where idtvrtka='" + idTvrtka + "'and iddjelatnik='" + idDjelatnik + "' and datumisteka IS NOT NULL ORDER BY idosposobljavanja, datumisteka DESC";
            ResultSet rs = k.getResultSet(sql, true);
            KlasaKorisneMetode.ispisiSql(sql);
            try {
                while (rs.next()) {
                    d = new DjelatnikOsposobljavanja();
                    d.setId(rs.getInt("id"));
                    d.setOznaka(rs.getString("oznaka"));
                    d.setNazivOsposobljavanja(rs.getString("nazivosposobljavanja"));
                    d.setDatumTeorija(DateUtil.getLocalDate(rs.getDate("datumteorija")));
                    d.setDatumIzdavanja(DateUtil.getLocalDate(rs.getDate("datumizdavanja")));
                    d.setDatumIsteka(DateUtil.getLocalDate(rs.getDate("datumisteka")));
                    osposobljavanje.add((Object)d);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return osposobljavanje;
        }

        private LocalDate vratiDatumOsposobljavanje(ObservableList<DjelatnikOsposobljavanja> listaOsposobljavanje) {
            SortedList sortedList = new SortedList(listaOsposobljavanje, (d1, d2) -> {
                if (d1.getDatumIsteka() == null || d2.getDatumIsteka() == null) {
                    return 0;
                }
                return d1.getDatumIsteka().compareTo(d2.getDatumIsteka());
            });
            listaOsposobljavanje.setAll((Collection)sortedList);
            if (listaOsposobljavanje.size() > 0) {
                return ((DjelatnikOsposobljavanja)listaOsposobljavanje.get(0)).getDatumIsteka();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObservableList<DjelatnikOstaliPregledi> dohvatiListuOstaliPregled(int idDjelatnik, int idTvrtka) {
            ObservableList dop = FXCollections.observableArrayList();
            DjelatnikOstaliPregledi dozs = null;
            Konekcija k = new Konekcija();
            String sql = "select  DISTINCT ON (idostalipregled) djelatnikostalipregled.id, datumpregleda, datumisteka ,ostalipregled.naziv,ostalipregled.oznaka from djelatnikostalipregled LEFT JOIN ostalipregled ON djelatnikostalipregled.idostalipregled = ostalipregled.id   where djelatnikostalipregled.idtvrtka='" + idTvrtka + "'and djelatnikostalipregled.iddjelatnik='" + idDjelatnik + "' and datumisteka is not null ORDER  BY idostalipregled, datumisteka DESC";
            ResultSet rs = k.getResultSet(sql, true);
            KlasaKorisneMetode.ispisiSql(sql);
            try {
                while (rs.next()) {
                    dozs = new DjelatnikOstaliPregledi();
                    dozs.setId(rs.getInt("id"));
                    dozs.setOznaka(rs.getString("oznaka"));
                    dozs.setNazivPregleda(rs.getString("naziv"));
                    dozs.setDatumIzdavanja(DateUtil.getLocalDate(rs.getDate("datumpregleda")));
                    dozs.setDatumIsteka(DateUtil.getLocalDate(rs.getDate("datumisteka")));
                    dop.add((Object)dozs);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(BazaMonitoring.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            return dop;
        }

        private LocalDate vratiDatumOstaliPregledi(ObservableList<DjelatnikOstaliPregledi> listaOstaliPregledi) {
            SortedList sortedList = new SortedList(listaOstaliPregledi, (d1, d2) -> {
                if (d1.getDatumIsteka() == null || d2.getDatumIsteka() == null) {
                    return 0;
                }
                return d1.getDatumIsteka().compareTo(d2.getDatumIsteka());
            });
            listaOstaliPregledi.setAll((Collection)sortedList);
            if (listaOstaliPregledi.size() > 0) {
                return ((DjelatnikOstaliPregledi)listaOstaliPregledi.get(0)).getDatumIsteka();
            }
            return null;
        }
    }
}

