/*
 * Decompiled with CFR 0.152.
 */
package monitoring;

import java.net.URL;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import kadrovska.DjelatnikOZS;
import kadrovska.UnosDjelatnikaController;
import monitoring.DjelatnikPregled;
import org.controlsfx.control.PopOver;
import zastitanaradu.GlavniPanelController;

public class DatumPopupController
implements Initializable {
    @FXML
    private AnchorPane paneZaglavlje;
    @FXML
    private Label lblImePrezime;
    @FXML
    private Label lblOdjel;
    @FXML
    private Label lblPoslovnica;
    @FXML
    private TableView<DjelatnikOZS> tablicaOZO;
    @FXML
    private TableColumn<DjelatnikOZS, String> kolNaziv;
    @FXML
    private TableColumn<DjelatnikOZS, LocalDate> kolDatumZaduzenja;
    @FXML
    private TableColumn<DjelatnikOZS, LocalDate> kolDatumIsteka;
    @FXML
    private Button btnPrikaziDjelatnika;
    @FXML
    private Button btnCancel;
    private DjelatnikPregled dp;
    private ObservableList<DjelatnikOZS> listaDjelatnikOZS = FXCollections.observableArrayList();
    private static DatumPopupController instance;
    private PopOver p = null;

    public DjelatnikPregled getDp() {
        return this.dp;
    }

    public void setDp(DjelatnikPregled dp) {
        this.dp = dp;
    }

    public static DatumPopupController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.urediTablicuOZO();
        this.btnCancel.setOnAction(e -> this.p.hide());
        this.btnPrikaziDjelatnika.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Djelatnika")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos Djelatnika");
                GlavniPanelController.getInstance().nadodajPanel("Unos Djelatnika", "/kadrovska/UnosDjelatnika.fxml");
                UnosDjelatnikaController.getInstance().izmjenaDjelatnika(this.dp);
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos Djelatnika", "/kadrovska/UnosDjelatnika.fxml");
                UnosDjelatnikaController.getInstance().izmjenaDjelatnika(this.dp);
            }
            UnosDjelatnikaController.getInstance().getTabPanePodaci().getSelectionModel().select(3);
            this.p.hide();
        });
    }

    private void urediTablicuOZO() {
        Callback dateCellFactory = param -> new DatumValueCell();
        this.kolNaziv.setCellValueFactory(cellData -> ((DjelatnikOZS)cellData.getValue()).NazivOZSProperty());
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaOZO.widthProperty().divide(2.5));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolDatumZaduzenja.setCellValueFactory(cellData -> ((DjelatnikOZS)cellData.getValue()).datumZaduzenjaProperty());
        this.kolDatumZaduzenja.prefWidthProperty().bind((ObservableValue)this.tablicaOZO.widthProperty().divide(3.3333333333333335));
        this.kolDatumZaduzenja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumZaduzenja.setCellFactory(dateCellFactory);
        this.kolDatumIsteka.setCellValueFactory(cellData -> ((DjelatnikOZS)cellData.getValue()).datumIstekaProperty());
        this.kolDatumIsteka.prefWidthProperty().bind((ObservableValue)this.tablicaOZO.widthProperty().divide(3.4482758620689653));
        this.kolDatumIsteka.setStyle("-fx-alignment: CENTER;");
        this.kolDatumIsteka.setCellFactory(dateCellFactory);
    }

    public void prikaziDjelatnika(DjelatnikPregled dp, PopOver p) {
        this.p = p;
        this.dp = dp;
        this.lblImePrezime.setText(dp.getIme() + " " + dp.getPrezime());
        this.lblPoslovnica.setText(dp.getPoslovnaJedinica());
        this.lblOdjel.setText(dp.getOdjel());
        this.listaDjelatnikOZS = dp.getListaOZO();
        this.tablicaOZO.setItems(this.listaDjelatnikOZS);
    }

    class DatumValueCell
    extends TableCell<DjelatnikOZS, LocalDate> {
        DatumValueCell() {
        }

        protected void updateItem(LocalDate item, boolean empty) {
            super.updateItem((Object)item, empty);
            Object lol = null;
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setStyle(null);
                this.setTooltip(null);
            } else if (item == null) {
                this.setText("---");
                this.setStyle(null);
                this.setTooltip(null);
                this.setGraphic(null);
            } else if (item != null) {
                if (this.getTableColumn().getText().equals("Datum zadu\u017eenja")) {
                    this.setText(item.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                } else {
                    this.izracunaj(item);
                }
            } else {
                this.setText(null);
                this.setGraphic(null);
            }
        }

        private void izracunaj(LocalDate d) {
            Tooltip tip = new Tooltip();
            tip.setStyle("-fx-font-size:12pt;-fx-text-fill:white");
            LocalDate datePocetni = LocalDate.now();
            LocalDate dateEnd = d;
            Period p = Period.between(datePocetni, dateEnd);
            long p2 = ChronoUnit.DAYS.between(datePocetni, dateEnd);
            if (p2 < 0L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, darkgray ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Pro\u0161lo je vi\u0161e od " + p.getYears() + " god. " + p.getMonths() + " mj. ,\n i  " + p.getDays() + " dana od isteka.\n ( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 <= 15L || p2 == 0L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, red ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj.,\n i " + p.getDays() + "  dana do isteka. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 <= 30L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, goldenrod ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do isteka. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else if (p2 > 30L) {
                this.setStyle("-fx-background-color:-fx-table-cell-border-color, yellowgreen ;-fx-background-insets: 0, 0 0 1 0; -fx-padding: 0.0em; -fx-alignment: CENTER;");
                this.setText(d.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
                tip.setText("Preostalo jo\u0161 " + p.getYears() + " god. " + p.getMonths() + " mj,\n i " + p.getDays() + "  dana do isteka. \n( ukupno  " + p2 + "  dana )");
                this.setTooltip(tip);
                this.setGraphic(null);
            } else {
                this.setTooltip(null);
                this.setGraphic(null);
                Tooltip.uninstall((Node)this, (Tooltip)tip);
            }
        }
    }
}

