/*
 * Decompiled with CFR 0.152.
 */
package mjerniinstrumenti;

import Utill.ComboBoxCellDokument;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import Utill.ScanDokument;
import Utill.TextAreaTableCell;
import dokumentiTvrtke.BazaDokumenti;
import dokumentiTvrtke.DokumentHiperlinkCell;
import ispitivanja.PopisIspitivanjaController;
import java.io.File;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javafx.util.StringConverter;
import kadrovska.BazaDjelatnik;
import kadrovska.Djelatnik;
import kadrovska.UnosDjelatnikaController;
import mjerniinstrumenti.BazaMjerniUredjaj;
import mjerniinstrumenti.ComboBoxCellZaduzeneOsobe;
import mjerniinstrumenti.HBoxDokument;
import mjerniinstrumenti.MjerniInstrumentEvidencija;
import mjerniinstrumenti.MjerniInstrumentPodaci;
import mjerniinstrumenti.PopisMjernihUredjajaController;
import mjerniinstrumenti.UredjajZaduzeneOsobe;
import monitoringnovi.ServiceRestart;
import odjeli.BazaOdjeli;
import poslovnejedinice.PoslovneJedinice;
import radnaoprema.UnosStrojevaController;
import strojevi.Strojevi;
import zastitanaradu.GlavniPanelController;

public class UnosMjernogInstrumentaController
implements Initializable {
    @FXML
    private Button btnDialogNazivUredjaja;
    @FXML
    private TextField txtGodinaProizvodnje;
    @FXML
    private ComboBox<String> cBoxVlasnistvo;
    @FXML
    private Button btnSpremi;
    @FXML
    private AnchorPane anchorPanelStroj;
    @FXML
    private TextField txtSifraStroja;
    @FXML
    private TextField txtNazivStroja;
    @FXML
    private ComboBox<PoslovneJedinice> cBoxPoslovnaJedinica;
    @FXML
    private ComboBox<String> cBoxOdjel;
    @FXML
    private TabPane tabPanePodaci;
    @FXML
    private ComboBox<String> cboxProizvodjac;
    @FXML
    private ComboBox<String> cboxModel;
    @FXML
    private ComboBox<String> cboxGrupaStroja;
    @FXML
    private ComboBox<String> cBoxVrstaStroja;
    @FXML
    private TextField txtInventurniBroj;
    @FXML
    private TextField txtTvornickiBroj;
    @FXML
    private TextArea txtAreaNapomena;
    @FXML
    private DatePicker dateStavljanjeUPogon;
    @FXML
    private CheckBox chBoxRazduzen;
    @FXML
    private Tab tabZaduzeneOsobe;
    @FXML
    private TableView<UredjajZaduzeneOsobe> tablicaZaduzeneOsobe;
    @FXML
    private TableColumn<UredjajZaduzeneOsobe, String> kolRedBrZO;
    @FXML
    private TableColumn<UredjajZaduzeneOsobe, String> kolSifra;
    @FXML
    private TableColumn<UredjajZaduzeneOsobe, String> kolNaziv;
    @FXML
    private Button btnUnosZOsobe;
    @FXML
    private Button btnBrisanjeZOsobe;
    @FXML
    private Button btnIspisZOsobe;
    @FXML
    private Tab tabEvidencijaPregleda;
    @FXML
    private Button btnUnosPStroja;
    @FXML
    private Button btnBrisanjePStroja;
    @FXML
    private Button btnIspisMM;
    @FXML
    private TableView<MjerniInstrumentEvidencija> tablicaEvidencijaPregleda;
    @FXML
    private TableColumn<MjerniInstrumentEvidencija, String> kolRedBrPregledStroja;
    @FXML
    private TableColumn<MjerniInstrumentEvidencija, LocalDate> kolDatumObavljenogIspitivanja;
    @FXML
    private TableColumn<MjerniInstrumentEvidencija, String> kolOrganizacija;
    @FXML
    private TableColumn<MjerniInstrumentEvidencija, String> kolBrojIsprave;
    @FXML
    private TableColumn<MjerniInstrumentEvidencija, LocalDate> kolDatumIzdavanja;
    @FXML
    private TableColumn<MjerniInstrumentEvidencija, String> kolUvjeti;
    @FXML
    private TableColumn<MjerniInstrumentEvidencija, LocalDate> kolDatumPonovogIspitivanja;
    @FXML
    private TableColumn<MjerniInstrumentEvidencija, String> kolDokument;
    @FXML
    private TableColumn<MjerniInstrumentEvidencija, String> kolPodatkeUpisao;
    @FXML
    private TableColumn<MjerniInstrumentEvidencija, String> kolPodatkeOdobrio;
    @FXML
    private Tab tabDokumenti;
    @FXML
    private TextField txtOpis;
    @FXML
    private TableView<ScanDokument> tablicaDokumenti;
    @FXML
    private TableColumn<ScanDokument, String> kolRedBr;
    @FXML
    private TableColumn<ScanDokument, String> kolNazivDokumenta;
    @FXML
    private Button btnSpremiDokument;
    @FXML
    private Button btnBrisanjeDokument;
    @FXML
    private HBox hBoxDokument;
    private static UnosMjernogInstrumentaController instance;
    private final ObservableList<String> listaVlasnistvo = FXCollections.observableArrayList((Object[])new String[]{"Vlastiti", "Najam"});
    private final ObservableList<String> listaVrstaStroja = FXCollections.observableArrayList((Object[])new String[]{"Fiksni", "Mobilni"});
    private ObservableList<ScanDokument> listaDokumenti = FXCollections.observableArrayList();
    private ObservableList<MjerniInstrumentEvidencija> listaUredjajUmjeravanje = FXCollections.observableArrayList();
    private ObservableList<UredjajZaduzeneOsobe> listaUredjajZaduzeneOsobe = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private Boolean izmjenaUrjedjaja = false;
    BooleanProperty bp = new SimpleBooleanProperty(false);
    private MjerniInstrumentPodaci mi = null;

    public TabPane getTabPanePodaci() {
        return this.tabPanePodaci;
    }

    public static UnosMjernogInstrumentaController getInstance() {
        return instance;
    }

    public MjerniInstrumentPodaci getMjerniInstrumentPodaci() {
        return this.mi;
    }

    public void setMjerniInstrumentPodaci(MjerniInstrumentPodaci mi) {
        this.mi = mi;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtOpis);
        this.cBoxVlasnistvo.getItems().addAll(this.listaVlasnistvo);
        this.cBoxVrstaStroja.getItems().addAll(this.listaVrstaStroja);
        this.popuniCBoxPoslovnice();
        this.cBoxPoslovnaJedinica.valueProperty().addListener((o, ov, nv) -> {
            PoslovneJedinice p = nv;
            this.popuniOdjelePoslovneJedinice(p.getId());
        });
        this.popuniCBoxProizvodjac();
        this.cboxProizvodjac.valueProperty().addListener((o, ov, nv) -> this.popuniCBoxModel((String)nv));
        this.popuniCBoxGrupaStrojeva();
        this.urediHBoxDokument();
        this.tabDokumenti.disableProperty().bind((ObservableValue)this.bp.not());
        this.tabEvidencijaPregleda.disableProperty().bind((ObservableValue)this.bp.not());
        this.tabZaduzeneOsobe.disableProperty().bind((ObservableValue)this.bp.not());
        this.urediZablicuZaduzeneOsobe();
        this.popuniTablicuZaduzeneOsobe();
        this.urediTblicuEvidencijaPregleda();
        this.popuniTablicuEvidencijaPregleda();
        this.urediKoloneUTabliciDokumenti();
        this.popuniTablicuDokumenti();
        this.btnBrisanjeDokument.disableProperty().bind((ObservableValue)Bindings.equal((ObservableNumberValue)this.tablicaDokumenti.getSelectionModel().selectedIndexProperty(), (int)-1));
        this.btnBrisanjeDokument.setOnAction(event -> {
            int selectedIdx = this.tablicaDokumenti.getSelectionModel().getSelectedIndex();
            ScanDokument sc = (ScanDokument)this.tablicaDokumenti.getSelectionModel().getSelectedItem();
            Alert alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje Dokumenta", "\u017delite li obrisati dokument ?");
            Optional result = alert.showAndWait();
            if (selectedIdx != -1) {
                if (result.get() == ButtonType.OK) {
                    if (BazaDokumenti.deleteDokument(sc)) {
                        this.popuniTablicuDokumenti();
                    } else {
                        Alert error = FxDialogs.getDialog(Alert.AlertType.ERROR, "Brisanje dokumenta", "Neuspjelo brisanje dokumenta");
                        error.showAndWait();
                    }
                } else {
                    this.tablicaDokumenti.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnSpremiDokument.setOnAction(e -> {
            block6: {
                boolean bopis = FormValidation.textFieldValidationonlyText(this.txtOpis);
                if (bopis) {
                    FileChooser fileChooser = new FileChooser();
                    File selectedFile = fileChooser.showOpenDialog(null);
                    if (selectedFile != null) {
                        try {
                            byte[] byteImage = KlasaKorisneMetode.ImageToByte(new File(selectedFile.getAbsolutePath()));
                            if (BazaDokumenti.addDokumentUredjaj(this.txtOpis.getText() + " (" + LocalDate.now().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)) + ")." + KlasaKorisneMetode.getExtension(selectedFile), GlavniPanelController.getOdabranaTvrtka(), this.mi.getId(), byteImage, GlavniPanelController.getInstance().getKorisnik().punoIme())) {
                                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen dokument", 1, "Information graphic");
                                this.txtOpis.clear();
                                this.popuniTablicuDokumenti();
                                break block6;
                            }
                            KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen dokument", 2, "Error graphic");
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti naziv Dokumenta");
                    alert.showAndWait();
                }
            }
        });
        this.btnUnosZOsobe.setOnAction(e -> {
            UredjajZaduzeneOsobe zo = new UredjajZaduzeneOsobe();
            if (BazaMjerniUredjaj.unesiNovuZaduzenuOsobu(zo, GlavniPanelController.getOdabranaTvrtka().getId(), this.mi.getId())) {
                this.popuniTablicuZaduzeneOsobe();
            } else {
                FxDialogs.showError("Gre\u0161ka unosa", "Neuspje\u0161an unos osobe");
            }
        });
        this.btnBrisanjeZOsobe.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaZaduzeneOsobe.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati djelatnika")).showAndWait()).get() == ButtonType.OK) {
                if (BazaMjerniUredjaj.obrisiZaduzenuOsobu((UredjajZaduzeneOsobe)this.tablicaZaduzeneOsobe.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuZaduzeneOsobe();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no brisanje ", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no brisanje", 2, "Error graphic");
                }
            }
        });
        this.btnUnosPStroja.setOnAction(e -> {
            MjerniInstrumentEvidencija m = new MjerniInstrumentEvidencija();
            m.setPodatkeUpisao(GlavniPanelController.getInstance().getKorisnik().punoIme());
            if (BazaMjerniUredjaj.unesiNoviUredjajPregled(m, GlavniPanelController.getOdabranaTvrtka().getId(), this.mi.getId())) {
                this.popuniTablicuEvidencijaPregleda();
            } else {
                FxDialogs.showError("Gre\u0161ka unosa", "Neuspje\u0161an unos pregleda");
            }
        });
        this.btnBrisanjePStroja.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaEvidencijaPregleda.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati  pregled")).showAndWait()).get() == ButtonType.OK) {
                if (BazaMjerniUredjaj.obrisiUredjajPregled((MjerniInstrumentEvidencija)this.tablicaEvidencijaPregleda.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuEvidencijaPregleda();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no brisanje ", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no brisanje", 2, "Error graphic");
                }
            }
        });
        this.btnSpremi.setOnAction(e -> this.spremiUredjaj());
        this.btnDialogNazivUredjaja.setOnAction(e -> {
            Strojevi st = FxDialogs.getDialogNazivStrojeva();
            if (st != null) {
                this.txtNazivStroja.setText(st.getNaziv());
                this.txtSifraStroja.setText(st.getOznaka());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniOdjelePoslovneJedinice(int idPoslovneJedinice) {
        this.cBoxOdjel.getItems().clear();
        ResultSet rs = BazaOdjeli.dajOdjel(GlavniPanelController.getOdabranaTvrtka(), idPoslovneJedinice);
        try {
            while (rs.next()) {
                this.cBoxOdjel.getItems().add((Object)rs.getString("nazivodjela"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosMjernogInstrumentaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosMjernogInstrumentaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void postaviPoslovnicu(String naziv) {
        this.cBoxPoslovnaJedinica.setValue(this.cBoxPoslovnaJedinica.getConverter().fromString(naziv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniCBoxPoslovnice() {
        final ObservableMap map = FXCollections.observableHashMap();
        ResultSet rs = BazaDjelatnik.dajPoslovnujednicu(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                PoslovneJedinice pj = new PoslovneJedinice();
                pj.setId(rs.getInt("id"));
                pj.setNazivPoslovnice(rs.getString("nazivposlovnice"));
                pj.setAdresaPoslovnice(rs.getString("adresa"));
                pj.setMjesto(rs.getString("mjesto"));
                map.put((Object)rs.getString("nazivposlovnice"), (Object)pj);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cBoxPoslovnaJedinica.getItems().addAll(map.values());
        this.cBoxPoslovnaJedinica.setConverter((StringConverter)new StringConverter<PoslovneJedinice>(){

            public String toString(PoslovneJedinice t) {
                if (t != null) {
                    String str = t.getNazivPoslovnice();
                    map.put((Object)str, (Object)t);
                    return str;
                }
                return "";
            }

            public PoslovneJedinice fromString(String string) {
                if (!map.containsKey((Object)string)) {
                    UnosMjernogInstrumentaController.this.cBoxPoslovnaJedinica.setValue(null);
                    UnosMjernogInstrumentaController.this.cBoxPoslovnaJedinica.getEditor().clear();
                    return null;
                }
                return (PoslovneJedinice)map.get((Object)string);
            }
        });
        this.cBoxPoslovnaJedinica.setCellFactory((Callback)new Callback<ListView<PoslovneJedinice>, ListCell<PoslovneJedinice>>(){

            public ListCell<PoslovneJedinice> call(ListView<PoslovneJedinice> p) {
                ListCell<PoslovneJedinice> cell = new ListCell<PoslovneJedinice>(){

                    protected void updateItem(PoslovneJedinice item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setText("");
                        } else {
                            this.setText(item.getNazivPoslovnice());
                            this.setAlignment(Pos.CENTER);
                            this.setPadding(new Insets(3.0, 3.0, 3.0, 0.0));
                        }
                    }
                };
                return cell;
            }
        });
    }

    private void popuniCBoxProizvodjac() {
        ResultSet rs = BazaMjerniUredjaj.dajProizvodjace(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                this.cboxProizvodjac.getItems().add((Object)rs.getString("nazivproizvodjaca"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosMjernogInstrumentaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosMjernogInstrumentaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniCBoxModel(String proizvodjac) {
        this.cboxModel.getItems().clear();
        ResultSet rs = BazaMjerniUredjaj.dajProizvodjace(GlavniPanelController.getOdabranaTvrtka(), proizvodjac);
        try {
            while (rs.next()) {
                this.cboxModel.getItems().add((Object)rs.getString("tip"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void popuniCBoxGrupaStrojeva() {
        ResultSet rs = BazaMjerniUredjaj.dajGrupeStrojeva(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                this.cboxGrupaStroja.getItems().add((Object)rs.getString("naziv"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosMjernogInstrumentaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosMjernogInstrumentaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void urediKoloneUTabliciDokumenti() {
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaDokumenti.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolNazivDokumenta.setCellValueFactory((Callback)new PropertyValueFactory("opisDokumenta"));
        this.kolNazivDokumenta.prefWidthProperty().bind((ObservableValue)this.tablicaDokumenti.widthProperty().divide(1.1235955056179776));
        this.kolNazivDokumenta.setStyle("-fx-alignment: CENTER;");
        Callback cellScanDokument = param -> new DokumentHiperlinkCell(this.listaDokumenti);
        this.kolNazivDokumenta.setCellFactory(cellScanDokument);
    }

    private void popuniTablicuDokumenti() {
        this.tablicaDokumenti.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskDokumenti();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaDokumenti.clear();
        this.tablicaDokumenti.getItems().clear();
    }

    private Task createTaskDokumenti() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(UnosMjernogInstrumentaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    UnosMjernogInstrumentaController.this.popuniTablicuDokumentiizBaze();
                }
                finally {
                    Platform.runLater(() -> UnosMjernogInstrumentaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void popuniTablicuDokumentiizBaze() {
        int br = 1;
        ResultSet rs = BazaDokumenti.getDokumentiUredjaj(GlavniPanelController.getOdabranaTvrtka().getId(), this.mi.getId());
        try {
            while (rs.next()) {
                ScanDokument cd = new ScanDokument();
                cd.setId(rs.getInt("id"));
                cd.setRedBroj(String.valueOf(br));
                cd.setOpisDokumenta(rs.getString("naziv"));
                this.listaDokumenti.add((Object)cd);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.tablicaDokumenti.getItems().addAll(this.listaDokumenti);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void urediZablicuZaduzeneOsobe() {
        this.kolRedBrZO.setCellValueFactory(cellData -> ((UredjajZaduzeneOsobe)cellData.getValue()).redBrojProperty());
        this.kolRedBrZO.prefWidthProperty().bind((ObservableValue)this.tablicaZaduzeneOsobe.widthProperty().divide(10.0));
        this.kolRedBrZO.setStyle("-fx-alignment: CENTER;");
        ObservableList listaDjelatnika = FXCollections.observableArrayList();
        ObservableList listaSifraOsobe = FXCollections.observableArrayList();
        ObservableList listaNazivOsobe = FXCollections.observableArrayList();
        ResultSet rs = BazaDjelatnik.dajDjelatnike(GlavniPanelController.getOdabranaTvrtka(), BazaDjelatnik.Opcije.zaposlene_djelatnike);
        try {
            while (rs.next()) {
                Djelatnik d = new Djelatnik();
                d.setSifraDjelatnika(rs.getString("sifradjelatnika"));
                d.setIme(rs.getString("ime"));
                d.setPrezime(rs.getString("prezime"));
                listaDjelatnika.add((Object)d);
                listaSifraOsobe.add((Object)rs.getString("sifradjelatnika"));
                listaNazivOsobe.add((Object)(rs.getString("ime") + " " + rs.getString("prezime")));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosMjernogInstrumentaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosMjernogInstrumentaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Callback comboCellFactoryPrezime = param -> new ComboBoxCellZaduzeneOsobe((ObservableList<Djelatnik>)listaDjelatnika, "prezime");
        Callback comboCellFactorySifra = param -> new ComboBoxCellZaduzeneOsobe((ObservableList<Djelatnik>)listaDjelatnika, "sifra");
        this.kolSifra.setCellValueFactory(cellData -> ((UredjajZaduzeneOsobe)cellData.getValue()).sifraOsobeProperty());
        this.kolSifra.prefWidthProperty().bind((ObservableValue)this.tablicaZaduzeneOsobe.widthProperty().divide(5.0));
        this.kolSifra.setStyle("-fx-alignment: CENTER;");
        this.kolSifra.setCellFactory(comboCellFactorySifra);
        this.kolSifra.setOnEditCommit(t -> ((UredjajZaduzeneOsobe)t.getTableView().getItems().get(t.getTablePosition().getRow())).setSifraOsobe((String)t.getNewValue()));
        this.kolNaziv.setCellValueFactory(cellData -> ((UredjajZaduzeneOsobe)cellData.getValue()).nazivOsobeProperty());
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaZaduzeneOsobe.widthProperty().divide(1.4285714285714286));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellFactory(comboCellFactoryPrezime);
        this.kolNaziv.setOnEditCommit(t -> ((UredjajZaduzeneOsobe)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivOsobe((String)t.getNewValue()));
    }

    private void popuniTablicuZaduzeneOsobe() {
        this.tablicaZaduzeneOsobe.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskUredjajZO();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaUredjajZaduzeneOsobe.clear();
        this.tablicaZaduzeneOsobe.getItems().clear();
    }

    private Task createTaskUredjajZO() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(UnosMjernogInstrumentaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    UnosMjernogInstrumentaController.this.popuniTablicuZaduzeneOsobePodaci();
                }
                finally {
                    Platform.runLater(() -> UnosMjernogInstrumentaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuZaduzeneOsobePodaci() {
        ResultSet rs = BazaMjerniUredjaj.dajUredjajZaduzeneOsobe(GlavniPanelController.getOdabranaTvrtka().getId(), this.mi.getId());
        UredjajZaduzeneOsobe zo = null;
        int br = 1;
        try {
            while (rs.next()) {
                zo = new UredjajZaduzeneOsobe();
                zo.setId(rs.getInt("id"));
                zo.setRedBroj(String.valueOf(br));
                zo.setNazivOsobe(rs.getString("nazivosobe"));
                zo.setSifraOsobe(rs.getString("sifraosobe"));
                this.listaUredjajZaduzeneOsobe.add((Object)zo);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosMjernogInstrumentaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosMjernogInstrumentaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaZaduzeneOsobe.setItems(this.listaUredjajZaduzeneOsobe);
    }

    private void urediTblicuEvidencijaPregleda() {
        this.tablicaEvidencijaPregleda.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE && UnosMjernogInstrumentaController.this.tablicaEvidencijaPregleda.getEditingCell() == null) {
                    UnosMjernogInstrumentaController.this.tablicaEvidencijaPregleda.getSelectionModel().clearSelection();
                    e.consume();
                }
            }
        });
        this.kolRedBrPregledStroja.setCellValueFactory(cellData -> ((MjerniInstrumentEvidencija)cellData.getValue()).redBrojProperty());
        this.kolRedBrPregledStroja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(20.0));
        this.kolRedBrPregledStroja.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory = param -> new DateCell();
        Label l1 = new Label("Datum \n obavljenog \n umjeravanja");
        this.kolDatumObavljenogIspitivanja.setGraphic((Node)l1);
        this.kolDatumObavljenogIspitivanja.setCellValueFactory(cellData -> ((MjerniInstrumentEvidencija)cellData.getValue()).datumObavljenogIspitivanjaProperty());
        this.kolDatumObavljenogIspitivanja.setCellFactory(dateCellFactory);
        this.kolDatumObavljenogIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolDatumObavljenogIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumObavljenogIspitivanja.setOnEditCommit(t -> {
            ((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumObavljenogIspitivanja((LocalDate)t.getNewValue());
            BazaMjerniUredjaj.unesiPromjenuUredjajPregled((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Label l2 = new Label("Naziv \n organizacije koja \n je obavila \n umjeravanje");
        this.kolOrganizacija.setGraphic((Node)l2);
        this.kolOrganizacija.setCellValueFactory(cellData -> ((MjerniInstrumentEvidencija)cellData.getValue()).nazivOrganizacijeIspitivanjaProperty());
        this.kolOrganizacija.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolOrganizacija.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolOrganizacija.setStyle("-fx-alignment: CENTER;");
        this.kolOrganizacija.setOnEditCommit(t -> {
            ((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivOrganizacijeIspitivanja((String)t.getNewValue());
            BazaMjerniUredjaj.unesiPromjenuUredjajPregled((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Label l3 = new Label("Broj isprave \n umjeravanja");
        this.kolBrojIsprave.setGraphic((Node)l3);
        this.kolBrojIsprave.setCellValueFactory(cellData -> ((MjerniInstrumentEvidencija)cellData.getValue()).brojIspraveProperty());
        this.kolBrojIsprave.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolBrojIsprave.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(12.5));
        this.kolBrojIsprave.setStyle("-fx-alignment: CENTER;");
        this.kolBrojIsprave.setOnEditCommit(t -> {
            ((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow())).setBrojIsprave((String)t.getNewValue());
            BazaMjerniUredjaj.unesiPromjenuUredjajPregled((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Label l3a = new Label("Datum \n izdavanja isprave \n o umjeravanju");
        this.kolDatumIzdavanja.setGraphic((Node)l3a);
        this.kolDatumIzdavanja.setCellValueFactory(cellData -> ((MjerniInstrumentEvidencija)cellData.getValue()).datumIzdavanjaIspraveProperty());
        this.kolDatumIzdavanja.setCellFactory(dateCellFactory);
        this.kolDatumIzdavanja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolDatumIzdavanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumIzdavanja.setOnEditCommit(t -> {
            ((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumIzdavanjaIsprave((LocalDate)t.getNewValue());
            BazaMjerniUredjaj.unesiPromjenuUredjajPregled((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Label l4 = new Label("Vrsta rada na \n ure\u0111aju (pregled \n ppopravaka,pode\u0161avanje...)");
        this.kolUvjeti.setGraphic((Node)l4);
        this.kolUvjeti.setCellValueFactory(cellData -> ((MjerniInstrumentEvidencija)cellData.getValue()).vrstaRadaNaUredjajuProperty());
        this.kolUvjeti.setCellFactory(TextAreaTableCell.forTableColumn());
        this.kolUvjeti.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolUvjeti.setStyle("-fx-alignment: CENTER;");
        this.kolUvjeti.setOnEditCommit(t -> {
            ((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow())).setVrstaRadaNaUredjaju((String)t.getNewValue());
            BazaMjerniUredjaj.unesiPromjenuUredjajPregled((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Label l5 = new Label("Datum \n ponovog \n umjeravanja");
        this.kolDatumPonovogIspitivanja.setGraphic((Node)l5);
        this.kolDatumPonovogIspitivanja.setCellValueFactory(cellData -> ((MjerniInstrumentEvidencija)cellData.getValue()).datumPonovogIspitivanjaProperty());
        this.kolDatumPonovogIspitivanja.setCellFactory(dateCellFactory);
        this.kolDatumPonovogIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolDatumPonovogIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumPonovogIspitivanja.setOnEditCommit(t -> {
            ((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumPonovogIspitivanja((LocalDate)t.getNewValue());
            BazaMjerniUredjaj.unesiPromjenuUredjajPregled((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow()));
            ServiceRestart.restartService(ServiceRestart.RService.mjerni_uredjaj);
        });
        Callback cellDokument = param -> new ComboBoxCellDokument(this.listaDokumenti);
        Label l6 = new Label("Dokument");
        this.kolDokument.setGraphic((Node)l6);
        this.kolDokument.setCellValueFactory(cellData -> ((MjerniInstrumentEvidencija)cellData.getValue()).nazivDokumentaProperty());
        this.kolDokument.setCellFactory(cellDokument);
        this.kolDokument.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(6.666666666666667));
        this.kolDokument.setStyle("-fx-alignment: CENTER;");
        this.kolDokument.setOnEditCommit(t -> {
            ((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivDokumenta((String)t.getNewValue());
            BazaMjerniUredjaj.unesiPromjenuUredjajPregled((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Label l8 = new Label("Odobrio \n Ime prezime");
        this.kolPodatkeOdobrio.setGraphic((Node)l8);
        this.kolPodatkeOdobrio.setCellValueFactory(cellData -> ((MjerniInstrumentEvidencija)cellData.getValue()).podatkeOdobrioProperty());
        this.kolPodatkeOdobrio.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolPodatkeOdobrio.setStyle("-fx-alignment: CENTER;");
        this.kolPodatkeOdobrio.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolPodatkeOdobrio.setOnEditCommit(t -> {
            ((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow())).setPodatkeOdobrio((String)t.getNewValue());
            BazaMjerniUredjaj.unesiPromjenuUredjajPregled((MjerniInstrumentEvidencija)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        Label l7 = new Label("Ime iPrezime \n radnika koji je \n upisao podatke u \n evidenciju");
        this.kolPodatkeUpisao.setGraphic((Node)l7);
        this.kolPodatkeUpisao.setCellValueFactory(cellData -> ((MjerniInstrumentEvidencija)cellData.getValue()).podatkeUpisaoProperty());
        this.kolPodatkeUpisao.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(6.666666666666667));
        this.kolPodatkeUpisao.setStyle("-fx-alignment: CENTER;");
    }

    public void popuniTablicuEvidencijaPregleda() {
        this.tablicaEvidencijaPregleda.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskStrojPregled();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaUredjajUmjeravanje.clear();
        this.tablicaEvidencijaPregleda.getItems().clear();
    }

    private Task createTaskStrojPregled() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisIspitivanjaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    UnosMjernogInstrumentaController.this.popuniTablicuPodatkeEvidencijaPregleda();
                }
                finally {
                    Platform.runLater(() -> UnosMjernogInstrumentaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuPodatkeEvidencijaPregleda() {
        ResultSet rs = BazaMjerniUredjaj.dajUredjajPreglede(GlavniPanelController.getOdabranaTvrtka().getId(), this.mi.getId());
        MjerniInstrumentEvidencija mip = null;
        int br = 1;
        try {
            while (rs.next()) {
                mip = new MjerniInstrumentEvidencija();
                mip.setId(rs.getInt("id"));
                mip.setRedBroj(String.valueOf(br));
                mip.setDatumObavljenogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumobavljenogispitivanja")));
                mip.setNazivOrganizacijeIspitivanja(rs.getString("nazivorganizacije"));
                mip.setBrojIsprave(rs.getString("brojispitivanja"));
                mip.setDatumIzdavanjaIsprave(DateUtil.getLocalDate(rs.getDate("datumispitivanja")));
                mip.setVrstaRadaNaUredjaju(rs.getString("vrstaradanauredjaju"));
                mip.setDatumPonovogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumponovogpregleda")));
                mip.setNazivDokumenta(rs.getString("dokument"));
                mip.setPodatkeOdobrio(rs.getString("podatkeodobrio"));
                mip.setPodatkeUpisao(rs.getString("podatkeupisao"));
                this.listaUredjajUmjeravanje.add((Object)mip);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaEvidencijaPregleda.setItems(this.listaUredjajUmjeravanje);
    }

    private void spremiUredjaj() {
        boolean bSifraStroja = FormValidation.textFieldValidationonlyText(this.txtSifraStroja);
        boolean bNazivStroja = FormValidation.textFieldValidationonlyText(this.txtNazivStroja);
        boolean bPoslovnica = FormValidation.comboBoxValidationText(this.cBoxPoslovnaJedinica);
        boolean bOdjel = FormValidation.comboBoxValidationText(this.cBoxOdjel);
        boolean bGrupaStroja = FormValidation.comboBoxValidationText(this.cboxGrupaStroja);
        if (bSifraStroja & bNazivStroja & bGrupaStroja & bPoslovnica & bOdjel) {
            if (this.izmjenaUrjedjaja.booleanValue()) {
                if (BazaMjerniUredjaj.izmjenaUredjaja(GlavniPanelController.getOdabranaTvrtka(), this.dajUredjaj(), this.mi.getId())) {
                    if (!GlavniPanelController.getInstance().getTabByIdifExist("Mjerni instrumenti")) {
                        PopisMjernihUredjajaController.getInstance().popuniTablicuPopisUredaja();
                    }
                    GlavniPanelController.getInstance().zatvoriTab("Unos ure\u0111aja");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena ure\u0111aja", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena ure\u0111aja", 2, "Error graphic");
                }
            } else if (BazaMjerniUredjaj.unesiNoviUredjaj(GlavniPanelController.getOdabranaTvrtka(), this.dajUredjaj())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen stroja", 1, "Information graphic");
                PopisMjernihUredjajaController.getInstance().popuniTablicuPopisUredaja();
                GlavniPanelController.getInstance().zatvoriTab("Unos ure\u0111aja");
                this.izmjenaUrjedjaja = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen ure\u0111aj", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti sva oznacena polja");
            alert.showAndWait();
        }
    }

    private MjerniInstrumentPodaci dajUredjaj() {
        MjerniInstrumentPodaci mip = new MjerniInstrumentPodaci();
        mip.setSifrastroja(this.txtSifraStroja.getText());
        mip.setNazivstroja(this.txtNazivStroja.getText());
        mip.setPoslovnajedinica(((PoslovneJedinice)this.cBoxPoslovnaJedinica.getValue()).getNazivPoslovnice());
        mip.setOdjel((String)this.cBoxOdjel.getValue());
        mip.setProizvodjac((String)this.cboxProizvodjac.getValue());
        mip.setModel((String)this.cboxModel.getValue());
        mip.setInventurnibroj(this.txtInventurniBroj.getText());
        mip.setTvornickibroj(this.txtTvornickiBroj.getText());
        mip.setGodinaProizvodnje(this.txtGodinaProizvodnje.getText());
        mip.setDatumStavljanjauPogon((LocalDate)this.dateStavljanjeUPogon.getValue());
        mip.setGrupaStroja((String)this.cboxGrupaStroja.getValue());
        mip.setVrstaStroja((String)this.cBoxVrstaStroja.getValue());
        mip.setNapomena(this.txtAreaNapomena.getText());
        mip.setRashodovan(this.chBoxRazduzen.isSelected());
        mip.setDokazOVlasnistvu(HBoxDokument.getLink());
        mip.setVlasnistvo((String)this.cBoxVlasnistvo.getValue());
        return mip;
    }

    public void izmjenaUredjaja(MjerniInstrumentPodaci mip) {
        this.izmjenaUrjedjaja = true;
        this.bp.set(true);
        this.mi = mip;
        this.txtSifraStroja.setText(mip.getSifrastroja());
        this.txtNazivStroja.setText(mip.getNazivstroja());
        this.postaviPoslovnicu(mip.getPoslovnajedinica());
        this.cBoxOdjel.setValue((Object)mip.getOdjel());
        this.cboxProizvodjac.setValue((Object)mip.getProizvodjac());
        this.cboxModel.setValue((Object)mip.getModel());
        this.txtInventurniBroj.setText(mip.getInventurnibroj());
        this.txtTvornickiBroj.setText(mip.getTvornickibroj());
        this.txtGodinaProizvodnje.setText(mip.getGodinaProizvodnje());
        this.dateStavljanjeUPogon.setValue((Object)mip.getDatumStavljanjauPogon());
        this.cboxGrupaStroja.setValue((Object)mip.getGrupaStroja());
        this.cBoxVrstaStroja.setValue((Object)mip.getVrstaStroja());
        this.txtAreaNapomena.setText(mip.getNapomena());
        this.chBoxRazduzen.setSelected(mip.isRashodovan());
        HBoxDokument.getH().setText(mip.getDokazOVlasnistvu());
        this.cBoxVlasnistvo.setValue((Object)mip.getVlasnistvo());
    }

    private void urediHBoxDokument() {
        this.hBoxDokument.setStyle("-fx-border-width: 2;\n    -fx-border-color: #046272");
        this.hBoxDokument.getChildren().addAll((Object[])new Node[]{new HBoxDokument(this.listaDokumenti)});
    }
}

