/*
 * Decompiled with CFR 0.152.
 */
package mjerniinstrumenti;

import TamplatePaneli.Template;
import Utill.DateUtil;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import filter.MenuButtonReporti;
import ispisJasper.IspisJasperButtonSaSubreportom;
import ispisJasper.IspisJasperMenuButtonSaSubreportom;
import ispisJasper.JRPrintPreview;
import ispisJasper.JasperViewerFX;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.util.Callback;
import mjerniinstrumenti.BazaMjerniUredjaj;
import mjerniinstrumenti.MjerniInstrumentPodaci;
import mjerniinstrumenti.UnosMjernogInstrumentaController;
import net.sf.jasperreports.engine.JasperPrint;
import zastitanaradu.GlavniPanelController;

public class PopisMjernihUredjajaController
implements Initializable {
    @FXML
    private Button btnIspis;
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<MjerniInstrumentPodaci> tablicaPopisUredaja;
    @FXML
    private TableColumn<MjerniInstrumentPodaci, String> kolPretraga;
    @FXML
    private TableColumn<MjerniInstrumentPodaci, String> kolInvBroj;
    @FXML
    private TableColumn<MjerniInstrumentPodaci, String> kolTvBroj;
    @FXML
    private TableColumn<MjerniInstrumentPodaci, String> kolRedBr;
    @FXML
    private TableColumn<MjerniInstrumentPodaci, String> kolSifraUredaja;
    @FXML
    private TableColumn<MjerniInstrumentPodaci, String> kolNazivUredaja;
    @FXML
    private TableColumn<MjerniInstrumentPodaci, String> kolPoslovnica;
    private static PopisMjernihUredjajaController instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<MjerniInstrumentPodaci> listaUredaja = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();

    public static PopisMjernihUredjajaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFIlter();
        this.urediTablicuPopisUredaja();
        this.popuniTablicuPopisUredaja();
        this.urediFilter(this.tablicaPopisUredaja);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos ure\u0111aja")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos ure\u0111aja");
                GlavniPanelController.getInstance().nadodajPanel("Unos ure\u0111aja", "/mjerniinstrumenti/UnosMjernogInstrumenta.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos ure\u0111aja", "/mjerniinstrumenti/UnosMjernogInstrumenta.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            MjerniInstrumentPodaci se;
            int selectdIndex = this.tablicaPopisUredaja.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (se = (MjerniInstrumentPodaci)this.tablicaPopisUredaja.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos ure\u0111aja")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos ure\u0111aja");
                    GlavniPanelController.getInstance().nadodajPanel("Unos ure\u0111aja", "/mjerniinstrumenti/UnosMjernogInstrumenta.fxml");
                    UnosMjernogInstrumentaController.getInstance().izmjenaUredjaja(se);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos ure\u0111aja", "/mjerniinstrumenti/UnosMjernogInstrumenta.fxml");
                    UnosMjernogInstrumentaController.getInstance().izmjenaUredjaja(se);
                }
                this.tablicaPopisUredaja.getSelectionModel().clearSelection();
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisUredaja.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati ure\u0111aj")).showAndWait()).get() == ButtonType.OK) {
                if (BazaMjerniUredjaj.obrisiUredaj((MjerniInstrumentPodaci)this.tablicaPopisUredaja.getSelectionModel().getSelectedItem(), GlavniPanelController.getOdabranaTvrtka())) {
                    this.popuniTablicuPopisUredaja();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan ure\u0111aj", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan ure\u0111aj", 2, "Error graphic");
                }
            }
        });
        this.btnIspis.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisUredaja.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.ispisKartonUredjaja((ObservableList<MjerniInstrumentPodaci>)this.tablicaPopisUredaja.getSelectionModel().getSelectedItems());
            }
        });
    }

    private void kreirajToolBarFIlter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Tv. broj", "Inv. broj", "\u0160ifra ure\u0111aja", "Naziv ure\u0111aja", "Poslovna jedinica"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Inv. broj");
        this.cbFilter.setPrefWidth(200.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter, this.getMenuButton(), MenuButtonReporti.getMenuButtonMjerniUredjajiIspis()});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaUredaja, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("\u0160ifra ure\u0111aja") ? pregled.getSifrastroja() != null && pregled.getSifrastroja().toLowerCase().startsWith(this.tfilter.getText().toLowerCase()) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv ure\u0111aja") ? pregled.getNazivstroja() != null && pregled.getNazivstroja().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") ? pregled.getPoslovnajedinica() != null && pregled.getPoslovnajedinica().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Inv. broj") ? pregled.getInventurnibroj() != null && pregled.getInventurnibroj().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Tv. broj") && pregled.getTvornickibroj() != null && pregled.getTvornickibroj().toLowerCase().startsWith(lowerCaseFilter))));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private MenuButton getMenuButtonIspis() {
        MenuButton ispis = new MenuButton("Izvje\u0161taji");
        MenuItem sviUUporabi = new MenuItem("Ispis svih ");
        sviUUporabi.setOnAction(event -> {});
        MenuItem sviRashodovani = new MenuItem("Ispis svih rashodovanih ure\u0111aja");
        sviRashodovani.setOnAction(event -> {});
        MenuItem kartonUredjaja = new MenuItem("Ispi\u0161i karton ure\u0111aja");
        kartonUredjaja.setOnAction(event -> {
            String sql = "SELECT \n  odjeli.nazivodjela, \n  poslovnejedinice.nazivposlovnice, \n  uredjaj.id, \n  uredjaj.nazivuredjaja, \n  uredjaj.model, \n  uredjaj.tvornickibroj, \n  uredjaj.inventurnibroj, \n  uredjaj.godinaproizvodnje, \n  uredjaj.datumstavljanjaupogon, \n  uredjaj.napomena, \n  uredjaj.podatkeupisao, \n  uredjaj.datumkreiranja, \n  uredjaj.proizvodjac, \n  uredjaj.dokumentovlasnistvu, \n  uredjaj.idtvrtka, \n  uredjaj.sifrauredjaja, \n  uredjaj.rashodovan, \n  uredjaj.vlasnistvo, \n  grupastrojeva.naziv, \n  uredjaj.vrstastroja\nFROM \n  public.uredjaj, \n  public.odjeli, \n  public.poslovnejedinice, \n  public.grupastrojeva\nWHERE \n  uredjaj.odjel = odjeli.id AND\n  uredjaj.poslovnajedinica = poslovnejedinice.id AND\n  uredjaj.grupastrojeva = grupastrojeva.id and rashodovan=false   and  idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "' ";
            final IspisJasperMenuButtonSaSubreportom wb = new IspisJasperMenuButtonSaSubreportom(ispis, sql, "MjerniInstrumenti.jrxml");
            wb.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

                public void handle(WorkerStateEvent t) {
                    if (wb.getValue() != null) {
                        JRPrintPreview printPreview = new JRPrintPreview((JasperPrint)wb.getValue());
                        printPreview.show();
                    }
                }
            });
            wb.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

                public void handle(WorkerStateEvent t) {
                    System.out.println("Connection error.");
                }
            });
            new Thread((Runnable)((Object)wb)).start();
        });
        Menu men = new Menu("Ispis svih djelatnika");
        men.getItems().addAll((Object[])new MenuItem[]{sviUUporabi, sviRashodovani});
        ispis.getItems().addAll((Object[])new MenuItem[]{men, new SeparatorMenuItem(), kartonUredjaja});
        return ispis;
    }

    private MenuButton getMenuButton() {
        MenuItem m1 = new MenuItem("Prikazi sve ure\u0111aje");
        m1.setOnAction(event -> this.popuniTablicuPopisUredaja(BazaMjerniUredjaj.Opcije.sve_uredaje));
        MenuItem m2 = new MenuItem("Prikazi ure\u0111aje u uporabi");
        m2.setOnAction(event -> this.popuniTablicuPopisUredaja(BazaMjerniUredjaj.Opcije.uredaje_u_uporabi));
        MenuItem m3 = new MenuItem("Prikazi rashodovane ure\u0111aje");
        m3.setOnAction(event -> this.popuniTablicuPopisUredaja(BazaMjerniUredjaj.Opcije.rashodovane_uredaje));
        MenuButton mb = new MenuButton("Pregled ure\u0111aja", null, new MenuItem[]{m1, m2, m3});
        return mb;
    }

    private void urediTablicuPopisUredaja() {
        this.tablicaPopisUredaja.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisUredaja.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisMjernihUredjajaController.this.tablicaPopisUredaja.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((MjerniInstrumentPodaci)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisUredaja.widthProperty().divide(20.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolInvBroj.setCellValueFactory(cellData -> ((MjerniInstrumentPodaci)cellData.getValue()).inventurnibrojProperty());
        this.kolInvBroj.prefWidthProperty().bind((ObservableValue)this.tablicaPopisUredaja.widthProperty().divide(10.0));
        this.kolInvBroj.setStyle("-fx-alignment: CENTER;");
        this.kolTvBroj.setCellValueFactory(cellData -> ((MjerniInstrumentPodaci)cellData.getValue()).tvornickibrojProperty());
        this.kolTvBroj.prefWidthProperty().bind((ObservableValue)this.tablicaPopisUredaja.widthProperty().divide(10.0));
        this.kolTvBroj.setStyle("-fx-alignment: CENTER;");
        this.kolSifraUredaja.setCellValueFactory(cellData -> ((MjerniInstrumentPodaci)cellData.getValue()).sifrastrojaProperty());
        this.kolSifraUredaja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisUredaja.widthProperty().divide(10.0));
        this.kolSifraUredaja.setStyle("-fx-alignment: CENTER;");
        this.kolNazivUredaja.setCellValueFactory(cellData -> ((MjerniInstrumentPodaci)cellData.getValue()).nazivstrojaProperty());
        this.kolNazivUredaja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisUredaja.widthProperty().divide(2.857142857142857));
        this.kolNazivUredaja.setStyle("-fx-alignment: CENTER;");
        this.kolPoslovnica.setCellValueFactory(cellData -> ((MjerniInstrumentPodaci)cellData.getValue()).poslovnajedinicaProperty());
        this.kolPoslovnica.prefWidthProperty().bind((ObservableValue)this.tablicaPopisUredaja.widthProperty().divide(5.0));
        this.kolPoslovnica.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledDjelatnika = new TableColumn("Pregled");
        kolPregledDjelatnika.setSortable(false);
        kolPregledDjelatnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisUredaja.widthProperty().divide(10.0));
        kolPregledDjelatnika.setStyle("-fx-alignment: CENTER;");
        kolPregledDjelatnika.setCellFactory((Callback)new Callback<TableColumn<MjerniInstrumentPodaci, Boolean>, TableCell<MjerniInstrumentPodaci, Boolean>>(){

            public TableCell<MjerniInstrumentPodaci, Boolean> call(TableColumn<MjerniInstrumentPodaci, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledDjelatnika);
        this.tablicaPopisUredaja.setItems(this.listaUredaja);
    }

    public void popuniTablicuPopisUredaja(BazaMjerniUredjaj.Opcije opcija) {
        this.tablicaPopisUredaja.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task<Void> task = this.createTask(opcija);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaUredaja.clear();
        this.tablicaPopisUredaja.getItems().clear();
    }

    public void popuniTablicuPopisUredaja() {
        this.tablicaPopisUredaja.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task<Void> task = this.createTask(BazaMjerniUredjaj.Opcije.uredaje_u_uporabi);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaUredaja.clear();
        this.tablicaPopisUredaja.getItems().clear();
    }

    private Task<Void> createTask(final BazaMjerniUredjaj.Opcije opcija) {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisMjernihUredjajaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaMjerniUredjaj.dajUredaje(GlavniPanelController.getOdabranaTvrtka(), opcija);
                    Platform.runLater(() -> PopisMjernihUredjajaController.this.popuniTablicuUredaja(rs));
                }
                finally {
                    Platform.runLater(() -> PopisMjernihUredjajaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuUredaja(ResultSet rs) {
        MjerniInstrumentPodaci mip = null;
        int br = 1;
        try {
            while (rs.next()) {
                mip = new MjerniInstrumentPodaci();
                mip.setId(rs.getInt("id"));
                mip.setRedBroj(String.valueOf(br));
                mip.setSifrastroja(rs.getString("oznaka"));
                mip.setNazivstroja(rs.getString("naziv"));
                mip.setProizvodjac(rs.getString("proizvodjac"));
                mip.setModel(rs.getString("model"));
                mip.setTvornickibroj(rs.getString("tvornickibroj"));
                mip.setInventurnibroj(rs.getString("inventurnibroj"));
                mip.setDokazOVlasnistvu(rs.getString("dokumentovlasnistvu"));
                mip.setGodinaProizvodnje(rs.getString("godinaproizvodnje"));
                mip.setDatumStavljanjauPogon(DateUtil.getLocalDate(rs.getDate("datumstavljanjaupogon")));
                mip.setGrupaStroja(rs.getString("grupastrojeva"));
                mip.setVrstaStroja(rs.getString("vrstastroja"));
                mip.setNapomena(rs.getString("napomena"));
                mip.setPoslovnajedinica(rs.getString("nazivposlovnice"));
                mip.setOdjel(rs.getString("nazivodjela"));
                mip.setRashodovan(rs.getBoolean("rashodovan"));
                mip.setVlasnistvo(rs.getString("vlasnistvo"));
                this.listaUredaja.add((Object)mip);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisMjernihUredjajaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisMjernihUredjajaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void ispisKartonUredjaja(ObservableList<MjerniInstrumentPodaci> listaMjerniInstrumenti) {
        String idArray = "";
        for (int i = 0; i < listaMjerniInstrumenti.size(); ++i) {
            idArray = i == 0 ? idArray + String.valueOf(((MjerniInstrumentPodaci)listaMjerniInstrumenti.get(i)).getId()) : idArray + "," + String.valueOf(((MjerniInstrumentPodaci)listaMjerniInstrumenti.get(i)).getId());
        }
        String sql = "SELECT \n  odjeli.nazivodjela, \n  poslovnejedinice.nazivposlovnice, \n  uredjaj.*,  \n  grupastrojeva.naziv\n \nFROM \n  public.uredjaj, \n  public.odjeli, \n  public.poslovnejedinice, \n  public.grupastrojeva\nWHERE \n  uredjaj.odjel = odjeli.id AND\n  uredjaj.poslovnajedinica = poslovnejedinice.id AND\n  uredjaj.grupastrojeva = grupastrojeva.id    and uredjaj.id IN (select(unnest(ARRAY [" + idArray + "])))  and  idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
        final IspisJasperButtonSaSubreportom wb = new IspisJasperButtonSaSubreportom(this.btnIspis, sql, "MjerniInstrumenti.jrxml");
        wb.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                if (wb.getValue() != null) {
                    JasperViewerFX viewer = new JasperViewerFX(new Stage(), ((JasperPrint)wb.getValue()).getName(), (JasperPrint)wb.getValue());
                    viewer.show();
                }
            }
        });
        wb.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                System.out.println("Connection error.");
            }
        });
        new Thread((Runnable)((Object)wb)).start();
    }

    private class ButtonCell
    extends TableCell<MjerniInstrumentPodaci, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    MjerniInstrumentPodaci se;
                    int selectdIndex = PopisMjernihUredjajaController.this.tablicaPopisUredaja.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (se = (MjerniInstrumentPodaci)PopisMjernihUredjajaController.this.tablicaPopisUredaja.getSelectionModel().getSelectedItem()) != null) {
                        GlavniPanelController.getInstance().setBlurEfekt(new GaussianBlur(10.0));
                        Template.getTamplate().showTemplate("mjerniinstrumenti/UnosMjernogInstrumenta.fxml", "anchorPanelStroj");
                        UnosMjernogInstrumentaController.getInstance().izmjenaUredjaja(se);
                        PopisMjernihUredjajaController.this.tablicaPopisUredaja.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PopisMjernihUredjajaController.this.tablicaPopisUredaja.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

