/*
 * Decompiled with CFR 0.152.
 */
package mjerniinstrumenti;

import Utill.ComboBoxCellDokument;
import Utill.FxDialogs;
import Utill.FxUtilTest;
import Utill.KlasaKorisneMetode;
import Utill.ScanDokument;
import dokumentiTvrtke.BazaDokumenti;
import java.awt.Desktop;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ListCell;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.ComboBoxListCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class HBoxDokument
extends VBox {
    private ScanDokument sd = null;
    private File temp = null;
    private ComboBox<ScanDokument> comboBox;
    private ObservableList<ScanDokument> listaDokumentiCombo = FXCollections.observableArrayList();
    private ProgressIndicator progressPane = new ProgressIndicator();
    static Hyperlink h;
    private BazaDokumenti bd;
    private Image img = new Image("/resorces/icon/15/dokumentPlus24.png");
    private ImageView imgView = new ImageView(this.img);
    private HBox hb = new HBox();
    private Button btnZajednickiDokumenti = null;

    public static String getLink() {
        return h.getText();
    }

    public static Hyperlink getH() {
        return h;
    }

    public static void setH(Hyperlink h) {
        HBoxDokument.h = h;
    }

    public HBoxDokument(ObservableList<ScanDokument> listaDokumenti) {
        this.listaDokumentiCombo = listaDokumenti;
        this.btnZajednickiDokumenti = new Button();
        this.btnZajednickiDokumenti.setId("btnPlus");
        this.btnZajednickiDokumenti.setTooltip(new Tooltip("Odaberite dokument iz zajedni\u010dkih dokumenata"));
        this.btnZajednickiDokumenti.setOnAction(e -> {
            ScanDokument sd = FxDialogs.getDokumentiDijalog();
            if (sd != null) {
                this.listaDokumentiCombo.add((Object)sd);
            }
        });
        this.setSpacing(1.0);
        this.hb.getChildren().addAll((Object[])new Node[]{this.getHiperLink("")});
        this.getChildren().addAll((Object[])new Node[]{new HBox(new Node[]{this.imgView, this.getComboBox(), this.btnZajednickiDokumenti}), this.hb});
        this.setStyle("-fx-alignment: CENTER;");
        this.progressPane.setPrefSize(25.0, 25.0);
    }

    public HBoxDokument() {
        this.btnZajednickiDokumenti = new Button();
        this.btnZajednickiDokumenti.setId("btnPlus");
        this.btnZajednickiDokumenti.setTooltip(new Tooltip("Odaberite dokument iz zajedni\u010dkih dokumenata"));
        this.btnZajednickiDokumenti.setOnAction(e -> {
            ScanDokument sd = FxDialogs.getDokumentiDijalog();
            if (sd != null) {
                this.listaDokumentiCombo.add((Object)sd);
            }
        });
        this.setSpacing(1.0);
        this.hb.getChildren().addAll((Object[])new Node[]{this.getHiperLink("")});
        this.getChildren().addAll((Object[])new Node[]{new HBox(new Node[]{this.imgView, this.getComboBox(), this.btnZajednickiDokumenti}), this.hb});
        this.setStyle("-fx-alignment: CENTER;");
        this.progressPane.setPrefSize(25.0, 25.0);
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(ComboBoxCellDokument.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.prikaziDokument();
                    this.updateMessage("Running...");
                }
                finally {
                    Platform.runLater(() -> HBoxDokument.this.hb.getChildren().remove((Object)HBoxDokument.this.progressPane));
                }
                return null;
            }

            private void prikaziDokument() {
                try {
                    HBoxDokument.this.bd;
                    HBoxDokument.this.writeToFileSystem(new ByteArrayInputStream(BazaDokumenti.getDokument(h.getText())), h.getText());
                }
                catch (Exception ex) {
                    Logger.getLogger(ComboBoxCellDokument.class.getName()).log(Level.SEVERE, null, ex);
                }
                System.out.println("otvaram report na lokaciji " + HBoxDokument.this.temp.getAbsolutePath());
                if (HBoxDokument.this.temp.exists()) {
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().open(new File(HBoxDokument.this.temp.getAbsolutePath()));
                        }
                        catch (IOException eo) {
                            eo.printStackTrace();
                        }
                    } else {
                        System.out.println("Awt Desktop is not supported!");
                    }
                } else {
                    System.out.println("File is not exists!");
                }
            }
        };
    }

    private Hyperlink getHiperLink(String item) {
        h = new Hyperlink(item);
        this.bd = new BazaDokumenti();
        this.imgView.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                HBoxDokument.this.comboBox.setVisible(true);
                HBoxDokument.this.btnZajednickiDokumenti.setVisible(true);
                HBoxDokument.this.imgView.setStyle(" -fx-cursor: hand;");
            }
        });
        h.setOnAction(event -> {
            if (!h.getText().equals("")) {
                this.hb.getChildren().add(0, (Object)this.progressPane);
                Task<Void> task = this.createTask();
                new Thread((Runnable)task).start();
                this.progressPane.progressProperty().bind((ObservableValue)task.progressProperty());
            }
        });
        h.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.DELETE) {
                h.setText("");
            }
        });
        return h;
    }

    private void writeToFileSystem(ByteArrayInputStream byteArrayInputStream, String nazivDokumenta) throws Exception {
        try {
            this.temp = File.createTempFile(nazivDokumenta, "." + KlasaKorisneMetode.getExtension(new File(nazivDokumenta)));
            this.temp.deleteOnExit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileOutputStream fileOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byteArray = new byte[byteArrayInputStream.available()];
        fileOutputStream = new FileOutputStream(this.temp);
        byteArrayOutputStream = new ByteArrayOutputStream(byteArrayInputStream.available());
        int x = byteArrayInputStream.read(byteArray, 0, byteArrayInputStream.available());
        byteArrayOutputStream.write(byteArray, 0, x);
        byteArrayOutputStream.writeTo(fileOutputStream);
        byteArrayInputStream.close();
        byteArrayOutputStream.close();
        fileOutputStream.close();
    }

    private ComboBox getComboBox() {
        this.comboBox = new ComboBox();
        this.comboBox.setPromptText("Odabareite dokument");
        this.comboBox.setPrefWidth(200.0);
        this.comboBox.setItems(this.listaDokumentiCombo);
        this.comboBox.setVisible(false);
        this.btnZajednickiDokumenti.setVisible(false);
        FxUtilTest.autoCompleteComboBoxPlus(this.comboBox, (typedText, itemToCompare) -> itemToCompare.getOpisDokumenta().toLowerCase().startsWith(typedText.toLowerCase()));
        FxUtilTest.getComboBoxValue(this.comboBox);
        this.comboBox.setConverter((StringConverter)new StringConverter<ScanDokument>(){

            public String toString(ScanDokument rm) {
                if (rm == null) {
                    return null;
                }
                return rm.getOpisDokumenta();
            }

            public ScanDokument fromString(String userId) {
                return null;
            }
        });
        this.comboBox.setCellFactory(p -> {
            ListCell<ScanDokument> cell = new ListCell<ScanDokument>(){

                protected void updateItem(ScanDokument t, boolean bln) {
                    super.updateItem((Object)t, bln);
                    if (t != null) {
                        this.setText(t.getOpisDokumenta());
                    } else {
                        this.setText(null);
                    }
                }
            };
            return cell;
        });
        this.comboBox.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean newVal) {
                if (!HBoxDokument.this.comboBox.isShowing()) {
                    HBoxDokument.this.comboBox.setVisible(false);
                    HBoxDokument.this.btnZajednickiDokumenti.setVisible(false);
                }
            }
        });
        this.comboBox.setButtonCell((ListCell)new ComboBoxListCell<ScanDokument>(){

            public void updateItem(ScanDokument s, boolean empty) {
                super.updateItem((Object)s, empty);
                this.setText(null);
            }
        });
        this.comboBox.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ESCAPE) {
                this.comboBox.setVisible(false);
                this.btnZajednickiDokumenti.setVisible(false);
            }
        });
        this.comboBox.setOnAction(e -> {
            if (this.comboBox.getValue() != null) {
                ScanDokument sd = (ScanDokument)this.comboBox.getSelectionModel().getSelectedItem();
                h.setText(((ScanDokument)this.comboBox.getValue()).getOpisDokumenta());
            }
        });
        return this.comboBox;
    }
}

