/*
 * Decompiled with CFR 0.152.
 */
package ljecnickipregledi;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.UtillBaza;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import ljecnickipregledi.BazaLjecnickiPregled;
import ljecnickipregledi.LjecnickiPregled;
import ljecnickipregledi.UnosLjecnickiPregledController;
import zastitanaradu.GlavniPanelController;

public class PopisLjecnickiPregledController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<LjecnickiPregled> tablicaPopisLjecnickihPregleda;
    @FXML
    private TableColumn<LjecnickiPregled, String> kolPretraga;
    @FXML
    private TableColumn<LjecnickiPregled, String> kolRedBr;
    @FXML
    private TableColumn<LjecnickiPregled, String> kolOznaka;
    @FXML
    private TableColumn<LjecnickiPregled, String> kolNaziv;
    private static PopisLjecnickiPregledController instance;
    private final ObservableList<LjecnickiPregled> listaLjecnickiPregledi = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisLjecnickiPregledController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciLjecnickiPregled();
        this.popuniTablicuLjecnickiPregled();
        this.urediFilter(this.tablicaPopisLjecnickihPregleda);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos lje\u010dni\u010dki pregled")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos lje\u010dni\u010dki pregled");
                GlavniPanelController.getInstance().nadodajPanel("Unos lje\u010dni\u010dki pregled", "/ljecnickipregledi/UnosLjecnickiPregled.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos lje\u010dni\u010dki pregled", "/ljecnickipregledi/UnosLjecnickiPregled.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            LjecnickiPregled lp;
            int selectdIndex = this.tablicaPopisLjecnickihPregleda.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (lp = (LjecnickiPregled)this.tablicaPopisLjecnickihPregleda.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos lje\u010dni\u010dki pregled")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos lje\u010dni\u010dki pregled");
                    GlavniPanelController.getInstance().nadodajPanel("Unos lje\u010dni\u010dki pregled", "/ljecnickipregledi/UnosLjecnickiPregled.fxml");
                    UnosLjecnickiPregledController.getInstance().izmjenaLjecnickiPregled(lp);
                    this.tablicaPopisLjecnickihPregleda.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos lje\u010dni\u010dki pregled", "/ljecnickipregledi/UnosLjecnickiPregled.fxml");
                    UnosLjecnickiPregledController.getInstance().izmjenaLjecnickiPregled(lp);
                    this.tablicaPopisLjecnickihPregleda.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisLjecnickihPregleda.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati lje\u010dni\u010dki pregled")).showAndWait()).get() == ButtonType.OK && !UtillBaza.provjeraNazivaLjecnickogPregleda((LjecnickiPregled)this.tablicaPopisLjecnickihPregleda.getSelectionModel().getSelectedItem())) {
                if (BazaLjecnickiPregled.obrisiLjecnickipregled((LjecnickiPregled)this.tablicaPopisLjecnickihPregleda.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuLjecnickiPregled();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisano lje\u010dni\u010dki pregled", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisano lje\u010dni\u010dki pregled", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Oznaka", "Naziv"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaLjecnickiPregledi, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Oznaka") ? pregled.getOznakaLjecnickiPregled() != null && pregled.getOznakaLjecnickiPregled().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") && pregled.getNazivLjecnickiPregled() != null && pregled.getNazivLjecnickiPregled().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciLjecnickiPregled() {
        this.tablicaPopisLjecnickihPregleda.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisLjecnickiPregledController.this.tablicaPopisLjecnickihPregleda.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cell -> ((LjecnickiPregled)cell.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisLjecnickihPregleda.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolOznaka.setCellValueFactory(cell -> ((LjecnickiPregled)cell.getValue()).oznakaLjecnickiPregledProperty());
        this.kolOznaka.prefWidthProperty().bind((ObservableValue)this.tablicaPopisLjecnickihPregleda.widthProperty().divide(5.0));
        this.kolOznaka.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory(cell -> ((LjecnickiPregled)cell.getValue()).nazivLjecnickiPregledProperty());
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisLjecnickihPregleda.widthProperty().divide(1.694915254237288));
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    public void popuniTablicuLjecnickiPregled() {
        this.tablicaPopisLjecnickihPregleda.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaLjecnickiPregledi.clear();
        this.tablicaPopisLjecnickihPregleda.getItems().clear();
    }

    private Task createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisLjecnickiPregledController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisLjecnickiPregledController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisLjecnickiPregledController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaLjecnickiPregled.dajLjecnickiPregled(GlavniPanelController.getOdabranaTvrtka());
        int br = 1;
        try {
            while (rs.next()) {
                LjecnickiPregled lp = new LjecnickiPregled();
                lp.setId(rs.getInt("id"));
                lp.setRedBroj(String.valueOf(br));
                lp.setOznakaLjecnickiPregled(rs.getString("oznaka"));
                lp.setNazivLjecnickiPregled(rs.getString("nazivljecnickipregled"));
                lp.setEk2(rs.getBoolean("ek2"));
                lp.setLjecnickiPregled(rs.getBoolean("ljecnickipregled"));
                this.listaLjecnickiPregledi.add((Object)lp);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisLjecnickiPregledController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisLjecnickiPregledController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisLjecnickihPregleda.getItems().addAll(this.listaLjecnickiPregledi);
    }
}

