/*
 * Decompiled with CFR 0.152.
 */
package kadrovska;

import TamplatePaneli.Template;
import Utill.DateUtil;
import Utill.FxDialogs;
import Utill.FxUtilTest;
import Utill.KlasaKorisneMetode;
import filter.MenuButtonReporti;
import ispisJasper.IspisJasperButtonSaSubreportom;
import ispisJasper.IspisReporta;
import ispisJasper.JasperViewerFX;
import java.io.IOException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.ComboBoxListCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import javafx.util.StringConverter;
import kadrovska.BazaDjelatnik;
import kadrovska.Djelatnik;
import kadrovska.UnosDjelatnikaController;
import net.sf.jasperreports.engine.JasperPrint;
import radnamjesta.BazaRadnaMjesta;
import radnamjesta.RadnoMjesto;
import zastitanaradu.GlavniPanelController;

public class PopisDjelatnikaController
implements Initializable {
    @FXML
    private AnchorPane anchorPanelDjelatnik;
    @FXML
    private Button btnIspis;
    @FXML
    private MenuButton btnIspis1;
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableColumn kolPretraga;
    @FXML
    private TableView<Djelatnik> tablicaPopisDjelatnika;
    @FXML
    private TableColumn<Djelatnik, String> kolRedBr;
    @FXML
    private TableColumn<Djelatnik, String> kolSifra;
    @FXML
    private TableColumn<Djelatnik, String> kolOIB;
    @FXML
    private TableColumn<Djelatnik, String> kolIme;
    @FXML
    private TableColumn<Djelatnik, String> kolPrezime;
    @FXML
    private TableColumn<Djelatnik, String> kolPoslovnica;
    private static PopisDjelatnikaController instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<Djelatnik> listaDjelatnika = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();

    public static PopisDjelatnikaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFIlter();
        this.urediTablicuPopisDjelatnika();
        this.popuniButtonIspis();
        this.popuniTablicuPopisDjelatnika();
        this.urediFilter(this.tablicaPopisDjelatnika);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Djelatnika")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos Djelatnika");
                GlavniPanelController.getInstance().nadodajPanel("Unos Djelatnika", "/kadrovska/UnosDjelatnika.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos Djelatnika", "/kadrovska/UnosDjelatnika.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            Djelatnik d;
            int selectdIndex = this.tablicaPopisDjelatnika.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (d = (Djelatnik)this.tablicaPopisDjelatnika.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Djelatnika")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos Djelatnika");
                    GlavniPanelController.getInstance().nadodajPanel("Unos Djelatnika", "/kadrovska/UnosDjelatnika.fxml");
                    UnosDjelatnikaController.getInstance().izmjenaDjelatnika(d);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos Djelatnika", "/kadrovska/UnosDjelatnika.fxml");
                    System.out.println("popis djelatnika id  " + d.getId());
                    UnosDjelatnikaController.getInstance().izmjenaDjelatnika(d);
                }
                this.tablicaPopisDjelatnika.getSelectionModel().clearSelection();
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisDjelatnika.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati djelatnika")).showAndWait()).get() == ButtonType.OK) {
                if (BazaDjelatnik.obrisiDjelatnika((Djelatnik)this.tablicaPopisDjelatnika.getSelectionModel().getSelectedItem(), GlavniPanelController.getOdabranaTvrtka())) {
                    this.popuniTablicuPopisDjelatnika();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan djelatnik", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan djelatnik", 2, "Error graphic");
                }
            }
        });
        this.btnIspis.setOnAction(e -> {
            FXMLLoader loader = new FXMLLoader(MenuButtonReporti.class.getResource("/radpodnadzorom/RadPodNadzorom.fxml"));
            Parent root = null;
            try {
                root = (Parent)loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(PopisDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
            Scene scene = new Scene(root);
            Stage stage = new Stage(StageStyle.UTILITY);
            stage.setTitle("Ispis Odluka za rad pod nadzorom");
            stage.getIcons().add((Object)new Image("/resorces/icon/printer.png"));
            stage.initModality(Modality.APPLICATION_MODAL);
            scene.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
            stage.setScene(scene);
            stage.showAndWait();
        });
    }

    private void kreirajToolBarFIlter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"\u0160ifra", "OIB", "Prezime", "Poslovna jedinica"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Prezime");
        this.cbFilter.setPrefWidth(200.0);
        this.tfilter.setPrefWidth(200.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter, this.getMenuButton(), MenuButtonReporti.getMenuButtonIspisRadnika()});
    }

    private MenuButton getMenuButton() {
        MenuButton mb = new MenuButton("Pregled radnika");
        MenuItem m1 = new MenuItem("Prikazi sve radnike");
        m1.setOnAction(event -> this.popuniTablicuPopisDjelatnika(BazaDjelatnik.Opcije.sve_djelatnike));
        MenuItem m2 = new MenuItem("Prikazi  PUR radnike");
        m2.setOnAction(event -> this.popuniTablicuPopisDjelatnika(BazaDjelatnik.Opcije.PUR_djelatnike));
        MenuItem m3 = new MenuItem("Prikazi odjavljene radnike ");
        m3.setOnAction(event -> this.popuniTablicuPopisDjelatnika(BazaDjelatnik.Opcije.odjavljene_djelatnike));
        MenuItem m4 = new MenuItem("Prikazi  zaposlene radnike ");
        m4.setOnAction(event -> this.popuniTablicuPopisDjelatnika(BazaDjelatnik.Opcije.zaposlene_djelatnike));
        Menu men = new Menu("Prika\u017ei radnike po radnom mjestu");
        men.getItems().addAll((Object[])new MenuItem[]{new MenuItem(null, (Node)this.getCBoxRadnoMjesto())});
        mb.getItems().addAll((Object[])new MenuItem[]{m1, m2, m3, m4, new SeparatorMenuItem(), men});
        return mb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComboBox getCBoxRadnoMjesto() {
        ObservableList radnaMjesta = FXCollections.observableArrayList();
        ResultSet rs = BazaRadnaMjesta.dajRadnaMjesta(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                RadnoMjesto rm = new RadnoMjesto();
                rm.setId(rs.getInt("id"));
                rm.setPur(rs.getString("pur"));
                rm.setNaziv(rs.getString("naziv"));
                rm.setOpasnostiRM(rs.getString("opasnosti"));
                rm.setClanak(rs.getString("clanak"));
                rm.setTockePregleda(rs.getString("tockepregleda"));
                radnaMjesta.add((Object)rm);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        final ComboBox comboBox = new ComboBox(radnaMjesta);
        comboBox.setPromptText("Odaberi radno mjesto");
        FxUtilTest.autoCompleteComboBoxPlus(comboBox, (typedText, itemToCompare) -> itemToCompare.getNaziv().toLowerCase().startsWith(typedText.toLowerCase()));
        comboBox.setCellFactory(cb -> new ListCell<RadnoMjesto>(){

            protected void updateItem(RadnoMjesto item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(item.getNaziv());
                }
            }
        });
        comboBox.setConverter(new StringConverter(){
            private Map<String, Object> map = new HashMap<String, Object>();

            public String toString(Object t) {
                if (t != null) {
                    RadnoMjesto rm = (RadnoMjesto)t;
                    String str = rm.getNaziv();
                    this.map.put(str, t);
                    return str;
                }
                return "";
            }

            public Object fromString(String string) {
                if (!this.map.containsKey(string)) {
                    comboBox.setValue(null);
                    comboBox.getEditor().clear();
                    return null;
                }
                return this.map.get(string);
            }
        });
        comboBox.setCellFactory(p -> {
            ListCell<RadnoMjesto> cell = new ListCell<RadnoMjesto>(){

                protected void updateItem(RadnoMjesto t, boolean bln) {
                    super.updateItem((Object)t, bln);
                    if (t != null) {
                        this.setText(t.getNaziv());
                    } else {
                        this.setText(null);
                    }
                }
            };
            return cell;
        });
        comboBox.setButtonCell((ListCell)new ComboBoxListCell<RadnoMjesto>(){

            public void updateItem(RadnoMjesto s, boolean empty) {
                super.updateItem((Object)s, empty);
                if (empty || s == null) {
                    this.setStyle("-fx-text-fill: derive(-fx-control-inner-background,-30%)");
                } else {
                    this.setStyle("-fx-text-fill: -fx-text-inner-color");
                    this.setText(null);
                }
            }
        });
        comboBox.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            if (newVal != null) {
                Platform.runLater(() -> comboBox.setValue(oldVal));
            }
        });
        comboBox.setOnAction(e -> {
            RadnoMjesto rmr;
            if (comboBox.getValue() != null && (rmr = (RadnoMjesto)comboBox.getSelectionModel().getSelectedItem()) != null) {
                this.popuniTablicuPopisDjelatnika(rmr.getId());
            }
        });
        return comboBox;
    }

    void popuniButtonIspis() {
        this.btnIspis1.disableProperty().unbind();
        this.btnIspis1.disableProperty().bind((ObservableValue)this.tablicaPopisDjelatnika.getSelectionModel().selectedItemProperty().isNull());
        MenuItem kd = new MenuItem("Ispi\u0161i karton djelatnika");
        kd.setOnAction(event -> {
            int selectdIndex = this.tablicaPopisDjelatnika.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                ObservableList listaDjelatnika = this.tablicaPopisDjelatnika.getSelectionModel().getSelectedItems();
                String idArray = "";
                for (int i = 0; i < listaDjelatnika.size(); ++i) {
                    idArray = i == 0 ? idArray + String.valueOf(((Djelatnik)listaDjelatnika.get(i)).getId()) : idArray + "," + String.valueOf(((Djelatnik)listaDjelatnika.get(i)).getId());
                }
                String sql = "SELECT spremastupanj.naziv as spremastupanj ,\n\tstrucnasprema.naziv as strucnasprema ,\n\tdjelatnik.*,\t\n\tposlovnejedinice.nazivposlovnice as nazivposlovnice,\n\todjeli.nazivodjela\nFROM djelatnik,\n\tspremastupanj,\n\tstrucnasprema,\n\todjeli,\n\tposlovnejedinice\n  WHERE \n\t djelatnik.stupanjobrazovanja = spremastupanj.id \n\t AND djelatnik.strucnasprema = strucnasprema.id   AND djelatnik.odjel = odjeli.id  AND djelatnik.poslovnajedinica = poslovnejedinice.id  \n\t   and djelatnik.id IN (select(unnest(ARRAY [" + idArray + "])))   and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
                IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspis1, "DjelatnikIspis.jrxml");
            }
        });
        MenuItem ek1 = new MenuItem("Ispi\u0161i EK-1");
        ek1.setOnAction(e -> {
            ObservableList listaDjelatnika = this.tablicaPopisDjelatnika.getSelectionModel().getSelectedItems();
            String idArray = "";
            for (int i = 0; i < listaDjelatnika.size(); ++i) {
                idArray = i == 0 ? idArray + String.valueOf(((Djelatnik)listaDjelatnika.get(i)).getId()) : idArray + "," + String.valueOf(((Djelatnik)listaDjelatnika.get(i)).getId());
            }
            String sql = "SELECT DISTINCT \n    djelatnik.id,\n    djelatnik.ime,\n    djelatnik.prezime,\n    djelatnik.mjestorodjenja,\n    djelatnik.datumrodjenja,\n    djelatnik.datumzaposlenja,\n    tvrtka.id as idtvrtka,\n    tvrtka.naziv_tvrtke,\n    tvrtka.pbr,\n    tvrtka.mjesto,\n    tvrtka.adresa,\n    radnamjesta.naziv,\n    radnamjesta.opasnosti,\n    radnamjesta.naznakasadrzaja,  \n    strucnasprema.naziv AS strucnaspremanaziv \n    FROM djelatnik,\n    tvrtka,\n    radnamjesta,\n    strucnasprema\n  WHERE djelatnik.idradnomjesto = radnamjesta.id AND djelatnik.strucnasprema = strucnasprema.id  \n  AND djelatnik.idtvrtka =tvrtka.id   and djelatnik.id  IN (select(unnest(ARRAY [" + idArray + "])))";
            IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspis1, "Ek-1.jrxml");
        });
        MenuItem ek2 = new MenuItem("Ispi\u0161i EK-2");
        ek2.setOnAction(event -> {
            ObservableList listaDjelatnika = this.tablicaPopisDjelatnika.getSelectionModel().getSelectedItems();
            String idArray = "";
            for (int i = 0; i < listaDjelatnika.size(); ++i) {
                idArray = i == 0 ? idArray + String.valueOf(((Djelatnik)listaDjelatnika.get(i)).getId()) : idArray + "," + String.valueOf(((Djelatnik)listaDjelatnika.get(i)).getId());
            }
            String sql = "SELECT DISTINCT djelatnik.id,\n    djelatnik.ime,\n    djelatnik.prezime,\n    tvrtka.id as idtvrtka,\n    tvrtka.naziv_tvrtke,\n    tvrtka.pbr,\n    tvrtka.mjesto,\n    tvrtka.adresa,\n    radnamjesta.naziv,\n    radnamjesta.opasnosti,\n    radnamjesta.clanak,\n    radnamjesta.tockepregleda AS radnamjestotockepregleda,\n     radnamjesta.dobzivota ,\n  radnamjesta.spol ,\n  radnamjesta.strucnasprema ,\n  radnamjesta.zdrastvenostanje ,\n  radnamjesta.psihosposobnost,  \n    djelatnik.mjestorodjenja,\n    djelatnik.datumrodjenja,\n    djelatnik.zanimanje,\n    djelatnik.datumpocetkapur,\n    strucnasprema.naziv AS strucnaspremanaziv ,\n      djelatnik.nazivisprave ,\n djelatnik.zdrastvenostanje as djelatnikzdrastveno,\n  djelatnik.psiholoskostanje as djelatnikpsiholo\u0161ko,\n  djelatnik.datumizdavanjaoi,\n  djelatnik.brojosobne   FROM djelatnik,\n    tvrtka,\n    radnamjesta,\n    djelatnikljpregled,\n    strucnasprema\n  WHERE djelatnik.idradnomjesto = radnamjesta.id AND djelatnik.strucnasprema = strucnasprema.id \n  AND djelatnik.idtvrtka =tvrtka.id and djelatnik.id  IN (select(unnest(ARRAY [" + idArray + "])))";
            IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspis1, "Ek-2.jrxml");
        });
        MenuItem ekpp = new MenuItem("Ispi\u0161i EK-PP");
        ekpp.setOnAction(event -> {
            ObservableList listaDjelatnika = this.tablicaPopisDjelatnika.getSelectionModel().getSelectedItems();
            String idArray = "";
            for (int i = 0; i < listaDjelatnika.size(); ++i) {
                idArray = i == 0 ? idArray + String.valueOf(((Djelatnik)listaDjelatnika.get(i)).getId()) : idArray + "," + String.valueOf(((Djelatnik)listaDjelatnika.get(i)).getId());
            }
            String sql = "SELECT DISTINCT \n    djelatnik.id,\n    djelatnik.ime,\n    djelatnik.prezime,\n    djelatnik.mjestorodjenja,\n    djelatnik.datumrodjenja,\n    djelatnik.datumzaposlenja,\n    tvrtka.id as idtvrtka,\n    tvrtka.naziv_tvrtke,\n    tvrtka.pbr,\n    tvrtka.mjesto,\n    tvrtka.adresa,\n    radnamjesta.naziv,\n    radnamjesta.opasnosti,\n    radnamjesta.prvapomoc,  \n    strucnasprema.naziv AS strucnaspremanaziv \n    FROM djelatnik,\n    tvrtka,\n    radnamjesta,\n    strucnasprema\n  WHERE djelatnik.idradnomjesto = radnamjesta.id AND djelatnik.strucnasprema = strucnasprema.id  \n  AND djelatnik.idtvrtka =tvrtka.id   and djelatnik.id  IN (select(unnest(ARRAY [" + idArray + "])))";
            IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspis1, "EK-PP.jrxml");
        });
        MenuItem ekzop = new MenuItem("Ispi\u0161i EK-ZOP");
        ekzop.setOnAction(event -> {
            ObservableList listaDjelatnika = this.tablicaPopisDjelatnika.getSelectionModel().getSelectedItems();
            String idArray = "";
            for (int i = 0; i < listaDjelatnika.size(); ++i) {
                idArray = i == 0 ? idArray + String.valueOf(((Djelatnik)listaDjelatnika.get(i)).getId()) : idArray + "," + String.valueOf(((Djelatnik)listaDjelatnika.get(i)).getId());
            }
            String sql = "SELECT DISTINCT \n    djelatnik.id,\n    djelatnik.ime,\n    djelatnik.prezime,\n    djelatnik.mjestorodjenja,\n    djelatnik.datumrodjenja,\n    djelatnik.datumzaposlenja,\n    tvrtka.id as idtvrtka,\n    tvrtka.naziv_tvrtke,\n    tvrtka.pbr,\n    tvrtka.mjesto,\n    tvrtka.adresa,\n    radnamjesta.naziv,\n    radnamjesta.opasnosti,\n    radnamjesta.gasenjepozara,  \n    strucnasprema.naziv AS strucnaspremanaziv \n    FROM djelatnik,\n    tvrtka,\n    radnamjesta,\n    strucnasprema\n  WHERE djelatnik.idradnomjesto = radnamjesta.id AND djelatnik.strucnasprema = strucnasprema.id  \n  AND djelatnik.idtvrtka =tvrtka.id   and djelatnik.id  IN (select(unnest(ARRAY [" + idArray + "])))";
            IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspis1, "EK-ZOP.jrxml");
        });
        this.btnIspis1.getItems().addAll((Object[])new MenuItem[]{kd, new SeparatorMenuItem(), ek1, ek2, ekpp, ekzop});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaDjelatnika, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("\u0160ifra") ? pregled.getSifraDjelatnika() != null && pregled.getSifraDjelatnika().toLowerCase().startsWith(this.tfilter.getText().toLowerCase()) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("OIB") ? pregled.getOIB() != null && pregled.getOIB().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Prezime") ? pregled.getPrezime() != null && pregled.getPrezime().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") && pregled.getPoslovnaJedinica() != null && pregled.getPoslovnaJedinica().toLowerCase().startsWith(lowerCaseFilter)));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediTablicuPopisDjelatnika() {
        this.tablicaPopisDjelatnika.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisDjelatnika.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisDjelatnikaController.this.tablicaPopisDjelatnika.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisDjelatnika.widthProperty().divide(12.5));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolSifra.setCellValueFactory((Callback)new PropertyValueFactory("sifraDjelatnika"));
        this.kolSifra.prefWidthProperty().bind((ObservableValue)this.tablicaPopisDjelatnika.widthProperty().divide(10.0));
        this.kolSifra.setStyle("-fx-alignment: CENTER;");
        this.kolOIB.setCellValueFactory((Callback)new PropertyValueFactory("OIB"));
        this.kolOIB.prefWidthProperty().bind((ObservableValue)this.tablicaPopisDjelatnika.widthProperty().divide(10.0));
        this.kolOIB.setStyle("-fx-alignment: CENTER;");
        this.kolIme.setCellValueFactory((Callback)new PropertyValueFactory("ime"));
        this.kolIme.prefWidthProperty().bind((ObservableValue)this.tablicaPopisDjelatnika.widthProperty().divide(5.0));
        this.kolIme.setStyle("-fx-alignment: CENTER;");
        this.kolPrezime.setCellValueFactory((Callback)new PropertyValueFactory("prezime"));
        this.kolPrezime.prefWidthProperty().bind((ObservableValue)this.tablicaPopisDjelatnika.widthProperty().divide(5.0));
        this.kolPrezime.setStyle("-fx-alignment: CENTER;");
        this.kolPoslovnica.setCellValueFactory((Callback)new PropertyValueFactory("poslovnaJedinica"));
        this.kolPoslovnica.prefWidthProperty().bind((ObservableValue)this.tablicaPopisDjelatnika.widthProperty().divide(5.0));
        this.kolPoslovnica.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledDjelatnika = new TableColumn("Pregled");
        kolPregledDjelatnika.setSortable(false);
        kolPregledDjelatnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisDjelatnika.widthProperty().divide(10.0));
        kolPregledDjelatnika.setStyle("-fx-alignment: CENTER;");
        kolPregledDjelatnika.setCellFactory((Callback)new Callback<TableColumn<Djelatnik, Boolean>, TableCell<Djelatnik, Boolean>>(){

            public TableCell<Djelatnik, Boolean> call(TableColumn<Djelatnik, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledDjelatnika);
        this.tablicaPopisDjelatnika.setItems(this.listaDjelatnika);
    }

    public void popuniTablicuPopisDjelatnika() {
        this.tablicaPopisDjelatnika.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task<Void> task = this.createTask(BazaDjelatnik.Opcije.zaposlene_djelatnike);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaDjelatnika.clear();
        this.tablicaPopisDjelatnika.getItems().clear();
    }

    public void popuniTablicuPopisDjelatnika(BazaDjelatnik.Opcije opcija) {
        this.tablicaPopisDjelatnika.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task<Void> task = this.createTask(opcija);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaDjelatnika.clear();
        this.tablicaPopisDjelatnika.getItems().clear();
    }

    public void popuniTablicuPopisDjelatnika(int idRadnoMjesto) {
        this.tablicaPopisDjelatnika.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task<Void> task = this.createTask(idRadnoMjesto);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaDjelatnika.clear();
        this.tablicaPopisDjelatnika.getItems().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuDjelatnika(ResultSet rs) {
        Djelatnik d = null;
        int br = 1;
        try {
            while (rs.next()) {
                d = new Djelatnik();
                d.setId(rs.getInt("id"));
                d.setRedBroj(String.valueOf(br));
                d.setSifraDjelatnika(rs.getString("sifradjelatnika"));
                d.setOIB(rs.getString("oib"));
                d.setIme(rs.getString("ime"));
                d.setPrezime(rs.getString("prezime"));
                d.setPoslovnaJedinica(rs.getString("nazivposlovnice"));
                d.setOdjel(rs.getString("nazivodjela"));
                d.setNazivRukovoditelja(rs.getString("nazivrukovoditelja"));
                d.setRadnoMjesto(rs.getString("rmnaziv"));
                if (rs.getString("rmpur").equals("PUR")) {
                    d.setPur(true);
                } else {
                    d.setPur(false);
                }
                d.setDatumPocetkaPUR(DateUtil.getLocalDate(rs.getDate("datumpocetkapur")));
                d.setDatumZaposlenja(DateUtil.getLocalDate(rs.getDate("datumzaposlenja")));
                d.setVrstaZaposlenja(rs.getString("vrstazaposlenja"));
                d.setRadnoVrijeme(rs.getString("radnovrijeme"));
                d.setStazUTvrtci(rs.getString("stazutvrtci"));
                d.setStazIzvanTvrtke(rs.getString("stazizvantvrtke"));
                d.setOdjavljen(rs.getBoolean("odjavljen"));
                d.setDatumOdjave(DateUtil.getLocalDate(rs.getDate("datumodjave")));
                d.setRazlogOdjave(rs.getString("razlogodjave"));
                d.setSpol(rs.getString("spol"));
                d.setStrucnaSprema(rs.getString("nazivss"));
                d.setStupanjObrazovanja(rs.getString("nazivso"));
                d.setDatumRodjenja(DateUtil.getLocalDate(rs.getDate("datumrodjenja")));
                d.setZanimianje(rs.getString("zanimanje"));
                d.setMjestoRodjenja(rs.getString("mjestorodjenja"));
                d.setOpcinaRodjenja(rs.getString("opcinarodjenja"));
                d.setDrzavaRodjenja(rs.getString("drzava"));
                d.setMjestoStanovanja(rs.getString("mjestostanovanja"));
                d.setAdresa(rs.getString("adresa"));
                d.setImeOca(rs.getString("imeoca"));
                d.setImeMajke(rs.getString("imemajke"));
                d.setBrOsobneIskaznice(rs.getString("brojosobne"));
                d.setBrOsiguraneOsobe(rs.getString("brojosiguraneosobe"));
                d.setKontaktTelefon(rs.getString("kontakttelefon"));
                d.setNapomena(rs.getString("napomena"));
                d.setVelicinaZastitneObuce(rs.getString("velicinaobuce"));
                d.setVelicinaZastitneOdjece(rs.getString("velicinaodjece"));
                d.setVelicinaZastiteZaGlavu(rs.getString("velicinazaglavu"));
                d.setVelicinaRukavica(rs.getString("velicinarukavica"));
                d.setDatumTrajanjaUgovora(DateUtil.getLocalDate(rs.getDate("datumtrajanjaugovora")));
                d.setEmail(rs.getString("email"));
                d.setPbr(rs.getString("pbr"));
                d.setKcbr(rs.getString("kcbr"));
                d.setOznakaNKZ(rs.getString("oznakankz"));
                d.setNazivIsprave(rs.getString("nazivisprave"));
                d.setZdrastvenoStanje(rs.getString("zdrastvenostanje"));
                d.setPsiholoskoStanje(rs.getString("psiholoskostanje"));
                d.setNocniRad(rs.getBoolean("nocnirad"));
                d.setDatumIzdavanjaOI(DateUtil.getLocalDate(rs.getDate("datumizdavanjaoi")));
                this.listaDjelatnika.add((Object)d);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private Task<Void> createTask(final BazaDjelatnik.Opcije opcija) {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaDjelatnik.dajDjelatnike(GlavniPanelController.getOdabranaTvrtka(), opcija);
                    Platform.runLater(() -> PopisDjelatnikaController.this.popuniTablicuDjelatnika(rs));
                }
                finally {
                    Platform.runLater(() -> PopisDjelatnikaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private Task<Void> createTask(final int idRadnoMjesto) {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisDjelatnikaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaDjelatnik.dajDjelatnike(GlavniPanelController.getOdabranaTvrtka(), idRadnoMjesto);
                    PopisDjelatnikaController.this.popuniTablicuDjelatnika(rs);
                }
                finally {
                    Platform.runLater(() -> PopisDjelatnikaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void ispisKartonDjelatnika(ObservableList<Djelatnik> listaDjelatnika) {
        String idArray = "";
        for (int i = 0; i < listaDjelatnika.size(); ++i) {
            idArray = i == 0 ? idArray + String.valueOf(((Djelatnik)listaDjelatnika.get(i)).getId()) : idArray + "," + String.valueOf(((Djelatnik)listaDjelatnika.get(i)).getId());
        }
        String sql = "SELECT spremastupanj.naziv as spremastupanj ,\n\tstrucnasprema.naziv as strucnasprema ,\n\tdjelatnik.*,\t\n\tposlovnejedinice.nazivposlovnice as nazivposlovnice,\n\todjeli.nazivodjela\nFROM djelatnik,\n\tspremastupanj,\n\tstrucnasprema,\n\todjeli,\n\tposlovnejedinice\nWHERE \n\t djelatnik.stupanjobrazovanja = spremastupanj.id \n\t AND djelatnik.strucnasprema = strucnasprema.id   AND djelatnik.odjel = odjeli.id  AND djelatnik.poslovnajedinica = poslovnejedinice.id  \n\t   and djelatnik.id IN (select(unnest(ARRAY [" + idArray + "])))   and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
        final IspisJasperButtonSaSubreportom wb = new IspisJasperButtonSaSubreportom(this.btnIspis, sql, "DjelatnikIspis.jrxml");
        wb.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                if (wb.getValue() != null) {
                    JasperViewerFX viewer = new JasperViewerFX(new Stage(), ((JasperPrint)wb.getValue()).getName(), (JasperPrint)wb.getValue());
                    viewer.show();
                }
            }
        });
        wb.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                System.out.println("Connection error.");
            }
        });
        new Thread((Runnable)((Object)wb)).start();
    }

    private class ButtonCell
    extends TableCell<Djelatnik, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    Djelatnik d;
                    int selectdIndex = PopisDjelatnikaController.this.tablicaPopisDjelatnika.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (d = (Djelatnik)PopisDjelatnikaController.this.tablicaPopisDjelatnika.getSelectionModel().getSelectedItem()) != null) {
                        Template.getTamplate().showTemplate("kadrovska/UnosDjelatnika.fxml", "anchorPanelDjelatnik");
                        UnosDjelatnikaController.getInstance().izmjenaDjelatnika(d);
                        PopisDjelatnikaController.this.tablicaPopisDjelatnika.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().unbind();
                this.cellButton.disableProperty().bind((ObservableValue)PopisDjelatnikaController.this.tablicaPopisDjelatnika.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

