/*
 * Decompiled with CFR 0.152.
 */
package kadrovska;

import Utill.FxUtilTest;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import kadrovska.BazaDjelatnik;
import kadrovska.DjelatnikOsposobljavanja;

public class ComboBoxOsposobljavanja
extends TableCell<DjelatnikOsposobljavanja, String> {
    private ComboBox<DjelatnikOsposobljavanja> comboBox;

    ComboBoxOsposobljavanja(ObservableList<DjelatnikOsposobljavanja> listaOsposobljavanje, String pretraga) {
        this.comboBox = new ComboBox(listaOsposobljavanje);
        this.comboBox.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.commitEdit(null);
            }
            if (event.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
            }
        });
        if (pretraga.toLowerCase().equals("oznaka")) {
            this.comboBox.setPromptText("Pretraga po oznaci");
            this.comboBox.setCellFactory((Callback)new Callback<ListView<DjelatnikOsposobljavanja>, ListCell<DjelatnikOsposobljavanja>>(){

                public ListCell<DjelatnikOsposobljavanja> call(ListView<DjelatnikOsposobljavanja> p) {
                    ListCell<DjelatnikOsposobljavanja> cell = new ListCell<DjelatnikOsposobljavanja>(){

                        protected void updateItem(DjelatnikOsposobljavanja t, boolean bln) {
                            super.updateItem((Object)t, bln);
                            if (t != null) {
                                this.setText(t.getOznaka());
                            } else {
                                this.setText(null);
                            }
                        }
                    };
                    return cell;
                }
            });
            FxUtilTest.autoCompleteComboBoxPlus(this.comboBox, (typedText, itemToCompare) -> itemToCompare.getOznaka().toLowerCase().startsWith(typedText.toLowerCase()));
        }
        if (pretraga.toLowerCase().equals("naziv")) {
            this.comboBox.setPromptText("Pretraga po nazivu");
            this.comboBox.setCellFactory((Callback)new Callback<ListView<DjelatnikOsposobljavanja>, ListCell<DjelatnikOsposobljavanja>>(){

                public ListCell<DjelatnikOsposobljavanja> call(ListView<DjelatnikOsposobljavanja> p) {
                    ListCell<DjelatnikOsposobljavanja> cell = new ListCell<DjelatnikOsposobljavanja>(){

                        protected void updateItem(DjelatnikOsposobljavanja t, boolean bln) {
                            super.updateItem((Object)t, bln);
                            if (t != null) {
                                this.setText(t.getNazivOsposobljavanja());
                            } else {
                                this.setText(null);
                            }
                        }
                    };
                    return cell;
                }
            });
            FxUtilTest.autoCompleteComboBoxPlus(this.comboBox, (typedText, itemToCompare) -> itemToCompare.getNazivOsposobljavanja().toLowerCase().startsWith(typedText.toLowerCase()));
        }
        FxUtilTest.getComboBoxValue(this.comboBox);
        this.comboBox.setConverter((StringConverter)new StringConverter<DjelatnikOsposobljavanja>(){

            public String toString(DjelatnikOsposobljavanja rm) {
                if (rm == null) {
                    return null;
                }
                return rm.getNazivOsposobljavanja();
            }

            public DjelatnikOsposobljavanja fromString(String userId) {
                return null;
            }
        });
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.comboBox.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
            this.comboBox.setOnAction(e -> {
                DjelatnikOsposobljavanja d = (DjelatnikOsposobljavanja)this.comboBox.getSelectionModel().getSelectedItem();
                if (d != null) {
                    this.commitEdit(FxUtilTest.getComboBoxValue(this.comboBox).getNazivOsposobljavanja());
                    ((DjelatnikOsposobljavanja)this.getTableView().getSelectionModel().getSelectedItem()).setOznaka(d.getOznaka());
                    ((DjelatnikOsposobljavanja)this.getTableView().getSelectionModel().getSelectedItem()).setNazivOsposobljavanja(d.getNazivOsposobljavanja());
                    BazaDjelatnik.unesiPromjenuDjelatnikOsposobljavanja((DjelatnikOsposobljavanja)this.getTableView().getSelectionModel().getSelectedItem());
                }
            });
            this.setText(null);
            this.setGraphic((Node)this.comboBox);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText((String)this.getItem());
        this.setGraphic(null);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            this.setText(null);
            this.setGraphic((Node)this.comboBox);
        } else {
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }
    }

    private String getString() {
        return this.getItem() == null ? "" : (String)this.getItem();
    }
}

