/*
 * Decompiled with CFR 0.152.
 */
package ispitivanja;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.UtillBaza;
import ispitivanja.BazaIspitivanja;
import ispitivanja.Ispitivanje;
import ispitivanja.UnosIspitivanjaController;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import zastitanaradu.GlavniPanelController;

public class PopisIspitivanjaController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<Ispitivanje> tablicaPopisIspitivanja;
    @FXML
    private TableColumn<Ispitivanje, String> kolPretraga;
    @FXML
    private TableColumn<Ispitivanje, String> kolRedBr;
    @FXML
    private TableColumn<Ispitivanje, String> kolOznaka;
    @FXML
    private TableColumn<Ispitivanje, String> kolNaziv;
    @FXML
    private TableColumn<Ispitivanje, String> kolPeriodika;
    private static PopisIspitivanjaController instance;
    private final ObservableList<Ispitivanje> listaIspitivanja = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisIspitivanjaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediTablicuPopisIspitivanja();
        this.popuniTablicuIspitivanja();
        this.urediFilter(this.tablicaPopisIspitivanja);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos ispitivanja")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos ispitivanja");
                GlavniPanelController.getInstance().nadodajPanel("Unos ispitivanja", "/ispitivanja/UnosIspitivanja.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos ispitivanja", "/ispitivanja/UnosIspitivanja.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            Ispitivanje i;
            int selectdIndex = this.tablicaPopisIspitivanja.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (i = (Ispitivanje)this.tablicaPopisIspitivanja.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos ispitivanja")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos ispitivanja");
                    GlavniPanelController.getInstance().nadodajPanel("Unos ispitivanja", "/ispitivanja/UnosIspitivanja.fxml");
                    UnosIspitivanjaController.getInstance().izmjenaIspitivanja(i);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos ispitivanja", "/ispitivanja/UnosIspitivanja.fxml");
                    UnosIspitivanjaController.getInstance().izmjenaIspitivanja(i);
                }
                this.tablicaPopisIspitivanja.getSelectionModel().clearSelection();
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisIspitivanja.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati ispitivanje")).showAndWait()).get() == ButtonType.OK && !UtillBaza.provjeraIspitivanja((Ispitivanje)this.tablicaPopisIspitivanja.getSelectionModel().getSelectedItem())) {
                if (BazaIspitivanja.obrisiIspitivanje((Ispitivanje)this.tablicaPopisIspitivanja.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuIspitivanja();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisana ispitivanje", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisana ispitivanje", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Oznaka", "Naziv"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaIspitivanja, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Oznaka") ? pregled.getOznaka() != null && pregled.getOznaka().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") && pregled.getNaziv() != null && pregled.getNaziv().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediTablicuPopisIspitivanja() {
        this.tablicaPopisIspitivanja.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisIspitivanjaController.this.tablicaPopisIspitivanja.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisIspitivanja.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolOznaka.setCellValueFactory((Callback)new PropertyValueFactory("oznaka"));
        this.kolOznaka.prefWidthProperty().bind((ObservableValue)this.tablicaPopisIspitivanja.widthProperty().divide(5.0));
        this.kolOznaka.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory((Callback)new PropertyValueFactory("naziv"));
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisIspitivanja.widthProperty().divide(1.694915254237288));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolPeriodika.setCellValueFactory((Callback)new PropertyValueFactory("periodika"));
        this.kolPeriodika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisIspitivanja.widthProperty().divide(10.0));
        this.kolPeriodika.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaIspitivanja.dajIspitivanja(GlavniPanelController.getOdabranaTvrtka());
        Ispitivanje i = null;
        int br = 1;
        try {
            while (rs.next()) {
                i = new Ispitivanje();
                i.setId(rs.getInt("id"));
                i.setRedBroj(String.valueOf(br));
                i.setOznaka(rs.getString("oznaka"));
                i.setNaziv(rs.getString("nazivpregleda"));
                i.setPeriodika(rs.getString("periodika"));
                this.listaIspitivanja.add((Object)i);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisIspitivanjaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisIspitivanjaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisIspitivanja.getItems().addAll(this.listaIspitivanja);
    }

    public void popuniTablicuIspitivanja() {
        this.tablicaPopisIspitivanja.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Random rng = new Random();
        Task<Void> task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaIspitivanja.clear();
        this.tablicaPopisIspitivanja.getItems().clear();
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisIspitivanjaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisIspitivanjaController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisIspitivanjaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }
}

